/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL plugin
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_GL_IMAGE_H__
#define __PGM_GL_IMAGE_H__

#include "pgmgldrawable.h"
#include "pgmtexture.h"

G_BEGIN_DECLS

#define PGM_TYPE_GL_IMAGE (pgm_gl_image_get_type())
#define PGM_GL_IMAGE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_GL_IMAGE, PgmGlImage))
#define PGM_GL_IMAGE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_GL_IMAGE, PgmGlImageClass))
#define PGM_IS_GL_IMAGE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_GL_IMAGE))
#define PGM_IS_GL_IMAGE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_GL_IMAGE))
#define PGM_GL_IMAGE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_GL_IMAGE, PgmGlImageClass))

typedef struct _PgmGlImage      PgmGlImage;
typedef struct _PgmGlImageClass PgmGlImageClass;

struct _PgmGlImage {
  PgmGlDrawable parent;

  /* Aspect ratios */
  gfloat drawable_ratio;
  gfloat image_ratio;

  /* Last position */
  gfloat last_x, last_y, last_z;

  /* Alignment coeficients */
  gfloat h_align, v_align;

  /* Drawing condition */
  gboolean empty;

  /* Textures */
  PgmTexture *native_texture;
  PgmTexture *texture;

  /* Image vertex arrays */
  PgmGlFloat fg_color[4];
  PgmGlFloat coord[8];
  PgmGlFloat vertex[12];

  /* Image border vertex arrays */
  PgmGlFloat border_vertex[30];
  PgmGlFloat border_color[40];
  gfloat     border_width;
};

struct _PgmGlImageClass {
  PgmGlDrawableClass parent_class;
};

GType          pgm_gl_image_get_type               (void) G_GNUC_CONST;

PgmGlDrawable *pgm_gl_image_new                    (PgmDrawable *drawable,
                                                    PgmGlViewport *glviewport);

void           pgm_gl_image_register               (GTypeModule *module);

void           pgm_gl_image_clear                  (PgmGlImage *glimage);
void           pgm_gl_image_set_from_buffer        (PgmGlImage *glimage);
void           pgm_gl_image_set_from_gst_buffer    (PgmGlImage *glimage);
void           pgm_gl_image_set_from_pixbuf        (PgmGlImage *glimage);
void           pgm_gl_image_set_from_system_buffer (PgmGlImage *glimage);
void           pgm_gl_image_set_from_image         (PgmGlImage *glimage);
void           pgm_gl_image_set_mapping_matrix     (PgmGlImage *glimage);
void           pgm_gl_image_set_alignment          (PgmGlImage *glimage);
void           pgm_gl_image_set_layout             (PgmGlImage *glimage);
void           pgm_gl_image_set_interp             (PgmGlImage *glimage);
void           pgm_gl_image_set_aspect_ratio       (PgmGlImage *glimage);
void           pgm_gl_image_set_border_width       (PgmGlImage *glimage);
void           pgm_gl_image_set_border_inner_color (PgmGlImage *glimage);
void           pgm_gl_image_set_border_outer_color (PgmGlImage *glimage);
void           pgm_gl_image_system_buffer_changed  (PgmGlImage *glimage);

G_END_DECLS

#endif /* __PGM_GL_IMAGE_H__ */
