/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment GStreamer image sink
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author(s): Loïc Molinari <loic@fluendo.com>
 *            Julien Moutte <julien@fluendo.com>
 */

#ifndef __PGM_IMAGE_SINK_H__
#define __PGM_IMAGE_SINK_H__

#include <gst/video/gstvideosink.h>
#include "pgmimage.h"

G_BEGIN_DECLS

#define PGM_TYPE_IMAGE_SINK (pgm_image_sink_get_type())
#define PGM_IMAGE_SINK(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_IMAGE_SINK, PgmImageSink))
#define PGM_IMAGE_SINK_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_IMAGE_SINK, PgmImageSink))
#define PGM_IS_IMAGE_SINK(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_IMAGE_SINK))
#define PGM_IS_IMAGE_SINK_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_IMAGE_SINK))

typedef struct _PgmImageSink      PgmImageSink;
typedef struct _PgmImageSinkClass PgmImageSinkClass;

/**
 * PgmImageSink:
 *
 * The opaque #PgmImageSink data structure.
 */
struct _PgmImageSink {
  /*< private >*/
  GstVideoSink base_element;

  GstCaps *our_caps;
  PgmImage *image;
  PgmImagePixelFormat format;

  gint framerate_n;
  gint framerate_d;
  gint par_n;
  gint par_d;
  gint width;
  gint height;
  gint stride;
};

struct _PgmImageSinkClass {
  GstVideoSinkClass parent_class;
};

GType       pgm_image_sink_get_type  (void);

GstElement *pgm_image_sink_new       (const gchar *name);

PgmError    pgm_image_sink_set_image (PgmImageSink *sink,
                                      PgmImage *image);

PgmError    pgm_image_sink_get_image (PgmImageSink *sink,
                                      PgmImage **image);

G_END_DECLS

#endif /* __PGM_IMAGE_SINK_H__ */
