# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python GTK+ integration example
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#
# Author: Loïc Molinari <loic@fluendo.com>

import sys, math, gobject, pgm, gtk

# Delete handler
def on_delete(viewport, event):
    gtk.main_quit()

# Key press handler
def on_key_press(viewport, event):
    print 'Pigment has the keyboard focus'

# Button press handler
def on_button_clicked(button):
    print 'GTK+ button clicked'

# Transform the mapping matrix of the image
def transform_mapping_matrix_cb(image, transformation):
    image.mapping_matrix *= transformation
    return True

# Start animating the mapping matrix when the pixbuf is loaded
def on_pixbuf_loaded(image, transformation):
    gobject.timeout_add(10, transform_mapping_matrix_cb, image, transformation)

def main(args):
    # OpenGL viewport creation
    viewport = pgm.viewport_factory_make('opengl')
    viewport.connect('key-press-event', on_key_press)

    # Transformation matrix creation
    t = pgm.mat4x4_new_identity()
    t.translate(0.5, 0.5, 0.0)
    t.rotate_z(-math.pi / 180.0)
    t.translate(-0.5, -0.5, 0.0)

    # Scene setup
    img = pgm.Image()
    img.size = (1.5, 1.5)
    img.position = (1.25, 0.75, 0.0)
    img.bg_color = (255, 255, 255, 0)
    img.set_from_file('examples/pictures/fluendo.png')
    img.connect('pixbuf-loaded', on_pixbuf_loaded, t)
    img.show()
    cvs = pgm.Canvas()
    cvs.add(pgm.DRAWABLE_MIDDLE, img)
    viewport.set_canvas(cvs)

    # GTK+ window creation
    window = gtk.Window()
    window.set_title('GTK+ integration')
    window.set_border_width(5)
    window.resize(400, 400)
    window.connect('delete-event', on_delete)

    # Pigment GTK+ socket setup
    socket = pgm.gtk.PgmGtk()
    socket.viewport = viewport

    # GTK+ interface creation
    button = gtk.Button("GTK+ button")
    button.connect ('clicked', on_button_clicked)
    entry = gtk.Entry()
    vbox = gtk.VBox(spacing=5)
    window.add(vbox)
    vbox.pack_start(button, expand=False, fill=False)
    vbox.pack_start(socket, expand=True, fill=True)
    vbox.pack_start(entry, expand=False, fill=False)
    window.show_all()

    # Start the mainloop
    gtk.main()

# Entry point
if __name__ == '__main__':
    sys.exit(main(sys.argv[1:]))
