#ifndef INCLUDE_PBBMISC_H
#define INCLUDE_PBBMISC_H
/* ----------------------------------------------------------------------------
 * pbbmisc.h
 * prototypes and definitions for misc functions in pbb library.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <sys/time.h>

#define STDBUFFERLEN	120
#define MAXARGS			10   /* maximum args for command */
#define MAXCMDLEN		150  /* maximum length of command + args */

/* testtypes for check_devorfile() */
#define TYPE_FILE		0
#define TYPE_BLKDEV		1
#define TYPE_CHARDEV	2
#define TYPE_SYMLINK	3
#define TYPE_DIR		4

/* prototypes */
int check_devorfile(char *file, int type);
int launch_program (char* maskstr, ...);
int get_lastrc();
int get_timeforcmd();
void set_timeforcmd(int timeout);
int check_permissions (char *file, int uid, int perms, int mask);
int get_owner (char *file);
int get_permissions (char *file);
int keydelayms (struct timeval *start, int value, int delay);
void cleanup_buffer(char *buffer);
int axtoi (char *arg);

#endif    /* INCLUDE_PBBMISC_H */
