#ifndef INCLUDE_INIT_H
#define INCLUDE_INIT_H
/* ----------------------------------------------------------------------------
 * init.h
 * prototypes and definitions for init.c.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

/* short options for optarg */
#define ARG_ALL			"hvqd::c:"
#define ARG_HELP		'h'
#define ARG_VERSION		'v'
#define ARG_DETACH		'd'
#define ARG_CONFIG		'c'
#define ARG_QUIET		'q'

#define DEFAULT_CONFIG	SYS_CONF_DIR "/pbbuttonsd.conf"
#define DEFAULT_PIDFILE "/var/run/" PACKAGE ".pid"
#define MODULECOUNT   15

struct serverdata {
	char *prgname;
	char *configreadfile;   /* configfile to read: eg. /etc/pbbuttonsd.conf
	                         * Writing the configfile will be controlled by
	                         * module_system.
	                         */
	int quiet;
	struct {
		int (*initfunc)();
		int (*openfunc)(struct tagitem *);
		int (*closefunc)();
		int (*exitfunc)();
	} module[MODULECOUNT];
};

/* prototypes */
void init_serverdata (struct serverdata *sd);
int init_modules(struct serverdata *sd);
void exit_modules(struct serverdata *sd);
void reconfig_modules(struct serverdata *sd);
int evaluate_args(struct serverdata *sd, int argc, char *argv[]);
void sighandler_cleanup (int signum);
int install_sighandler ();
int ipc_init_stub ();

#endif    /* INCLUDE_INIT_H */
