. /usr/share/debconf/confmodule

iscsi_login () {
	local portal discovery targets target
	while :; do
		db_input critical partman-iscsi/login/address
		db_go || return 1
		db_get partman-iscsi/login/address
		[ "$RET" ] || continue

		portal="$RET"
		if [ "${portal%:*}" = "$portal" ]; then
			portal="$portal:3260"
		fi
		if ! discovery="$(iscsiadm -m discovery --type sendtargets \
					   --portal "$portal")"; then
			db_capb align
			db_subst partman-iscsi/login/no_targets \
				PORTAL "$portal"
			db_input critical partman-iscsi/login/no_targets
			db_go || true
			db_capb backup align
			continue
		fi

		targets="$(echo "$discovery" | while read portal target; do
			printf ', %s' "$(echo "$target" | sed 's/,/\\,/g')"
		done | sed 's/^, //')"
		db_subst partman-iscsi/login/targets PORTAL "$portal"
		db_subst partman-iscsi/login/targets TARGETS "$targets"
		db_input critical partman-iscsi/login/targets
		db_go || continue

		db_get partman-iscsi/login/targets
		targets="$RET"
		while [ "$targets" ]; do
			target="${targets%%, *}"
			if ! iscsiadm -m node --portal "$portal" \
				      --target "$target" --login; then
				db_capb align
				db_subst partman-iscsi/login/failed \
					PORTAL "$portal"
				db_subst partman-iscsi/login/failed \
					TARGET "$target"
				db_input critical partman-iscsi/login/failed
				db_go partman-iscsi/login/failed || true
				db_capb backup align
			fi

			if [ "$target" = "$targets" ]; then
				targets=
			else
				targets="${targets#*, }"
			fi
		done
		break
	done
}
