#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ots/libots.h>

/*
The Inner product of two text is defined as the number of topics they
share. One of my professors is doing research in this field and needed a
matrix of the inner product of cunks of text. Here is a quick example, 
of how to use OTS to generate this list of topics. 

This code shows how to calculate the relevance of two texts; for example 
slashdot article and a comment; Score should be compared to other scores
given by the program to other comments; The score is reletive and not absolute;  
*/

#define BUFF_SIZE 1024*8

FILE *stream_from_file(char *filename)
{
 if (filename)
    {
      FILE *input_stream = fopen (filename, "r");
      if  (!input_stream)
        {
          perror ("Couldn't load input file");
          return NULL;
        }
	return input_stream;
    }
return NULL;
}



char * buffer_from_file(FILE *stream)
{
  unsigned char fread_buffer[BUFF_SIZE];
  unsigned char *buffer;
  size_t nread, total_read, avail_size;
  
  if (stream==NULL) return NULL;

  buffer = g_new0 (unsigned char, BUFF_SIZE);
  avail_size = BUFF_SIZE;
  total_read = nread = 0;
   while ((nread =
          fread (fread_buffer, sizeof (unsigned char), sizeof (fread_buffer),
                 stream)) > 0)
    {
      if (nread + total_read > avail_size)
        {
          avail_size *= 2;
          buffer = g_renew (unsigned char, buffer, avail_size);
        }

      strncpy (buffer + total_read, fread_buffer, nread);
      total_read += nread;
    }
fclose(stream);
return buffer;
}

int main(int argc , char* argv[])
{

int j;
char *topics;

if (argc<3)
{
printf("usage: inn-prod [file1.txt] [file2.txt]\n");
return 0;
}

char *main_text=buffer_from_file(stream_from_file(argv[1]));
if (main_text==NULL) return 0;

topics=ots_text_topics(main_text,"en",10);

printf("Main Topics for [%s]:\n[%s]\n",argv[1],topics);
g_free(topics);


for (j=2;j<argc;j++)
{
	int score=0;
	char *comment_text=NULL;
	comment_text=buffer_from_file(stream_from_file(argv[j]));
	if ((comment_text)&&(main_text)) score=ots_text_relations(main_text,"en",comment_text,"en",15);
	printf("%s:[%d]\n",argv[j],score);

if (comment_text!=NULL) g_free(comment_text);
}


if (main_text!=NULL) g_free(main_text);

return 0;
}
