#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <ots/libots.h>

/****************/

	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *hbox;

	GtkWidget *spinner;
	GtkWidget *langage;
	GtkWidget *summ_now;
	GtkWidget *exit_now;
	
	GtkWidget *art_label;
	GtkWidget *control_label;	
	GtkWidget *per_label;
	GtkWidget *empty_label;
	GtkWidget *main_menu,*menu_items , *root_menu ,*menu_bar; 			 /*main menu*/
	GtkWidget *opt, *menu, *item; 								/*language menu*/
	GtkWidget *article_box;	
	GtkWidget *scrolled_window1;
	GtkAdjustment *adj;
	
	
GtkTextTag *tag_red;
GtkTextTag *tag_blue;	
	
	
GtkTextBuffer* summary;
GtkTextBuffer* article;	

char *language;
	void call_ots(void);
	void set_lang(GtkWidget *item,char *lng);
GtkWidget *make_menu_item (gchar     *name, GCallback  callback, gpointer   data);
			   
	
int main( int   argc,
          char *argv[] )
{
 
    char* english="en";
    gtk_init (&argc, &argv);

    /* create a new window */
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_widget_set_size_request (GTK_WIDGET (window), 450, 250);
    gtk_window_set_title (GTK_WINDOW (window), "Gnome-Summarizer");
		
    g_signal_connect (G_OBJECT (window), "destroy",G_CALLBACK (gtk_main_quit), NULL);
    g_signal_connect_swapped (G_OBJECT (window), "delete_event",G_CALLBACK (gtk_widget_destroy),G_OBJECT (window));

    scrolled_window1 = gtk_scrolled_window_new (NULL, NULL);                                                                                                                        
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window1),GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
    gtk_scrolled_window_set_shadow_type ( GTK_SCROLLED_WINDOW(scrolled_window1), GTK_SHADOW_IN);
    gtk_widget_show (scrolled_window1);
   
    main_menu = gtk_menu_new ();
    menu_items = gtk_menu_item_new_with_label ("Exit");    
    gtk_menu_shell_append (GTK_MENU_SHELL (main_menu), menu_items);
                                                                                                                            
    g_signal_connect_swapped (G_OBJECT (menu_items), "activate",G_CALLBACK (gtk_widget_destroy),G_OBJECT (window));
    gtk_widget_show (menu_items);

    
    root_menu = gtk_menu_item_new_with_label ("File");                                                                                                                        
	 gtk_menu_item_set_submenu (GTK_MENU_ITEM (root_menu), main_menu);
    gtk_widget_show (root_menu);

    menu_bar = gtk_menu_bar_new ();
    gtk_menu_shell_append (GTK_MENU_SHELL (menu_bar), root_menu);
    gtk_widget_show (menu_bar);



    opt = gtk_option_menu_new ();
    menu = gtk_menu_new ();

	 language=english;

    item = make_menu_item ("English",G_CALLBACK (set_lang),GINT_TO_POINTER ("en"));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);  
    item = make_menu_item ("French",G_CALLBACK (set_lang),GINT_TO_POINTER ("fr"));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
    item = make_menu_item ("Spanish",G_CALLBACK (set_lang),GINT_TO_POINTER ("es"));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
    item = make_menu_item ("Norwegian",G_CALLBACK (set_lang),GINT_TO_POINTER ("nn"));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
    
    item = make_menu_item ("Russian",G_CALLBACK (set_lang),GINT_TO_POINTER ("ru"));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
    
    item = make_menu_item ("Ukrainian",G_CALLBACK (set_lang),GINT_TO_POINTER ("uk"));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);

    item = make_menu_item ("Dutch",G_CALLBACK (set_lang),GINT_TO_POINTER ("nl"));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
    
    item = make_menu_item ("German",G_CALLBACK (set_lang),GINT_TO_POINTER ("de"));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
        
    item = make_menu_item ("Italian",G_CALLBACK (set_lang),GINT_TO_POINTER ("it"));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
    
    item = make_menu_item ("Romanian",G_CALLBACK (set_lang),GINT_TO_POINTER ("ro"));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);
    
    item = make_menu_item ("Portuguese",G_CALLBACK (set_lang),GINT_TO_POINTER ("pt"));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);  
    item = make_menu_item ("Hebrew",G_CALLBACK (set_lang),GINT_TO_POINTER ("he"));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);  
    item = make_menu_item ("Yiddish",G_CALLBACK (set_lang),GINT_TO_POINTER ("yi"));
    gtk_menu_shell_append (GTK_MENU_SHELL (menu), item);  

  
    gtk_option_menu_set_menu (GTK_OPTION_MENU (opt), menu);
    
   

    vbox = gtk_vbox_new (FALSE, 2);
    gtk_widget_show (vbox);

	hbox = gtk_hbox_new (FALSE, 6);
        gtk_widget_show (hbox);


	art_label = gtk_label_new ("http://libots.sf.net");
	gtk_widget_show (art_label);

	per_label = gtk_label_new ("Summary %");
	gtk_widget_show (per_label);

	empty_label = gtk_label_new ("");
	gtk_widget_show (empty_label);


	control_label = gtk_label_new ("Gnome Summarizer");
	gtk_widget_show (control_label);
	
        article_box = gtk_text_view_new();
        gtk_widget_show (article_box);
  

        gtk_text_view_set_wrap_mode(article_box,GTK_WRAP_WORD);                                                     




	gtk_container_add (GTK_CONTAINER (window), vbox);
	gtk_box_pack_start (GTK_BOX (vbox), menu_bar, FALSE, FALSE, 0);
	//gtk_box_pack_start (GTK_BOX (vbox), control_label, FALSE, FALSE, 0);
   gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);


	gtk_container_add (GTK_CONTAINER (scrolled_window1), article_box);
	gtk_container_add (GTK_CONTAINER (vbox), scrolled_window1);
	
  
  adj = (GtkAdjustment *) gtk_adjustment_new (1.0, 1.0, 100.0, 1.0,5.0, 0.0);
  spinner = gtk_spin_button_new (adj, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (spinner), TRUE);


   gtk_box_pack_start (GTK_BOX (hbox), per_label, FALSE, FALSE, 0);

  gtk_box_pack_start (GTK_BOX (hbox), spinner, FALSE, FALSE, 0);
  gtk_widget_show (spinner);                                                                                                              

  g_signal_connect (G_OBJECT (adj), "value_changed",
                    G_CALLBACK (call_ots),(gpointer) spinner);


   
   summ_now = gtk_button_new_with_label ("Summarize");							  
	gtk_widget_show (summ_now);
  
   exit_now = gtk_button_new_from_stock (GTK_STOCK_QUIT);	  
	gtk_widget_show (exit_now);


    gtk_box_pack_start (GTK_BOX (hbox), opt, FALSE, FALSE, 0);
    gtk_widget_show (opt);
    
   gtk_box_pack_start (GTK_BOX (hbox), summ_now, FALSE, FALSE, 0);
   gtk_container_add (GTK_CONTAINER (hbox), empty_label);
   gtk_box_pack_start (GTK_BOX (hbox), exit_now, FALSE, FALSE, 0);

    
    
   g_signal_connect_swapped (G_OBJECT (exit_now), "clicked", G_CALLBACK (gtk_widget_destroy), G_OBJECT (window));
	g_signal_connect_swapped (G_OBJECT (summ_now), "clicked", G_CALLBACK (call_ots),NULL);
			      
	gtk_box_pack_start (GTK_BOX (vbox), art_label, FALSE, FALSE, 0);
   article = gtk_text_view_get_buffer (GTK_TEXT_VIEW(article_box));
   tag_red = gtk_text_buffer_create_tag (article, "red_foreground","background", "yellow", NULL);  
   tag_blue = gtk_text_buffer_create_tag (article, "blue_foreground","foreground", "blue", NULL);  


   gtk_widget_show (window);

    gtk_main();

    return 0;
}

void set_lang(GtkWidget *item,char *lng)
{
language=lng;
}

void call_ots(void)
{
OtsArticle *Art;
  
int sum_per;
GtkSpinButton *spin;
 
char* buffer; 


GList *line;
GtkTextIter iter;
GtkTextIter start_iter;
GtkTextIter end_iter;
int i;

char *dictionary_file = language;	/* if not told otherwise, assume we're using english */
  
spin = GTK_SPIN_BUTTON (spinner);
sum_per = gtk_spin_button_get_value_as_int (spin);
   

 
Art = ots_new_article ();	
if (!ots_load_xml_dictionary (Art, dictionary_file))
    {
      ots_free_article (Art);
      perror ("Couldn't load dictionary");
      return;
    }

	gtk_text_buffer_get_end_iter (article,&end_iter);   
	gtk_text_buffer_get_start_iter (article,&start_iter);   
	buffer=gtk_text_buffer_get_text(article,&start_iter,&end_iter,0);

	gtk_text_buffer_get_end_iter (article,&end_iter);   
	gtk_text_buffer_get_start_iter (article,&start_iter);   
	gtk_text_buffer_delete(article,&start_iter,&end_iter);

	
	
  ots_parse_stream (buffer,strlen(buffer), Art);	/* read article from stdin , put it in struct Article */
  ots_grade_doc (Art);					/* grade each sentence (how relevent is it to the text) */
  ots_highlight_doc (Art, sum_per);	/* highlight what we are going to print 0% - 100% of the words */
       			

  for (line = (GList *) Art->lines; line != NULL; line = line->next)	
	{ 
	OtsSentence * aLine=line->data;

		if (aLine->selected)
   	 {
   	 
				gtk_text_buffer_get_end_iter (article,&iter);   
			   gtk_text_buffer_insert_with_tags (article,&iter,ots_get_line_text (line->data,FALSE,&i),-1,tag_red,NULL);   
   	 }

		else 
		{ 	
				gtk_text_buffer_get_end_iter (article,&iter);   

			   gtk_text_buffer_insert_with_tags (article,&iter,ots_get_line_text (line->data,FALSE,&i),-1,tag_blue,NULL);
   		
   	 }
   	 
   } 
  

    	char *about_label=g_new0(char,1024);
	strcat(about_label,"Article talks about:");
	strcat(about_label,Art->title);
	gtk_label_set_text(art_label,about_label);	
  	return;
}		




GtkWidget *make_menu_item (gchar     *name,
                           GCallback  callback,
			   gpointer   data)
{
    GtkWidget *item;
  
    item = gtk_menu_item_new_with_label (name);
    g_signal_connect (G_OBJECT (item), "activate",
	              callback, (gpointer) data);
    gtk_widget_show (item);

    return item;
}			   




