#include "CosEventChannel.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

/* The following is mostly taken from CosEventComm-impl.c as generated by
   "orbit-idl -Eskeleton_impl CosEventComm.idl", only the stub
   implemementations have been removed and some lines have been added,
   those are marked with "added". also all supplier stuff have been removed */

/***************************************************************************/
/*                         begin of generated part                         */
/***************************************************************************/

/*** App-specific servant structures ***/

typedef struct {
   POA_CosEventComm_PushConsumer servant;
   PortableServer_POA poa;

} impl_POA_CosEventComm_PushConsumer;

typedef struct {
   POA_CosEventComm_PullConsumer servant;
   PortableServer_POA poa;

} impl_POA_CosEventComm_PullConsumer;

/*** Implementation stub prototypes ***/

static void impl_CosEventComm_PushConsumer__destroy(impl_POA_CosEventComm_PushConsumer * servant,
						    CORBA_Environment * ev);
void
 impl_CosEventComm_PushConsumer_push(impl_POA_CosEventComm_PushConsumer * servant,
				     CORBA_any * data,
				     CORBA_Environment * ev);

void
 impl_CosEventComm_PushConsumer_disconnect_push_consumer(impl_POA_CosEventComm_PushConsumer * servant,
						    CORBA_Environment * ev);

static void impl_CosEventComm_PullConsumer__destroy(impl_POA_CosEventComm_PullConsumer * servant,
						    CORBA_Environment * ev);
void
 impl_CosEventComm_PullConsumer_disconnect_pull_consumer(impl_POA_CosEventComm_PullConsumer * servant,
						    CORBA_Environment * ev);

/*** epv structures ***/

static PortableServer_ServantBase__epv impl_CosEventComm_PushConsumer_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_CosEventComm_PushConsumer__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_CosEventComm_PushConsumer__epv impl_CosEventComm_PushConsumer_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_CosEventComm_PushConsumer_push,

   (gpointer) & impl_CosEventComm_PushConsumer_disconnect_push_consumer,

};
static PortableServer_ServantBase__epv impl_CosEventComm_PullConsumer_base_epv =
{
   NULL,			/* _private data */
   (gpointer) & impl_CosEventComm_PullConsumer__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_CosEventComm_PullConsumer__epv impl_CosEventComm_PullConsumer_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_CosEventComm_PullConsumer_disconnect_pull_consumer,

};

/*** vepv structures ***/

static POA_CosEventComm_PushConsumer__vepv impl_CosEventComm_PushConsumer_vepv =
{
   &impl_CosEventComm_PushConsumer_base_epv,
   &impl_CosEventComm_PushConsumer_epv,
};
static POA_CosEventComm_PullConsumer__vepv impl_CosEventComm_PullConsumer_vepv =
{
   &impl_CosEventComm_PullConsumer_base_epv,
   &impl_CosEventComm_PullConsumer_epv,
};

/*** Stub implementations ***/

static CosEventComm_PushConsumer 
impl_CosEventComm_PushConsumer__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   CosEventComm_PushConsumer retval;
   impl_POA_CosEventComm_PushConsumer *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_CosEventComm_PushConsumer, 1);
   newservant->servant.vepv = &impl_CosEventComm_PushConsumer_vepv;
   newservant->poa = poa;
   POA_CosEventComm_PushConsumer__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_CosEventComm_PushConsumer__destroy(impl_POA_CosEventComm_PushConsumer * servant, CORBA_Environment * ev)
{

   POA_CosEventComm_PushConsumer__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

static CosEventComm_PullConsumer 
impl_CosEventComm_PullConsumer__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   CosEventComm_PullConsumer retval;
   impl_POA_CosEventComm_PullConsumer *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_CosEventComm_PullConsumer, 1);
   newservant->servant.vepv = &impl_CosEventComm_PullConsumer_vepv;
   newservant->poa = poa;
   POA_CosEventComm_PullConsumer__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_CosEventComm_PullConsumer__destroy(impl_POA_CosEventComm_PullConsumer * servant, CORBA_Environment * ev)
{

   POA_CosEventComm_PullConsumer__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

void
impl_CosEventComm_PushConsumer_push(impl_POA_CosEventComm_PushConsumer * servant,
				    CORBA_any * data,
				    CORBA_Environment * ev)
{
}

void
impl_CosEventComm_PushConsumer_disconnect_push_consumer(impl_POA_CosEventComm_PushConsumer * servant,
						     CORBA_Environment * ev)
{
}

void
impl_CosEventComm_PullConsumer_disconnect_pull_consumer(impl_POA_CosEventComm_PullConsumer * servant,
						     CORBA_Environment * ev)
{
}

int
main (int argc, char *argv[])
{
  CORBA_ORB orb;
  CORBA_Environment ev;
  CosEventChannelAdmin_EventChannelFactory factory;
  CosEventChannelAdmin_EventChannel channel;
  CosEventChannelAdmin_ConsumerAdmin consumer_admin;
  CosEventChannelAdmin_ProxyPushSupplier push_supplier;
  CosEventComm_PushConsumer push_consumer;
  PortableServer_POA root_poa;
  PortableServer_POAManager pm;
  FILE *infile;
  char objref_str[2048];
  int i;

  CORBA_exception_init (&ev);
  
  orb = CORBA_ORB_init (&argc, argv, "orbit-local-orb", &ev);

  root_poa = (PortableServer_POA)
    CORBA_ORB_resolve_initial_references (orb, "RootPOA", &ev);

  pm = PortableServer_POA__get_the_POAManager (root_poa, &ev);
  PortableServer_POAManager_activate (pm, &ev);

  push_consumer = impl_CosEventComm_PushConsumer__create(root_poa, &ev);

  infile = fopen( "/tmp/event-service-ior", "r" );
  fgets( objref_str, 2048, infile );
  fclose( infile );
  i = strlen(objref_str) - 1;
  while(isspace(objref_str[i]))
    objref_str[i--] = '\0';
  g_assert(!(strlen(objref_str) % 2));

  factory = CORBA_ORB_string_to_object(orb, objref_str, &ev);

  channel = 
    CosEventChannelAdmin_EventChannelFactory_new_event_channel( factory, &ev );

  consumer_admin = 
    CosEventChannelAdmin_EventChannel_for_consumers( channel, &ev );

  push_supplier =
    CosEventChannelAdmin_ConsumerAdmin_obtain_push_supplier( consumer_admin,
							     &ev );
  
  CosEventChannelAdmin_ProxyPushSupplier_connect_push_consumer( push_supplier,
							   push_consumer,
							   &ev );

  CORBA_Object_release (factory, &ev);
  return 0;
}
