/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_galdlg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:55:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <algorithm>
#include <ucbhelper/content.hxx>
#include <vos/mutex.hxx>
#include <vcl/svapp.hxx>
#include <vcl/msgbox.hxx>
#include <svtools/pathoptions.hxx>
#include "opengrf.hxx"
#include "impgrf.hxx"
#include "gallery1.hxx"
#include "galtheme.hxx"
#include "galbrws2.hxx"
#include "galdlg.hxx"

#ifndef _PICKERHELPER_HXX
#include <svtools/pickerhelper.hxx>
#endif
#ifndef _SVX_HELPID_HRC
#include "helpid.hrc"
#endif
#ifndef INCLUDED_SVTOOLS_SYSLOCALE_HXX
#include <svtools/syslocale.hxx>
#endif

#ifndef  _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#ifndef  _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif

#ifndef  _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif

#ifndef  _COM_SUN_STAR_UI_DIALOGS_EXECUTABLEDIALOGRESULTS_HPP_
#include <com/sun/star/ui/dialogs/ExecutableDialogResults.hpp>
#endif
#ifndef _COM_SUN_STAR_UI_XFOLDERPICKER_HDL_
#include <com/sun/star/ui/dialogs/XFolderPicker.hpp>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTACCESS_HPP_
#include <com/sun/star/ucb/XContentAccess.hpp>
#endif
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {


// --------------
// - Namespaces -
// --------------

using namespace ::ucb;
using namespace ::rtl;
using namespace ::cppu;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::ucb;
using namespace ::com::sun::star::ui::dialogs;
using namespace ::com::sun::star::uno;


// -----------
// - Defines -
// -----------

#define MAXPATH 1024

// ----------------
// - SearchThread -
// ----------------

//STRIP001 SearchThread::SearchThread( SearchProgress* pProgess,
//STRIP001 							TPGalleryThemeProperties* pBrowser,
//STRIP001 							const INetURLObject& rStartURL ) :
//STRIP001 		mpProgress	( pProgess ),
//STRIP001 		mpBrowser	( pBrowser ),
//STRIP001 		maStartURL	( rStartURL )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SearchThread::~SearchThread()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SAL_CALL SearchThread::run()
//STRIP001 {
//STRIP001 	const String aFileType( mpBrowser->aCbbFileType.GetText() );
//STRIP001 	
//STRIP001 	if( aFileType.Len() )
//STRIP001 	{
//STRIP001 	    const sal_uInt16        nFileNumber = mpBrowser->aCbbFileType.GetEntryPos( aFileType );
//STRIP001         sal_uInt16              nBeginFormat, nEndFormat;
//STRIP001         ::std::vector< String > aFormats;
//STRIP001 
//STRIP001 	    if( !nFileNumber || ( nFileNumber >= mpBrowser->aCbbFileType.GetEntryCount() ) )
//STRIP001 	    {
//STRIP001 		    nBeginFormat = 1;
//STRIP001 		    nEndFormat = mpBrowser->aCbbFileType.GetEntryCount() - 1;
//STRIP001 	    }
//STRIP001 	    else
//STRIP001 		    nBeginFormat = nEndFormat = nFileNumber;
//STRIP001 
//STRIP001 	    for( sal_uInt16 i = nBeginFormat; i <= nEndFormat; ++i )
//STRIP001 	        aFormats.push_back( ( (FilterEntry*) mpBrowser->aFilterEntryList.GetObject( i ) )->aFilterName.ToLowerAscii() );
//STRIP001 
//STRIP001 	    ImplSearch( maStartURL, aFormats, mpBrowser->bSearchRecursive );    
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SAL_CALL SearchThread::onTerminated()
//STRIP001 {
//STRIP001 	Application::PostUserEvent( LINK( mpProgress, SearchProgress, CleanUpHdl ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SearchThread::ImplSearch( const INetURLObject& rStartURL, 
//STRIP001                                const ::std::vector< String >& rFormats,
//STRIP001                                BOOL bRecursive )
//STRIP001 {
//STRIP001 	::vos::IMutex&	rMutex = Application::GetSolarMutex();
//STRIP001 
//STRIP001 	rMutex.acquire();
//STRIP001 	mpProgress->SetDirectory( rStartURL );
//STRIP001     mpProgress->Sync();
//STRIP001 	rMutex.release();
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Reference< XCommandEnvironment >	xEnv;
//STRIP001 		Content	   							aCnt( rStartURL.GetMainURL( INetURLObject::NO_DECODE ), xEnv );
//STRIP001 		Sequence< OUString >				aProps( 1 );
//STRIP001 
//STRIP001 		aProps.getArray()[ 0 ] == OUString::createFromAscii( "Url" );
//STRIP001 		Reference< ::com::sun::star::sdbc::XResultSet > xResultSet( aCnt.createCursor( aProps, INCLUDE_FOLDERS_AND_DOCUMENTS ) );
//STRIP001 
//STRIP001 		if( xResultSet.is() )
//STRIP001 		{
//STRIP001 			Reference< XContentAccess > xContentAccess( xResultSet, UNO_QUERY );
//STRIP001 
//STRIP001 			if( xContentAccess.is() )
//STRIP001 			{
//STRIP001 				while( xResultSet->next() && schedule() )
//STRIP001 				{
//STRIP001 					INetURLObject	aFoundURL( xContentAccess->queryContentIdentifierString() );
//STRIP001 					DBG_ASSERT( aFoundURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 					Content			aFoundCnt( aFoundURL.GetMainURL( INetURLObject::NO_DECODE ), xEnv );
//STRIP001 
//STRIP001 					if( bRecursive && aFoundCnt.isFolder() )
//STRIP001 						ImplSearch( aFoundURL, rFormats, TRUE );
//STRIP001 					else if( aFoundCnt.isDocument() )
//STRIP001 					{
//STRIP001 						GraphicDescriptor   aDesc( aFoundURL );
//STRIP001 						String              aFileName;
//STRIP001 						
//STRIP001 						if( ( aDesc.Detect() && ::std::find( rFormats.begin(), rFormats.end(), aDesc.GetImportFormatShortName( aDesc.GetFileFormat() ).ToLowerAscii() ) != rFormats.end() ) ||
//STRIP001 						    ::std::find( rFormats.begin(), rFormats.end(), aFoundURL.GetExtension().ToLowerAscii() ) != rFormats.end() )
//STRIP001 						{
//STRIP001 							rMutex.acquire();
//STRIP001 							mpBrowser->aFoundList.Insert( new String( aFoundURL.GetMainURL( INetURLObject::NO_DECODE ) ), LIST_APPEND );
//STRIP001 							mpBrowser->aLbxFound.InsertEntry( GetReducedString( aFoundURL, 50 ), (USHORT) mpBrowser->aFoundList.Count() - 1 );
//STRIP001 							rMutex.release();
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( const ContentCreationException& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 	catch( const ::com::sun::star::uno::RuntimeException& )
//STRIP001 	{
//STRIP001 	}
//STRIP001     catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------
//STRIP001 // - SearchProgress -
//STRIP001 // ------------------
//STRIP001 
//STRIP001 SearchProgress::SearchProgress( Window* pParent, const INetURLObject& rStartURL ) :
//STRIP001 	ModalDialog     ( pParent, GAL_RESID(RID_SVXDLG_GALLERY_SEARCH_PROGRESS ) ),
//STRIP001 	aFtSearchDir    ( this, ResId( FT_SEARCH_DIR ) ),
//STRIP001     aFLSearchDir   ( this, ResId( FL_SEARCH_DIR ) ),
//STRIP001 	aFtSearchType   ( this, ResId( FT_SEARCH_TYPE ) ),
//STRIP001     aFLSearchType  ( this, ResId( FL_SEARCH_TYPE ) ),
//STRIP001 	aBtnCancel      ( this, ResId( BTN_CANCEL ) ),
//STRIP001 	maSearchThread	( this, (TPGalleryThemeProperties*) pParent, rStartURL )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	aBtnCancel.SetClickHdl( LINK( this, SearchProgress, ClickCancelBtn ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SearchProgress, ClickCancelBtn, void*, p )
//STRIP001 {
//STRIP001 	maSearchThread.terminate();
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SearchProgress, CleanUpHdl, void*, p )
//STRIP001 {
//STRIP001 	EndDialog( RET_OK );
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 short SearchProgress::Execute()
//STRIP001 {
//STRIP001 	maSearchThread.create();
//STRIP001 	return ModalDialog::Execute();
//STRIP001 }
//STRIP001 
//STRIP001 // --------------
//STRIP001 // - TakeThread -
//STRIP001 // --------------
//STRIP001 
//STRIP001 TakeThread::TakeThread( TakeProgress* pProgess, TPGalleryThemeProperties* pBrowser, List& rTakenList ) :
//STRIP001 		mpProgress	( pProgess ),
//STRIP001 		mpBrowser	( pBrowser ),
//STRIP001 		mrTakenList	( rTakenList )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 TakeThread::~TakeThread()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SAL_CALL TakeThread::run()
//STRIP001 {
//STRIP001 	String				aName;
//STRIP001 	INetURLObject		aURL;
//STRIP001 	USHORT				nEntries;
//STRIP001 	GalleryTheme* 		pThm = mpBrowser->GetXChgData()->pTheme;
//STRIP001 	::vos::IMutex&		rMutex = Application::GetSolarMutex();
//STRIP001 	USHORT				nPos;
//STRIP001 	GalleryProgress*	pStatusProgress;
//STRIP001 
//STRIP001 	rMutex.acquire();
//STRIP001 	pStatusProgress = new GalleryProgress;
//STRIP001 	nEntries = mpBrowser->bTakeAll ? mpBrowser->aLbxFound.GetEntryCount() : mpBrowser->aLbxFound.GetSelectEntryCount();
//STRIP001 	pThm->LockBroadcaster();
//STRIP001 	rMutex.release();
//STRIP001 
//STRIP001 	for( USHORT i = 0; i < nEntries && schedule(); i++ )
//STRIP001 	{
//STRIP001 		// kompletten Filenamen aus FoundList holen
//STRIP001 		if( mpBrowser->bTakeAll )
//STRIP001 			aURL = *mpBrowser->aFoundList.GetObject( nPos = i );
//STRIP001 		else
//STRIP001 			aURL = *mpBrowser->aFoundList.GetObject( nPos = mpBrowser->aLbxFound.GetSelectEntryPos( i ) );
//STRIP001 
//STRIP001 		// Position in Taken-Liste uebernehmen
//STRIP001 		mrTakenList.Insert( (void*) nPos, LIST_APPEND );
//STRIP001 
//STRIP001 		rMutex.acquire();
//STRIP001 		mpProgress->SetFile( aURL.GetMainURL( INetURLObject::DECODE_UNAMBIGUOUS ) );
//STRIP001 		pStatusProgress->Update( i, nEntries - 1 );
//STRIP001         mpProgress->Sync();
//STRIP001 		pThm->InsertURL( aURL );
//STRIP001 		rMutex.release();
//STRIP001 	}
//STRIP001 
//STRIP001 	rMutex.acquire();
//STRIP001 	pThm->UnlockBroadcaster();
//STRIP001 	delete pStatusProgress;
//STRIP001     rMutex.release();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SAL_CALL TakeThread::onTerminated()
//STRIP001 {
//STRIP001 	Application::PostUserEvent( LINK( mpProgress, TakeProgress, CleanUpHdl ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ----------------
//STRIP001 // - TakeProgress -
//STRIP001 // ----------------
//STRIP001 
//STRIP001 TakeProgress::TakeProgress( Window* pWindow ) :
//STRIP001 	ModalDialog     ( pWindow, GAL_RESID( RID_SVXDLG_GALLERY_TAKE_PROGRESS ) ),
//STRIP001 	maTakeThread	( this, (TPGalleryThemeProperties*) pWindow, maTakenList ),
//STRIP001 	aFtTakeFile     ( this, ResId( FT_TAKE_FILE ) ),
//STRIP001     aFLTakeProgress( this, ResId( FL_TAKE_PROGRESS ) ),
//STRIP001 	aBtnCancel      ( this, ResId( BTN_CANCEL ) )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	aBtnCancel.SetClickHdl( LINK( this, TakeProgress, ClickCancelBtn ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( TakeProgress, ClickCancelBtn, void*, p )
//STRIP001 {
//STRIP001     maTakeThread.terminate();
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( TakeProgress, CleanUpHdl, void*, p )
//STRIP001 {
//STRIP001 	TPGalleryThemeProperties*	mpBrowser = (TPGalleryThemeProperties*) GetParent();
//STRIP001 	::std::bit_vector           aRemoveEntries( mpBrowser->aFoundList.Count(), false );
//STRIP001 	::std::vector< String >     aRemainingVector;
//STRIP001 	sal_uInt32                  i, nCount;
//STRIP001 
//STRIP001 	GetParent()->EnterWait();
//STRIP001 	mpBrowser->aLbxFound.SetUpdateMode( FALSE );
//STRIP001 	mpBrowser->aLbxFound.SetNoSelection();
//STRIP001 
//STRIP001 	// mark all taken positions in aRemoveEntries
//STRIP001 	for( i = 0UL, nCount = maTakenList.Count(); i < nCount; ++i )
//STRIP001 	    aRemoveEntries[ (ULONG) maTakenList.GetObject( i ) ] = true;
//STRIP001 
//STRIP001 	maTakenList.Clear();
//STRIP001 	    
//STRIP001     // refill found list
//STRIP001     for( i = 0, nCount = aRemoveEntries.size(); i < nCount; ++i )
//STRIP001         if( !aRemoveEntries[ i ] )
//STRIP001             aRemainingVector.push_back( *mpBrowser->aFoundList.GetObject( i ) );
//STRIP001 
//STRIP001     for( String* pStr = mpBrowser->aFoundList.First(); pStr; pStr = mpBrowser->aFoundList.Next() )
//STRIP001 	    delete pStr;
//STRIP001 	
//STRIP001 	mpBrowser->aFoundList.Clear();
//STRIP001 	
//STRIP001 	for( i = 0, nCount = aRemainingVector.size(); i < nCount; ++i )
//STRIP001 	    mpBrowser->aFoundList.Insert( new String( aRemainingVector[ i ] ), LIST_APPEND );
//STRIP001 	
//STRIP001 	aRemainingVector.clear();
//STRIP001 	
//STRIP001     // refill list box
//STRIP001     for( i = 0, nCount = aRemoveEntries.size(); i < nCount; ++i )
//STRIP001         if( !aRemoveEntries[ i ] )
//STRIP001             aRemainingVector.push_back( mpBrowser->aLbxFound.GetEntry( (sal_uInt16) i ) );
//STRIP001 
//STRIP001     mpBrowser->aLbxFound.Clear();
//STRIP001 	
//STRIP001 	for( i = 0, nCount = aRemainingVector.size(); i < nCount; ++i )
//STRIP001 	    mpBrowser->aLbxFound.InsertEntry( aRemainingVector[ i ] );
//STRIP001 	
//STRIP001 	aRemainingVector.clear();
//STRIP001 
//STRIP001 	mpBrowser->aLbxFound.SetUpdateMode( TRUE );
//STRIP001 	mpBrowser->SelectFoundHdl( NULL );
//STRIP001 	GetParent()->LeaveWait();
//STRIP001 	EndDialog( RET_OK );
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 short TakeProgress::Execute()
//STRIP001 {
//STRIP001 	maTakeThread.create();
//STRIP001 	return ModalDialog::Execute();
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------
//STRIP001 // - ActualizeProgress -
//STRIP001 // ---------------------
//STRIP001 
//STRIP001 ActualizeProgress::ActualizeProgress( Window* pWindow, GalleryTheme* pThm ) :
//STRIP001 	ModalDialog				( pWindow, GAL_RESID( RID_SVXDLG_GALLERY_ACTUALIZE_PROGRESS ) ),
//STRIP001 	aFtActualizeFile		( this, ResId( FT_ACTUALIZE_FILE ) ),
//STRIP001     aFLActualizeProgress   ( this, ResId( FL_ACTUALIZE_PROGRESS ) ),
//STRIP001 	aBtnCancel				( this, ResId( BTN_CANCEL ) ),
//STRIP001 	pTheme					( pThm )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	aBtnCancel.SetClickHdl( LINK( this, ActualizeProgress, ClickCancelBtn ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 short ActualizeProgress::Execute()
//STRIP001 {
//STRIP001 	short nRet;
//STRIP001 
//STRIP001 	pTimer = new Timer;
//STRIP001 
//STRIP001 	if ( pTimer )
//STRIP001 	{
//STRIP001 		pTimer->SetTimeoutHdl( LINK( this, ActualizeProgress, TimeoutHdl ) );
//STRIP001 		pTimer->SetTimeout( 500 );
//STRIP001 		pTimer->Start();
//STRIP001 	}
//STRIP001 
//STRIP001 	nRet = ModalDialog::Execute();
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( ActualizeProgress, ClickCancelBtn, void*, p )
//STRIP001 {
//STRIP001 	pTheme->AbortActualize();
//STRIP001 	EndDialog( RET_OK );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( ActualizeProgress, TimeoutHdl, Timer*, pTimer )
//STRIP001 {
//STRIP001 	if ( pTimer )
//STRIP001 	{
//STRIP001 		pTimer->Stop();
//STRIP001 		delete pTimer;
//STRIP001 	}
//STRIP001 
//STRIP001 	pTheme->Actualize( LINK( this, ActualizeProgress, ActualizeHdl ), &aStatusProgress );
//STRIP001 	ClickCancelBtn( NULL );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( ActualizeProgress, ActualizeHdl, INetURLObject*, pURL )
//STRIP001 {
//STRIP001   for( long i = 0; i < 128; i++ )
//STRIP001 	Application::Reschedule();
//STRIP001 
//STRIP001     Flush();
//STRIP001     Sync();
//STRIP001 
//STRIP001     if( pURL )
//STRIP001     {
//STRIP001         aFtActualizeFile.SetText( GetReducedString( *pURL, 30 ) );
//STRIP001         aFtActualizeFile.Flush();
//STRIP001         aFtActualizeFile.Sync();
//STRIP001     }
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------
//STRIP001 // - TitleDialog -
//STRIP001 // ---------------
//STRIP001 
//STRIP001 TitleDialog::TitleDialog( Window* pParent, const String& rOldTitle ) :
//STRIP001 	ModalDialog	( pParent, GAL_RESID( RID_SVXDLG_GALLERY_TITLE ) ),
//STRIP001 	maOk		( this, GAL_RESID( BTN_OK ) ),
//STRIP001 	maCancel	( this, GAL_RESID( BTN_CANCEL ) ),
//STRIP001 	maHelp		( this, GAL_RESID( BTN_HELP ) ),
//STRIP001     maFL       ( this, GAL_RESID( FL_TITLE ) ),
//STRIP001 	maEdit		( this, GAL_RESID( EDT_TITLE ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	maEdit.SetText( rOldTitle );
//STRIP001 	maEdit.GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------
//STRIP001 // - GalleryIdDialog -
//STRIP001 // -------------------
//STRIP001 
//STRIP001 GalleryIdDialog::GalleryIdDialog( Window* pParent, GalleryTheme* _pThm ) :
//STRIP001 			ModalDialog	( pParent, GAL_RESID( RID_SVXDLG_GALLERY_THEMEID ) ),
//STRIP001 			aBtnOk		( this, GAL_RESID( BTN_OK ) ),
//STRIP001 			aBtnCancel	( this, GAL_RESID( BTN_CANCEL ) ),
//STRIP001             aFLId      ( this, GAL_RESID( FL_ID ) ),
//STRIP001 			aLbResName	( this, GAL_RESID( LB_RESNAME ) ),
//STRIP001 			pThm		( _pThm )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aLbResName.InsertEntry( String( RTL_CONSTASCII_USTRINGPARAM( "!!! No Id !!!" ) ) );
//STRIP001 
//STRIP001 	for( USHORT i = RID_GALLERYSTR_THEME_FIRST; i <= RID_GALLERYSTR_THEME_LAST; i++ )
//STRIP001 		aLbResName.InsertEntry( String( GAL_RESID( i ) ) );
//STRIP001 
//STRIP001 	aLbResName.SelectEntryPos( (USHORT) pThm->GetId() );
//STRIP001 	aLbResName.GrabFocus();
//STRIP001 
//STRIP001 	aBtnOk.SetClickHdl( LINK( this, GalleryIdDialog, ClickOkHdl ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( GalleryIdDialog, ClickOkHdl, void*, p )
//STRIP001 {
//STRIP001 	Gallery*	pGal = pThm->GetParent();
//STRIP001 	const ULONG	nId = GetId();
//STRIP001 	BOOL		bDifferentThemeExists = FALSE;
//STRIP001 
//STRIP001 	for( ULONG i = 0, nCount = pGal->GetThemeCount(); i < nCount && !bDifferentThemeExists; i++ )
//STRIP001 	{
//STRIP001 		const GalleryThemeEntry* pInfo = pGal->GetThemeInfo( i );
//STRIP001 
//STRIP001 		if( ( pInfo->GetId() == nId ) && ( pInfo->GetThemeName() != pThm->GetName() ) )
//STRIP001 		{
//STRIP001 			String aStr( GAL_RESID( RID_SVXSTR_GALLERY_ID_EXISTS ) );
//STRIP001 
//STRIP001 			aStr += String( RTL_CONSTASCII_USTRINGPARAM( " (" ) );
//STRIP001 			aStr += pInfo->GetThemeName();
//STRIP001 			aStr += ')';
//STRIP001 
//STRIP001 			InfoBox aBox( this, aStr );
//STRIP001 			aBox.Execute();
//STRIP001 			aLbResName.GrabFocus();
//STRIP001 			bDifferentThemeExists = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !bDifferentThemeExists )
//STRIP001 		EndDialog( RET_OK );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // --------------------------
//STRIP001 // - GalleryThemeProperties -
//STRIP001 // --------------------------
//STRIP001 
//STRIP001 GalleryThemeProperties::GalleryThemeProperties( Window* pParent, ExchangeData* _pData, SfxItemSet* pItemSet  ) :
//STRIP001 			SfxTabDialog    ( pParent, GAL_RESID( RID_SVXTABDLG_GALLERYTHEME ), pItemSet ),
//STRIP001 			pData			( _pData )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	AddTabPage( RID_SVXTABPAGE_GALLERY_GENERAL, TPGalleryThemeGeneral::Create, 0 );
//STRIP001 	AddTabPage( RID_SVXTABPAGE_GALLERYTHEME_FILES, TPGalleryThemeProperties::Create, 0 );
//STRIP001 
//STRIP001 	if( pData->pTheme->IsReadOnly() )
//STRIP001 		RemoveTabPage( RID_SVXTABPAGE_GALLERYTHEME_FILES );
//STRIP001 
//STRIP001 	String aText( GetText() );
//STRIP001 
//STRIP001 	aText += pData->pTheme->GetName();
//STRIP001 
//STRIP001 	if( pData->pTheme->IsReadOnly() )
//STRIP001 		aText += String( GAL_RESID( RID_SVXSTR_GALLERY_READONLY ) );
//STRIP001 
//STRIP001 	SetText( aText );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryThemeProperties::PageCreated( USHORT nId, SfxTabPage &rPage )
//STRIP001 {
//STRIP001 	if( RID_SVXTABPAGE_GALLERY_GENERAL == nId )
//STRIP001 		( (TPGalleryThemeGeneral&) rPage ).SetXChgData( pData );
//STRIP001 	else
//STRIP001 		( (TPGalleryThemeProperties&) rPage ).SetXChgData( pData );
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------
//STRIP001 // - TPGalleryThemeGeneral -
//STRIP001 // -------------------------
//STRIP001 
//STRIP001 TPGalleryThemeGeneral::TPGalleryThemeGeneral( Window* pParent, const SfxItemSet& rSet ) :
//STRIP001 			SfxTabPage              ( pParent, GAL_RESID( RID_SVXTABPAGE_GALLERY_GENERAL ), rSet ),
//STRIP001 			aFiMSImage              ( this, GAL_RESID( FI_MS_IMAGE ) ),
//STRIP001 			aEdtMSName              ( this, GAL_RESID( EDT_MS_NAME ) ),
//STRIP001 			aFlMSGeneralFirst       ( this, GAL_RESID( FL_MS_GENERAL_FIRST ) ),
//STRIP001 			aFtMSType               ( this, GAL_RESID( FT_MS_TYPE ) ),
//STRIP001 			aFtMSShowType           ( this, GAL_RESID( FT_MS_SHOW_TYPE ) ),
//STRIP001 			aFtMSPath               ( this, GAL_RESID( FT_MS_PATH ) ),
//STRIP001 			aFtMSShowPath           ( this, GAL_RESID( FT_MS_SHOW_PATH ) ),
//STRIP001 			aFtMSContent            ( this, GAL_RESID( FT_MS_CONTENT ) ),
//STRIP001 			aFtMSShowContent        ( this, GAL_RESID( FT_MS_SHOW_CONTENT ) ),
//STRIP001 			aFlMSGeneralSecond      ( this, GAL_RESID( FL_MS_GENERAL_SECOND ) ),
//STRIP001 			aFtMSChangeDate         ( this, GAL_RESID( FT_MS_CHANGEDATE ) ),
//STRIP001 			aFtMSShowChangeDate     ( this, GAL_RESID( FT_MS_SHOW_CHANGEDATE ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void TPGalleryThemeGeneral::SetXChgData( ExchangeData* _pData )
//STRIP001 {
//STRIP001 	pData = _pData;
//STRIP001 
//STRIP001 	GalleryTheme*		pThm = pData->pTheme;
//STRIP001 	String              aOutStr( String::CreateFromInt32( pThm->GetObjectCount() ) );
//STRIP001 	String              aObjStr( GAL_RESID( RID_SVXSTR_GALLERYPROPS_OBJECT ) );
//STRIP001 	String              aAccess;
//STRIP001 	String				aType( GAL_RESID( RID_SVXSTR_GALLERYPROPS_GALTHEME ) );
//STRIP001 	BOOL				bReadOnly = pThm->IsReadOnly() && !pThm->IsImported();
//STRIP001 
//STRIP001 	aEdtMSName.SetText( pThm->GetName() );
//STRIP001 	aEdtMSName.SetReadOnly( bReadOnly );
//STRIP001 
//STRIP001 	if( bReadOnly )
//STRIP001 		aEdtMSName.Disable();
//STRIP001 	else
//STRIP001 		aEdtMSName.Enable();
//STRIP001 
//STRIP001 	if( pThm->IsReadOnly() )
//STRIP001 		aType += String( GAL_RESID( RID_SVXSTR_GALLERY_READONLY ) );
//STRIP001 
//STRIP001 	aFtMSShowType.SetText( aType );
//STRIP001 	aFtMSShowPath.SetText( pThm->GetSdgURL().GetMainURL( INetURLObject::DECODE_UNAMBIGUOUS ) );
//STRIP001 
//STRIP001 	// Ein- oder Mehrzahl?
//STRIP001 	if ( 1 == pThm->GetObjectCount() )
//STRIP001 		aObjStr = aObjStr.GetToken( 0 );
//STRIP001 	else
//STRIP001 		aObjStr = aObjStr.GetToken( 1 );
//STRIP001 
//STRIP001 	aOutStr += ' ';
//STRIP001 	aOutStr += aObjStr;
//STRIP001 
//STRIP001 	aFtMSShowContent.SetText( aOutStr );
//STRIP001 
//STRIP001 	// get locale wrapper (singleton)
//STRIP001 	const LocaleDataWrapper&    aLocaleData = SvtSysLocale().GetLocaleData();
//STRIP001 
//STRIP001 	// ChangeDate/Time
//STRIP001 	aAccess = aLocaleData.getDate( pData->aThemeChangeDate );
//STRIP001 	aAccess += String( RTL_CONSTASCII_USTRINGPARAM( ", " ) );
//STRIP001 	aAccess += aLocaleData.getTime( pData->aThemeChangeTime );
//STRIP001 	aFtMSShowChangeDate.SetText( aAccess );
//STRIP001 
//STRIP001 	// Image setzen
//STRIP001 	USHORT nId;
//STRIP001 
//STRIP001 	if( pThm->IsImported() )
//STRIP001 		nId = RID_SVXBMP_THEME_IMPORTED_BIG;
//STRIP001 	else if( pThm->IsReadOnly() )
//STRIP001 		nId = RID_SVXBMP_THEME_READONLY_BIG;
//STRIP001 	else if( pThm->IsDefault() )
//STRIP001 		nId = RID_SVXBMP_THEME_DEFAULT_BIG;
//STRIP001 	else
//STRIP001 		nId = RID_SVXBMP_THEME_NORMAL_BIG;
//STRIP001 
//STRIP001 	aFiMSImage.SetImage( Image( Bitmap( GAL_RESID( nId ) ), COL_LIGHTMAGENTA ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL TPGalleryThemeGeneral::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	pData->aEditedTitle = aEdtMSName.GetText();
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* TPGalleryThemeGeneral::Create( Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return new TPGalleryThemeGeneral( pParent, rSet );
//STRIP001 }
//STRIP001 
//STRIP001 // ----------------------------
//STRIP001 // - TPGalleryThemeProperties -
//STRIP001 // ----------------------------
//STRIP001 
//STRIP001 TPGalleryThemeProperties::TPGalleryThemeProperties( Window* pWindow, const SfxItemSet& rSet ) :
//STRIP001 		SfxTabPage			( pWindow, GAL_RESID( RID_SVXTABPAGE_GALLERYTHEME_FILES ), rSet ),
//STRIP001 		aFtFileType         ( this, GAL_RESID(FT_FILETYPE ) ),
//STRIP001 		aLbxFound           ( this, GAL_RESID(LBX_FOUND ) ),
//STRIP001 		aCbbFileType        ( this, GAL_RESID(CBB_FILETYPE ) ),
//STRIP001 		aBtnSearch          ( this, GAL_RESID(BTN_SEARCH ) ),
//STRIP001 		aBtnTake            ( this, GAL_RESID(BTN_TAKE ) ),
//STRIP001 		aBtnTakeAll         ( this, GAL_RESID(BTN_TAKEALL ) ),
//STRIP001 		aCbxPreview         ( this, GAL_RESID(CBX_PREVIEW ) ),
//STRIP001 		aWndPreview         ( this, GAL_RESID( WND_BRSPRV ) ),
//STRIP001 		bEntriesFound       (FALSE),
//STRIP001 		nCurFilterPos		(0),
//STRIP001 		nFirstExtFilterPos	(0),
//STRIP001 		bInputAllowed		(TRUE),
//STRIP001 		bSearchRecursive	(FALSE)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void TPGalleryThemeProperties::SetXChgData( ExchangeData* _pData )
//STRIP001 {
//STRIP001 	pData = _pData;
//STRIP001 
//STRIP001 	aSound.SetNotifyHdl( LINK( this, TPGalleryThemeProperties, SoundEndHdl ) );
//STRIP001 	aPreviewTimer.SetTimeoutHdl( LINK( this, TPGalleryThemeProperties, PreviewTimerHdl ) );
//STRIP001 	aPreviewTimer.SetTimeout( 500 );
//STRIP001 	aBtnSearch.SetClickHdl(LINK(this, TPGalleryThemeProperties, ClickSearchHdl));
//STRIP001 	aBtnTake.SetClickHdl(LINK(this, TPGalleryThemeProperties, ClickTakeHdl));
//STRIP001 	aBtnTakeAll.SetClickHdl(LINK(this, TPGalleryThemeProperties, ClickTakeAllHdl));
//STRIP001 	aCbxPreview.SetClickHdl(LINK(this, TPGalleryThemeProperties, ClickPreviewHdl));
//STRIP001 	aCbbFileType.SetSelectHdl(LINK(this, TPGalleryThemeProperties, SelectFileTypeHdl));
//STRIP001 	aCbbFileType.EnableDDAutoWidth( sal_False );
//STRIP001 	aLbxFound.SetDoubleClickHdl(LINK(this, TPGalleryThemeProperties, DClickFoundHdl));
//STRIP001 	aLbxFound.SetSelectHdl(LINK(this, TPGalleryThemeProperties, SelectFoundHdl));
//STRIP001 	aLbxFound.InsertEntry(String(GAL_RESID(RID_SVXSTR_GALLERY_NOFILES)));
//STRIP001 	aLbxFound.Show();
//STRIP001 
//STRIP001 	FillFilterList();
//STRIP001 
//STRIP001 	aBtnTake.Enable();
//STRIP001 	aBtnTakeAll.Disable();
//STRIP001 	aCbxPreview.Disable();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 TPGalleryThemeProperties::~TPGalleryThemeProperties()
//STRIP001 {
//STRIP001 	for( String* pStr = aFoundList.First(); pStr; pStr = aFoundList.Next() )
//STRIP001 		delete pStr;
//STRIP001 
//STRIP001 	for( void* pEntry = aFilterEntryList.First(); pEntry; pEntry = aFilterEntryList.Next() )
//STRIP001 		delete (FilterEntry*) pEntry;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* TPGalleryThemeProperties::Create( Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return new TPGalleryThemeProperties( pParent, rSet );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 ::rtl::OUString TPGalleryThemeProperties::addExtension( const ::rtl::OUString& _rDisplayText, const ::rtl::OUString& _rExtension )
//STRIP001 {
//STRIP001     ::rtl::OUString sAllFilter( RTL_CONSTASCII_USTRINGPARAM( "(*.*)" ) );
//STRIP001     ::rtl::OUString sOpenBracket( RTL_CONSTASCII_USTRINGPARAM( " (" ) );
//STRIP001     ::rtl::OUString sCloseBracket( RTL_CONSTASCII_USTRINGPARAM( ")" ) );
//STRIP001     ::rtl::OUString sRet = _rDisplayText;
//STRIP001     
//STRIP001     if ( sRet.indexOf( sAllFilter ) == -1 )
//STRIP001     {
//STRIP001         String sExt = _rExtension;
//STRIP001         sRet += sOpenBracket;
//STRIP001         sRet += sExt;
//STRIP001         sRet += sCloseBracket;
//STRIP001     }
//STRIP001     return sRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void TPGalleryThemeProperties::FillFilterList()
//STRIP001 {
//STRIP001 	GraphicFilter*		pFilter = GetGrfFilter();
//STRIP001 	String				aExt;
//STRIP001     String				aName;
//STRIP001 	FilterEntry*		pFilterEntry;
//STRIP001 	FilterEntry*		pTestEntry;
//STRIP001 	BOOL				bInList;
//STRIP001 
//STRIP001     sal_uInt16 i;
//STRIP001     sal_uInt16 nKeyCount;
//STRIP001 	for( i = 0, nKeyCount = pFilter->GetImportFormatCount(); i < nKeyCount; i++ )
//STRIP001 	{
//STRIP001 		aExt = pFilter->GetImportFormatShortName( i );
//STRIP001         aName = pFilter->GetImportFormatName( i );
//STRIP001 		pTestEntry = (FilterEntry*) aFilterEntryList.First();
//STRIP001 		bInList = FALSE;
//STRIP001 
//STRIP001 		String aExtensions;
//STRIP001 		int j = 0;
//STRIP001 		String sWildcard;
//STRIP001         while( TRUE )
//STRIP001         {
//STRIP001             sWildcard = pFilter->GetImportWildcard( i, j++ );
//STRIP001             if ( !sWildcard.Len() )
//STRIP001                 break;
//STRIP001             if ( aExtensions.Search( sWildcard ) == STRING_NOTFOUND )
//STRIP001             {
//STRIP001                 if ( aExtensions.Len() )
//STRIP001                     aExtensions += sal_Unicode(';');
//STRIP001                 aExtensions += sWildcard;
//STRIP001             }
//STRIP001         }
//STRIP001         aName = addExtension( aName, aExtensions );
//STRIP001 
//STRIP001 		while( pTestEntry )
//STRIP001 		{
//STRIP001 			if ( pTestEntry->aFilterName == aExt )
//STRIP001 			{
//STRIP001 				bInList = TRUE;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			pTestEntry = (FilterEntry*) aFilterEntryList.Next();
//STRIP001 		}
//STRIP001 		if ( !bInList )
//STRIP001 		{
//STRIP001 			pFilterEntry = new FilterEntry;
//STRIP001 			pFilterEntry->aFilterName = aExt;
//STRIP001 			aFilterEntryList.Insert( pFilterEntry, aCbbFileType.InsertEntry( aName ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     String aWildcard;
//STRIP001 
//STRIP001 	pFilterEntry = new FilterEntry;
//STRIP001 	pFilterEntry->aFilterName = String(GAL_RESID(RID_SVXSTR_EXTFORMAT1_SYS));
//STRIP001     aWildcard = String(RTL_CONSTASCII_USTRINGPARAM("*.")) + String(GAL_RESID(RID_SVXSTR_EXTFORMAT1_SYS));
//STRIP001 	nFirstExtFilterPos = aCbbFileType.InsertEntry( addExtension( String(GAL_RESID(RID_SVXSTR_EXTFORMAT1_UI)), 
//STRIP001                                                                  aWildcard ) );
//STRIP001 	aFilterEntryList.Insert(pFilterEntry, nFirstExtFilterPos);
//STRIP001 
//STRIP001 	pFilterEntry = new FilterEntry;
//STRIP001 	pFilterEntry->aFilterName = String(GAL_RESID(RID_SVXSTR_EXTFORMAT2_SYS));
//STRIP001     aWildcard = String(RTL_CONSTASCII_USTRINGPARAM("*.")) + String(GAL_RESID(RID_SVXSTR_EXTFORMAT2_SYS));
//STRIP001 	aFilterEntryList.Insert(pFilterEntry, aCbbFileType.InsertEntry( addExtension( String(GAL_RESID(RID_SVXSTR_EXTFORMAT2_UI)),
//STRIP001                                                                                   aWildcard ) ));
//STRIP001 
//STRIP001 	pFilterEntry = new FilterEntry;
//STRIP001 	pFilterEntry->aFilterName = String(GAL_RESID(RID_SVXSTR_EXTFORMAT3_SYS));
//STRIP001     aWildcard = String(RTL_CONSTASCII_USTRINGPARAM("*.")) + String(GAL_RESID(RID_SVXSTR_EXTFORMAT3_SYS));
//STRIP001 	aFilterEntryList.Insert(pFilterEntry, aCbbFileType.InsertEntry( addExtension( String(GAL_RESID(RID_SVXSTR_EXTFORMAT3_UI)),
//STRIP001                                                                                   aWildcard )) );
//STRIP001 
//STRIP001 	// 'Alle' als Filter-Auswahl
//STRIP001 
//STRIP001 	// compute the extension string for all known import filters
//STRIP001 	String aExtensions;
//STRIP001 
//STRIP001 	for ( i = 0; i < nKeyCount; ++i )
//STRIP001 	{
//STRIP001 		int j = 0;
//STRIP001 		String sWildcard;
//STRIP001 		while( TRUE )
//STRIP001 		{
//STRIP001 			sWildcard = pFilter->GetImportWildcard( i, j++ );
//STRIP001 			if ( !sWildcard.Len() )
//STRIP001 				break;
//STRIP001 			if ( aExtensions.Search( sWildcard ) == STRING_NOTFOUND )
//STRIP001 			{
//STRIP001 				if ( aExtensions.Len() )
//STRIP001 					aExtensions += sal_Unicode(';');
//STRIP001 				aExtensions += sWildcard;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     if ( aExtensions.Len() )
//STRIP001         aExtensions += sal_Unicode(';');
//STRIP001 
//STRIP001     aExtensions += String( RTL_CONSTASCII_USTRINGPARAM("*.") );
//STRIP001     aExtensions += String(GAL_RESID(RID_SVXSTR_EXTFORMAT1_SYS));
//STRIP001 
//STRIP001     aExtensions += String( RTL_CONSTASCII_USTRINGPARAM(";*.") );
//STRIP001 	aExtensions += String(GAL_RESID(RID_SVXSTR_EXTFORMAT2_SYS));
//STRIP001 
//STRIP001     aExtensions += String( RTL_CONSTASCII_USTRINGPARAM(";*.") );
//STRIP001 	aExtensions += String(GAL_RESID(RID_SVXSTR_EXTFORMAT3_SYS));
//STRIP001 
//STRIP001 
//STRIP001 #if defined(WIN) || defined(WNT)
//STRIP001 	if ( aExtensions.Len() > 240 )
//STRIP001 		aExtensions = DEFINE_CONST_UNICODE( "*.*" );
//STRIP001 #endif
//STRIP001 
//STRIP001     pFilterEntry = new FilterEntry;
//STRIP001     pFilterEntry->aFilterName = String( GAL_RESID( RID_SVXSTR_GALLERY_ALLFILES ) );
//STRIP001     pFilterEntry->aFilterName = addExtension( pFilterEntry->aFilterName, aExtensions );
//STRIP001     aFilterEntryList.Insert(pFilterEntry, aCbbFileType. InsertEntry( pFilterEntry->aFilterName, 0 ) );
//STRIP001     
//STRIP001     aCbbFileType.SetText( pFilterEntry->aFilterName );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( TPGalleryThemeProperties, SelectFileTypeHdl, void *, p )
//STRIP001 {
//STRIP001 	String aText( aCbbFileType.GetText() );
//STRIP001 
//STRIP001 	if( bInputAllowed && ( aLastFilterName != aText ) )
//STRIP001 	{
//STRIP001 		aLastFilterName = aText;
//STRIP001 
//STRIP001 		if( QueryBox( this, WB_YES_NO, String( GAL_RESID( RID_SVXSTR_GALLERY_SEARCH ) ) ).Execute() == RET_YES )
//STRIP001 			SearchFiles();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void TPGalleryThemeProperties::SearchFiles()
//STRIP001 {
//STRIP001 	SearchProgress*	pProgress = new SearchProgress( this, aURL );
//STRIP001 
//STRIP001 	for( String* pStr = aFoundList.First(); pStr; pStr = aFoundList.Next() )
//STRIP001 		delete pStr;
//STRIP001 
//STRIP001 	aFoundList.Clear();
//STRIP001 	aLbxFound.Clear();
//STRIP001 
//STRIP001 	pProgress->SetFileType( aCbbFileType.GetText() );
//STRIP001 	pProgress->SetDirectory( String() );
//STRIP001 	pProgress->Update();
//STRIP001 	pProgress->Execute();
//STRIP001 	delete pProgress;
//STRIP001 
//STRIP001 	if( aFoundList.Count() )
//STRIP001 	{
//STRIP001 		aLbxFound.SelectEntryPos( 0 );
//STRIP001 		aBtnTakeAll.Enable();
//STRIP001 		aCbxPreview.Enable();
//STRIP001 		bEntriesFound = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLbxFound.InsertEntry( String( GAL_RESID( RID_SVXSTR_GALLERY_NOFILES ) ) );
//STRIP001 		aBtnTakeAll.Disable();
//STRIP001 		aCbxPreview.Disable();
//STRIP001 		bEntriesFound = FALSE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( TPGalleryThemeProperties, ClickCloseBrowserHdl, void *, p )
//STRIP001 {
//STRIP001 	if( bInputAllowed )
//STRIP001 		aPreviewTimer.Stop();
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( TPGalleryThemeProperties, ClickSearchHdl, void *, p )
//STRIP001 {
//STRIP001 	if( bInputAllowed )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			// setup folder picker
//STRIP001 			Reference< XMultiServiceFactory > xMgr( ::legacy_binfilters::getLegacyProcessServiceFactory() );
//STRIP001 			if( xMgr.is() )
//STRIP001 			{
//STRIP001 				Reference< XFolderPicker >	xFolderDlg = Reference< XFolderPicker >(
//STRIP001 					xMgr->createInstance( OUString::createFromAscii( "com.sun.star.ui.dialogs.FolderPicker" )), UNO_QUERY );
//STRIP001 		   
//STRIP001 				if ( xFolderDlg.is() )
//STRIP001 				{
//STRIP001 //					svt::SetDialogHelpId( xFolderDlg, HID_GALLERY_NEWTHEME_FINDFILES );
//STRIP001 					String	aDlgPathName( SvtPathOptions().GetGraphicPath() );
//STRIP001 					xFolderDlg->setDisplayDirectory(aDlgPathName);
//STRIP001 
//STRIP001 					aPreviewTimer.Stop();
//STRIP001 				
//STRIP001 					if( xFolderDlg->execute() == RET_OK )
//STRIP001 					{
//STRIP001 						aURL = INetURLObject( xFolderDlg->getDirectory() );
//STRIP001 						bSearchRecursive = sal_True;	// UI choice no longer possible, windows file picker allows no user controls
//STRIP001 						SearchFiles();
//STRIP001 					}
//STRIP001 
//STRIP001 					nCurFilterPos = aCbbFileType.GetEntryPos( aCbbFileType.GetText() );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		catch(IllegalArgumentException)
//STRIP001 		{
//STRIP001 #ifdef DBG_UTIL
//STRIP001 			DBG_ERROR( "Folder picker failed with illegal arguments" );
//STRIP001 #endif
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void TPGalleryThemeProperties::TakeFiles()
//STRIP001 {
//STRIP001 	if( aLbxFound.GetSelectEntryCount() || ( bTakeAll && bEntriesFound ) )
//STRIP001 	{
//STRIP001 		TakeProgress* pTakeProgress = new TakeProgress( this );
//STRIP001 		pTakeProgress->Update();
//STRIP001 		pTakeProgress->Execute();
//STRIP001 		delete pTakeProgress;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( TPGalleryThemeProperties, ClickPreviewHdl, void *, p )
//STRIP001 {
//STRIP001 	if ( bInputAllowed )
//STRIP001 	{
//STRIP001 		aPreviewTimer.Stop();
//STRIP001 		aPreviewString.Erase();
//STRIP001 
//STRIP001 		if( !aCbxPreview.IsChecked() )
//STRIP001 		{
//STRIP001 			aSound.SetSoundName( String() );
//STRIP001 			aWndPreview.SetGraphic( Graphic() );
//STRIP001 			aWndPreview.Invalidate();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			DoPreview();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void TPGalleryThemeProperties::DoPreview()
//STRIP001 {
//STRIP001 	String aString( aLbxFound.GetSelectEntry() );
//STRIP001 
//STRIP001 	if( aString != aPreviewString )
//STRIP001 	{
//STRIP001 		Graphic	        aGraphic;
//STRIP001 		INetURLObject	aURL( *aFoundList.GetObject( aLbxFound.GetEntryPos( aString ) ) );
//STRIP001 		String			aFileExt( aURL.GetExtension().ToLowerAscii() );
//STRIP001 		BOOL			bNoSound1 = ( aFileExt != String( GAL_RESID( RID_SVXSTR_EXTFORMAT1_SYS ) ).ToLowerAscii() );
//STRIP001 		BOOL			bNoSound2 = ( aFileExt != String( GAL_RESID( RID_SVXSTR_EXTFORMAT2_SYS ) ).ToLowerAscii() );
//STRIP001 		BOOL			bNoSound3 = ( aFileExt != String( GAL_RESID( RID_SVXSTR_EXTFORMAT3_SYS ) ).ToLowerAscii() );
//STRIP001 
//STRIP001 		bInputAllowed = FALSE;
//STRIP001 
//STRIP001 		if( bNoSound1 && bNoSound2 && bNoSound3 )
//STRIP001 		{
//STRIP001 			GraphicFilter*  pFilter = GetGrfFilter();
//STRIP001 			GalleryProgress aProgress( pFilter );
//STRIP001 
//STRIP001 			if( pFilter->ImportGraphic( aGraphic, aURL, GRFILTER_FORMAT_DONTKNOW ) )
//STRIP001 			{
//STRIP001 				GetParent()->LeaveWait();
//STRIP001 				ErrorHandler::HandleError( ERRCODE_IO_NOTEXISTSPATH );
//STRIP001 				GetParent()->EnterWait();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Bitmap aBitmap( GAL_RESID( RID_SVXBMP_GALLERY_SOUND_0 ) );
//STRIP001 			BitmapEx aBmpEx( aBitmap, COL_LIGHTMAGENTA );
//STRIP001 			aGraphic = aBmpEx;
//STRIP001 			aSound.SetSoundName( aURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 			aSound.Play();
//STRIP001 		}
//STRIP001 
//STRIP001 		aWndPreview.SetGraphic( aGraphic );
//STRIP001 		aWndPreview.Invalidate();
//STRIP001 		bInputAllowed = TRUE;
//STRIP001 		aPreviewString = aString;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( TPGalleryThemeProperties, ClickTakeHdl, void*, p )
//STRIP001 {
//STRIP001 	if( bInputAllowed )
//STRIP001 	{
//STRIP001 		aPreviewTimer.Stop();
//STRIP001 
//STRIP001 		if( !aLbxFound.GetSelectEntryCount() || !bEntriesFound )
//STRIP001 		{
//STRIP001 			SvxOpenGraphicDialog aDlg(String( RTL_CONSTASCII_USTRINGPARAM( "Gallery" ) ) );
//STRIP001 //			aDlg.SetDialogHelpId( HID_GALLERY_NEWTHEME_ADDFILES );
//STRIP001 			aDlg.EnableLink(sal_False);
//STRIP001 			aDlg.AsLink(sal_False);
//STRIP001 
//STRIP001 			if( !aDlg.Execute() )
//STRIP001 				pData->pTheme->InsertURL( INetURLObject( aDlg.GetPath() ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bTakeAll = FALSE;
//STRIP001 			TakeFiles();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( TPGalleryThemeProperties, ClickTakeAllHdl, void *, p )
//STRIP001 {
//STRIP001 	if( bInputAllowed )
//STRIP001 	{
//STRIP001 		aPreviewTimer.Stop();
//STRIP001 		bTakeAll = TRUE;
//STRIP001 		TakeFiles();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( TPGalleryThemeProperties, SelectFoundHdl, void *, p )
//STRIP001 {
//STRIP001 	if( bInputAllowed )
//STRIP001 	{
//STRIP001 		BOOL bPreviewPossible = FALSE;
//STRIP001 
//STRIP001 		aPreviewTimer.Stop();
//STRIP001 
//STRIP001 		if( bEntriesFound )
//STRIP001 		{
//STRIP001 			if( aLbxFound.GetSelectEntryCount() == 1 )
//STRIP001 			{
//STRIP001 				aCbxPreview.Enable();
//STRIP001 				bPreviewPossible = TRUE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aCbxPreview.Disable();
//STRIP001 
//STRIP001 			if( aFoundList.Count() )
//STRIP001 				aBtnTakeAll.Enable();
//STRIP001 			else
//STRIP001 				aBtnTakeAll.Disable();
//STRIP001 		}
//STRIP001 
//STRIP001 		if( bPreviewPossible && aCbxPreview.IsChecked() )
//STRIP001 			aPreviewTimer.Start();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( TPGalleryThemeProperties, DClickFoundHdl, void *, p )
//STRIP001 {
//STRIP001 	if( bInputAllowed )
//STRIP001 	{
//STRIP001 		aPreviewTimer.Stop();
//STRIP001 
//STRIP001 		return (aLbxFound.GetSelectEntryCount() == 1 && bEntriesFound) ?
//STRIP001 			ClickTakeHdl(NULL) : 0;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( TPGalleryThemeProperties, PreviewTimerHdl, void *, p )
//STRIP001 {
//STRIP001 	aPreviewTimer.Stop();
//STRIP001 	DoPreview();
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( TPGalleryThemeProperties, SoundEndHdl, Sound*, pSound )
//STRIP001 {
//STRIP001 	aSound.SetSoundName( String() );
//STRIP001 	return 0L;
//STRIP001 }

}
