/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_border.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:35:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFX_OBJSH_HXX
#include <bf_sfx2/objsh.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif
#pragma hdrstop

#define _SVX_BORDER_CXX

#include "dialogs.hrc"
#include "svxitems.hrc"
#include "border.hrc"
#include "helpid.hrc"

#define ITEMID_COLOR_TABLE	0
#define ITEMID_BOX			SID_ATTR_BORDER_OUTER
#define ITEMID_BOXINFO 		SID_ATTR_BORDER_INNER
#define ITEMID_SHADOW 		SID_ATTR_BORDER_SHADOW

#define LINESTYLE_HTML_MAX 5

#include "xtable.hxx"				// XColorTable
#include "drawitem.hxx"
#include "boxitem.hxx"
#include "shaditem.hxx"
#include "border.hxx"
#include "linelink.hxx"
#include "dlgutil.hxx"
#include "dialmgr.hxx"
#include "htmlmode.hxx"
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
namespace binfilter {

// -----------------------------------------------------------------------

/*
 * [Beschreibung:]
 * TabPage zum Einstellen der Rahmen-Attribute.
 * Benoetigt
 *		ein SvxShadowItem: Schatten
 *		ein SvxBoxItem:    Linien links,rechts,oben,unten ),
 *		ein SvxBoxInfo:    Linien vertikal,horizontal, Abstaende, Flags )
 *
 * Linien koennen drei Zustaende haben.
 *		1. Show		( -> gueltige Werte )
 *		2. Hide		( -> NULL-Pointer )
 *		3. DontCare ( -> gesonderte Valid-Flags im InfoItem )
 */

// static ----------------------------------------------------------------

//STRIP001 static USHORT pRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_BORDER_INNER,
//STRIP001 	SID_ATTR_BORDER_SHADOW,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 BOOL SvxBorderTabPage::bSync = TRUE;
//STRIP001 
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 #define LINE_WIDTH0		(DEF_LINE_WIDTH_0 *100)
//STRIP001 #define LINE_WIDTH1		(DEF_LINE_WIDTH_1 *100)
//STRIP001 #define LINE_WIDTH2		(DEF_LINE_WIDTH_2 *100)
//STRIP001 #define LINE_WIDTH3		(DEF_LINE_WIDTH_3 *100)
//STRIP001 #define LINE_WIDTH4		(DEF_LINE_WIDTH_4 *100)
//STRIP001 
//STRIP001 #define DLINE0_OUT		(DEF_DOUBLE_LINE0_OUT  *100)
//STRIP001 #define DLINE0_IN		(DEF_DOUBLE_LINE0_IN   *100)
//STRIP001 #define DLINE0_DIST		(DEF_DOUBLE_LINE0_DIST *100)
//STRIP001 
//STRIP001 #define DLINE1_OUT		(DEF_DOUBLE_LINE1_OUT  *100)
//STRIP001 #define DLINE1_IN		(DEF_DOUBLE_LINE1_IN   *100)
//STRIP001 #define DLINE1_DIST		(DEF_DOUBLE_LINE1_DIST *100)
//STRIP001 
//STRIP001 #define DLINE2_OUT		(DEF_DOUBLE_LINE2_OUT  *100)
//STRIP001 #define DLINE2_IN		(DEF_DOUBLE_LINE2_IN   *100)
//STRIP001 #define DLINE2_DIST		(DEF_DOUBLE_LINE2_DIST *100)
//STRIP001 
//STRIP001 #define DLINE3_OUT		(DEF_DOUBLE_LINE3_OUT  *100)
//STRIP001 #define DLINE3_IN		(DEF_DOUBLE_LINE3_IN   *100)
//STRIP001 #define DLINE3_DIST		(DEF_DOUBLE_LINE3_DIST *100)
//STRIP001 
//STRIP001 #define DLINE4_OUT		(DEF_DOUBLE_LINE4_OUT  *100)
//STRIP001 #define DLINE4_IN		(DEF_DOUBLE_LINE4_IN   *100)
//STRIP001 #define DLINE4_DIST		(DEF_DOUBLE_LINE4_DIST *100)
//STRIP001 
//STRIP001 #define DLINE5_OUT		(DEF_DOUBLE_LINE5_OUT  *100)
//STRIP001 #define DLINE5_IN		(DEF_DOUBLE_LINE5_IN   *100)
//STRIP001 #define DLINE5_DIST		(DEF_DOUBLE_LINE5_DIST *100)
//STRIP001 
//STRIP001 #define DLINE6_OUT		(DEF_DOUBLE_LINE6_OUT  *100)
//STRIP001 #define DLINE6_IN		(DEF_DOUBLE_LINE6_IN   *100)
//STRIP001 #define DLINE6_DIST		(DEF_DOUBLE_LINE6_DIST *100)
//STRIP001 
//STRIP001 #define DLINE7_OUT		(DEF_DOUBLE_LINE7_OUT  *100)
//STRIP001 #define DLINE7_IN		(DEF_DOUBLE_LINE7_IN   *100)
//STRIP001 #define DLINE7_DIST		(DEF_DOUBLE_LINE7_DIST *100)
//STRIP001 
//STRIP001 #define DLINE8_OUT		(DEF_DOUBLE_LINE8_OUT  *100)
//STRIP001 #define DLINE8_IN		(DEF_DOUBLE_LINE8_IN   *100)
//STRIP001 #define DLINE8_DIST		(DEF_DOUBLE_LINE8_DIST *100)
//STRIP001 
//STRIP001 #define DLINE9_OUT		(DEF_DOUBLE_LINE9_OUT  *100)
//STRIP001 #define DLINE9_IN		(DEF_DOUBLE_LINE9_IN   *100)
//STRIP001 #define DLINE9_DIST		(DEF_DOUBLE_LINE9_DIST *100)
//STRIP001 
//STRIP001 #define DLINE10_OUT		(DEF_DOUBLE_LINE10_OUT *100)
//STRIP001 #define DLINE10_IN		(DEF_DOUBLE_LINE10_IN  *100)
//STRIP001 #define DLINE10_DIST	(DEF_DOUBLE_LINE10_DIST*100)
//STRIP001 
//STRIP001 #define EQSTYLE(s1,s2) \
//STRIP001 	(   (s1).nLeft   == (s2).nLeft		\
//STRIP001 	 && (s1).nMiddle == (s2).nMiddle	\
//STRIP001 	 && (s1).nRight  == (s2).nRight		\
//STRIP001 	)
//STRIP001 
//STRIP001 #define SET_STYLE(s,l,m,r)	\
//STRIP001 		((s).nLeft   = l),	\
//STRIP001 		((s).nMiddle = m),   \
//STRIP001 	 	((s).nRight  = r)
//STRIP001 
//STRIP001 #define RGBCOL(eColorName) (TpBorderRGBColor(eColorName))
//STRIP001 
//STRIP001 // LOKALE FUNKTION
//STRIP001 // Konvertiert in echte RGB-Farben, damit in den Listboxen
//STRIP001 // endlich mal richtig selektiert werden kann.
//STRIP001 
//STRIP001 Color TpBorderRGBColor( ColorData aColorData )
//STRIP001 {
//STRIP001 	Color aRGBColor( aColorData );
//STRIP001 
//STRIP001 	return( aRGBColor );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 Color TpBorderRGBColor( const Color& rColor )
//STRIP001 {
//STRIP001 	Color aRGBColor( rColor.GetRed(),
//STRIP001 					 rColor.GetGreen(),
//STRIP001 					 rColor.GetBlue() );
//STRIP001 
//STRIP001 	return( aRGBColor );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxBorderTabPage::SvxBorderTabPage( Window* pParent,
//STRIP001 									const SfxItemSet& rCoreAttrs )
//STRIP001 
//STRIP001 	:	SfxTabPage( pParent, ResId( RID_SVXPAGE_BORDER, DIALOG_MGR() ), rCoreAttrs ),
//STRIP001 
//STRIP001 		aFlBorder       ( this, ResId( FL_BORDER ) ),
//STRIP001         aDefaultFT      ( this, ResId( FT_DEFAULT ) ),
//STRIP001         aUserDefFT      ( this, ResId( FT_USERDEF ) ),
//STRIP001         aStyleFT        ( this, ResId( FT_STYLE ) ),
//STRIP001         aColorFT        ( this, ResId( FT_COLOR ) ),
//STRIP001 		aWndPresets     ( this, ResId( WIN_PRESETS ) ),
//STRIP001         aFrameSel(          this, ResId( WIN_FRAMESEL )),
//STRIP001         aFlSep1         ( this, ResId( FL_SEPARATOR1 ) ),
//STRIP001         aFlLine         ( this, ResId( FL_LINE ) ),
//STRIP001 		aLbLineStyle    ( this, ResId( LB_LINESTYLE ) ),
//STRIP001 		aLbLineColor    ( this, ResId( LB_LINECOLOR ) ),
//STRIP001 
//STRIP001         aFlSep2         ( this, ResId( FL_SEPARATOR2 ) ),
//STRIP001         aDistanceFL     ( this, ResId( FL_DISTANCE ) ),
//STRIP001         aLeftFT         ( this, ResId( FT_LEFT ) ),
//STRIP001         aLeftMF         ( this, ResId( MF_LEFT ) ),
//STRIP001         aRightFT        ( this, ResId( FT_RIGHT ) ),
//STRIP001         aRightMF        ( this, ResId( MF_RIGHT ) ),
//STRIP001         aTopFT          ( this, ResId( FT_TOP ) ),
//STRIP001         aTopMF          ( this, ResId( MF_TOP ) ),
//STRIP001         aBottomFT       ( this, ResId( FT_BOTTOM ) ),
//STRIP001         aBottomMF       ( this, ResId( MF_BOTTOM ) ),
//STRIP001         aSynchronizeCB  ( this, ResId( CB_SYNC ) ),
//STRIP001 
//STRIP001 		aFlShadow       ( this, ResId( FL_SHADOW ) ),
//STRIP001 		aFtShadowPos    ( this, ResId( FT_SHADOWPOS ) ),
//STRIP001 		aWndShadows     ( this, ResId( WIN_SHADOWS ) ),
//STRIP001 		aFtShadowSize   ( this, ResId( FT_SHADOWSIZE ) ),
//STRIP001 		aEdShadowSize   ( this, ResId( ED_SHADOWSIZE ) ),
//STRIP001 		aFtShadowColor  ( this, ResId( FT_SHADOWCOLOR ) ),
//STRIP001 		aLbShadowColor  ( this, ResId( LB_SHADOWCOLOR ) ),
//STRIP001         aShadowImgLstH( ResId(ILH_SDW_BITMAPS)),
//STRIP001         aShadowImgLst( ResId(IL_SDW_BITMAPS)),
//STRIP001         aBorderImgLstH( ResId(ILH_PRE_BITMAPS)),
//STRIP001         aBorderImgLst( ResId(IL_PRE_BITMAPS)),
//STRIP001         nMinValue(0),
//STRIP001 		bIsTableBorder	( FALSE ),
//STRIP001 		nSWMode(0)
//STRIP001 {
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// Metrik einstellen
//STRIP001 	FieldUnit eFUnit = GetModuleFieldUnit( &rCoreAttrs );
//STRIP001 
//STRIP001 	switch ( eFUnit )
//STRIP001 	{
//STRIP001 		case FUNIT_M:
//STRIP001 		case FUNIT_KM:
//STRIP001 			eFUnit = FUNIT_MM;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	SetFieldUnit( aEdShadowSize, eFUnit );
//STRIP001 
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_BORDER_INNER );
//STRIP001 	BOOL bIsDontCare = TRUE;
//STRIP001 
//STRIP001 	if ( rCoreAttrs.GetItemState( nWhich, TRUE ) >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		// Absatz oder Tabelle
//STRIP001 		const SvxBoxInfoItem* pBoxInfo =
//STRIP001 			(const SvxBoxInfoItem*)&( rCoreAttrs.Get( nWhich ) );
//STRIP001 		bIsTableBorder = pBoxInfo->IsTable();
//STRIP001 
//STRIP001 		if(pBoxInfo->IsDist())
//STRIP001 		{
//STRIP001 			SetFieldUnit(aLeftMF, eFUnit);
//STRIP001 			SetFieldUnit(aRightMF, eFUnit);
//STRIP001 			SetFieldUnit(aTopMF, eFUnit);
//STRIP001 			SetFieldUnit(aBottomMF, eFUnit);
//STRIP001 			aSynchronizeCB.Check(bSync);
//STRIP001 			aSynchronizeCB.SetClickHdl(LINK(this, SvxBorderTabPage, SyncHdl_Impl));
//STRIP001 			aLeftMF.SetModifyHdl(LINK(this, SvxBorderTabPage, ModifyDistanceHdl_Impl));
//STRIP001 			aRightMF.SetModifyHdl(LINK(this, SvxBorderTabPage, ModifyDistanceHdl_Impl));
//STRIP001 			aTopMF.SetModifyHdl(LINK(this, SvxBorderTabPage, ModifyDistanceHdl_Impl));
//STRIP001 			aBottomMF.SetModifyHdl(LINK(this, SvxBorderTabPage, ModifyDistanceHdl_Impl));
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001             aFlSep2.Hide();
//STRIP001             aDistanceFL.Hide();
//STRIP001 			aLeftFT.Hide();
//STRIP001 			aLeftMF.Hide();
//STRIP001 			aRightFT.Hide();
//STRIP001 			aRightMF.Hide();
//STRIP001 			aTopFT.Hide();
//STRIP001 			aTopMF.Hide();
//STRIP001 			aBottomFT.Hide();
//STRIP001 			aBottomMF.Hide();
//STRIP001 			aSynchronizeCB.Hide();
//STRIP001 		}
//STRIP001 		bIsDontCare = !pBoxInfo->IsValid( VALID_DISABLE );
//STRIP001 	}
//STRIP001 	if(eFUnit == FUNIT_MM && SFX_MAPUNIT_TWIP == rCoreAttrs.GetPool()->GetMetric( GetWhich( SID_ATTR_BORDER_INNER ) ))
//STRIP001 	{
//STRIP001 		aLeftMF.SetDecimalDigits(1);
//STRIP001 		aRightMF.SetDecimalDigits(1);
//STRIP001 		aTopMF.SetDecimalDigits(1);
//STRIP001 		aBottomMF.SetDecimalDigits(1);
//STRIP001 		aEdShadowSize.SetDecimalDigits(1);
//STRIP001 	}
//STRIP001 
//STRIP001     aFrameSel.Initialize(   bIsTableBorder
//STRIP001                                 ? SVX_FRMSELTYPE_TABLE
//STRIP001                                 : SVX_FRMSELTYPE_PARAGRAPH,
//STRIP001                                 bIsDontCare );
//STRIP001 
//STRIP001     aFrameSel.SetSelectLink(LINK(this, SvxBorderTabPage, LinesChanged_Impl));
//STRIP001 	aLbLineStyle.SetSelectHdl( LINK( this, SvxBorderTabPage, SelStyleHdl_Impl ) );
//STRIP001 	aLbLineColor.SetSelectHdl( LINK( this, SvxBorderTabPage, SelColHdl_Impl ) );
//STRIP001 	aLbShadowColor.SetSelectHdl( LINK( this, SvxBorderTabPage, SelColHdl_Impl ) );
//STRIP001 	aWndPresets.SetSelectHdl( LINK( this, SvxBorderTabPage, SelPreHdl_Impl ) );
//STRIP001 	aWndShadows.SetSelectHdl( LINK( this, SvxBorderTabPage, SelSdwHdl_Impl ) );
//STRIP001 
//STRIP001 	FillValueSets_Impl();
//STRIP001 	FillLineListBox_Impl();
//STRIP001 
//STRIP001 	// ColorBox aus der XColorTable fuellen.
//STRIP001 	SfxObjectShell*		pDocSh		= SfxObjectShell::Current();
//STRIP001 	const SfxPoolItem*	pItem 		= NULL;
//STRIP001 	XColorTable*		pColorTable = NULL;
//STRIP001 
//STRIP001 	DBG_ASSERT( pDocSh, "DocShell not found!" );
//STRIP001 
//STRIP001 	if ( pDocSh && ( pItem = pDocSh->GetItem( SID_COLOR_TABLE ) ) )
//STRIP001 		pColorTable = ( (SvxColorTableItem*)pItem )->GetColorTable();
//STRIP001 
//STRIP001 	DBG_ASSERT( pColorTable, "ColorTable not found!" );
//STRIP001 
//STRIP001 	if ( pColorTable )
//STRIP001 	{
//STRIP001 		// fuellen der Linienfarben-Box
//STRIP001 		aLbLineColor.SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 		for ( long i = 0; i < pColorTable->Count(); ++i )
//STRIP001 		{
//STRIP001 			XColorEntry* pEntry = pColorTable->Get(i);
//STRIP001 			aLbLineColor.InsertEntry( pEntry->GetColor(), pEntry->GetName() );
//STRIP001 		}
//STRIP001 		aLbLineColor.SetUpdateMode( TRUE );
//STRIP001 		// dann nur noch in die Schattenfarben-Box kopieren
//STRIP001 		aLbShadowColor.CopyEntries( aLbLineColor );
//STRIP001 	}
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxBorderTabPage::~SvxBorderTabPage()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT* SvxBorderTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return pRanges;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxBorderTabPage::Create( Window* pParent,
//STRIP001 									  const SfxItemSet& rAttrSet )
//STRIP001 {
//STRIP001 	return ( new SvxBorderTabPage( pParent, rAttrSet ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBorderTabPage::ResetFrameLine_Impl( const SvxBorderLine* pCoreLine,
//STRIP001 											SvxFrameLine& rFrameLine )
//STRIP001 {
//STRIP001 	SvxLineStruct   newLineStyle = { 0,0,0 };
//STRIP001 
//STRIP001 	if ( !pCoreLine ) // == Linie nicht darstellen
//STRIP001 	{
//STRIP001 		rFrameLine.SetStyle( newLineStyle );
//STRIP001 		rFrameLine.SetColor( RGBCOL(COL_BLACK) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		newLineStyle.nLeft   = pCoreLine->GetOutWidth()*100;
//STRIP001 		newLineStyle.nMiddle = pCoreLine->GetDistance()*100;
//STRIP001 		newLineStyle.nRight  = pCoreLine->GetInWidth() *100;
//STRIP001 		rFrameLine.SetStyle( newLineStyle );
//STRIP001 		rFrameLine.SetColor( pCoreLine->GetColor() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBorderTabPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	const SvxBoxItem*       pBoxItem;
//STRIP001 	const SvxBoxInfoItem*   pBoxInfoItem;
//STRIP001 	const SvxShadowItem*    pShadowItem;
//STRIP001 	USHORT					nWhichBox		= GetWhich(SID_ATTR_BORDER_OUTER);
//STRIP001 	USHORT					nWhichShadow	= GetWhich(SID_ATTR_BORDER_SHADOW);
//STRIP001 	SfxMapUnit 				eCoreUnit;
//STRIP001 	const Color				aColBlack		= RGBCOL(COL_BLACK);
//STRIP001 
//STRIP001 	pBoxItem  = (const SvxBoxItem*)GetItem( rSet, SID_ATTR_BORDER_OUTER );
//STRIP001 	pBoxInfoItem = (const SvxBoxInfoItem*)GetItem( rSet, SID_ATTR_BORDER_INNER );
//STRIP001 	pShadowItem = (const SvxShadowItem*)GetItem( rSet, SID_ATTR_BORDER_SHADOW );
//STRIP001 
//STRIP001 	eCoreUnit = rSet.GetPool()->GetMetric( nWhichBox );
//STRIP001 
//STRIP001 	if ( pBoxItem && pBoxInfoItem ) // -> Don't Care
//STRIP001 	{
//STRIP001 		//-----------------
//STRIP001 		// Umrandung links:
//STRIP001 		//-----------------
//STRIP001 		if ( pBoxInfoItem->IsValid( VALID_LEFT ) )
//STRIP001 			ResetFrameLine_Impl( pBoxItem->GetLeft(),
//STRIP001                                  aFrameSel.GetLine(SVX_FRMSELLINE_LEFT) );
//STRIP001 		else
//STRIP001             aFrameSel.GetLine(SVX_FRMSELLINE_LEFT).SetState( SVX_FRMLINESTATE_DONT_CARE );
//STRIP001 
//STRIP001 		//------------------
//STRIP001 		// Umrandung rechts:
//STRIP001 		//------------------
//STRIP001 		if ( pBoxInfoItem->IsValid( VALID_RIGHT ) )
//STRIP001 			ResetFrameLine_Impl( pBoxItem->GetRight(),
//STRIP001                                  aFrameSel.GetLine(SVX_FRMSELLINE_RIGHT) );
//STRIP001 		else
//STRIP001             aFrameSel.GetLine(SVX_FRMSELLINE_RIGHT).SetState( SVX_FRMLINESTATE_DONT_CARE );
//STRIP001 
//STRIP001 		//----------------
//STRIP001 		// Umrandung oben:
//STRIP001 		//----------------
//STRIP001 		if ( pBoxInfoItem->IsValid( VALID_TOP ) )
//STRIP001 			ResetFrameLine_Impl( pBoxItem->GetTop(),
//STRIP001                                  aFrameSel.GetLine(SVX_FRMSELLINE_TOP) );
//STRIP001 		else
//STRIP001             aFrameSel.GetLine(SVX_FRMSELLINE_TOP).SetState( SVX_FRMLINESTATE_DONT_CARE );
//STRIP001 
//STRIP001 		//-----------------
//STRIP001 		// Umrandung unten:
//STRIP001 		//-----------------
//STRIP001 		if ( pBoxInfoItem->IsValid( VALID_BOTTOM ) )
//STRIP001 			ResetFrameLine_Impl( pBoxItem->GetBottom(),
//STRIP001                                  aFrameSel.GetLine(SVX_FRMSELLINE_BOTTOM) );
//STRIP001 		else
//STRIP001             aFrameSel.GetLine(SVX_FRMSELLINE_BOTTOM).SetState( SVX_FRMLINESTATE_DONT_CARE );
//STRIP001 
//STRIP001 		//-------------------
//STRIP001 		// Abstand nach innen
//STRIP001 		//-------------------
//STRIP001 		if ( aLeftMF.IsVisible() )
//STRIP001 		{
//STRIP001 			SetMetricValue( aLeftMF,	pBoxInfoItem->GetDefDist(), eCoreUnit );
//STRIP001 			SetMetricValue( aRightMF,   pBoxInfoItem->GetDefDist(), eCoreUnit );
//STRIP001 			SetMetricValue( aTopMF,		pBoxInfoItem->GetDefDist(), eCoreUnit );
//STRIP001 			SetMetricValue( aBottomMF,	pBoxInfoItem->GetDefDist(), eCoreUnit );
//STRIP001 
//STRIP001 			nMinValue = aLeftMF.GetValue();
//STRIP001 
//STRIP001 			if ( pBoxInfoItem->IsMinDist() )
//STRIP001 			{
//STRIP001 				aLeftMF.SetFirst( nMinValue );
//STRIP001 				aRightMF.SetFirst( nMinValue );
//STRIP001 				aTopMF.SetFirst( nMinValue );
//STRIP001 				aBottomMF.SetFirst( nMinValue );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pBoxInfoItem->IsDist() )
//STRIP001 			{
//STRIP001 				if ( SFX_ITEM_SET == rSet.GetItemState( nWhichBox, FALSE ) &&
//STRIP001 					 pBoxInfoItem->IsValid( VALID_DISTANCE ) )
//STRIP001 				{
//STRIP001                     BOOL bIsAnyLineSet = aFrameSel.IsAnyLineSet();
//STRIP001                     if( !bIsAnyLineSet||
//STRIP001                         !pBoxInfoItem->IsMinDist() )
//STRIP001 					{
//STRIP001 						aLeftMF.SetMin( 0 );
//STRIP001 						aLeftMF.SetFirst( 0 );
//STRIP001 						aRightMF.SetMin( 0 );
//STRIP001 						aRightMF.SetFirst( 0 );
//STRIP001 						aTopMF.SetMin( 0 );
//STRIP001 						aTopMF.SetFirst( 0 );
//STRIP001 						aBottomMF.SetMin( 0 );
//STRIP001 						aBottomMF.SetFirst( 0 );
//STRIP001 					}
//STRIP001 					long nLeftDist = pBoxItem->GetDistance( BOX_LINE_LEFT);
//STRIP001 					SetMetricValue( aLeftMF, nLeftDist, eCoreUnit );
//STRIP001 					long nRightDist = pBoxItem->GetDistance( BOX_LINE_RIGHT);
//STRIP001 					SetMetricValue( aRightMF, nRightDist, eCoreUnit );
//STRIP001 					long nTopDist = pBoxItem->GetDistance( BOX_LINE_TOP);
//STRIP001 					SetMetricValue( aTopMF, nTopDist, eCoreUnit );
//STRIP001 					long nBottomDist = pBoxItem->GetDistance( BOX_LINE_BOTTOM);
//STRIP001 					SetMetricValue( aBottomMF, nBottomDist, eCoreUnit );
//STRIP001 
//STRIP001 					// ist der Abstand auf nicht-default gesetzt,
//STRIP001 					// dann soll der Wert auch nicht
//STRIP001 					// mehr autom. veraendert werden
//STRIP001 
//STRIP001                     // if the distance is set with no active border line
//STRIP001                     // or it is null with an active border line
//STRIP001                     // no automatic changes should be made
//STRIP001                     const long nDefDist = bIsAnyLineSet ? pBoxInfoItem->GetDefDist() : 0;
//STRIP001                     BOOL bDiffDist = (nDefDist != nLeftDist ||
//STRIP001                                 nDefDist != nRightDist ||
//STRIP001                                 nDefDist != nTopDist   ||
//STRIP001                                 nDefDist != nBottomDist);
//STRIP001 					if((pBoxItem->GetDistance() ||
//STRIP001                             (nSWMode & (SW_BORDER_MODE_FRAME|SW_BORDER_MODE_TABLE))&&
//STRIP001                                 aFrameSel.IsAnyLineSet()) &&
//STRIP001                                 bDiffDist )
//STRIP001 					{
//STRIP001 						aLeftMF.SetModifyFlag();
//STRIP001 						aRightMF.SetModifyFlag();
//STRIP001 						aTopMF.SetModifyFlag();
//STRIP001 						aBottomMF.SetModifyFlag();
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SetMetricValue( aLeftMF,	pBoxInfoItem->GetDefDist(), eCoreUnit );
//STRIP001 					SetMetricValue( aRightMF,	pBoxInfoItem->GetDefDist(), eCoreUnit );
//STRIP001 					SetMetricValue( aTopMF,		pBoxInfoItem->GetDefDist(), eCoreUnit );
//STRIP001 					SetMetricValue( aBottomMF,	pBoxInfoItem->GetDefDist(), eCoreUnit );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			aLeftMF.SaveValue();
//STRIP001 			aRightMF.SaveValue();
//STRIP001 			aTopMF.SaveValue();
//STRIP001 			aBottomMF.SaveValue();
//STRIP001 		}
//STRIP001 
//STRIP001 		//----------------
//STRIP001 		// innen vertikal:
//STRIP001 		//----------------
//STRIP001 		if ( pBoxInfoItem->IsValid( VALID_VERT ) )
//STRIP001 			ResetFrameLine_Impl( pBoxInfoItem->GetVert(),
//STRIP001                                  aFrameSel.GetLine(SVX_FRMSELLINE_VER) );
//STRIP001 		else
//STRIP001             aFrameSel.GetLine(SVX_FRMSELLINE_VER).SetState( SVX_FRMLINESTATE_DONT_CARE );
//STRIP001 
//STRIP001 		//------------------
//STRIP001 		// innen horizontal:
//STRIP001 		//------------------
//STRIP001 		if ( pBoxInfoItem->IsValid( VALID_HORI ) )
//STRIP001 			ResetFrameLine_Impl( pBoxInfoItem->GetHori(),
//STRIP001                                  aFrameSel.GetLine(SVX_FRMSELLINE_HOR) );
//STRIP001 		else
//STRIP001             aFrameSel.GetLine(SVX_FRMSELLINE_HOR).SetState( SVX_FRMLINESTATE_DONT_CARE );
//STRIP001 
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// ResetFrameLine-Aufrufe einsparen:
//STRIP001 		Color		  aColBlack = RGBCOL(COL_BLACK);
//STRIP001 		SvxLineStruct aNullLine = { 0,0,0 };
//STRIP001         SvxFrameLine& rLeft     = aFrameSel.GetLine(SVX_FRMSELLINE_LEFT);
//STRIP001         SvxFrameLine& rRight    = aFrameSel.GetLine(SVX_FRMSELLINE_RIGHT);
//STRIP001         SvxFrameLine& rTop      = aFrameSel.GetLine(SVX_FRMSELLINE_TOP);
//STRIP001         SvxFrameLine& rBottom   = aFrameSel.GetLine(SVX_FRMSELLINE_BOTTOM);
//STRIP001         SvxFrameLine& rHor      = aFrameSel.GetLine(SVX_FRMSELLINE_HOR);
//STRIP001         SvxFrameLine& rVer      = aFrameSel.GetLine(SVX_FRMSELLINE_VER);
//STRIP001 
//STRIP001 		rLeft	.SetStyle( aNullLine ); rLeft	.SetColor( aColBlack );
//STRIP001 		rRight	.SetStyle( aNullLine ); rRight	.SetColor( aColBlack );
//STRIP001 		rTop	.SetStyle( aNullLine ); rTop	.SetColor( aColBlack );
//STRIP001 		rBottom	.SetStyle( aNullLine ); rBottom	.SetColor( aColBlack );
//STRIP001 		rHor	.SetStyle( aNullLine ); rHor	.SetColor( aColBlack );
//STRIP001 		rVer	.SetStyle( aNullLine ); rVer	.SetColor( aColBlack );
//STRIP001 	}
//STRIP001 
//STRIP001 	//-------------------------------
//STRIP001 	// Linien im Selektor darstellen:
//STRIP001 	//-------------------------------
//STRIP001     aFrameSel.ShowLines();
//STRIP001 
//STRIP001 	//-------------------------------------------------------------
//STRIP001 	// Linie/Linienfarbe in Controllern darstellen, wenn eindeutig:
//STRIP001 	//-------------------------------------------------------------
//STRIP001 	{
//STRIP001 		SvxLineStruct 	aDefStyle;
//STRIP001 		List			aList;
//STRIP001 
//STRIP001 		SvxFrameSelectorLine eTypes[] = {	SVX_FRMSELLINE_TOP,
//STRIP001 											SVX_FRMSELLINE_BOTTOM,
//STRIP001 											SVX_FRMSELLINE_LEFT,
//STRIP001 											SVX_FRMSELLINE_RIGHT,
//STRIP001 											SVX_FRMSELLINE_HOR,
//STRIP001 											SVX_FRMSELLINE_VER
//STRIP001 										};
//STRIP001 
//STRIP001 		for (sal_Int32 i=0; i < sizeof(eTypes)/sizeof(SvxFrameSelectorLine); ++i)
//STRIP001 		{
//STRIP001 			if ( aFrameSel.GetLine(eTypes[i]).GetState() == SVX_FRMLINESTATE_SHOW )
//STRIP001 			{
//STRIP001 				aList.Insert( &(aFrameSel.GetLine(eTypes[i])) );
//STRIP001 				aFrameSel.SelectLine( eTypes[i] );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aFrameSel.SelectLine( eTypes[i], FALSE );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aList.Count() > 0 )
//STRIP001 		{
//STRIP001 			SvxFrameLine*	pLine = (SvxFrameLine*)aList.First();
//STRIP001 			Color			aColor( pLine->GetColor() );
//STRIP001 			SvxLineStruct	aStyle = pLine->GetStyle();
//STRIP001 			BOOL			bEqual = TRUE;
//STRIP001 
//STRIP001 			// Linienfarbe -------------------------------------
//STRIP001 
//STRIP001 			while ( pLine && bEqual )
//STRIP001 			{
//STRIP001 				bEqual = (aColor == pLine->GetColor());
//STRIP001 				pLine  = (SvxFrameLine*)aList.Next();
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( !bEqual )
//STRIP001 				aColor = aColBlack;
//STRIP001 
//STRIP001 			USHORT nSelPos = aLbLineColor.GetEntryPos( aColor );
//STRIP001 
//STRIP001 			if ( LISTBOX_ENTRY_NOTFOUND != nSelPos )
//STRIP001 				aLbLineColor.SelectEntryPos( nSelPos );
//STRIP001 			else
//STRIP001 			{
//STRIP001 				nSelPos = aLbLineColor.GetEntryPos( aColor );
//STRIP001 
//STRIP001 				if ( LISTBOX_ENTRY_NOTFOUND != nSelPos )
//STRIP001 				{
//STRIP001 					aLbLineColor.SelectEntryPos( nSelPos );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					aLbLineColor.SelectEntryPos( aLbLineColor.InsertEntry(
//STRIP001 						aColor, SVX_RESSTR( RID_SVXSTR_COLOR_USER ) ) );
//STRIP001 			}
//STRIP001 			aLbLineStyle.SetColor( aColor );
//STRIP001 			if ( bEqual )
//STRIP001                 aFrameSel.SetCurLineColor( aColor );
//STRIP001 
//STRIP001 			// Linienstil --------------------------------------
//STRIP001 
//STRIP001 			pLine = (SvxFrameLine*)aList.First();
//STRIP001 			bEqual = TRUE;
//STRIP001 
//STRIP001 			while ( pLine && bEqual )
//STRIP001 			{
//STRIP001 				bEqual = EQSTYLE( pLine->GetStyle(), aStyle );
//STRIP001 				pLine = (SvxFrameLine*)aList.Next();
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( bEqual )
//STRIP001 			{
//STRIP001 				aLbLineStyle.SelectEntry( aStyle.nLeft,
//STRIP001 										  aStyle.nRight,
//STRIP001 										  aStyle.nMiddle );
//STRIP001                 aFrameSel.SetCurLineStyle( aStyle );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				SET_STYLE( aDefStyle, LINE_WIDTH0, 0, 0 );
//STRIP001 				aLbLineStyle.SelectEntry( LINE_WIDTH0 );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_NONE );
//STRIP001                 aFrameSel.SetCurLineStyle( aDefStyle );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aLbLineColor.SelectEntry( aColBlack, TRUE );
//STRIP001 			aLbLineStyle.SetColor( aColBlack );
//STRIP001             aFrameSel.SetCurLineColor( aColBlack );
//STRIP001 
//STRIP001 			SET_STYLE( aDefStyle, 0, 0, 0 );
//STRIP001 			aLbLineStyle.SelectEntryPos( 0 );
//STRIP001             aFrameSel.SetCurLineStyle( aDefStyle );
//STRIP001             aFrameSel.SelectLine( SVX_FRMSELLINE_NONE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//----------
//STRIP001 	// Schatten:
//STRIP001 	//----------
//STRIP001 	if ( pShadowItem )
//STRIP001 	{
//STRIP001 		Color  aColor( pShadowItem->GetColor() );
//STRIP001 		USHORT nSelPos = aLbShadowColor.GetEntryPos( aColor );
//STRIP001 
//STRIP001 		if ( LISTBOX_ENTRY_NOTFOUND != nSelPos )
//STRIP001 			aLbShadowColor.SelectEntryPos( nSelPos );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nSelPos = aLbShadowColor.GetEntryPos( aColor );
//STRIP001 
//STRIP001 			if ( LISTBOX_ENTRY_NOTFOUND != nSelPos )
//STRIP001 			{
//STRIP001 				aLbShadowColor.SelectEntryPos( nSelPos );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aLbShadowColor.SelectEntryPos(
//STRIP001 					aLbShadowColor.InsertEntry(
//STRIP001 						aColor, SVX_RESSTR( RID_SVXSTR_COLOR_USER ) ) );
//STRIP001 		}
//STRIP001 
//STRIP001         aFrameSel.SetShadowColor( aColor );
//STRIP001 
//STRIP001 		// Shadow-Attribut auslesen
//STRIP001 		SetMetricValue( aEdShadowSize, pShadowItem->GetWidth(), eCoreUnit );
//STRIP001 		USHORT nItem = 1;
//STRIP001 		SvxFrameShadow ePos = SVX_FRMSHADOW_NONE;
//STRIP001 
//STRIP001 		switch ( pShadowItem->GetLocation() )
//STRIP001 		{
//STRIP001 			case SVX_SHADOW_NONE:
//STRIP001 				break;
//STRIP001 			case SVX_SHADOW_BOTTOMRIGHT:
//STRIP001 				nItem = 2;
//STRIP001 				ePos = SVX_FRMSHADOW_BOT_RIGHT;
//STRIP001 				break;
//STRIP001 			case SVX_SHADOW_TOPRIGHT:
//STRIP001 				nItem = 3;
//STRIP001 				ePos = SVX_FRMSHADOW_TOP_RIGHT;
//STRIP001 				break;
//STRIP001 			case SVX_SHADOW_BOTTOMLEFT:
//STRIP001 				nItem = 4;
//STRIP001 				ePos = SVX_FRMSHADOW_BOT_LEFT;
//STRIP001 				break;
//STRIP001 			case SVX_SHADOW_TOPLEFT:
//STRIP001 				nItem = 5;
//STRIP001 				ePos = SVX_FRMSHADOW_TOP_LEFT;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		aWndShadows.SelectItem( nItem );
//STRIP001         aFrameSel.SetShadowPos( ePos );
//STRIP001 	}
//STRIP001 	else // Don't Care
//STRIP001 	{
//STRIP001 		// diese Bedingung erfordert noch eine geeignete
//STRIP001 		// Schatten-TriState-Darstellung
//STRIP001 		aWndShadows.SelectItem( 1 );
//STRIP001         aFrameSel.SetShadowPos( SVX_FRMSHADOW_NONE );
//STRIP001 
//STRIP001 		Color  aColor( aColBlack );
//STRIP001 		USHORT nSelPos = aLbShadowColor.GetEntryPos( aColor );
//STRIP001 
//STRIP001 		if ( LISTBOX_ENTRY_NOTFOUND != nSelPos )
//STRIP001 			aLbShadowColor.SelectEntryPos( nSelPos );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nSelPos = aLbShadowColor.GetEntryPos( aColor );
//STRIP001 
//STRIP001 			if ( LISTBOX_ENTRY_NOTFOUND != nSelPos )
//STRIP001 			{
//STRIP001 				aLbShadowColor.SelectEntryPos( nSelPos );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aLbShadowColor.SelectEntryPos(
//STRIP001 					aLbShadowColor.InsertEntry(
//STRIP001 						aColor, SVX_RESSTR( RID_SVXSTR_COLOR_USER ) ) );
//STRIP001 		}
//STRIP001 
//STRIP001         aFrameSel.SetShadowColor( aColor );
//STRIP001 
//STRIP001 		// Default-Schattenbreite vom Pool abholen
//STRIP001 		SetMetricValue( aEdShadowSize,
//STRIP001 						((const SvxShadowItem&)rSet.GetPool()->
//STRIP001 							GetDefaultItem( nWhichShadow )).GetWidth(),
//STRIP001 						eCoreUnit );
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bEnable = aWndShadows.GetSelectItemId() > 1 ;
//STRIP001 	aFtShadowSize.Enable(bEnable);
//STRIP001 	aEdShadowSize.Enable(bEnable);
//STRIP001 
//STRIP001 	//---------------------------------
//STRIP001 	// Schatten im Selektor darstellen:
//STRIP001 	//---------------------------------
//STRIP001 //    aFrameSel.ShowShadow();
//STRIP001 
//STRIP001 	aWndPresets.SetNoSelection();
//STRIP001 
//STRIP001 	// - keine Line - sollte nicht selektiert sein
//STRIP001 
//STRIP001 	if ( aLbLineStyle.GetSelectEntryPos() == 0 )
//STRIP001 	{
//STRIP001 		aLbLineStyle.SelectEntryPos( 1 );
//STRIP001 		SelStyleHdl_Impl( &aLbLineStyle );
//STRIP001 	}
//STRIP001 
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 	SfxObjectShell* pShell;
//STRIP001 	if(SFX_ITEM_SET == rSet.GetItemState(SID_HTML_MODE, FALSE, &pItem) ||
//STRIP001 		( 0 != (pShell = SfxObjectShell::Current()) &&
//STRIP001 					0 != (pItem = pShell->GetItem(SID_HTML_MODE))))
//STRIP001 	{
//STRIP001 		USHORT nHtmlMode = ((SfxUInt16Item*)pItem)->GetValue();
//STRIP001 		if(nHtmlMode & HTMLMODE_ON)
//STRIP001 		{
//STRIP001 			//Im Html-Mode gibt es keinen Schatten und nur komplette Umrandungen
//STRIP001 			aFtShadowPos  .Enable(FALSE);
//STRIP001 			aWndShadows   .Enable(FALSE);
//STRIP001 			aFtShadowSize .Enable(FALSE);
//STRIP001 			aEdShadowSize .Enable(FALSE);
//STRIP001 			aFtShadowColor.Enable(FALSE);
//STRIP001 			aLbShadowColor.Enable(FALSE);
//STRIP001 			aFlShadow     .Enable(FALSE);
//STRIP001 
//STRIP001 			USHORT nLBCount = aLbLineStyle.GetEntryCount();
//STRIP001 			// ist es ein Absatzdialog, dann alle Linien fuer
//STRIP001 			// Sw-Export, sonst ist die Page nicht da
//STRIP001 			if(!bIsTableBorder && 0 == (nHtmlMode & HTMLMODE_FULL_ABS_POS) &&
//STRIP001 				SFX_ITEM_AVAILABLE > rSet.GetItemState(GetWhich( SID_ATTR_PARA_LINESPACE )))
//STRIP001 			{
//STRIP001 				for( USHORT i = nLBCount - 1; i > LINESTYLE_HTML_MAX; --i)
//STRIP001 					aLbLineStyle.RemoveEntry(i);
//STRIP001 			}
//STRIP001 
//STRIP001 			if(!bIsTableBorder)
//STRIP001 			{
//STRIP001 				aFlBorder   .Enable(FALSE);
//STRIP001                 aFrameSel.Enable(FALSE);
//STRIP001 				aWndPresets.RemoveItem(3);
//STRIP001 				aWndPresets.RemoveItem(4);
//STRIP001 				aWndPresets.RemoveItem(5);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxBorderTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBorderTabPage::SetCoreLine_Impl( const SvxFrameLine* pFrameLine,
//STRIP001 										 SvxBorderLine*& rpCoreLine )
//STRIP001 {
//STRIP001 	if ( !pFrameLine )
//STRIP001 		rpCoreLine = NULL;
//STRIP001 	else if ( pFrameLine->GetState() == SVX_FRMLINESTATE_HIDE )
//STRIP001 		rpCoreLine = NULL;
//STRIP001 	else if ( pFrameLine->GetState() == SVX_FRMLINESTATE_SHOW )
//STRIP001 	{
//STRIP001 		const USHORT nOut  = (USHORT)pFrameLine->GetStyle().nLeft;
//STRIP001 		const USHORT nDist = (USHORT)pFrameLine->GetStyle().nMiddle;
//STRIP001 		const USHORT nIn   = (USHORT)pFrameLine->GetStyle().nRight;
//STRIP001 
//STRIP001 		if ( 0 == nOut && 0 == nDist && 0 == nIn )
//STRIP001 			rpCoreLine = NULL;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rpCoreLine->SetColor	( pFrameLine->GetColor() );
//STRIP001 			rpCoreLine->SetOutWidth ( nOut  ? (nOut  / 100) : 0 );
//STRIP001 			rpCoreLine->SetDistance ( nDist ? (nDist / 100) : 0 );
//STRIP001 			rpCoreLine->SetInWidth  ( nDist ? (nIn   / 100) : 0 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 #define IS_DONT_CARE(a) ((a).GetState() == SVX_FRMLINESTATE_DONT_CARE )
//STRIP001 
//STRIP001 BOOL SvxBorderTabPage::FillItemSet( SfxItemSet& rCoreAttrs )
//STRIP001 {
//STRIP001 	BOOL				  bAttrsChanged = FALSE;
//STRIP001 	BOOL				  bPut		   	= TRUE;
//STRIP001 	USHORT				  nBoxWhich		= GetWhich( SID_ATTR_BORDER_OUTER );
//STRIP001 	USHORT				  nBoxInfoWhich = GetWhich( SID_ATTR_BORDER_INNER );
//STRIP001 	USHORT				  nShadowWhich  = GetWhich( SID_ATTR_BORDER_SHADOW );
//STRIP001 	const SfxItemSet&	  rOldSet		= GetItemSet();
//STRIP001 	SvxBoxItem		      aBoxItem 	    ( nBoxWhich );
//STRIP001 	SvxBoxInfoItem        aBoxInfoItem  ( nBoxInfoWhich );
//STRIP001 	SvxShadowItem         aShadowItem   ( nShadowWhich );
//STRIP001 	SvxBorderLine		  aCoreLine;
//STRIP001 	SvxBorderLine*		  pCoreLine;
//STRIP001 	SvxBoxItem* pOldBoxItem = (SvxBoxItem*)GetOldItem( rCoreAttrs, SID_ATTR_BORDER_OUTER );
//STRIP001 
//STRIP001 	SfxMapUnit eCoreUnit = rOldSet.GetPool()->GetMetric( nBoxWhich );
//STRIP001 	const SfxPoolItem* pOld = 0;
//STRIP001 
//STRIP001 	//------------------
//STRIP001 	// Umrandung aussen:
//STRIP001 	//------------------
//STRIP001 	typedef ::std::pair<SvxFrameSelectorLine,USHORT> TBorderPair;
//STRIP001 	TBorderPair eTypes1[] = {		
//STRIP001 								TBorderPair(SVX_FRMSELLINE_TOP,BOX_LINE_TOP),
//STRIP001 								TBorderPair(SVX_FRMSELLINE_BOTTOM,BOX_LINE_BOTTOM),
//STRIP001 								TBorderPair(SVX_FRMSELLINE_LEFT,BOX_LINE_LEFT),
//STRIP001 								TBorderPair(SVX_FRMSELLINE_RIGHT,BOX_LINE_RIGHT),
//STRIP001 							};
//STRIP001 
//STRIP001 	for (sal_Int32 i=0; i < sizeof(eTypes1)/sizeof(TBorderPair); ++i)
//STRIP001 	{
//STRIP001 		pCoreLine = &aCoreLine;
//STRIP001 		SetCoreLine_Impl( &aFrameSel.GetLine(eTypes1[i].first), pCoreLine );
//STRIP001 		aBoxItem.SetLine( pCoreLine, eTypes1[i].second );
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------
//STRIP001 	// Umrandung hor/ver und TableFlag
//STRIP001 	//--------------------------------
//STRIP001 	TBorderPair eTypes2[] = {
//STRIP001 								TBorderPair(SVX_FRMSELLINE_HOR,BOXINFO_LINE_HORI),
//STRIP001 								TBorderPair(SVX_FRMSELLINE_VER,BOXINFO_LINE_VERT)
//STRIP001 							};
//STRIP001 	for (sal_Int32 j=0; j < sizeof(eTypes2)/sizeof(TBorderPair); ++j)
//STRIP001 	{
//STRIP001 		pCoreLine = &aCoreLine;
//STRIP001 		SetCoreLine_Impl( &aFrameSel.GetLine(eTypes2[j].first), pCoreLine );
//STRIP001 		aBoxInfoItem.SetLine( pCoreLine, eTypes2[j].second );
//STRIP001 	}
//STRIP001 
//STRIP001 	aBoxInfoItem.SetTable( bIsTableBorder );
//STRIP001 
//STRIP001 	//-------------------
//STRIP001 	// Abstand nach Innen
//STRIP001 	//-------------------
//STRIP001 	if( aLeftMF.IsVisible() )
//STRIP001 	{
//STRIP001 		aBoxInfoItem.SetDist( TRUE );
//STRIP001 
//STRIP001 		if ( ((bIsTableBorder || (nSWMode & SW_BORDER_MODE_TABLE)) &&
//STRIP001 				(aLeftMF.IsModified()||aRightMF.IsModified()||
//STRIP001 					aTopMF.IsModified()||aBottomMF.IsModified()) )||
//STRIP001              aFrameSel.GetLine(SVX_FRMSELLINE_TOP)   .GetState() != SVX_FRMLINESTATE_HIDE
//STRIP001              || aFrameSel.GetLine(SVX_FRMSELLINE_BOTTOM).GetState() != SVX_FRMLINESTATE_HIDE
//STRIP001              || aFrameSel.GetLine(SVX_FRMSELLINE_LEFT)  .GetState() != SVX_FRMLINESTATE_HIDE
//STRIP001              || aFrameSel.GetLine(SVX_FRMSELLINE_RIGHT) .GetState() != SVX_FRMLINESTATE_HIDE )
//STRIP001 		{
//STRIP001 			SvxBoxInfoItem* pOldBoxInfoItem = (SvxBoxInfoItem*)GetOldItem(
//STRIP001 												rCoreAttrs, SID_ATTR_BORDER_INNER );
//STRIP001 			if(!pOldBoxItem ||
//STRIP001 			aLeftMF  .GetText() != aLeftMF  .GetSavedValue() ||
//STRIP001 			aRightMF .GetText() != aRightMF .GetSavedValue() ||
//STRIP001 			aTopMF   .GetText() != aTopMF   .GetSavedValue() ||
//STRIP001 			aBottomMF.GetText() != aBottomMF.GetSavedValue() ||
//STRIP001 			nMinValue == aLeftMF  .GetValue() ||
//STRIP001 			nMinValue == aRightMF .GetValue() ||
//STRIP001 			nMinValue == aTopMF   .GetValue() ||
//STRIP001 			nMinValue == aBottomMF.GetValue() ||
//STRIP001 				pOldBoxInfoItem && !pOldBoxInfoItem->IsValid(VALID_DISTANCE))
//STRIP001 			{
//STRIP001 				aBoxItem.SetDistance( (USHORT)GetCoreValue( aLeftMF, eCoreUnit ), BOX_LINE_LEFT  );
//STRIP001 				aBoxItem.SetDistance( (USHORT)GetCoreValue( aRightMF, eCoreUnit ), BOX_LINE_RIGHT );
//STRIP001 				aBoxItem.SetDistance( (USHORT)GetCoreValue( aTopMF, eCoreUnit ), BOX_LINE_TOP   );
//STRIP001 				aBoxItem.SetDistance( (USHORT)GetCoreValue( aBottomMF, eCoreUnit ), BOX_LINE_BOTTOM);
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aBoxItem.SetDistance(pOldBoxItem->GetDistance(BOX_LINE_LEFT ), BOX_LINE_LEFT);
//STRIP001 				aBoxItem.SetDistance(pOldBoxItem->GetDistance(BOX_LINE_RIGHT), 	BOX_LINE_RIGHT);
//STRIP001 				aBoxItem.SetDistance(pOldBoxItem->GetDistance(BOX_LINE_TOP  ), BOX_LINE_TOP);
//STRIP001 				aBoxItem.SetDistance(pOldBoxItem->GetDistance(BOX_LINE_BOTTOM), BOX_LINE_BOTTOM);
//STRIP001 			}
//STRIP001 			aBoxInfoItem.SetValid( VALID_DISTANCE, TRUE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aBoxInfoItem.SetValid( VALID_DISTANCE, FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------
//STRIP001 	// Don't Care Status im Info-Item vermerken:
//STRIP001 	//------------------------------------------
//STRIP001     aBoxInfoItem.SetValid( VALID_TOP, !IS_DONT_CARE( aFrameSel.GetLine(SVX_FRMSELLINE_TOP) ) );
//STRIP001     aBoxInfoItem.SetValid( VALID_BOTTOM, !IS_DONT_CARE( aFrameSel.GetLine(SVX_FRMSELLINE_BOTTOM) )    );
//STRIP001     aBoxInfoItem.SetValid( VALID_LEFT, !IS_DONT_CARE( aFrameSel.GetLine(SVX_FRMSELLINE_LEFT) ) );
//STRIP001     aBoxInfoItem.SetValid( VALID_RIGHT, !IS_DONT_CARE( aFrameSel.GetLine(SVX_FRMSELLINE_RIGHT) ) );
//STRIP001     aBoxInfoItem.SetValid( VALID_HORI, !IS_DONT_CARE( aFrameSel.GetLine(SVX_FRMSELLINE_HOR) ) );
//STRIP001     aBoxInfoItem.SetValid( VALID_VERT, !IS_DONT_CARE( aFrameSel.GetLine(SVX_FRMSELLINE_VER) ) );
//STRIP001 
//STRIP001 	//
//STRIP001 	// Put oder Clear der Umrandung?
//STRIP001 	//
//STRIP001 	bPut = TRUE;
//STRIP001 
//STRIP001 	if (   SFX_ITEM_DEFAULT == rOldSet.GetItemState( nBoxWhich,     FALSE )
//STRIP001 		|| SFX_ITEM_DEFAULT == rOldSet.GetItemState( nBoxInfoWhich, FALSE ) )
//STRIP001 	{
//STRIP001 		const SvxBoxInfoItem& rOldBoxInfo = (const SvxBoxInfoItem&)
//STRIP001 								rOldSet.Get(nBoxInfoWhich);
//STRIP001 
//STRIP001 		aBoxInfoItem.SetMinDist( rOldBoxInfo.IsMinDist() );
//STRIP001 		aBoxInfoItem.SetDefDist( rOldBoxInfo.GetDefDist() );
//STRIP001 		bPut =
//STRIP001 			(   (aBoxItem     != (const SvxBoxItem&)(rOldSet.Get(nBoxWhich)))
//STRIP001 			 || (aBoxInfoItem != rOldBoxInfo ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bPut )
//STRIP001 	{
//STRIP001 		if ( !pOldBoxItem || !( *pOldBoxItem == aBoxItem ) )
//STRIP001 		{
//STRIP001 			rCoreAttrs.Put( aBoxItem );
//STRIP001 			bAttrsChanged |= TRUE;
//STRIP001 		}
//STRIP001 		pOld = GetOldItem( rCoreAttrs, SID_ATTR_BORDER_INNER );
//STRIP001 
//STRIP001 		if ( !pOld || !( *(const SvxBoxInfoItem*)pOld == aBoxInfoItem ) )
//STRIP001 		{
//STRIP001 			rCoreAttrs.Put( aBoxInfoItem );
//STRIP001 			bAttrsChanged |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rCoreAttrs.ClearItem( nBoxWhich );
//STRIP001 		rCoreAttrs.ClearItem( nBoxInfoWhich );
//STRIP001 	}
//STRIP001 
//STRIP001 	//---------
//STRIP001 	// Schatten
//STRIP001 	//---------
//STRIP001     aShadowItem.SetColor( TpBorderRGBColor( aFrameSel.GetShadowColor() ) );
//STRIP001 	aShadowItem.SetWidth( (USHORT)GetCoreValue( aEdShadowSize, eCoreUnit ) );
//STRIP001 	SvxShadowLocation eLoc = SVX_SHADOW_NONE;
//STRIP001 
//STRIP001     switch ( aFrameSel.GetShadowPos() )
//STRIP001 	{
//STRIP001 		case SVX_FRMSHADOW_BOT_RIGHT:
//STRIP001 			eLoc = SVX_SHADOW_BOTTOMRIGHT;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SVX_FRMSHADOW_TOP_RIGHT:
//STRIP001 			eLoc = SVX_SHADOW_TOPRIGHT;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SVX_FRMSHADOW_BOT_LEFT:
//STRIP001 			eLoc = SVX_SHADOW_BOTTOMLEFT;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SVX_FRMSHADOW_TOP_LEFT:
//STRIP001 			eLoc = SVX_SHADOW_TOPLEFT;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	aShadowItem.SetLocation( eLoc );
//STRIP001 
//STRIP001 	//
//STRIP001 	// Put oder Clear des Schattens?
//STRIP001 	//
//STRIP001 	bPut = TRUE;
//STRIP001 
//STRIP001 	if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nShadowWhich, FALSE ) )
//STRIP001 	{
//STRIP001 		const SvxShadowItem& rOldShadowItem
//STRIP001 			= (const SvxShadowItem&)(rOldSet.Get( nShadowWhich ));
//STRIP001 
//STRIP001 		// der Vergleich von Brushes haut nicht hin, deshalb einzeln:
//STRIP001 		if (   ( aShadowItem.GetWidth()    == rOldShadowItem.GetWidth() )
//STRIP001 			&& ( aShadowItem.GetLocation() == rOldShadowItem.GetLocation() ) )
//STRIP001 		{
//STRIP001 			Color aCol	  = aShadowItem.GetColor();
//STRIP001 			Color aOldCol = rOldShadowItem.GetColor();
//STRIP001 			bPut = (   aCol.GetRed()   != aOldCol.GetRed()
//STRIP001 					|| aCol.GetGreen() != aOldCol.GetGreen()
//STRIP001 					|| aCol.GetBlue()  != aOldCol.GetBlue()  );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bPut )
//STRIP001 	{
//STRIP001 		if ( aShadowItem.GetLocation() == SVX_SHADOW_NONE )
//STRIP001 		{
//STRIP001 			// wenn kein Schatten ausgewaehlt wurde, wird das
//STRIP001 			// Default-Item genommen:
//STRIP001 			const SfxItemPool* pPool = rCoreAttrs.GetPool();
//STRIP001 
//STRIP001 			if ( pPool->IsInRange( nShadowWhich ) )
//STRIP001 				aShadowItem =
//STRIP001 					(const SvxShadowItem&)pPool->GetDefaultItem( nShadowWhich );
//STRIP001 		}
//STRIP001 		pOld = GetOldItem( rCoreAttrs, SID_ATTR_BORDER_SHADOW );
//STRIP001 
//STRIP001 		if ( !pOld || !( *(const SvxShadowItem*)pOld == aShadowItem ) )
//STRIP001 		{
//STRIP001 			rCoreAttrs.Put( aShadowItem );
//STRIP001 			bAttrsChanged |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rCoreAttrs.ClearItem( nShadowWhich );
//STRIP001 	return bAttrsChanged;
//STRIP001 }
//STRIP001 
//STRIP001 #undef IS_DONT_CARE
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBorderTabPage::HideShadowControls()
//STRIP001 {
//STRIP001 	aFtShadowPos.Hide();
//STRIP001 	aWndShadows.Hide();
//STRIP001 	aFtShadowSize.Hide();
//STRIP001 	aEdShadowSize.Hide();
//STRIP001 	aFtShadowColor.Hide();
//STRIP001 	aLbShadowColor.Hide();
//STRIP001 	aFlShadow.Hide();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBorderTabPage, SelPreHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT			nSelId	= aWndPresets.GetSelectItemId();
//STRIP001 	SvxLineStruct	theNewStyle;
//STRIP001 
//STRIP001 	if ( nSelId > 1 )
//STRIP001 		if (    aLbLineStyle.GetSelectEntryPos() == 0
//STRIP001 			 || aLbLineStyle.GetSelectEntryPos() == LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			aLbLineStyle.SelectEntryPos( 1 );
//STRIP001 
//STRIP001 	theNewStyle.nLeft   = (short)aLbLineStyle.GetSelectEntryLine1();
//STRIP001 	theNewStyle.nMiddle = (short)aLbLineStyle.GetSelectEntryDistance();
//STRIP001 	theNewStyle.nRight  = (short)aLbLineStyle.GetSelectEntryLine2();
//STRIP001 
//STRIP001 	switch ( nSelId )
//STRIP001 	{
//STRIP001 		case 1: // keine Linien
//STRIP001 		{
//STRIP001 //            aFrameSel.ShowShadow();
//STRIP001             aFrameSel.HideLines();
//STRIP001             aFrameSel.SelectLine( SVX_FRMSELLINE_NONE );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case 2: // aussen
//STRIP001 		{
//STRIP001 
//STRIP001             aFrameSel.HideLines();
//STRIP001 			static const SvxFrameSelectorLine eTypes[] = {	SVX_FRMSELLINE_NONE,
//STRIP001 															SVX_FRMSELLINE_TOP,
//STRIP001 															SVX_FRMSELLINE_BOTTOM,
//STRIP001 															SVX_FRMSELLINE_LEFT,
//STRIP001 															SVX_FRMSELLINE_RIGHT
//STRIP001 														};
//STRIP001 
//STRIP001 			sal_Int32 i;
//STRIP001 			for (i=1; i < sizeof(eTypes)/sizeof(SvxFrameSelectorLine); ++i)
//STRIP001 				aFrameSel.GetLine(eTypes[i])  .SetState( SVX_FRMLINESTATE_SHOW );
//STRIP001 
//STRIP001 			for (i=0; i < sizeof(eTypes)/sizeof(SvxFrameSelectorLine); ++i)
//STRIP001 				aFrameSel.SelectLine( eTypes[i] );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case 3:
//STRIP001 		{
//STRIP001 			if ( bIsTableBorder ) // aussen/horizontal
//STRIP001 			{
//STRIP001                 aFrameSel.HideLines();
//STRIP001 				static const SvxFrameSelectorLine eTypes[] = {	SVX_FRMSELLINE_NONE,
//STRIP001 																SVX_FRMSELLINE_TOP,
//STRIP001 																SVX_FRMSELLINE_BOTTOM,
//STRIP001 																SVX_FRMSELLINE_LEFT,
//STRIP001 																SVX_FRMSELLINE_RIGHT,
//STRIP001 																SVX_FRMSELLINE_HOR
//STRIP001 															};
//STRIP001 
//STRIP001 				sal_Int32 i;
//STRIP001 				for (i=1; i < sizeof(eTypes)/sizeof(SvxFrameSelectorLine); ++i)
//STRIP001 					aFrameSel.GetLine(eTypes[i])  .SetState( SVX_FRMLINESTATE_SHOW );
//STRIP001 				for (i=0; i < sizeof(eTypes)/sizeof(SvxFrameSelectorLine); ++i)
//STRIP001 					aFrameSel.SelectLine( eTypes[i] );
//STRIP001 			}
//STRIP001 			else // links/rechts
//STRIP001 			{
//STRIP001                 aFrameSel.HideLines();
//STRIP001                 aFrameSel.GetLine(SVX_FRMSELLINE_LEFT) .SetState( SVX_FRMLINESTATE_SHOW );
//STRIP001                 aFrameSel.GetLine(SVX_FRMSELLINE_RIGHT).SetState( SVX_FRMLINESTATE_SHOW );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_NONE );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_LEFT );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_RIGHT );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case 4:
//STRIP001 		{
//STRIP001 			if ( bIsTableBorder ) // aussen/hor./ver.
//STRIP001 			{
//STRIP001                 aFrameSel.HideLines();
//STRIP001 				static const SvxFrameSelectorLine eTypes[] = {	SVX_FRMSELLINE_NONE,
//STRIP001 																SVX_FRMSELLINE_TOP,
//STRIP001 																SVX_FRMSELLINE_BOTTOM,
//STRIP001 																SVX_FRMSELLINE_LEFT,
//STRIP001 																SVX_FRMSELLINE_RIGHT,
//STRIP001 																SVX_FRMSELLINE_HOR,
//STRIP001 																SVX_FRMSELLINE_VER
//STRIP001 															};
//STRIP001 
//STRIP001 				sal_Int32 i;
//STRIP001 				for (i=1; i < sizeof(eTypes)/sizeof(SvxFrameSelectorLine); ++i)
//STRIP001 					aFrameSel.GetLine(eTypes[i])  .SetState( SVX_FRMLINESTATE_SHOW );
//STRIP001 				for (i=0; i < sizeof(eTypes)/sizeof(SvxFrameSelectorLine); ++i)
//STRIP001 					aFrameSel.SelectLine( eTypes[i] );
//STRIP001 			}
//STRIP001 			else // oben/unten
//STRIP001 			{
//STRIP001                 aFrameSel.HideLines();
//STRIP001                 aFrameSel.GetLine(SVX_FRMSELLINE_TOP)   .SetState( SVX_FRMLINESTATE_SHOW );
//STRIP001                 aFrameSel.GetLine(SVX_FRMSELLINE_BOTTOM).SetState( SVX_FRMLINESTATE_SHOW );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_NONE );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_TOP );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_BOTTOM );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case 5:
//STRIP001 		{
//STRIP001 			if ( bIsTableBorder ) // Aussen setzen, innen Don't Care
//STRIP001 			{
//STRIP001                 aFrameSel.HideLines();
//STRIP001                 aFrameSel.GetLine(SVX_FRMSELLINE_LEFT)  .SetState( SVX_FRMLINESTATE_SHOW );
//STRIP001                 aFrameSel.GetLine(SVX_FRMSELLINE_RIGHT) .SetState( SVX_FRMLINESTATE_SHOW );
//STRIP001                 aFrameSel.GetLine(SVX_FRMSELLINE_TOP)   .SetState( SVX_FRMLINESTATE_SHOW );
//STRIP001                 aFrameSel.GetLine(SVX_FRMSELLINE_BOTTOM).SetState( SVX_FRMLINESTATE_SHOW );
//STRIP001                 aFrameSel.GetLine(SVX_FRMSELLINE_HOR)   .SetState( SVX_FRMLINESTATE_DONT_CARE );
//STRIP001                 aFrameSel.GetLine(SVX_FRMSELLINE_VER)   .SetState( SVX_FRMLINESTATE_DONT_CARE );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_NONE );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_LEFT );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_RIGHT );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_TOP );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_BOTTOM );
//STRIP001 			}
//STRIP001 			else // links (Absatz-Markierung)
//STRIP001 			{
//STRIP001                 aFrameSel.HideLines();
//STRIP001                 aFrameSel.GetLine(SVX_FRMSELLINE_LEFT).SetState( SVX_FRMLINESTATE_SHOW );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_NONE );
//STRIP001                 aFrameSel.SelectLine( SVX_FRMSELLINE_LEFT );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001     aFrameSel.SetCurLineStyle( theNewStyle );
//STRIP001     aFrameSel.SetCurLineColor( aLbLineColor.GetSelectEntryColor() );
//STRIP001     aFrameSel.SetShadowColor( aLbShadowColor.GetSelectEntryColor() );
//STRIP001     aFrameSel.ShowLines();
//STRIP001 //    aFrameSel.ShowShadow();
//STRIP001 	aWndPresets.SetNoSelection(); // Nur Auswahl, kein Status
//STRIP001 	LinesChanged_Impl(0);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBorderTabPage, SelSdwHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	BOOL bEnable = aWndShadows.GetSelectItemId() > 1;
//STRIP001 	aFtShadowSize.Enable(bEnable);
//STRIP001 	aEdShadowSize.Enable(bEnable);
//STRIP001 
//STRIP001 	SvxFrameShadow ePos = SVX_FRMSHADOW_NONE; // case 1
//STRIP001 
//STRIP001 	switch ( aWndShadows.GetSelectItemId() )
//STRIP001 	{
//STRIP001 		case 2: ePos = SVX_FRMSHADOW_BOT_RIGHT;	break;
//STRIP001 		case 3: ePos = SVX_FRMSHADOW_TOP_RIGHT;	break;
//STRIP001 		case 4: ePos = SVX_FRMSHADOW_BOT_LEFT;	break;
//STRIP001 		case 5: ePos = SVX_FRMSHADOW_TOP_LEFT;	break;
//STRIP001 	}
//STRIP001     aFrameSel.SetShadowPos( ePos );
//STRIP001 //    aFrameSel.ShowShadow();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBorderTabPage, SelColHdl_Impl, ListBox *, pLb )
//STRIP001 {
//STRIP001 	ColorListBox* pColLb = (ColorListBox*)pLb;
//STRIP001 
//STRIP001 	if ( pLb == &aLbLineColor )
//STRIP001 	{
//STRIP001         aFrameSel.SetCurLineColor( pColLb->GetSelectEntryColor() );
//STRIP001 		aLbLineStyle.SetColor( pColLb->GetSelectEntryColor() );
//STRIP001         aFrameSel.ShowLines();
//STRIP001 	}
//STRIP001 	else if ( pLb == &aLbShadowColor )
//STRIP001 	{
//STRIP001         aFrameSel.SetShadowColor( pColLb->GetSelectEntryColor() );
//STRIP001 //        aFrameSel.ShowShadow();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBorderTabPage, SelStyleHdl_Impl, ListBox *, pLb )
//STRIP001 {
//STRIP001 	if ( pLb == &aLbLineStyle )
//STRIP001 	{
//STRIP001 		SvxLineStruct theNewStyle;
//STRIP001 
//STRIP001 		theNewStyle.nLeft   = (short)aLbLineStyle.GetSelectEntryLine1();
//STRIP001 		theNewStyle.nMiddle = (short)aLbLineStyle.GetSelectEntryDistance();
//STRIP001 		theNewStyle.nRight  = (short)aLbLineStyle.GetSelectEntryLine2();
//STRIP001 
//STRIP001         aFrameSel.SetCurLineStyle( theNewStyle );
//STRIP001         aFrameSel.ShowLines();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 #define MAX_VALUESET_COUNT 	5
//STRIP001 #define FIRST_VALUESET_ITEM	1
//STRIP001 
//STRIP001 void SvxBorderTabPage::FillValueSets_Impl()
//STRIP001 {
//STRIP001 	// Initialize presets window
//STRIP001 	aWndPresets.SetColCount( MAX_VALUESET_COUNT );
//STRIP001 	aWndPresets.SetStyle( aWndPresets.GetStyle() | WB_ITEMBORDER | WB_DOUBLEBORDER );
//STRIP001     aWndPresets.SetSizePixel(
//STRIP001 		aWndPresets.CalcWindowSizePixel( aBorderImgLst.GetImage(IID_PRENONE).GetSizePixel() ) );
//STRIP001     aWndShadows.SetColCount( MAX_VALUESET_COUNT );
//STRIP001     aWndShadows.SetStyle( aWndShadows.GetStyle() | WB_ITEMBORDER | WB_DOUBLEBORDER );
//STRIP001 	aWndShadows.SetPosSizePixel( aWndShadows.GetPosPixel(),
//STRIP001 		aWndShadows.CalcWindowSizePixel( aShadowImgLst.GetImage(IID_SHADOWNONE).GetSizePixel() ) );
//STRIP001 
//STRIP001     for(USHORT i = FIRST_VALUESET_ITEM; i <= MAX_VALUESET_COUNT; i++)
//STRIP001     {
//STRIP001         aWndPresets.InsertItem( i );
//STRIP001         aWndShadows.InsertItem( i );
//STRIP001     }
//STRIP001     aWndPresets.SetNoSelection();
//STRIP001     aWndShadows.SelectItem( FIRST_VALUESET_ITEM );
//STRIP001 
//STRIP001     InitValueSets_Impl();
//STRIP001     aWndPresets.Show();
//STRIP001     aWndShadows.Show();
//STRIP001 }
//STRIP001 /* -----------------------------03.06.2002 10:17------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxBorderTabPage::InitValueSets_Impl()
//STRIP001 {
//STRIP001     static const USHORT aTableBorders[] =
//STRIP001     {
//STRIP001         IID_PRENONE,
//STRIP001         IID_TABLE_PRE1,
//STRIP001         IID_TABLE_PRE2,
//STRIP001         IID_TABLE_PRE3,
//STRIP001         IID_TABLE_PRE4
//STRIP001     };
//STRIP001     static const USHORT aParaBorders[] =
//STRIP001     {
//STRIP001         IID_PRENONE,
//STRIP001         IID_PARAGRAPH_PRE1,
//STRIP001         IID_PARAGRAPH_PRE2,
//STRIP001         IID_PARAGRAPH_PRE3,
//STRIP001         IID_PARAGRAPH_PRE4
//STRIP001     };
//STRIP001     static const USHORT aShadows[] =
//STRIP001     {
//STRIP001         IID_SHADOWNONE,
//STRIP001         IID_SHADOW_BOT_RIGHT,
//STRIP001         IID_SHADOW_TOP_RIGHT,
//STRIP001         IID_SHADOW_BOT_LEFT,
//STRIP001         IID_SHADOW_TOP_LEFT
//STRIP001     };
//STRIP001 
//STRIP001 	BOOL bDark = aWndPresets.GetDisplayBackground().GetColor().IsDark();
//STRIP001     ImageList& rBorderImgLst = bDark ? aBorderImgLstH : aBorderImgLst;
//STRIP001     const USHORT * pBorderIds = bIsTableBorder ? aTableBorders : aParaBorders;
//STRIP001 	const USHORT nBorderStartId = bIsTableBorder ? RID_SVXSTR_TABLE_PRESET_START : RID_SVXSTR_PARA_PRESET_START;
//STRIP001     for( USHORT nBorder = 0; nBorder < aWndPresets.GetItemCount(); ++nBorder )
//STRIP001 	{
//STRIP001         aWndPresets.SetItemImage( nBorder + 1, rBorderImgLst.GetImage( pBorderIds[nBorder] ) );
//STRIP001         aWndPresets.SetItemText ( nBorder + 1, SVX_RESSTR( nBorderStartId + nBorder ) );
//STRIP001 	}
//STRIP001     ImageList& rShadowImgLst = bDark ? aShadowImgLstH : aShadowImgLst;
//STRIP001     for ( USHORT nShadow = 0; nShadow < 5; ++nShadow )
//STRIP001 	{
//STRIP001         aWndShadows.SetItemImage( nShadow + 1, rShadowImgLst.GetImage( aShadows[nShadow] ) );
//STRIP001         aWndShadows.SetItemText ( nShadow + 1, SVX_RESSTR( RID_SVXSTR_SHADOW_STYLE_START + nShadow ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxBorderTabPage::FillLineListBox_Impl()
//STRIP001 {
//STRIP001 	aLbLineStyle.SetUnit( FUNIT_POINT );
//STRIP001 	aLbLineStyle.SetSourceUnit( FUNIT_TWIP );
//STRIP001 
//STRIP001 	// Writer 2.0 Defaults:
//STRIP001 	aLbLineStyle.InsertEntry( SVX_RESSTR( STR_NONE ) );
//STRIP001 
//STRIP001 	aLbLineStyle.InsertEntry( LINE_WIDTH0 );
//STRIP001 	aLbLineStyle.InsertEntry( LINE_WIDTH1 );
//STRIP001 	aLbLineStyle.InsertEntry( LINE_WIDTH2 );
//STRIP001 	aLbLineStyle.InsertEntry( LINE_WIDTH3 );
//STRIP001 	aLbLineStyle.InsertEntry( LINE_WIDTH4 );
//STRIP001 
//STRIP001 	// OS: wenn hier neue Linienstaerken zugfuegt werden, dann
//STRIP001 	// LINESTYLE_HTML_MAX anpassen
//STRIP001 
//STRIP001 	aLbLineStyle.InsertEntry( DLINE0_OUT, DLINE0_IN, DLINE0_DIST );
//STRIP001 	aLbLineStyle.InsertEntry( DLINE7_OUT, DLINE7_IN, DLINE7_DIST );
//STRIP001 	aLbLineStyle.InsertEntry( DLINE1_OUT, DLINE1_IN, DLINE1_DIST );
//STRIP001 	aLbLineStyle.InsertEntry( DLINE2_OUT, DLINE2_IN, DLINE2_DIST );
//STRIP001 	aLbLineStyle.InsertEntry( DLINE8_OUT, DLINE8_IN, DLINE8_DIST );
//STRIP001 	aLbLineStyle.InsertEntry( DLINE9_OUT, DLINE9_IN, DLINE9_DIST );
//STRIP001 	aLbLineStyle.InsertEntry( DLINE10_OUT,DLINE10_IN,DLINE10_DIST);
//STRIP001 	aLbLineStyle.InsertEntry( DLINE3_OUT, DLINE3_IN, DLINE3_DIST );
//STRIP001 	aLbLineStyle.InsertEntry( DLINE4_OUT, DLINE4_IN, DLINE4_DIST );
//STRIP001 	aLbLineStyle.InsertEntry( DLINE5_OUT, DLINE5_IN, DLINE5_DIST );
//STRIP001 	aLbLineStyle.InsertEntry( DLINE6_OUT, DLINE6_IN, DLINE6_DIST );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 IMPL_LINK( SvxBorderTabPage, LinesChanged_Impl, void*, EMPTYARG )
//STRIP001 {
//STRIP001 	if(aLeftMF.IsVisible())
//STRIP001 	{
//STRIP001         BOOL bLineSet = aFrameSel.IsAnyLineSet();
//STRIP001         BOOL bMinAllowed = 0 != (nSWMode & (SW_BORDER_MODE_FRAME|SW_BORDER_MODE_TABLE));
//STRIP001 		BOOL bSpaceModified = 	aLeftMF  .IsModified()||
//STRIP001 								aRightMF .IsModified()||
//STRIP001 								aTopMF   .IsModified()||
//STRIP001 								aBottomMF.IsModified();
//STRIP001 
//STRIP001 		if(bLineSet)
//STRIP001 		{
//STRIP001 			if(!bMinAllowed)
//STRIP001 			{
//STRIP001 				aLeftMF  .SetFirst(nMinValue);
//STRIP001 				aRightMF .SetFirst(nMinValue);
//STRIP001 				aTopMF   .SetFirst(nMinValue);
//STRIP001 				aBottomMF.SetFirst(nMinValue);
//STRIP001 			}
//STRIP001 			if(!bSpaceModified)
//STRIP001 			{
//STRIP001 				aLeftMF  .SetValue(nMinValue);
//STRIP001 				aRightMF .SetValue(nMinValue);
//STRIP001 				aTopMF   .SetValue(nMinValue);
//STRIP001 				aBottomMF.SetValue(nMinValue);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aLeftMF  .SetMin(0);
//STRIP001 			aRightMF .SetMin(0);
//STRIP001 			aTopMF   .SetMin(0);
//STRIP001 			aBottomMF.SetMin(0);
//STRIP001 			aLeftMF  .SetFirst(0);
//STRIP001 			aRightMF .SetFirst(0);
//STRIP001 			aTopMF   .SetFirst(0);
//STRIP001 			aBottomMF.SetFirst(0);
//STRIP001 			if(!bSpaceModified)
//STRIP001 			{
//STRIP001 				aLeftMF  .SetValue(0);
//STRIP001 				aRightMF .SetValue(0);
//STRIP001 				aTopMF   .SetValue(0);
//STRIP001 				aBottomMF.SetValue(0);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		//fuer Tabellen ist alles erlaubt
//STRIP001 		USHORT nValid = VALID_TOP|VALID_BOTTOM|VALID_LEFT|VALID_RIGHT;
//STRIP001 
//STRIP001 		//fuer Rahmen und  Absatz wird das Edit disabled, wenn keine Border gesetzt ist
//STRIP001 		if(nSWMode & (SW_BORDER_MODE_FRAME|SW_BORDER_MODE_PARA))
//STRIP001 		{
//STRIP001             if(bLineSet)
//STRIP001             {
//STRIP001                 nValid = aFrameSel.GetLine(SVX_FRMSELLINE_TOP).GetState() == SVX_FRMLINESTATE_SHOW ? VALID_TOP : 0;
//STRIP001                 nValid |= aFrameSel.GetLine(SVX_FRMSELLINE_BOTTOM).GetState() == SVX_FRMLINESTATE_SHOW ? VALID_BOTTOM : 0;
//STRIP001                 nValid |= aFrameSel.GetLine(SVX_FRMSELLINE_LEFT).GetState() == SVX_FRMLINESTATE_SHOW ? VALID_LEFT : 0;
//STRIP001                 nValid |= aFrameSel.GetLine(SVX_FRMSELLINE_RIGHT).GetState() == SVX_FRMLINESTATE_SHOW ? VALID_RIGHT : 0;
//STRIP001             }
//STRIP001             else
//STRIP001                 nValid = 0;
//STRIP001 		}
//STRIP001         aLeftFT.Enable(0 != (nValid&VALID_LEFT));
//STRIP001         aRightFT.Enable(0 != (nValid&VALID_RIGHT));
//STRIP001         aTopFT.Enable(0 != (nValid&VALID_TOP));
//STRIP001         aBottomFT.Enable(0 != (nValid&VALID_BOTTOM));
//STRIP001         aLeftMF.Enable(0 != (nValid&VALID_LEFT));
//STRIP001         aRightMF.Enable(0 != (nValid&VALID_RIGHT));
//STRIP001         aTopMF.Enable(0 != (nValid&VALID_TOP));
//STRIP001         aBottomMF.Enable(0 != (nValid&VALID_BOTTOM));
//STRIP001         aSynchronizeCB.Enable( aRightMF.IsEnabled() || aTopMF.IsEnabled() ||
//STRIP001                                aBottomMF.IsEnabled() || aLeftMF.IsEnabled() );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxBorderTabPage, ModifyDistanceHdl_Impl, MetricField*, pField)
//STRIP001 {
//STRIP001 	if ( bSync )
//STRIP001 	{
//STRIP001 		long nVal = pField->GetValue();
//STRIP001 		if(pField != &aLeftMF)
//STRIP001 			aLeftMF.SetValue(nVal);
//STRIP001 		if(pField != &aRightMF)
//STRIP001 			aRightMF.SetValue(nVal);
//STRIP001 		if(pField != &aTopMF)
//STRIP001 			aTopMF.SetValue(nVal);
//STRIP001 		if(pField != &aBottomMF)
//STRIP001 			aBottomMF.SetValue(nVal);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SvxBorderTabPage, SyncHdl_Impl, CheckBox*, pBox)
//STRIP001 {
//STRIP001 	bSync = pBox->IsChecked();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void	SvxBorderTabPage::SetSWMode(BYTE nSet)
//STRIP001 {
//STRIP001 //#define SW_BORDER_MODE_PARA 	0x01
//STRIP001 //#define SW_BORDER_MODE_TABLE  0x02
//STRIP001 //#define SW_BORDER_MODE_FRAME  0x04
//STRIP001 	nSWMode = nSet;
//STRIP001 }
//STRIP001 /* -----------------------------03.06.2002 10:15------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxBorderTabPage::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             InitValueSets_Impl();
//STRIP001 
//STRIP001     SfxTabPage::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 #undef EQSTYLE
//STRIP001 #undef SET_STYLE


}
