/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dosztc.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:15:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <stdio.h>
#include <ctype.h>

#include "comdep.hxx"

//--------------------------------------------------------------------

struct dirent *readdir( DIR *pDir )
{
    if ( pDir->pDirEnt )
        pDir->pDirEnt = findnext();
    else
        pDir->pDirEnt = findfirst( pDir->p, 0xFF );

    if ( pDir->pDirEnt )
        for ( char *p = pDir->pDirEnt->d_name; *p; p++ )
            *p = tolower( *p );

    return pDir->pDirEnt;
}

int closedir( DIR *pDir )
{
    if ( pDir )
    {
        delete pDir->p;
        delete pDir;
    }
    return (pDir != NULL);
}

DIR *opendir( const char* pPfad )
{
    DIR *pDir = new DIR;
    if ( pDir )
    {
        pDir->pDirEnt = NULL;
        pDir->p = new char[ strlen( pPfad ) + 5 ];
        if ( !pDir->p )
        {
            delete pDir;
            return NULL;
        }

        // *.* dahinter, ggf mit "\\" abtrennen (falls nicht schon da)
        strcpy( pDir->p, pPfad );
        strcat( pDir->p,
                "\\*.*" + ( *(pDir->p + strlen( pPfad ) - 1 ) == '\\' ) );
    }
    return pDir;
}

char* volumeid( const char* pPfad )
{
    static char     sVolume[260];
    struct dirent*  pDirEnt;

#ifdef WIN
    // unter Windows koennen wir die Netzwerknamen auch leicht rausbekommen
    unsigned nLen = sizeof(sVolume);
    unsigned nErr = WNetGetConnection( (char*) pPfad, sVolume, &nLen );
    if ( nErr == WN_SUCCESS )
        return sVolume;
#endif

    char* pMask = new char[ strlen( pPfad ) + 5 ];

    // *.* dahinter, ggf mit "\\" abtrennen (falls nicht schon da)
    strcpy( pMask, pPfad );
    strcat( pMask, "\\*.*" + ( *( pPfad + strlen( pPfad ) - 1 ) == '\\' ) );
    pDirEnt = findfirst( pMask, _A_VOLID );
    delete pMask;
    if ( pDirEnt )
    {
        strcpy( sVolume, pDirEnt->d_name );
        return sVolume;
    }
    else
        return NULL;
}

#include "dos.cxx"
