/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sharedunocomponent.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:00:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SW_SHARED_UNO_COMPONENT_HXX
#define SW_SHARED_UNO_COMPONENT_HXX

#ifndef _COM_SUN_STAR_SDBC_XCONNECTION_HPP_
#include <com/sun/star/sdbc/XConnection.hpp>
#endif

#ifndef INCLUDED_SWDLLAPI_H
#include "swdllapi.h"
#endif

#include <boost/shared_ptr.hpp>

class SW_DLLPUBLIC ComponentHolder
{
private:
    ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >
                            m_xComponent;
    bool                    bHaveOwnership;
public:
    ComponentHolder( const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& rComponent, bool _bTakeOwnership = true );
    ~ComponentHolder();

    inline  const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& getComponent() const
    {
        return m_xComponent;
    }

private:
    ComponentHolder( const ComponentHolder& );              // never implemented
    ComponentHolder& operator=( const ComponentHolder& );   // never implemented
};

/** is a helper class for sharing ownership of a UNO component

    If you need to share an UNO component, which normally needs a dedicated owner,
    and is lifetime controlled by disposal (->XComponent::dispose), between different
    classes, ->SharedUNOComponent is what you need.

    Instead of passing around a <code>Reference&lt; XFoo &gt;</code>, and bothering
    with ownership and disposal, you just use a <code>SharedUNOComponent&lt; XFoo &gt;</code>.
    This instance can be passed around, including copying, and in nearly all respects behaves
    like the original <code>Reference&lt; XFoo &gt;</code>. However, when the last
    ->SharedUNOComponent referencing a certain <code>Reference&lt; XFoo &gt;</code> dies, it
    will automatically dispose the object held by this reference.
*/
template < class INTERFACE >
class SharedUNOComponent
{
private:
    ::boost::shared_ptr< ComponentHolder >          m_pHolder;
    ::com::sun::star::uno::Reference< INTERFACE >   m_xTypedComponent;

public:
    inline  SharedUNOComponent()
    {
    }
    inline  SharedUNOComponent( const ::com::sun::star::uno::Reference< INTERFACE >& rComponent, bool _bTakeOwnership = true )
        :m_pHolder( new ComponentHolder( rComponent.get(), _bTakeOwnership ) )
        ,m_xTypedComponent( rComponent )
    {
    }
    inline  SharedUNOComponent& operator=( const ::com::sun::star::uno::Reference< INTERFACE >& rComponent )
    {
        m_pHolder = ::boost::shared_ptr< ComponentHolder >( new ComponentHolder( rComponent.get(), true ) );
        m_xTypedComponent = rComponent;
        return *this;
    }
    inline  operator const ::com::sun::star::uno::Reference< INTERFACE >&() const
    {
        return m_xTypedComponent;
    }
    inline  const ::com::sun::star::uno::Reference< INTERFACE >& getTyped() const
    {
        return m_xTypedComponent;
    }
    inline  bool is() const
    {
        return m_xTypedComponent.is();
    }
    inline  void clear()
    {
        m_pHolder = ::boost::shared_ptr< ComponentHolder >();
        m_xTypedComponent.clear();
    }
};

typedef SharedUNOComponent< ::com::sun::star::sdbc::XConnection >   SharedConnection;

#endif // SW_SHARED_UNO_COMPONENT_HXX
