/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: classfactory.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:58:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
 
#ifndef CLASSFACTORY_HXX_INCLUDED
#define CLASSFACTORY_HXX_INCLUDED

#include <objidl.h>

class CClassFactory : public IClassFactory  
{
public:
	CClassFactory(const CLSID& clsid);
	virtual ~CClassFactory();

	//-----------------------------
	// IUnknown methods
	//-----------------------------

	virtual HRESULT STDMETHODCALLTYPE QueryInterface( 
            REFIID riid,
            void __RPC_FAR *__RPC_FAR *ppvObject);
        
    virtual ULONG STDMETHODCALLTYPE AddRef(void);
        
    virtual ULONG STDMETHODCALLTYPE Release(void);

	//-----------------------------
	// IClassFactory methods
	//-----------------------------

	virtual HRESULT STDMETHODCALLTYPE CreateInstance( 
            IUnknown __RPC_FAR *pUnkOuter,
            REFIID riid,
            void __RPC_FAR *__RPC_FAR *ppvObject);
        
    virtual HRESULT STDMETHODCALLTYPE LockServer(BOOL fLock);

	static bool IsLocked();

private:
	long  m_RefCnt;	
	CLSID m_Clsid;

	static long  s_ServerLocks;
};

#endif
