/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: speekctl.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:12:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SPEEKCTL_HXX
#define _SPEEKCTL_HXX

#ifndef _IMAGE_HXX
#include <vcl/image.hxx>
#endif

//=========================================================================

class SfxDictation;
class SfxTaskStatusBar;

class SfxSpeekStatusBarControl: public SfxTaskStatusBarControl
{
private:

	Image 			_aImgOff;
	Image 			_aImgDict;
	Image 			_aImgCmd;
	SfxDictation*   _pDictation;
	BOOL			_bSpeaking;
	BOOL			_mbNative;

	BOOL			ImplInitSpeachEngine();
	void			ImplReadSettings();
	void			ImplWriteSettings();

protected:

	virtual void	StateChanged( USHORT nSID, SfxItemState eState,
								  const SfxPoolItem* pState );
	virtual BOOL	Command( USHORT, const CommandEvent& rCEvt );
	virtual BOOL	MouseButtonDown( USHORT, const MouseEvent & );

public:
					SfxSpeekStatusBarControl( USHORT nId, SfxTaskStatusBar& rBar, SfxBindings & );
	virtual 		~SfxSpeekStatusBarControl();

	BOOL			IsSpeakingEnabled() const { return _bSpeaking; }
	void			ModeChanged();
};


#endif
