/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: appsys.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:36:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef WNT

#include <tools/solar.h>
#include <tools/prewin.h>
#include <winreg.h>
#include <tools/postwin.h>

#include <tools/urlobj.hxx>

#include "sfxuno.hxx"

#pragma hdrstop

String GetUserID()
{
	String aUserID;
	HKEY hkResult;			// address of handle of open key
	DWORD dwType;			// address of buffer for value type
	char sCurUser[32];		// address of data buffer
	DWORD nBufSize = 31;	// of data buffer size

	// Windows95
	LONG nErr = RegOpenKeyEx( HKEY_LOCAL_MACHINE,
								"System\\CurrentControlSet\\Control",
								0, KEY_READ, &hkResult );
	if ( ERROR_SUCCESS == nErr )
		nErr = RegQueryValueEx( hkResult, "Current User", 0, &dwType,
								(unsigned char*) sCurUser, &nBufSize );
	if ( ERROR_SUCCESS != nErr )
	{
		RegCloseKey( hkResult );
		nErr = RegOpenKeyEx( HKEY_LOCAL_MACHINE,
								"SOFTWARE\\Microsoft\\Windows NT"
								"\\CurrentVersion\\Winlogon",
								0, KEY_READ, &hkResult );
		if ( ERROR_SUCCESS == nErr )
			nErr = RegQueryValueEx( hkResult, "DefaultUserName", 0, &dwType,
									(unsigned char*) sCurUser, &nBufSize );
	}

	if ( ERROR_SUCCESS == nErr && REG_SZ == dwType )
		aUserID = String::CreateFromAscii(sCurUser);
	RegCloseKey( hkResult );
	return aUserID;
}

void FATToVFat_Impl( String& aName )
{
	INetURLObject aObj( aName );
	if ( aObj.GetProtocol() == INET_PROT_FILE )
	{
		WIN32_FIND_DATA aData;
		HANDLE h = FindFirstFile( U2S(aName).getStr(), &aData );
		if ( h )
		{
			// FAT-Kurzname in VFAT-Langname wandeln
			aObj.removeSegment();
			aObj.insertName( String::CreateFromAscii( aData.cFileName ) );
			aName = aObj.PathToFileName();
			FindClose( h );
		}
	}
}

int GetModulePathName( const char* pLib, char* pPathName, unsigned short nLen )
{
	HMODULE aModule = GetModuleHandle( pLib );
	if( aModule )
		GetModuleFileName( aModule, pPathName, nLen );
	return aModule != 0;
}

#endif // WNT?


