#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.4 $
#
#   last change: $Author: rt $ $Date: 2005/09/09 07:23:59 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ=..
PRJNAME=sdk_oo
TARGET=sdk

# ------------------------------------------------------------------
.INCLUDE: settings.mk
.INCLUDE: makefile.pmk
# ------------------------------------------------------------------

.IF "$(OS)"=="WNT"
all:\
    $(BIN)$/$(PRODUCTZIPFILE)
.ELSE
all:\
    $(BIN)$/$(PRODUCTTARGZFILE)
.ENDIF

$(BIN)$/$(PRODUCTZIPFILE) : $(SDK_CONTENT_CHECK_FILES) $(SDKCHECKFLAG)
	+cd $(BIN) && $(WRAPCMD) zip -urq $(PRODUCTZIPFILE) $(PRODUCT_NAME)

$(BIN)$/$(PRODUCTTARGZFILE) : $(SDK_CONTENT_CHECK_FILES) $(SDKCHECKFLAG)
	+-rm -f $@ >& $(NULLDEV)
#	tar does not properly support update
.IF "$(OS)"=="SOLARIS"
#	always use the system tar on Solaris
	+cd $(BIN) && /usr/bin/tar cf - $(PRODUCT_NAME) | gzip - > $(PRODUCTTARGZFILE)
.ELSE
	+cd $(BIN) && tar cf - $(PRODUCT_NAME) | gzip - > $(PRODUCTTARGZFILE)
.ENDIF


