/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: MasterPagesContainerSelector.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:40:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SD_TOOLPANEL_CONTROLS_MASTER_PAGES_CONTAINER_SELECTOR_HXX
#define SD_TOOLPANEL_CONTROLS_MASTER_PAGES_CONTAINER_SELECTOR_HXX

#include "MasterPagesSelector.hxx"

#ifndef _PRESENTATION_HXX
#include "pres.hxx"
#endif
#include <sfx2/shell.hxx>
#include <vcl/image.hxx>
#include "glob.hxx"

#include <queue>

class MouseEvent;
class SdDrawDocument;
class SdPage;
class SfxModule;

namespace sd { 
class DrawViewShell;
class TemplateEntry;
class TemplateDir;
class ViewShellBase;
}

namespace sd { namespace toolpanel { namespace controls {

class PreviewValueSet;

/** This intermediate class adds the knowledge about how to access the
    MasterPageContainer to the MasterPagesSelector class.  This is used by
    the derived classes RecentMasterPagesSelector and
    AllMasterPagesSelector.  In contrast the CurrentMasterPagesSelector
    class is not derived.  It takes its master pages directly from the
    current document.
*/
class MasterPagesContainerSelector
    : public MasterPagesSelector
{
public:
    TYPEINFO();

    MasterPagesContainerSelector (
        TreeNode* pParent,
        SdDrawDocument& rDocument,
        ViewShellBase& rBase);
    virtual ~MasterPagesContainerSelector (void);

    virtual SdPage* GetSelectedMasterPage (void);

    virtual void Clear (void);

protected:
    void AddItemForPage (
        const String& sURL,
        const String& sPageName,
        SdPage* pMasterPage,
        Image aPreview,
        bool bCreatePreview = true);
    void AddItemForToken (
        MasterPageContainer::Token aToken,
        bool bCreatePreview = true);

    /** Ask the master page container for the previews of all items and set
        them to the value set.  Call this function when the size of the
        previews has changed.
    */
    virtual void UpdateAllPreviews (void);
    virtual void UpdatePreview (USHORT nIndex);

    /** Call this method to tell a selector object that the preview that
        belongs to the given page does not reflect the pages content
        anymore.  This method forwards the call to the variant that takes a
        value set index as argument so call that variant directly when the
        index is already present.
        @param pPage
            When NULL or a pointer to page is given that does not belong to
            the selector then the call is ignored.
    */
    virtual void InvalidatePreview (const SdPage* pPage);

    DECL_LINK(PreviewAvailableCallback, void*);
};

} } } // end of namespace ::sd::toolpanel::controls

#endif
