/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: otasksaccess.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:25:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_HELPER_OTASKSACCESS_HXX_
#include <helper/otasksaccess.hxx>
#endif

#ifndef __FRAMEWORK_HELPER_OTASKSENUMERATION_HXX_
#include <helper/otasksenumeration.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_RESETABLEGUARD_HXX_
#include <threadhelp/resetableguard.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::com::sun::star::container		;
using namespace ::com::sun::star::frame			;
using namespace ::com::sun::star::lang			;
using namespace ::com::sun::star::uno			;
using namespace ::cppu							;
using namespace ::osl							;
using namespace ::rtl							;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
OTasksAccess::OTasksAccess(	const	Reference< XDesktop >&		xOwner	,
                                    FrameContainer*             pTasks  )
		//	Init baseclasses first
		:	OWeakObject		(			)
		// Init member
		,	m_xOwner		( xOwner	)
		,	m_pTasks		( pTasks	)
{
	// Safe impossible cases
    LOG_ASSERT( impldbg_checkParameter_OTasksAccessCtor( xOwner, pTasks ), "OTasksAccess::OTasksAccess()\nInvalid parameter detected!\n" )
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
OTasksAccess::~OTasksAccess()
{
}

//*****************************************************************************************************************
//	XInterface, XTypeProvider
//*****************************************************************************************************************
DEFINE_XINTERFACE_3(	OTasksAccess							,
						OWeakObject								,
						DIRECT_INTERFACE(XTypeProvider		)	,
						DIRECT_INTERFACE(XEnumerationAccess	)	,
						DIRECT_INTERFACE(XElementAccess		)	)

DEFINE_XTYPEPROVIDER_3(	OTasksAccess							,
						XTypeProvider							,
						XEnumerationAccess						,
						XElementAccess							)

//*****************************************************************************************************************
//	XEnumerationAccess
//*****************************************************************************************************************
Reference< XEnumeration > SAL_CALL OTasksAccess::createEnumeration() throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );

	// Set default return value, if method failed.
	// If no desktop exist and there is no taskcontainer - return an empty enumeration!
	Reference< XEnumeration > xReturn = Reference< XEnumeration >();

	// Try to "lock" the desktop for access to taskscontainer.
	Reference< XInterface > xLock = m_xOwner.get();
	if ( xLock.is() == sal_True )
	{
		// Desktop exist => pointer to taskscontainer must be valid.
		// Initialize a new enumeration ... if some tasks exist!
		// (TasksEnumeration will make an assert, if we initialize the new instance without valid values!)

		// Create new instance in memory (user of this metod will be owner of this new object!)
		OTasksEnumeration* pEnumeration = new OTasksEnumeration( m_pTasks->getAllElements() );
		// Cast it to right reference.
		xReturn = Reference< XEnumeration >( (OWeakObject*)pEnumeration, UNO_QUERY );
	}

	// Return result of this operation.
	return xReturn;
}

//*****************************************************************************************************************
//	XElementAccess
//*****************************************************************************************************************
Type SAL_CALL OTasksAccess::getElementType() throw( RuntimeException )
{
	// Elements in list an enumeration are tasks!
	// Return the uno-type of XTask.
	return ::getCppuType((const Reference< XTask >*)NULL);
}

//*****************************************************************************************************************
//	XElementAccess
//*****************************************************************************************************************
sal_Bool SAL_CALL OTasksAccess::hasElements() throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );

	// Set default return value, if method failed.
	sal_Bool bReturn = sal_False;

	// Try to "lock" the desktop for access to taskscontainer.
	Reference< XInterface > xLock = m_xOwner.get();
	if ( xLock.is() == sal_True )
	{
		// Desktop exist => pointer to taskscontainer must be valid.
		// Ask container for existing elements.
		bReturn = m_pTasks->hasElements();
	}

	// Return result of this operation.
	return bReturn;
}

//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods checks the parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact the autor or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
sal_Bool OTasksAccess::impldbg_checkParameter_OTasksAccessCtor(	const	Reference< XDesktop >&		xOwner	,
                                                                        FrameContainer*             pTasks  )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &xOwner		==	NULL		)	||
			( xOwner.is()	==	sal_False	)	||
			( pTasks		==	NULL		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

#endif	//	#ifdef ENABLE_ASSERTIONS

}		//	namespace framework
