/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dp_services.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 17:24:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "dp_misc.h"
#include "dp_servicefactory.h"
#include "cppuhelper/implementationentry.hxx"
#include "com/sun/star/lang/XMultiServiceFactory.hpp"
#include "com/sun/star/registry/XRegistryKey.hpp"


using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using ::rtl::OUString;

namespace dp_registry {
namespace backend {

Sequence<OUString> SAL_CALL getSupportedServiceNames()
{
    OUString strName = OUSTR("com.sun.star.deployment.PackageRegistryBackend");
    return Sequence<OUString>( &strName, 1 );
}

namespace configuration {
Reference<XInterface> SAL_CALL create(
    Sequence<Any> const &, Reference<XComponentContext> const & );
OUString SAL_CALL getImplementationName();
}

namespace component {
Reference<XInterface> SAL_CALL create(
    Sequence<Any> const &, Reference<XComponentContext> const & );
OUString SAL_CALL getImplementationName();
}

namespace script {
Reference<XInterface> SAL_CALL create(
    Sequence<Any> const &, Reference<XComponentContext> const & );
OUString SAL_CALL getImplementationName();
}

namespace sfwk {
Reference<XInterface> SAL_CALL create(
    Sequence<Any> const &, Reference<XComponentContext> const & );
OUString SAL_CALL getImplementationName();
}

}
}

namespace dp_manager {
namespace factory {
Reference<XInterface> SAL_CALL create(
    Sequence<Any> const &, Reference<XComponentContext> const & );
OUString SAL_CALL getImplementationName();
Sequence<OUString> SAL_CALL getSupportedServiceNames();
bool singleton_entries( Reference<registry::XRegistryKey> const & );
}
}

namespace dp_log {
Reference<XInterface> SAL_CALL create(
    Sequence<Any> const &, Reference<XComponentContext> const & );
OUString SAL_CALL getImplementationName();
Sequence<OUString> SAL_CALL getSupportedServiceNames();
}

namespace dp_migration {
OUString SAL_CALL getImplementationName();
Sequence<OUString> SAL_CALL getSupportedServiceNames() {
    const OUString strName( ::dp_migration::getImplementationName() );
    return Sequence<OUString>( &strName, 1 );
}
Reference<XInterface> SAL_CALL create(
    Sequence<Any> const &, Reference<XComponentContext> const & );
}

static const ::cppu::ImplementationEntry s_entries [] = {
    {
        (::cppu::ComponentFactoryFunc)
        ::dp_registry::backend::configuration::create,
        ::dp_registry::backend::configuration::getImplementationName,
        ::dp_registry::backend::getSupportedServiceNames,
        ::dp_misc::createFactory,
        0, 0
    },
    {
        (::cppu::ComponentFactoryFunc)
        ::dp_registry::backend::component::create,
        ::dp_registry::backend::component::getImplementationName,
        ::dp_registry::backend::getSupportedServiceNames,
        ::dp_misc::createFactory,
        0, 0
    },
    {
        (::cppu::ComponentFactoryFunc) ::dp_registry::backend::script::create,
        ::dp_registry::backend::script::getImplementationName,
        ::dp_registry::backend::getSupportedServiceNames,
        ::dp_misc::createFactory,
        0, 0
    },
    {
        (::cppu::ComponentFactoryFunc) ::dp_registry::backend::sfwk::create,
        ::dp_registry::backend::sfwk::getImplementationName,
        ::dp_registry::backend::getSupportedServiceNames,
        ::dp_misc::createFactory,
        0, 0
    },
    {
        (::cppu::ComponentFactoryFunc) ::dp_manager::factory::create,
        ::dp_manager::factory::getImplementationName,
        ::dp_manager::factory::getSupportedServiceNames,
        ::dp_misc::createFactory,
        0, 0
    },
    {
        (::cppu::ComponentFactoryFunc) ::dp_log::create,
        ::dp_log::getImplementationName,
        ::dp_log::getSupportedServiceNames,
        ::dp_misc::createFactory,
        0, 0
    },
    {
        (::cppu::ComponentFactoryFunc) ::dp_migration::create,
        ::dp_migration::getImplementationName,
        ::dp_migration::getSupportedServiceNames,
        ::dp_misc::createFactory,
        0, 0
    },
    { 0, 0, 0, 0, 0, 0 }
};

extern "C" {

void SAL_CALL component_getImplementationEnvironment(
    const sal_Char ** ppEnvTypeName, uno_Environment ** ppEnv )
{
    *ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

sal_Bool SAL_CALL component_writeInfo(
    lang::XMultiServiceFactory * pServiceManager,
    registry::XRegistryKey * pRegistryKey )
{
    return ::cppu::component_writeInfoHelper(
        pServiceManager, pRegistryKey, s_entries ) &&
        ::dp_manager::factory::singleton_entries( pRegistryKey );
}

void * SAL_CALL component_getFactory(
    sal_Char const * pImplName,
    lang::XMultiServiceFactory * pServiceManager,
    registry::XRegistryKey * pRegistryKey )
{
    return ::cppu::component_getFactoryHelper(
        pImplName, pServiceManager, pRegistryKey, s_entries );
}

} // extern "C"

