/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: TableDescWin.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 16:40:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef DBAUI_TABLEDESCRIPTIONWINDOW_HXX
#define DBAUI_TABLEDESCRIPTIONWINDOW_HXX

#ifndef _SV_TABPAGE_HXX 
#include <vcl/tabpage.hxx>
#endif

class FixedText;
class MultiLineEdit;
class CheckBox;

namespace dbaui
{
	//==================================================================
	class OTableDescWin : public TabPage
	{
	private:
		FixedText*				m_pHeader;
		MultiLineEdit*			m_pTextWin;
		FixedText*				m_pFTTableDesc;
		BOOL					m_bModified;
		BOOL					m_bRowVersionAvailable;

		DECL_LINK(OnModified, void*);
	protected:
		virtual void Resize();
		virtual void Paint( const Rectangle& rRect );

	public:
		OTableDescWin( Window* pParent);
		virtual ~OTableDescWin();

		void	SetReadOnly( BOOL bReadOnly );
		//	void	SetEditorCtrl( SbaTableEditorCtrl* pCtrl ){  m_pEditorCtrl = pCtrl; }

		BOOL	IsModified() const { return m_bModified; }
		String	GetTableDesc() const;

		virtual void Init();

		virtual void GetFocus();
	};
}
#endif // DBAUI_TABLEDESCRIPTIONWINDOW_HXX

