/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: EnhancedCustomShape3d.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 13:13:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _ENHANCEDCUSTOMSHAPE3D_HXX
#define _ENHANCEDCUSTOMSHAPE3D_HXX

#ifndef _MSDFFIMP_HXX
#include <msdffimp.hxx>
#endif
#include <vector>
//#include <poly3d.hxx>
//#include <goodies/point3d.hxx>
#ifndef _COM_SUN_STAR_DRAWING_PROJECTIONMODE_HPP_
#include <com/sun/star/drawing/ProjectionMode.hpp>
#endif

#ifndef _BGFX_POINT_B3DPOINT_HXX
#include <basegfx/point/b3dpoint.hxx>
#endif

#ifndef _BGFX_POLYGON_B3DPOLYGON_HXX
#include <basegfx/polygon/b3dpolygon.hxx>
#endif

class EnhancedCustomShape3d
{
	class Transformation2D
	{
		Point									aCenter;
		com::sun::star::drawing::ProjectionMode eProjectionMode;

		// parallel projection
		double		fSkewAngle;
		double		fSkew;			// in percent

		// perspective projection
		double		fZScreen;
		basegfx::B3DPoint		fViewPoint;
		double		fOriginX;
		double		fOriginY;

		const double* pMap;

		public :

						Transformation2D( const SdrObject* pCustomShape, const Rectangle& rBoundRect, const double* pMap );

			basegfx::B3DPolygon ApplySkewSettings( const basegfx::B3DPolygon& rPolygon3D ) const;
			Point		Transform2D( const basegfx::B3DPoint& rPoint ) const;
			sal_Bool	IsParallel() const;
	};

	friend class Transformation2D;

	protected :

//		static void Rotate( Vector3D& rPoint, const double x, const double y, const double z );
//		static void Rotate( basegfx::B3DPolyPolygon&, const Point3D& rRotateCenter, const double x, const double y, const double z );
		static Rectangle CalculateNewSnapRect( const SdrObject* pCustomShape, const Rectangle& rBoundRect, const double* pMap );

	public :

		static SdrObject* Create3DObject( const SdrObject* pShape2d, const SdrObject* pCustomShape );
};

#endif

