/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: overlaymanager.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 13:07:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SDR_OVERLAY_OVERLAYMANAGER_HXX
#define _SDR_OVERLAY_OVERLAYMANAGER_HXX

#ifndef _SDR_ANIMATION_SCHEDULER_HXX
#include <svx/sdr/animation/scheduler.hxx>
#endif

#ifndef _SV_MAPMOD_HXX
#include <vcl/mapmod.hxx>
#endif

#ifndef _TOOLS_COLOR_HXX
#include <tools/color.hxx>
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

//////////////////////////////////////////////////////////////////////////////
// predeclarations

class OutputDevice;
class Region;

namespace sdr
{
	namespace overlay
	{
		class OverlayObject;
	} // end of namespace overlay
} // end of namespace sdr

namespace basegfx
{
	class B2DRange;
} // end of namespace basegfx

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace overlay
	{
		class SVX_DLLPUBLIC OverlayManager : public ::sdr::animation::Scheduler
		{
		protected:
			// the OutputDevice to work on, set on construction and not to be changed
			OutputDevice&							rmOutputDevice;

			// start, end and number of the double linked list of OverlayObjects
			// managed by this manager
			OverlayObject*							mpOverlayObjectStart;
			OverlayObject*							mpOverlayObjectEnd;

			// MapMode for MapMode change watching
			MapMode									maMapMode;

			// Stripe support. All striped OverlayObjects use these stripe
			// values. Changes change all those objects.
			Color									maStripeColorA; // defaults to Color(COL_BLACK)
			Color									maStripeColorB; // defaults to Color(COL_WHITE)
			sal_uInt32								mnStripeLengthPixel; // defaults to 4L

			// internal
			void ImpDrawMembers(const basegfx::B2DRange& rRange, OutputDevice& rDestinationDevice) const;
			void ImpCheckMapModeChange() const;
			void ImpStripeDefinitionChanged();

		public:
			OverlayManager(OutputDevice& rOutputDevice);
			virtual ~OverlayManager();

			// complete redraw
			virtual void completeRedraw(const Region& rRegion, OutputDevice* pPreRenderDevice = 0L) const;

			// flush. Do buffered updates.
			virtual void flush();

			// restore part of background. Implemented form buffered versions only.
			virtual void restoreBackground(const Region& rRegion) const;

			// get the OutputDevice
			OutputDevice& getOutputDevice() const { return rmOutputDevice; }

			// add and remove OverlayObjects
			void add(OverlayObject& rOverlayObject);
			void remove(OverlayObject& rOverlayObject);

			// invalidate the given range at local OutputDevice
			virtual void invalidateRange(const basegfx::B2DRange& rRange);

			// stripe support ColA
			Color getStripeColorA() const { return maStripeColorA; }
			void setStripeColorA(Color aNew= Color(COL_BLACK));

			// stripe support ColB
			Color getStripeColorB() const { return maStripeColorB; }
			void setStripeColorB(Color aNew = Color(COL_WHITE));

			// stripe support StripeLengthPixel
			sal_uInt32 getStripeLengthPixel() const { return mnStripeLengthPixel; }
			void setStripeLengthPixel(sal_uInt32 nNew = 5L);
		};
	} // end of namespace overlay
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_OVERLAY_OVERLAYMANAGER_HXX

// eof
