/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: aeitem.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 14:58:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svtools.hxx"
#ifndef GCC
#endif

#include <tools/string.hxx>

#define _SVSTDARR_USHORTS
#include <svstdarr.hxx>
#include <svarray.hxx>
#include "aeitem.hxx"

// STATIC DATA -----------------------------------------------------------

DBG_NAME(SfxAllEnumItem)

TYPEINIT1_AUTOFACTORY(SfxAllEnumItem, SfxEnumItem)

// -----------------------------------------------------------------------

struct SfxAllEnumValue_Impl
{
	USHORT nValue;
	XubString aText;
};

SV_DECL_PTRARR_DEL(SfxAllEnumValueArr, SfxAllEnumValue_Impl*, 0, 8)
SV_IMPL_PTRARR(SfxAllEnumValueArr, SfxAllEnumValue_Impl*)

// -----------------------------------------------------------------------

SfxAllEnumItem::SfxAllEnumItem() :
    SfxEnumItem(),
    pValues( 0 ),
    pDisabledValues( 0 )
{
}

SfxAllEnumItem::SfxAllEnumItem( USHORT which, USHORT nVal, const XubString &rText ):
	SfxEnumItem(which, nVal),
	pValues( 0 ),
	pDisabledValues( 0 )
{
	DBG_CTOR(SfxAllEnumItem, 0);
	InsertValue( nVal, rText );
}

// -----------------------------------------------------------------------

SfxAllEnumItem::SfxAllEnumItem(USHORT which, USHORT nVal):
	SfxEnumItem(which, nVal),
	pValues( 0 ),
	pDisabledValues( 0 )
{
	DBG_CTOR(SfxAllEnumItem, 0);
	InsertValue( nVal );
}

// -----------------------------------------------------------------------

SfxAllEnumItem::SfxAllEnumItem( USHORT which, SvStream &rStream ):
	SfxEnumItem(which, rStream),
	pValues( 0 ),
	pDisabledValues( 0 )
{
	DBG_CTOR(SfxAllEnumItem, 0);
	InsertValue( GetValue() );
}

// -----------------------------------------------------------------------


SfxAllEnumItem::SfxAllEnumItem(USHORT which):
	SfxEnumItem(which, 0),
	pValues( 0 ),
	pDisabledValues( 0 )
{
	DBG_CTOR(SfxAllEnumItem, 0);
}


// -----------------------------------------------------------------------

SfxAllEnumItem::SfxAllEnumItem(const SfxAllEnumItem &rCopy):
	SfxEnumItem(rCopy),
	pValues(0),
	pDisabledValues( 0 )
{
	DBG_CTOR(SfxAllEnumItem, 0);
	if ( !rCopy.pValues )
		return;

	pValues = new SfxAllEnumValueArr;

	for ( USHORT nPos = 0; nPos < rCopy.pValues->Count(); ++nPos )
	{
		SfxAllEnumValue_Impl *pVal = new SfxAllEnumValue_Impl;
		pVal->nValue = rCopy.pValues->GetObject(nPos)->nValue;
		pVal->aText = rCopy.pValues->GetObject(nPos)->aText;
		const SfxAllEnumValue_Impl *pTemp = pVal;
		pValues->Insert( pTemp, nPos );
	}

	if( rCopy.pDisabledValues )
	{
		pDisabledValues = new SvUShorts;
		for ( USHORT nPos = 0; nPos < rCopy.pDisabledValues->Count(); ++nPos )
		{
			pDisabledValues->Insert( rCopy.pDisabledValues->GetObject(nPos),
									 nPos );
		}
	}
}

// -----------------------------------------------------------------------

SfxAllEnumItem::~SfxAllEnumItem()
{
	DBG_DTOR(SfxAllEnumItem, 0);
	delete pValues;
	delete pDisabledValues;
}

// -----------------------------------------------------------------------

USHORT SfxAllEnumItem::GetValueCount() const
{
	DBG_CHKTHIS(SfxAllEnumItem, 0);
	return pValues ? pValues->Count() : 0;
}

// -----------------------------------------------------------------------

XubString SfxAllEnumItem::GetValueTextByPos( USHORT nPos ) const
{
	DBG_CHKTHIS(SfxAllEnumItem, 0);
	DBG_ASSERT( pValues && nPos < pValues->Count(), "enum overflow" );
	return pValues->GetObject(nPos)->aText;
}

// -----------------------------------------------------------------------

USHORT SfxAllEnumItem::GetValueByPos( USHORT nPos ) const
{
	DBG_CHKTHIS(SfxAllEnumItem, 0);
	DBG_ASSERT( pValues && nPos < pValues->Count(), "enum overflow" );
	return pValues->GetObject(nPos)->nValue;
}

// -----------------------------------------------------------------------

SfxPoolItem* SfxAllEnumItem::Clone( SfxItemPool * ) const
{
	DBG_CHKTHIS(SfxAllEnumItem, 0);
	return new SfxAllEnumItem(*this);
}

// -----------------------------------------------------------------------

SfxPoolItem* SfxAllEnumItem::Create( SvStream & rStream, USHORT ) const
{
	DBG_CHKTHIS(SfxAllEnumItem, 0);
	return new SfxAllEnumItem( Which(), rStream );
}


// -----------------------------------------------------------------------

USHORT SfxAllEnumItem::_GetPosByValue( USHORT nVal ) const

/*	[Beschreibung]

	Im Ggs. zu <SfxEnumItemInterface::GetPosByValue(USHORT)const> liefert
	diese interne Methode bei nicht vorhandenen Values die Position,
	an der der Wert liegen w"urde.
*/

{
	DBG_CHKTHIS(SfxAllEnumItem, 0);

	if ( !pValues )
		return 0;

	//!O: binaere Suche oder SortArray verwenden
	USHORT nPos;
	for ( nPos = 0; nPos < pValues->Count(); ++nPos )
		if ( pValues->GetObject(nPos)->nValue >= nVal )
			return nPos;
	return nPos;
}

// -----------------------------------------------------------------------

USHORT SfxAllEnumItem::GetPosByValue( USHORT nValue ) const

/*  [Beschreibung]

	Liefert im Gegensatz zu <SfxEnumItemInterface::GetPosByValue(USHORT)const>
	immer nValue zur"uck, solange nicht mindestens ein Wert mit einer der
	Methoden <SfxAllEnumItem::InsertValue()> eingef"ugt wurde.
*/

{
	DBG_CHKTHIS(SfxAllEnumItem, 0);

	if ( !pValues || !pValues->Count() )
		return nValue;

	return SfxEnumItem::GetPosByValue( nValue );
}

// -----------------------------------------------------------------------

void SfxAllEnumItem::InsertValue( USHORT nValue, const XubString &rValue )
{
	DBG_CHKTHIS(SfxAllEnumItem, 0);
	SfxAllEnumValue_Impl *pVal = new SfxAllEnumValue_Impl;
	pVal->nValue = nValue;
	pVal->aText = rValue;
	const SfxAllEnumValue_Impl *pTemp = pVal;
	if ( !pValues )
		pValues = new SfxAllEnumValueArr;
	else if ( GetPosByValue( nValue ) != USHRT_MAX )
		// remove when exists
		RemoveValue( nValue );
	// then insert
	pValues->Insert( pTemp, _GetPosByValue(nValue) ); //! doppelte?!
}

// -----------------------------------------------------------------------

void SfxAllEnumItem::InsertValue( USHORT nValue )
{
	DBG_CHKTHIS(SfxAllEnumItem, 0);
	SfxAllEnumValue_Impl *pVal = new SfxAllEnumValue_Impl;
	pVal->nValue = nValue;
	pVal->aText = XubString::CreateFromInt32( nValue );
	const SfxAllEnumValue_Impl *pTemp = pVal;
	if ( !pValues )
		pValues = new SfxAllEnumValueArr;

	pValues->Insert( pTemp, _GetPosByValue(nValue) ); //! doppelte?!
}

void SfxAllEnumItem::DisableValue( USHORT nValue )
{
	DBG_CHKTHIS(SfxAllEnumItem, 0);
	if ( !pDisabledValues )
		pDisabledValues = new SvUShorts;

	pDisabledValues->Insert( nValue, pDisabledValues->Count() );
}

BOOL SfxAllEnumItem::IsEnabled( USHORT nValue ) const
{
	if ( pDisabledValues )
	{
		for ( USHORT i=0; i<pDisabledValues->Count(); i++ )
			if ( (*pDisabledValues)[i] == nValue )
				return FALSE;
	}

	return TRUE;
}

// -----------------------------------------------------------------------

void SfxAllEnumItem::RemoveValue( USHORT nValue )
{
	DBG_CHKTHIS(SfxAllEnumItem, 0);
	USHORT nPos = GetPosByValue(nValue);
	DBG_ASSERT( nPos != USHRT_MAX, "removing value not in enum" );
	pValues->Remove( nPos );
}

// -----------------------------------------------------------------------


void SfxAllEnumItem::RemoveAllValues()
{
	DBG_CHKTHIS(SfxAllEnumItem, 0);
	if ( pValues )
		pValues->DeleteAndDestroy( 0, pValues->Count() );
}



