/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: drawdoc_animations.cxx,v $
 *
 *  $Revision: 1.4.94.1 $
 *
 *  last change: $Author: rt $ $Date: 2007/01/19 16:22:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"

#include "drawdoc.hxx"
#include "cusshow.hxx"

/** replaces a slide from all custom shows with a new one or removes a slide from
	all custom shows if pNewPage is 0.
*/
void SdDrawDocument::ReplacePageInCustomShows( const SdPage* pOldPage, const SdPage* pNewPage )
{
	if ( mpCustomShowList )
	{
		for (ULONG i = 0; i < mpCustomShowList->Count(); i++)
		{
			SdCustomShow* pCustomShow = (SdCustomShow*) mpCustomShowList->GetObject(i);
			if( pNewPage == 0 )
				pCustomShow->RemovePage(pOldPage);
			else
				pCustomShow->ReplacePage(pOldPage,pNewPage);
		}
	}
}

