/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fuarea.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:09:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"



#include <svx/svxids.hrc>

#ifndef _SVX_TAB_AREA_HXX //autogen
<svx/tabarea.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif

#include "viewshel.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "fuarea.hxx"

#include <svx/svxdlg.hxx> //CHINA001
#include <svx/dialogs.hrc> //CHINA001
/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuArea::SchFuArea(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
					 ChartModel* pDoc, SfxRequest& rReq)
	: SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	BOOL bHasMarked = pView->AreObjectsMarked();

	const SfxItemSet* pArgs = rReq.GetArgs();
	SfxBindings& rBind = pViewSh->GetViewFrame()->GetBindings();

	if (!pArgs)
	{
		SfxItemSet* pNewAttr = new SfxItemSet(bHasMarked
												  ? pView->GetAttrFromMarked()
												  : pView->GetDefaultAttr());

		//CHINA001 SvxAreaTabDialog* pDlg = new SvxAreaTabDialog(&(pViewSh->GetViewFrame()->GetWindow()),
		//CHINA001 													  pNewAttr,	pDoc);
		SvxAbstractDialogFactory* pFact = SvxAbstractDialogFactory::Create();
		DBG_ASSERT(pFact, "Dialogdiet Factory fail!");//CHINA001
		AbstractSvxAreaTabDialog * pDlg = pFact->CreateSvxAreaTabDialog( &(pViewSh->GetViewFrame()->GetWindow()),
										pNewAttr, 
										pDoc,
										ResId(RID_SVXDLG_AREA),
										pView);
		DBG_ASSERT(pDlg, "Dialogdiet fail!");//CHINA001
		if (pDlg->Execute() == RET_OK)
		{
			rReq.Done(*(pDlg->GetOutputItemSet()));
			pArgs = rReq.GetArgs();
			delete pDlg;
			delete pNewAttr;
		}
		else
		{
			delete pDlg;
			delete pNewAttr;

			// update object bars because attributes may have changed
			rBind.Invalidate(SID_ATTR_FILL_STYLE);
			rBind.Invalidate(SID_ATTR_FILL_COLOR);
			rBind.Invalidate(SID_ATTR_FILL_GRADIENT);
			rBind.Invalidate(SID_ATTR_FILL_HATCH);
			rBind.Invalidate(SID_ATTR_FILL_BITMAP);
			return; // early RETURN
		}
	}

	if (bHasMarked)	pView->SetAttrToMarked(*pArgs);
	else pView->SetDefaultAttr(*pArgs);

	// update object bars nad list boxes because attributes may have changed
	rBind.Invalidate(SID_ATTR_FILL_STYLE);
	rBind.Invalidate(SID_ATTR_FILL_COLOR);
	rBind.Invalidate(SID_ATTR_FILL_GRADIENT);
	rBind.Invalidate(SID_ATTR_FILL_HATCH);
	rBind.Invalidate(SID_ATTR_FILL_BITMAP);
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchFuArea::~SchFuArea()
{
}



