/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: docshell.cxx,v $
 *
 *  $Revision: 1.68 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:08:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

#define ITEMID_FONTLIST 		SID_ATTR_CHAR_FONTLIST
#define ITEMID_NUMBERINFO		SID_ATTR_NUMBERFORMAT_INFO
#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_GRADIENT_LIST	SID_GRADIENT_LIST
#define ITEMID_HATCH_LIST		SID_HATCH_LIST
#define ITEMID_BITMAP_LIST		SID_BITMAP_LIST
#define ITEMID_DASH_LIST		SID_DASH_LIST
#define ITEMID_LINEEND_LIST 	SID_LINEEND_LIST

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#include <svx/svxids.hrc>
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#include <sot/clsids.hxx>
#ifndef _SFX_PRINTER_HXX //autogen
#include <sfx2/printer.hxx>
#endif
#ifndef _UNDO_HXX
#include <svtools/undo.hxx>
#endif
#ifndef _CTRLTOOL_HXX
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SFXMNUMGR_HXX
#include <sfx2/mnumgr.hxx>
#endif
#ifndef _SFX_PROGRESS_HXX
#include <sfx2/progress.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SFXECODE_HXX //autogen
#include <svtools/sfxecode.hxx>
#endif
#ifndef _SVX_DRAWITEM_HXX //autogen
#include <svx/drawitem.hxx>
#endif
#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif
#ifndef _SCH_DLL_HXX //autogen
#include <schdll.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_SAVEOPT_HXX
#include <svtools/saveopt.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#include <sfx2/msg.hxx>
#include <sfx2/objface.hxx>
#include <sot/formats.hxx>
#include <svx/flstitem.hxx>
#include <svx/svxids.hrc>
#include <sfx2/fcontnr.hxx>
#include <sfx2/app.hxx>

#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "schresid.hxx"
#include "schview.hxx"
#include "docshell.hxx"
#include "schmod.hxx"

#include "ChXChartDocument.hxx"
#include "ChXChartData.hxx"
#include "SchTransferable.hxx"

// header for class SfxFilter
#ifndef _SFX_DOCFILT_HACK_HXX
#include <sfx2/docfilt.hxx>
#endif

#ifndef	_RTL_LOGFILE_HXX_
#include <rtl/logfile.hxx>
#endif

// XML filter
#include "SchXMLWrapper.hxx"

#ifndef _SCH_MEMCHRT_HXX
#include "memchrt.hxx"
#endif

#define POOL_BUFFER_SIZE		(USHORT)32768
#define BASIC_BUFFER_SIZE		(USHORT)8192
#define DOCUMENT_BUFFER_SIZE	(USHORT)32768

#define SCH_STYLE_SHEET_NAME	String( RTL_CONSTASCII_USTRINGPARAM( "SfxStyleSheets" ))

#define SCH_DEFAULT_CHART_SIZE_WIDTH  8000
#define SCH_DEFAULT_CHART_SIZE_HEIGHT 7000

using namespace com::sun::star::uno;


// STATIC DATA -----------------------------------------------------------

static const String __FAR_DATA aStarChartDoc = String( RTL_CONSTASCII_USTRINGPARAM( "StarChartDocument" ));

//----------------------------------------------------------------------

/*************************************************************************
|*
|* SFX-Slotmaps und -Definitionen
|*
\************************************************************************/

#define SchChartDocShell
#include "schslots.hxx"


namespace
{

/** This class sets EnableSetModified( TRUE ) in the CTOR, and
    EnableSetModified( FALSE ) in the DTOR.  Thus, this can be used to safeld do
    changes at the model without resulting in a modification.
 */
class lcl_NoModificationGuard
{
public:
    lcl_NoModificationGuard( SfxObjectShell * pPersist ) :
            m_pPersist( pPersist ),
            m_bModifyingWasEnabled( pPersist ? pPersist->IsEnableSetModified() : FALSE )
    {
        if( m_bModifyingWasEnabled &&
            m_pPersist )
            m_pPersist->EnableSetModified( FALSE );
    }

    ~lcl_NoModificationGuard()
    {
        if( m_bModifyingWasEnabled &&
            m_pPersist )
            m_pPersist->EnableSetModified( TRUE );
    }

private:
    SfxObjectShell * m_pPersist;
    BOOL        m_bModifyingWasEnabled;
};
}

SFX_IMPL_INTERFACE( SchChartDocShell, SfxObjectShell, SchResId( 0 ) )
// from macro: void SchChartDocShell::InitInterface_Impl()
{}

using namespace com::sun::star;

SFX_IMPL_OBJECTFACTORY( SchChartDocShell, SvGlobalName(SO3_SCH_CLASSID), SFXOBJECTSHELL_STD_NORMAL, "schart"  )

TYPEINIT1(SchChartDocShell, SfxObjectShell);

/*************************************************************************
|*
|* shared construction - used by internal CTOR and InitNew
|*
\************************************************************************/

void SchChartDocShell::Construct() throw()
{
	DBG_ASSERT( pChDoc, "SchChartDocShell::Construct() called with no valid model!" );
	//Wird fuer die ModelCollection benoetigt
	SetPool(&pChDoc->GetItemPool());
    if( pUndoManager )
        delete pUndoManager;
    pUndoManager = new SfxUndoManager;

	// Listen, bzw. Tables im ItemSet der DocShell anlegen
	UpdateTablePointers();

	if (pChDoc->GetPageCount() == 0L)
	{
		// Seite einfuegen
		SdrPage* pPage = pChDoc->AllocPage(FALSE);
		pPage->SetSize(GetVisArea(ASPECT_CONTENT).GetSize());
		pChDoc->InsertPage(pPage);
        // #i49463# set a default size
        SetVisArea(Rectangle(Point(0, 0), Size( SCH_DEFAULT_CHART_SIZE_WIDTH, SCH_DEFAULT_CHART_SIZE_HEIGHT )));
	}
}

void SchChartDocShell::DataModified( chart::ChartDataChangeEvent& aEvent ) throw()
{
	uno::Reference< chart::XChartDocument > xChartDoc( GetModel(), uno::UNO_QUERY );
	if( xChartDoc.is() )
	{
		uno::Reference< chart::XChartData > xData = xChartDoc->getData();
		if( xData.is() )
		{
			ChXChartData* pChXData = ChXChartData::getImplementation( xData );
			if( pChXData )
			{
				pChXData->DataModified( aEvent );
			}
		}
	}
}


/*************************************************************************
|*
|* Default CTOR - this one is called by the factory from SFX
|*
\************************************************************************/

SchChartDocShell::SchChartDocShell(SfxObjectCreateMode eMode) throw() :
	SfxObjectShell(eMode),
	pUndoManager(NULL),
	pPrinter(NULL),
	pFontList(NULL),
	pChDoc(NULL),
	bInitNewNoNewDoc(FALSE),
	bOwnPrinter(FALSE),
	mbClipboardExport( FALSE )
{
	CHART_TRACE( "SchChartDocShell::SchChartDocShell(SfxObjectCreateMode)" );
	SetModel( new ChXChartDocument( this ));
}

/*************************************************************************
|*
|* CTOR used by dragserver
|*
\************************************************************************/

SchChartDocShell::SchChartDocShell(ChartModel* pDoc,
								   SfxObjectCreateMode eMode) throw() :
	SfxObjectShell(eMode),
	pUndoManager(NULL),
	pPrinter(NULL),
	pFontList(NULL),
	pChDoc(pDoc),
	bInitNewNoNewDoc(TRUE),
	bOwnPrinter(FALSE),
	mbClipboardExport( FALSE )
{
	CHART_TRACE1( "SchChartDocShell::SchChartDocShell(pDoc,eMode) pDoc=%lx", (long)pDoc );
	SetModel( new ChXChartDocument( this ));
	Construct();
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchChartDocShell::~SchChartDocShell() throw()
{
	CHART_TRACE( "SchChartDocShell::~SchChartDocShell" );

	delete pFontList;

	delete pUndoManager;

	if( pChDoc )
	{
		pChDoc->ClearUndoBuffer();				// clear draw undo actions
		pChDoc->SetMaxUndoActionCount( 1 );		// don't add further undo actions
	}

	if(bOwnPrinter)
		delete pPrinter;

	delete pChDoc;
}

/*************************************************************************
|*
|* SFX-Requests bearbeiten
|*
\************************************************************************/

void SchChartDocShell::Execute(SfxRequest& rReq) throw()
{
	switch (rReq.GetSlot())
	{
		case SID_CLOSEDOC:
			SfxObjectShell::DoClose();
			break;

		case SID_UPDATE:
			pChDoc->InitDataAttrs();
			pChDoc->BuildChart(FALSE);
			break;
	}
}

/*************************************************************************
|*
|* Slot-Stati setzen
|*
\************************************************************************/

void SchChartDocShell::GetState(SfxItemSet &rSet) throw()
{
	SfxWhichIter aIter(rSet);
	USHORT nWhich = aIter.FirstWhich();

	while (nWhich)
	{
		USHORT nSlotId = SfxItemPool::IsWhich(nWhich) ?
						 GetPool().GetSlotId(nWhich) : nWhich;

		switch (nSlotId)
		{
/*            case SID_DOC_MODIFIED:
				rSet.Put( SfxStringItem( SID_DOC_MODIFIED,
										 IsModified() ? '*' : ' ' ) );
				//rSet.Put(SfxBoolItem(SID_DOC_MODIFIED, IsModified()));
				break;
*/
			case SID_DOCTEMPLATE :
				rSet.DisableItem (SID_DOCTEMPLATE);
				break;
		}

		nWhich = aIter.NextWhich();
	}
}

/*************************************************************************
|*
|* SFX-Aktivierung
|*
\************************************************************************/

void SchChartDocShell::Activate() throw()
{
}

/*************************************************************************
|*
|* SFX-Deaktivierung
|*
\************************************************************************/

void SchChartDocShell::Deactivate() throw()
{
}

/*************************************************************************
|*
|* SFX-Undomanager zurueckgeben
|*
\************************************************************************/

SfxUndoManager* SchChartDocShell::GetUndoManager() throw()
{
	return pUndoManager;
}

/*************************************************************************
|*
|* SfxPrinter ggf. erzeugen und zurueckgeben
|*
\************************************************************************/
SfxPrinter* SchChartDocShell::GetPrinter() throw()
{
	if (!pPrinter)
	{
		SfxBoolItem aItem(SID_PRINTER_NOTFOUND_WARN, TRUE);
		// ItemSet mit speziellem Poolbereich anlegen
		SfxItemSet* pSet = new SfxItemSet(GetPool(),
										  SID_PRINTER_NOTFOUND_WARN,
										  SID_PRINTER_NOTFOUND_WARN, 0);
		pSet->Put(aItem);
		pPrinter = new SfxPrinter(pSet);
		bOwnPrinter = TRUE;

		MapMode aMapMode = pPrinter->GetMapMode();
		aMapMode.SetMapUnit(MAP_100TH_MM);
		pPrinter->SetMapMode(aMapMode);

		if (pChDoc)
		{
			if (pPrinter != pChDoc->GetRefDevice())
				pChDoc->SetRefDevice(pPrinter);

			if (pPrinter != pChDoc->GetOutliner()->GetRefDevice())
				pChDoc->GetOutliner()->SetRefDevice(pPrinter);
		}
	}

	return pPrinter;
}


/*************************************************************************
|*
|* neuen SfxPrinter setzen
|*
\************************************************************************/
void SchChartDocShell::SetPrinter( SfxPrinter* pNewPrinter, BOOL bIsDeletedHere ) throw()
{
    bool bFirstTimeSettingPrinter = ( pPrinter == NULL );

    // Printer may only be used, if the MapUnit is correct
	if( pNewPrinter &&
        pNewPrinter->GetMapMode().GetMapUnit() == MAP_100TH_MM )
	{
		if (pPrinter && bOwnPrinter && (pPrinter != pNewPrinter))
		{
			delete pPrinter;
			bOwnPrinter = FALSE;
		}

		bOwnPrinter = bIsDeletedHere;

		pPrinter = pNewPrinter;
		if(pFontList)delete pFontList;
		OutputDevice* pOut = Application::GetDefaultDevice();	// #67730#
		pFontList = new FontList( pPrinter, pOut, FALSE );
		PutItem(SvxFontListItem(pFontList));
    }
	else
		if( bIsDeletedHere )
			delete pNewPrinter;

    OutputDevice * pRefDev = GetRefDevice();
    if( pChDoc &&
        pRefDev &&
        pRefDev->GetMapMode().GetMapUnit() == MAP_100TH_MM )
    {
        // set ref device at document at its outliner as well
        OutputDevice * pRefDev = GetRefDevice();
        if( pRefDev && pRefDev->GetMapMode().GetMapUnit() == MAP_100TH_MM )
        {
            pChDoc->SetRefDevice( pRefDev );
            pChDoc->GetOutliner()->SetRefDevice( pRefDev );

            // re-render chart with new ref-device

            // call EnableSetModified( FALSE ) temporarily and safely
            lcl_NoModificationGuard aNoModGuard( this );

            if( ! bFirstTimeSettingPrinter &&
                pChDoc->IsInitialized() )
            {
                pChDoc->BuildChart( FALSE );
            }
        }
    }
}

/*************************************************************************
|*
|*
|*
\************************************************************************/
Printer* SchChartDocShell::GetDocumentPrinter() throw()
{
	return GetPrinter();
}

/*************************************************************************
|*
|*
|*
\************************************************************************/
void SchChartDocShell::OnDocumentPrinterChanged(Printer* pNewPrinter) throw()
{
    // we have no rtti, thus assert that we have an SfxPrinter
    SetPrinter( reinterpret_cast< SfxPrinter * >( pNewPrinter ) );
}

OutputDevice * SchChartDocShell::GetRefDevice()
{
    if ( IsInPlaceActive() ||
         SFX_CREATE_MODE_EMBEDDED == GetCreateMode() )
    {
        OutputDevice* pOutDev = GetDocumentRefDev();
        if ( pOutDev )
            return pOutDev;
    }

    return GetPrinter();
}

/*************************************************************************
|*
|* InitNew, (Dokument wird neu erzeugt): Streams oeffnen
|*
\************************************************************************/

BOOL SchChartDocShell::InitNew( const uno::Reference < embed::XStorage >& pStor ) throw()
{
	CHART_TRACE1( "SchChartDocShell::InitNew pModel=%lx", (long)pChDoc );

    if( SfxObjectShell::InitNew( pStor ))
	{
		if(!pChDoc)
		{
			pChDoc = new ChartModel( SvtPathOptions().GetPalettePath(), this );
			// set new model at ChXChartDocument
			ChXChartDocument* pImpl = ChXChartDocument::getImplementation( GetModel() );
			if( pImpl )
				pImpl->SetChartModel( pChDoc );
			Construct();
		}
		if( pChDoc )
		{
			if(bInitNewNoNewDoc)
				pChDoc->NewOrLoadCompleted(DOC_LOADED);
			else
				pChDoc->NewOrLoadCompleted(NEW_DOC);
		}

		SetVisArea(Rectangle(Point(0, 0), Size( SCH_DEFAULT_CHART_SIZE_WIDTH, SCH_DEFAULT_CHART_SIZE_HEIGHT )));

		return TRUE;
	}

	return FALSE;
}

/*************************************************************************
|*
|* Load: Pools und Dokument laden
|*
\************************************************************************/

BOOL SchChartDocShell::Load(SfxMedium& rMedium) throw()
{
	RTL_LOGFILE_CONTEXT_AUTHOR (context, "sch", "af119097", "::SchChartDocShell::Load");

	CHART_TRACE( "SchChartDocShell::Load" );

	BOOL bRet = FALSE;

	pChDoc = new ChartModel( SvtPathOptions().GetPalettePath(), this );
	SetPool( &pChDoc->GetItemPool());
	ChXChartDocument* pImpl = ChXChartDocument::getImplementation( GetModel() );
	if( pImpl )
		pImpl->SetChartModel( pChDoc );

	{
		RTL_LOGFILE_CONTEXT_TRACE (context, "XML format");
        bRet = SfxObjectShell::Load( rMedium );

		// create a new draw page etc.
		Construct();
		// The XML Filter expects a completely
		// initialized document. This is achieved by the
		// following statement
		pChDoc->NewOrLoadCompleted( NEW_DOC );

		if( bRet )
		{
			SetWaitCursor( TRUE );

			{
                Reference<com::sun::star::frame::XModel> xModel(GetModel());
                SchXMLWrapper aFilter( xModel, rMedium, TRUE );
                sal_Int32 nWarning = aFilter.Import();
                if( nWarning )
                    SetError( nWarning );

                // ok if there was no waring
				bRet = (nWarning == 0);

                // reset number format ids last set by calc
                pChDoc->ResetLastAxisNumFmt( -2 );

				if( bRet )
				{
					// during import the page size is set
					// the vis area has to be set to the whole page size
                    Size aPageSize = pChDoc->GetPage( 0 )->GetSize();
                    if( aPageSize.Width() <= 0 ||
                        aPageSize.Height() <= 0 )
                    {
                        // invalid page size
                        // assume that page size is uninitialized
                        DBG_ASSERT( aPageSize.Height() == 0 &&
                                    aPageSize.Width() == 0,
                                    "Invalid Page Size" );
                        aPageSize.setWidth( SCH_DEFAULT_CHART_SIZE_WIDTH );
                        aPageSize.setHeight( SCH_DEFAULT_CHART_SIZE_HEIGHT );
                    }

					Rectangle aVisRect( Point( 0, 0 ), aPageSize );
					SetVisArea( aVisRect );

					pChDoc->SetChanged( FALSE );
					pChDoc->NewOrLoadCompleted( DOC_LOADED );
					SetModified( FALSE );

					FinishedLoading(SFX_LOADED_ALL);
				}
			}

			SetWaitCursor( FALSE );
		}
		else
			DBG_ERROR( "Load (XML): SfxInPlaceObject::Load failed!" );
	}

	return bRet;
}

// ------------------------------------------------------------

BOOL SchChartDocShell::Save() throw()
{
	RTL_LOGFILE_CONTEXT_AUTHOR (context, "sch", "af119097", "::SchChartDocShell::Save");


		RTL_LOGFILE_CONTEXT_TRACE (context, "XML format");
        BOOL bRet = SfxObjectShell::Save();

		/**********************************************************************
		 * StarOffice XML-Filter Export
		 **********************************************************************/
		{
            Reference<com::sun::star::frame::XModel> xModel(GetModel());
            SchXMLWrapper aFilter( xModel, *GetMedium(),
								   GetCreateMode() != SFX_CREATE_MODE_EMBEDDED );

			// update user info before writing
			UpdateDocInfoForSave();

			bRet = aFilter.Export();
		}

	return bRet;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

BOOL SchChartDocShell::SaveAs( SfxMedium& rMedium) throw()
{
	RTL_LOGFILE_CONTEXT_AUTHOR (context, "sch", "af119097", "::SchChartDocShell::SaveAs");

	CHART_TRACE( "SchChartDocShell::SaveAs" );

	BOOL bRet = FALSE;

	//	If chart was loaded from binary format it has never been built.
	if( ! pChDoc->IsInitialized())
		pChDoc->Initialize();

	{
		RTL_LOGFILE_CONTEXT_TRACE (context, "XML format");
        bRet = SfxObjectShell::SaveAs( rMedium );

		/**********************************************************************
		 * StarOffice XML-Filter Export
		 **********************************************************************/
		{
            Reference<com::sun::star::frame::XModel> xModel(GetModel());
            SchXMLWrapper aFilter( xModel, rMedium,
								   GetCreateMode() != SFX_CREATE_MODE_EMBEDDED );

			// update user info before writing
			UpdateDocInfoForSave();

			bRet = aFilter.Export();
		}
	}

	return bRet;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

/*************************************************************************
|*
|* Tabellenzeiger auffrischen
|*
\************************************************************************/
void SchChartDocShell::UpdateTablePointers() throw()
{
	PutItem(SvxColorTableItem(pChDoc->GetColorTable()));
	PutItem(SvxGradientListItem(pChDoc->GetGradientList()));
	PutItem(SvxHatchListItem(pChDoc->GetHatchList()));
	PutItem(SvxBitmapListItem(pChDoc->GetBitmapList()));
	PutItem(SvxDashListItem(pChDoc->GetDashList()));
	PutItem(SvxLineEndListItem(pChDoc->GetLineEndList()));

	if(pFontList)delete pFontList;

	if ( GetCreateMode() == SFX_CREATE_MODE_EMBEDDED && !pPrinter )
	{
		// OLE-Objekt: kein Printer anlegen
		pFontList = new FontList( Application::GetDefaultDevice(), NULL, FALSE );	// #67730#
	}
	else
	{
		pFontList = new FontList(GetPrinter(), NULL, FALSE);
	}

	SvxFontListItem aFontListItem(pFontList);
	PutItem(aFontListItem);

//	PutItem(SvxNumberInfoItem(pChDoc->GetNumFormatter()));
}

/*************************************************************************
|*
|* FillClass
|*
\************************************************************************/

void SchChartDocShell::FillClass(SvGlobalName* pClassName,
                                 sal_uInt32*  pFormat,
								 String* pAppName,
								 String* pFullTypeName,
                                 String* pShortTypeName,
								 sal_Int32 nFileFormat ) const
{
	if (nFileFormat == SOFFICE_FILEFORMAT_60)
	{
		*pClassName		= SvGlobalName(SO3_SCH_CLASSID_60);
		*pFormat        = SOT_FORMATSTR_ID_STARCHART_60;
        *pFullTypeName  = String(SchResId(STR_CHART_DOCUMENT_FULLTYPE_CURRENT));
		*pShortTypeName = String(SchResId(STR_CHART_DOCUMENT));
	}
	else if (nFileFormat == SOFFICE_FILEFORMAT_8)
	{
		*pClassName		= SvGlobalName(SO3_SCH_CLASSID_60);
		*pFormat		= SOT_FORMATSTR_ID_STARCHART_8;
		*pFullTypeName	= String(RTL_CONSTASCII_USTRINGPARAM("chart8"));
		*pShortTypeName	= String(SchResId(STR_CHART_DOCUMENT));
	}
    else
    {
        DBG_ERROR( "Unknown Filformat" );
    }
}

void SchChartDocShell::InPlaceActivate( BOOL b ) throw()
{
	if( pChDoc )
	{
		pChDoc->CatchUpBufferedData();
	}
    SfxObjectShell::InPlaceActivate( b );
}
