/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: schlib.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:02:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

#pragma optimize("",off)

#include "schlib.hxx"
//#include "schdll0.hxx"
#include "schmod.hxx"
#include "res_bmp.hrc"
#include "dlggraut.hxx"

#include <osl/module.hxx>

static ::osl::Module* pLibHandleSch = NULL;
BOOL LoadLibSch()
{
	if( pLibHandleSch == NULL )
	{
		pLibHandleSch = new ::osl::Module();
		if (!pLibHandleSch->load( String( RTL_CONSTASCII_USTRINGPARAM( DLL_NAME ) ) ) )
			return FALSE;
	}

	return pLibHandleSch->is();
}

void* GetFuncSch( const char * pFuncName )
{
	if( LoadLibSch() )
        return pLibHandleSch->getSymbol( ::rtl::OUString::createFromAscii(pFuncName) );\
	return NULL;												\
}

void __EXPORT SchDLL::Update( const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >& aIPObj, SchMemChart* pData, OutputDevice* pOut )
{
    void (__LOADONCALLAPI*fp)(const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >&, SchMemChart*, OutputDevice*);

    fp = (void (__LOADONCALLAPI*)(const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >&, SchMemChart*, OutputDevice*))GetFuncSch("SchUpdate");

	if (fp)
	{
	fp(aIPObj, pData, pOut);
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/


void __EXPORT SchDLL::Update( const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >& aIPObj, SchMemChart* pData, const SfxItemSet& rAttr, OutputDevice* pOut )
{
    void (__LOADONCALLAPI*fp)(const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >&, SchMemChart*, const SfxItemSet&, OutputDevice*);

    fp = (void (__LOADONCALLAPI*)(const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >&, SchMemChart*, const SfxItemSet&, OutputDevice*))GetFuncSch("SchUpdateAttr");

	if (fp)
	{
	fp(aIPObj, pData, rAttr, pOut);
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

ModalDialog* __EXPORT SchDLL::CreateAutoPilotDlg(Window* pParent,
										SchMemChart* pData,
										const SfxItemSet& rInAttrs,
										SfxItemSet& rOutAttrs,
										BOOL bPrePage)
{
	ModalDialog* (__LOADONCALLAPI*fp)(Window*, SchMemChart*, const SfxItemSet&, SfxItemSet&, BOOL);

	fp = (ModalDialog*(__LOADONCALLAPI*)(Window*, SchMemChart*, const SfxItemSet&, SfxItemSet&, BOOL))GetFuncSch("SchCreateDiagramAutoPilotDlg");

	if (fp)
	{
	return fp(pParent, pData, rInAttrs, rOutAttrs, bPrePage);
	}
	else return 0;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void __EXPORT SchDLL::ChangeChartData(ModalDialog* pDlg,
							 SchMemChart* pData)
{
	void (__LOADONCALLAPI*fp)(ModalDialog*, SchMemChart*);

	fp = (void (__LOADONCALLAPI*)(ModalDialog*, SchMemChart*))GetFuncSch("SchChangeChartData");

	if (fp)
	{
	fp(pDlg, pData);
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

SfxTabDialog* __EXPORT SchDLL::CreateOptionsDlg(Window* pParent,
									   const SfxItemSet& rInAttrs,
									   XOutdevItemPool* pItemPool)
{
	SfxTabDialog* (__LOADONCALLAPI*fp)(Window*, const SfxItemSet&, XOutdevItemPool*);

	fp = (SfxTabDialog* (__LOADONCALLAPI*)(Window*, const SfxItemSet&, XOutdevItemPool*))GetFuncSch("SchCreateOptionsDlg");

	if (fp)
	{
	return fp(pParent, rInAttrs, pItemPool);
	}
	else return 0;
}

SfxTabPage* __EXPORT SchDLL::CreateOptionsTabPage( USHORT nId, Window* pParent, const SfxItemSet* pSet )
{
	SfxTabPage* (__LOADONCALLAPI*fp)( USHORT, Window*, const SfxItemSet* );
	fp = (SfxTabPage* (__LOADONCALLAPI*)( USHORT, Window*, const SfxItemSet* ) )GetFuncSch("SchCreateOptionsTabPage");
	if (fp)
		return fp( nId, pParent, pSet );
	else return 0;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

SchMemChart* __EXPORT SchDLL::GetChartData (const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >& aIPObj)
{
    SchMemChart* (__LOADONCALLAPI*fp)(const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >&);

    fp = (SchMemChart* (__LOADONCALLAPI*)(const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >& aIPObj))GetFuncSch("SchGetChartData");

	return fp
			   ? fp (aIPObj)
			   : 0;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

SchMemChart* __EXPORT SchDLL::NewMemChart ()
{
	SchMemChart* (__LOADONCALLAPI*fp)();

	fp = (SchMemChart* (__LOADONCALLAPI*)())GetFuncSch("SchNewMemChartNone");

	return fp
			   ? fp ()
			   : 0;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

SchMemChart* __EXPORT SchDLL::NewMemChart (short nCols, short nRows)
{
	SchMemChart* (__LOADONCALLAPI*fp)(short, short);

	fp = (SchMemChart* (__LOADONCALLAPI*)(short, short))GetFuncSch("SchNewMemChartXY");

	if (fp)
	{
		return fp(nCols, nRows);
	}
	else return 0;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

SchMemChart* __EXPORT SchDLL::NewMemChart (const SchMemChart &rMemChart)
{
	SchMemChart* (__LOADONCALLAPI*fp)(const SchMemChart &);

	fp = (SchMemChart* (__LOADONCALLAPI*)(const SchMemChart &))GetFuncSch("SchNewMemChartCopy");

	if (fp)
	{
		return fp(rMemChart);
	}
	else return 0;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

ChartModel __EXPORT *SchDLL::GetModel (const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >& aIPObj)
{
    ChartModel *(__LOADONCALLAPI*fp)(const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >&);

    fp = (ChartModel* (__LOADONCALLAPI*)(const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >&))GetFuncSch("SchGetModel");

	if (fp)
	{
		return fp(aIPObj);
	}
	else return 0;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/


void __EXPORT SchDLL::SetTransparentBackground( const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >& aIPObj, BOOL bTransp )
{
    void (__LOADONCALLAPI*fp)(const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >&, BOOL );

    fp = (void (__LOADONCALLAPI*)(const ::com::sun::star::uno::Reference< ::com::sun::star::embed::XEmbeddedObject >&, BOOL))GetFuncSch("SchSetTransparent");

	if (fp)
	{
	fp(aIPObj, bTransp);
	}
}

void __EXPORT SchDLL::GetDefaultForColumnText( const SchMemChart& rMemChart, sal_Int32 nCol, String& aResult )
{
	void (__LOADONCALLAPI*fp)( const SchMemChart&, sal_Int32, String& );

	fp = (void (__LOADONCALLAPI*)( const SchMemChart&, sal_Int32, String& ))GetFuncSch("SchGetDefaultForColumnText");

	if( fp )
	{
		fp( rMemChart, nCol, aResult );
	}
}

void __EXPORT SchDLL::GetDefaultForRowText( const SchMemChart& rMemChart, sal_Int32 nRow, String& aResult )
{
	void (__LOADONCALLAPI*fp)( const SchMemChart&, sal_Int32, String& );

	fp = (void (__LOADONCALLAPI*)( const SchMemChart&, sal_Int32, String& ))GetFuncSch("SchGetDefaultForRowText");

	if( fp )
	{
		fp( rMemChart, nRow, aResult );
	}
}

void __EXPORT SchDLL::ConvertChartRangeForWriter( SchMemChart& rMemChart,
													BOOL bOldToNew )
{
	void (__LOADONCALLAPI* fp )( SchMemChart&, BOOL )
		= (void (__LOADONCALLAPI*)( SchMemChart&, BOOL ))
								GetFuncSch("SchConvertChartRangeForWriter");
	if( fp )
		fp( rMemChart, bOldToNew );
}

void __EXPORT SchDLL::ConvertChartRangeForCalc( SchMemChart& rMemChart,
												BOOL bOldToNew )
{
	void (__LOADONCALLAPI* fp )( SchMemChart&, BOOL )
		= (void (__LOADONCALLAPI*)( SchMemChart&, BOOL ))
								GetFuncSch("SchConvertChartRangeForCalc");
	if( fp )
		fp( rMemChart, bOldToNew );
}

void __EXPORT SchDLL::MemChartResetTranslation( SchMemChart& rMemChart,
												long *pTable,long nCnt )
{
	void (__LOADONCALLAPI* fp )( SchMemChart&, long*, long )
		= (void (__LOADONCALLAPI*)( SchMemChart&, long*, long ))
								GetFuncSch("SchMemChartResetTranslation");
	if( fp )
		fp( rMemChart, pTable, nCnt );
}

void __EXPORT SchDLL::MemChartUpdateTranslation( SchMemChart& rMemChart,
													long *pTable,long nCnt )
{
	void (__LOADONCALLAPI* fp )( SchMemChart&, long*, long )
		= (void (__LOADONCALLAPI*)( SchMemChart&, long*, long ))
								GetFuncSch("SchMemChartUpdateTranslation");
	if( fp )
		fp( rMemChart, pTable, nCnt );
}


void __EXPORT SchDLL::MemChartInsertCols( SchMemChart& rMemChart,
											short nAtCol, short nCount)
{
	void (__LOADONCALLAPI* fp )( SchMemChart&, short, short )
		= (void (__LOADONCALLAPI*)( SchMemChart&, short, short ))
								GetFuncSch("SchMemChartInsertCols");
	if( fp )
		fp( rMemChart, nAtCol, nCount );
}
void __EXPORT SchDLL::MemChartRemoveCols( SchMemChart& rMemChart,
											short nAtCol, short nCount)
{
	void (__LOADONCALLAPI* fp )( SchMemChart&, short, short )
		= (void (__LOADONCALLAPI*)( SchMemChart&, short, short ))
								GetFuncSch("SchMemChartRemoveCols");
	if( fp )
		fp( rMemChart, nAtCol, nCount );
}

void __EXPORT SchDLL::MemChartInsertRows( SchMemChart& rMemChart,
											short nAtRow, short nCount )
{
	void (__LOADONCALLAPI* fp )( SchMemChart&, short, short )
		= (void (__LOADONCALLAPI*)( SchMemChart&, short, short ))
								GetFuncSch("SchMemChartInsertRows");
	if( fp )
		fp( rMemChart, nAtRow, nCount );
}
void __EXPORT SchDLL::MemChartRemoveRows( SchMemChart& rMemChart,
											short nAtRow, short nCount )
{
	void (__LOADONCALLAPI* fp )( SchMemChart&, short, short )
		= (void (__LOADONCALLAPI*)( SchMemChart&, short, short ))
								GetFuncSch("SchMemChartRemoveRows");
	if( fp )
		fp( rMemChart, nAtRow, nCount );
}

void __EXPORT SchDLL::MemChartSwapCols( SchMemChart& rMemChart,
										int nAtCol1, int nAtCol2 )
{
	void (__LOADONCALLAPI* fp )( SchMemChart&, int, int )
		= (void (__LOADONCALLAPI*)( SchMemChart&, int, int ))
								GetFuncSch("SchMemChartSwapCols");
	if( fp )
		fp( rMemChart, nAtCol1, nAtCol2 );
}
void __EXPORT SchDLL::MemChartSwapRows( SchMemChart& rMemChart,
										int nAtRow1,int nAtRow2 )
{
	void (__LOADONCALLAPI* fp )( SchMemChart&, int, int )
		= (void (__LOADONCALLAPI*)( SchMemChart&, int, int ))
								GetFuncSch("SchMemChartSwapRows");
	if( fp )
		fp( rMemChart, nAtRow1, nAtRow2);
}
