/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chtmode1.cxx,v $
 *
 *  $Revision: 1.30 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 19:50:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif

#ifndef _SVX_XLNTRIT_HXX //autogen
#include <svx/xlntrit.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _SVDVITER_HXX
#include <svx/svdviter.hxx>
#endif
#ifndef _SVDVIEW_HXX
#include <svx/svdview.hxx>
#endif
#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif

#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#ifndef _SCH_MEMCHRT_HXX
#include "memchrt.hxx"
#endif
#define ITEMID_ADJUST EE_PARA_JUST
#include <svx/adjitem.hxx>

#ifndef _SVX_CHRTITEM_HXX //autogen
#define ITEMID_DOUBLE	        0
#define ITEMID_CHARTDATADESCR	SCHATTR_DATADESCR_DESCR
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
#include <svx/chrtitem.hxx>
#endif

#define ITEMID_FONT        EE_CHAR_FONTINFO
#define ITEMID_COLOR       EE_CHAR_COLOR
#define ITEMID_FONTHEIGHT  EE_CHAR_FONTHEIGHT
#include <svx/fontitem.hxx>
#include <svx/fhgtitem.hxx>
#include <svx/colritem.hxx>
#ifndef _XTABLE_HXX
#include <xtable.hxx>
#endif
#ifndef _SCH_OBJADJ_HXX
#include  "objadj.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#include "globfunc.hxx"
#endif
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _SCH_SCHRESID_HXX
#include "schresid.hxx"
#endif
#ifndef _DEFINES_HXX
#include "defines.hxx"
#endif

#include "glob.hrc"
#include <svx/dialogs.hrc>
#include "math.h"

#ifndef _SVX_ITEMTYPE_HXX //autogen
#include <svx/itemtype.hxx>
#endif

#ifndef _SVX_XLNEDCIT_HXX //autogen
#include <svx/xlnedcit.hxx>
#endif

#ifndef _SVX_XLNSTCIT_HXX //autogen
#include <svx/xlnstcit.hxx>
#endif

#ifndef _SVX_XLNEDWIT_HXX //autogen
#include <svx/xlnedwit.hxx>
#endif

#ifndef _SVX_XLNSTWIT_HXX //autogen
#include <svx/xlnstwit.hxx>
#endif

#ifndef _SVX_XLNEDIT_HXX //autogen
#include <svx/xlnedit.hxx>
#endif

#ifndef _SVX_XLNSTIT_HXX //autogen
#include <svx/xlnstit.hxx>
#endif

#ifndef _SVX_XLNDSIT_HXX //autogen
#include <svx/xlndsit.hxx>
#endif

#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif

#ifndef _SVX_XLNCLIT_HXX //autogen
#include <svx/xlnclit.hxx>
#endif

#ifndef _SVX_XLNWTIT_HXX //autogen
#include <svx/xlnwtit.hxx>
#endif

#include "pairs.hxx"
#include "datalog.hxx"

#include "chaxis.hxx"

#include "chmod3d.hxx"
#include "schmod.hxx"
#include "schopt.hxx"

/************************************************************************/

const double fDefaultArr[DEFAULT_ROWCNT][DEFAULT_COLCNT] =
{
	{ 9.1,	3.2,	4.54 },
	{ 2.4,	8.8,	9.65 },
	{ 3.1,	1.5,	3.7 },
	{ 4.3,	9.02,	6.2 }
};

/*************************************************************************
|*
|* delete top-level object (called by BuildChart to create shape newly)
|*
\************************************************************************/

void ChartModel::DeleteObject( SdrObject* pObj )
{
	if( pObj )
	{
		// unmark object in all views
		SdrViewIter aIter( pObj );
		SdrView* pView = aIter.FirstView();

		while( pView )
		{
			// important: leave group so that SdrPageView's object list is always
			// the same as the object list of the page
			pView->LeaveAllGroup();
			pView->UnmarkAll();

			pView = aIter.NextView();
		}

#if OSL_DEBUG_LEVEL > 1
  		SdrObject* pDelObj = pObj->GetObjList()->RemoveObject( pObj->GetOrdNum());
  		DBG_ASSERT( pDelObj == pObj , "Wrong object removed!" );
#else
  		pObj->GetObjList()->RemoveObject( pObj->GetOrdNum());
#endif

  		delete pObj;
	}
	else
		DBG_ERROR( "DeleteObject: Invalid object" );
}

const USHORT nExchangeTitleWhichPairs[] =
{                                                    //ca.:
	SCHATTR_TEXT_ORIENT, SCHATTR_TEXT_ORIENT,       // 1
	SCHATTR_TEXT_DEGREES,SCHATTR_TEXT_DEGREES,      //
	XATTR_LINE_FIRST, XATTR_LINE_LAST,              // 1000
	XATTR_FILL_FIRST, XATTR_FILL_LAST,              // 1020
	SDRATTR_START, SDRATTR_END, //hier geaendert auf alle SdrAttr
	EE_ITEMS_START, EE_ITEMS_END,                   // 4000
	0
};

/*************************************************************************
|*
|* Textobjekt fuer Diagramme erzeugen
|* FG: Der Parameter MaximumWidth wird beachtet, falls er groesser als 0 ist.
|*     Dann wird zur Not der Text umgebrochen. Diese Groesse muss auch
|*     CalcMaxDescrSize uebergeben werden, sonst stimmt die Formatierung nicht.
|*     Es werden maximal 2 Zeilen dieser Breite erzeugt der Rest wird abgeschnitten.
|*
|*      Das sollte umgeschrieben werden, denn:
|*      1)  Es wird der Text in ein Outline-Objekt gepackt, damit man mit Stacked-Text
|*          zurecht kommt.
|*      2)  daraus wird die Groesse und die Breite berechnet.
|*      3)  dann wird diese Groesse genommen um ein SdrTextObj mit den gleichen
|*          Attributen zu erzeugen, wie das Outline Objekt.
|*
\************************************************************************/

SdrRectObj* ChartModel::CreateTextObj(UINT16           nId,
									  const Point      &rPos,
									  const String     &rText,
									  const SfxItemSet &rAttr,
									  BOOL             bIsTitle,
									  ChartAdjust      eAdjust,
									  const long       nMaximumWidth)
{
	const SfxPoolItem* pPoolItem = NULL;
	SvxChartTextOrient eOrient;

	if (rAttr.GetItemState(SCHATTR_TEXT_ORIENT, TRUE, &pPoolItem) == SFX_ITEM_SET)
		eOrient = ((const SvxChartTextOrientItem*)pPoolItem)->GetValue();
	else
		eOrient = CHTXTORIENT_STANDARD;

	SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);
	aTextAttr.Put(rAttr);

	if (bIsTitle)
		aTextAttr.Put(SvxAdjustItem(SVX_ADJUST_CENTER));
	else
		aTextAttr.Put(SvxAdjustItem((eOrient == CHTXTORIENT_BOTTOMTOP)
										 ? SVX_ADJUST_RIGHT
										 : SVX_ADJUST_LEFT));

    // clear old outliner content
	pOutliner->Clear();

	if (eOrient == CHTXTORIENT_STACKED)
		pOutliner->SetText(StackString(rText), pOutliner->GetParagraph( 0 ));
	else
		pOutliner->SetText(rText, pOutliner->GetParagraph( 0 ));

		// FG: Diese Routine berechnet nun wirklich ob der Text umgebrochen werden soll oder nicht.
	Size aSize = CalcTextSizeOfOneText (eOrient, aTextAttr, pOutliner, nMaximumWidth,FALSE);

		// FG: Was macht das?
	OutlinerParaObject* pPara =	pOutliner->CreateParaObject();

		// FG: Hier wird der Text der oben muehsam erzeugt und formatiert wurde, wieder weggeworfen.
	pOutliner->Clear();

	//rPos=Position im ChartRect, wird als arg uebergeben,
	//size ergibt sich aus CalcTextOf... (s.o.)
	Rectangle aRect(rPos, aSize);
	SdrRectObj* pObj;

	AdjustRect(aRect, eAdjust);

	switch(nId)
	{
		//Alle Titel sorgen selbst fuer ihre Attributierung:
		case CHOBJID_DIAGRAM_TITLE_X_AXIS:
		case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
		case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
		case CHOBJID_TITLE_MAIN:
		case CHOBJID_TITLE_SUB:
			pObj = new SchRectObj(OBJ_TEXT, aRect);
			break;
		default:
			pObj = new SdrRectObj(OBJ_TEXT, aRect);
			break;

	}

	//Seit 4/1998 koennen Texte frei gedreht werden: SCHATTR_TEXT_DEGREES
	long nDegrees=GetTextRotation((SfxItemSet&)rAttr,eOrient);
	if(nDegrees)
	{
	   Rectangle aOldBoundRect=pObj->GetCurrentBoundRect();
	   double fVal=nDegrees * nPi180;
	   pObj->Rotate(pObj->GetSnapRect().Center(), nDegrees, sin(fVal), cos(fVal));
	   pObj->NbcMove( AdjustRotatedRect(aOldBoundRect, eAdjust,pObj->GetCurrentBoundRect()));
	}

	//ToDo: anhaengen der ,*(pItemPool->GetFrozenIdRanges()) ???, erstmal mit diesen Whichpairs
	SfxItemSet aAreaAttr(*pItemPool,nExchangeTitleWhichPairs);

	//Neu: #52009#
	aAreaAttr.Put(SdrTextAutoGrowHeightItem( bIsTitle ));
	aAreaAttr.Put(SdrTextAutoGrowWidthItem( bIsTitle ));
	aAreaAttr.Put(rAttr);


//-/	pObj->NbcSetAttributes(aAreaAttr, FALSE);//#63904# 10%
	pObj->SetMergedItemSet(aAreaAttr);//#63904# 10%

	pObj->InsertUserData(new SchObjectId(nId));
	pObj->InsertUserData(new SchObjectAdjust(eAdjust, eOrient));
	pObj->NbcSetOutlinerParaObject(pPara);

	return pObj;
}

/*************************************************************************
|*
|* Text von Diagramm-Textobjekten setzen
|*
\************************************************************************/

void ChartModel::SetTextString(SdrTextObj& rTextObj, const String& rText,
							   SvxChartTextOrient eOrient, const long nMaximumWidth)
{
	if (eOrient == CHTXTORIENT_AUTOMATIC)
	{
		SchObjectAdjust* pObjAdjust = GetObjectAdjust(rTextObj);
		DBG_ASSERT( pObjAdjust, "ChartModel::SetTextString: no adjustment info in text obj") ;
		eOrient = pObjAdjust->GetOrient();
	}

	pOutliner->SetText(*rTextObj.GetOutlinerParaObject());
	SfxItemSet aTextAttr(pOutliner->GetParaAttribs(0));
	aTextAttr.Put(SvxAdjustItem((eOrient == CHTXTORIENT_BOTTOMTOP)
									? SVX_ADJUST_RIGHT
									: SVX_ADJUST_LEFT));
	pOutliner->Clear();

	if (eOrient == CHTXTORIENT_STACKED)
		pOutliner->SetText(StackString(rText), pOutliner->GetParagraph( 0 ));
	else
		pOutliner->SetText(rText, pOutliner->GetParagraph( 0 ));

		// FG: Diese Routine berechnet nun wirklich ob der Text umgebrochen werden soll oder nicht.
	Size aSize = CalcTextSizeOfOneText (eOrient, aTextAttr, pOutliner, nMaximumWidth,FALSE);

	OutlinerParaObject* pPara =	pOutliner->CreateParaObject();

	pOutliner->Clear();

	rTextObj.SetOutlinerParaObject(pPara);
	AdjustTextSize(rTextObj, aSize);
}

/*************************************************************************
|*
|* Attribute von Diagramm-Textobjekten setzen
|*
\************************************************************************/

void ChartModel::SetTextAttr(SdrTextObj& rTextObj,
							 const SfxItemSet& rAttr,
							 const long nMaximumWidth)
{
    // #97992# calling SetItemSet results in changing the p...Attr in the ChartModel
    // because of the implementation of SchRectObj.  Maybe this is wrong, but it seemed
    // to risky, therefore I set here all the correct items to prevent loss
//	SfxItemSet aObjAttr( *pItemPool, nAreaWhichPairs );
//	aObjAttr.Put(rAttr);
//	rTextObj.SetItemSetAndBroadcast(aAreaAttr);

    // #117446# BM: Attention: If rAttr is identical to the p..Attr member, this
    // results in overwrite of items by stored items in the SdrObject, thus copy
    // the given itemset
    SfxItemSet aAttrClone( rAttr );
    rTextObj.SetMergedItemSetAndBroadcast( aAttrClone );

	if ( rTextObj.GetOutlinerParaObject())
	{
		SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);
		aTextAttr.Put(rAttr);
		aTextAttr.Put(SvxAdjustItem());

		pOutliner->SetText(*rTextObj.GetOutlinerParaObject());

		SetTextAttributes (aTextAttr);

		if(IsAttrChangeNeedsBuildChart(rAttr))
		{
			//in diesem Fall koennte ein Textresize/reorg noetig sein

			Size aSize = pOutliner->CalcTextSize();
			aSize.Height() += TEXTHEIGHT_OFS;
			aSize.Width () = (aSize.Width () * 6) / 5;

			OutlinerParaObject* pPara =	pOutliner->CreateParaObject();

			pOutliner->Clear();

			rTextObj.SetOutlinerParaObject(pPara);
			AdjustTextSize(rTextObj, aSize);
		}
	}
}
/*************************************************************************
|*
|* Liefert die maximale Beschriftungs-Text-Groesse
|* FG: Hier wird der groesste Text berechnet und die Groesse des ersten
|*     und letzten (je nach Chart-Typ braucht man einen oder alle 3 Werte
|*     nNumberFormat ist der Index fuer ein Zahlenformat, dies kann noetig
|*       sin um die wahre Textbreite und Hoehe auszurechnen
|*     nMaximumWidth ist die Breite ab der der Text umgebrochen wird
|*
\************************************************************************/

Size ChartModel::CalcMaxDescrSize(BOOL               bRowDescr,
								  SvxChartTextOrient eOrient,
								  const UINT32       nNumberFormat,
								  long				 nAxisUId,
								  const long         MaximumWidth,
								  Pair*				 pFirstAndLast )
{
	ChartAxis *pCurrentXAxis = (nAxisUId == CHAXIS_AXIS_A)? pChartAAxis: pChartXAxis;

	BOOL bLogarithm = pCurrentXAxis->IsLogarithm();
	short nCnt;
	SfxItemSet* pAxisAttr;
	if (bRowDescr)
	{
		nCnt			= GetRowCount();
		pAxisAttr		= &GetAttr(CHOBJID_DIAGRAM_Z_AXIS);
	}
	else
	{
		nCnt			= GetColCount();
		pAxisAttr		= &GetAttr(CHOBJID_DIAGRAM_X_AXIS);
	}

	pOutliner->SetUpdateMode (FALSE);

	Size aMaxSize(0, 0);

	if (IsXYChart())
	{
		/**********************************************************************
		* XY-Chart oder Zeilen muessen zusammengefasst werden
		**********************************************************************/
		if (/*IsXYChart() && */pCurrentXAxis->GetMin() == pCurrentXAxis->GetMax())//#55400#
		{
			return Size (0, 0);
		}
		else
		{

			// #55400#
			// #67961#
			double fMinX  = pCurrentXAxis->GetMin();
			double fMaxX  = pCurrentXAxis->GetMax();
			double fStepX = pCurrentXAxis->GetStep();

			//	Collect the items which control the text appearence and set them to
			//	the outliner.
			SfxItemSet aTextAttr(*pItemPool, nTextOrientWhichPairs);
			aTextAttr.Put(GetAttr(CHOBJID_DIAGRAM_X_AXIS));
//			SetTextAttributes (aTextAttr);

			double fAct = fMinX;

			while (fAct <= fMaxX)
			{
				String aNumStr;
				Color* pDummy = NULL;

                pNumFormatter->GetOutputString(fAct, nNumberFormat, aNumStr, &pDummy);

				if (eOrient == CHTXTORIENT_STACKED)
					pOutliner->SetText(StackString(aNumStr), pOutliner->GetParagraph( 0 ));
				else
					pOutliner->SetText(aNumStr, pOutliner->GetParagraph( 0 ));

				// FG: Hier wird wirklich berechnet wie gross der Textbereich werden soll. Insbesondere
				//     wird hier entschieden, ob der Text umgebrochen werden soll oder nicht!
				SetTextAttributes (aTextAttr);
				Size aSize = CalcTextSizeOfOneText (eOrient, aTextAttr, pOutliner, MaximumWidth,
					TRUE, FALSE);
				pOutliner->SetUpdateMode (FALSE);

				pOutliner->Clear();

				if (aSize.Width() > aMaxSize.Width())
					aMaxSize.Width() = aSize.Width();
				if (aSize.Height() > aMaxSize.Height())
					aMaxSize.Height() = aSize.Height();

					// FG: Die Berechnung erfolgt hier, damit die Raender in Create2DBackplane
				if (fAct <= fMinX)
				{
					nWidthOfFirstXAxisText = aSize.Width();
					if(pFirstAndLast)
						pFirstAndLast->A()=nWidthOfFirstXAxisText;

				}
				IncValue(fAct, fStepX, bLogarithm);
					// FG: Die Berechnung erfolgt hier, damit die Raender in Create2DBackplane
				if (fAct >= fMaxX)
				{
					nWidthOfLastXAxisText = aSize.Width();
					if(pFirstAndLast)
						pFirstAndLast->B()=nWidthOfLastXAxisText;
				}

			}
		}
	}
	else
	{
		//	Collect the items which control the text appearence and set them to
		//	the outliner.
		SfxItemSet aTextAttr(*pItemPool, nTextOrientWhichPairs);
		aTextAttr.Put(*pAxisAttr);
//		SetTextAttributes (aTextAttr);

		for (short i = 0; i < nCnt; i++)
		{
			String aDescrStr = bRowDescr ? RowText(i) : ColText(i);

			if (eOrient == CHTXTORIENT_STACKED)
				pOutliner->SetText(StackString(aDescrStr), pOutliner->GetParagraph( 0 ));
			else
				pOutliner->SetText(aDescrStr, pOutliner->GetParagraph( 0 ));

			// FG: Hier wird wirklich berechnet wie gross der Textbereich werden soll. Insbesondere wird
			//     hier entschieden, ob der Text umgebrochen werden soll oder nicht!
			SetTextAttributes (aTextAttr);
			Size aSize = CalcTextSizeOfOneText (eOrient, aTextAttr, pOutliner, MaximumWidth,TRUE,
				FALSE);
			pOutliner->SetUpdateMode (FALSE);
			pOutliner->Clear();

			if (aSize.Width() > aMaxSize.Width())
				aMaxSize.Width() = aSize.Width();
			if (aSize.Height() > aMaxSize.Height())
				aMaxSize.Height() = aSize.Height();
			// FG: Die Berechnung erfolgt hier, damit die Raender in Create2DBackplane
			//     richtig berechnet werden koennen.
			if (i == 0)
			{
				nWidthOfFirstXAxisText = aSize.Width();
				if(pFirstAndLast)
					pFirstAndLast->A()=nWidthOfFirstXAxisText;
			}
			if (i == nCnt-1)
			{
				nWidthOfLastXAxisText = aSize.Width();
				if(pFirstAndLast)
					pFirstAndLast->B()=nWidthOfLastXAxisText;
			}
		}
	}

	pOutliner->SetUpdateMode (TRUE);

	return aMaxSize;
}

/*************************************************************************
|*
|* Text-Hoehe ermitteln
|*
\************************************************************************/

long ChartModel::GetLineHeight(const SfxItemSet& rAttr)
{
	SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);
	aTextAttr.Put(rAttr);

	pOutliner->SetText( String( RTL_CONSTASCII_USTRINGPARAM( "JQXYZ09" )), pOutliner->GetParagraph( 0 ) );
	SetTextAttributes (aTextAttr);

	long nHeight = pOutliner->CalcTextSize().Height() + TEXTHEIGHT_OFS;

	pOutliner->Clear();

	return nHeight;
}

/*************************************************************************
|*
|* Datenzeilen-Attributsets initialisieren
|*
\************************************************************************/

//
// schneller machen, es muss nicht alles neu gebaut werden
//

void ChartModel::InitDataAttrs()
{
	CHART_TRACE( "ChartModel::InitDataAttrs" );

	DBG_ASSERT( pChartData, "ChartModel::InitDataAttrs: No ChartData-Object available!" );

	short nDataColCnt	= pChartData->GetColCount();
	short nDataRowCnt	= pChartData->GetRowCount();

    /* For pie charts we need the maximum of both dimensions, because the pie interprets data a bit
     * odd: only the first series (data-row) is used for the pie.  Each segment is a data point of
     * this single series.  However to get the correct colors the array containing series attributes
     * is used instead of the data point attributes.  Thus for a 1x10 data we need 10 series
     * attributes although we have only one series.  However for 20x10 data we need 20 series
     * attributes, because we actually have 20 series although just the first one is visible.  But
     * we need those attributes in case the chart type is switched.
     */
    short nCnt          = IsPieChart()
        ? ::std::max( GetColCount(), GetRowCount())
        : GetRowCount();

    short i;

	if (nCnt != nPieSegCount)
	{
		long *pOfs = new long[nCnt];

		if (nPieSegCount > nCnt)
			for (i = 0; i < nCnt; i++)
				pOfs[i] = pPieSegOfs[i];
		else
		{
			for (i = 0; i < nPieSegCount; i++)
				pOfs[i] = pPieSegOfs[i];
			for (; i < nCnt; i++)
				pOfs[i] = 0;
		}

		delete[] pPieSegOfs;
		pPieSegOfs = pOfs;
		nPieSegCount = nCnt;
	}


	long nRowListCnt ;
	//regressattr
	nRowListCnt = (short)aRegressAttrList.Count();

	DBG_ASSERT( pDefaultColors, "invalid default colors" );
	sal_Int32 nNumDefCol = pDefaultColors->Count();
	DBG_ASSERT( nNumDefCol, "Empty Default Color List" );

	if (nCnt != nRowListCnt)
	{
		if (nRowListCnt > nCnt)
		{
			aRegressAttrList.Seek((ULONG)nCnt);
			for (i = nCnt; i < nRowListCnt; i++)
				delete aRegressAttrList.Remove();
		}
		else
		{
			for (i = nRowListCnt; i < nCnt; i++)
			{
				SfxItemSet* pRegressAttr = new SfxItemSet(*pItemPool, nGridWhichPairs);
				aRegressAttrList.Insert(pRegressAttr, LIST_APPEND);

				pRegressAttr->Put(XLineStyleItem(XLINE_SOLID));
				pRegressAttr->Put(XLineWidthItem(100));
				if( nNumDefCol != 0 )
				{
					XColorEntry* pEntry = (XColorEntry*)pDefaultColors->
						GetObject(i % nNumDefCol);
					pRegressAttr->Put(XLineColorItem(pEntry->GetName(),
													 pEntry->GetColor()));
				}
				pRegressAttr->Put(XLineDashItem());
				pRegressAttr->Put(XLineStartItem());
				pRegressAttr->Put(XLineEndItem());
				pRegressAttr->Put(XLineStartWidthItem());
				pRegressAttr->Put(XLineEndWidthItem());
				pRegressAttr->Put(XLineStartCenterItem());
				pRegressAttr->Put(XLineEndCenterItem());
				pRegressAttr->Put(XLineTransparenceItem());
			}
		}
	}

	//average attr
	nRowListCnt = (short)aAverageAttrList.Count();
	if (nCnt != nRowListCnt)
		if (nRowListCnt > nCnt)
		{
			aAverageAttrList.Seek((ULONG)nCnt);
			for (i = nCnt; i < nRowListCnt; i++)
				delete aAverageAttrList.Remove();
		}
		else
		{
			for (i = nRowListCnt; i < nCnt; i++)
			{
				SfxItemSet* pAverageAttr = new SfxItemSet(*pItemPool, nGridWhichPairs);
				aAverageAttrList.Insert(pAverageAttr, LIST_APPEND);

				pAverageAttr->Put(XLineStyleItem(XLINE_SOLID));
				pAverageAttr->Put(XLineWidthItem(0));
				if( nNumDefCol != 0 )
				{
					XColorEntry* pEntry = (XColorEntry*)pDefaultColors->
						GetObject(i % nNumDefCol);
					pAverageAttr->Put(XLineColorItem(pEntry->GetName(),
													 pEntry->GetColor()));
				}
				pAverageAttr->Put(XLineDashItem());
				pAverageAttr->Put(XLineStartItem());
				pAverageAttr->Put(XLineEndItem());
				pAverageAttr->Put(XLineStartWidthItem());
				pAverageAttr->Put(XLineEndWidthItem());
				pAverageAttr->Put(XLineStartCenterItem());
				pAverageAttr->Put(XLineEndCenterItem());
				pAverageAttr->Put(XLineTransparenceItem());
			}
		}

	//error attr
	nRowListCnt = (short)aErrorAttrList.Count();
	if (nCnt != nRowListCnt)
		if (nRowListCnt > nCnt)
		{
			aErrorAttrList.Seek((ULONG)nCnt);
			for (i = nCnt; i < nRowListCnt; i++)
				delete aErrorAttrList.Remove();
		}
		else
		{
			for (i = nRowListCnt; i < nCnt; i++)
			{
				SfxItemSet* pErrorAttr = new SfxItemSet(*pItemPool, nGridWhichPairs);
				aErrorAttrList.Insert(pErrorAttr, LIST_APPEND);

				pErrorAttr->Put(XLineStyleItem(XLINE_SOLID));
				pErrorAttr->Put(XLineWidthItem(0));
				pErrorAttr->Put(XLineColorItem(String(), RGBColor(COL_BLACK)));
				pErrorAttr->Put(XLineDashItem());
				pErrorAttr->Put(XLineStartItem());
				pErrorAttr->Put(XLineEndItem());
				pErrorAttr->Put(XLineStartWidthItem());
				pErrorAttr->Put(XLineEndWidthItem());
				pErrorAttr->Put(XLineStartCenterItem());
				pErrorAttr->Put(XLineEndCenterItem());
				pErrorAttr->Put(XLineTransparenceItem());
			}
		}

	// Point-Attr
	long nPointCnt		= nDataColCnt * nDataRowCnt;
	long nPointListCnt	= aDataPointAttrList.Count();
	if (nPointCnt != nPointListCnt)
		if (nPointListCnt > nPointCnt)
		{
//			aDataPointAttrList.Seek((ULONG)nPointCnt);
//			for (long i = nPointCnt; i < nPointListCnt; i++)
//				delete aDataPointAttrList.Remove();
			while (nPointListCnt-- > nPointCnt)
			{
				aDataPointAttrList.Seek((ULONG)nPointCnt);
				delete aDataPointAttrList.Remove();
			}
		}
		else for (long ii = nPointListCnt; ii < nPointCnt; ii++)
			 aDataPointAttrList.Insert(NULL, LIST_APPEND);

	// Switch-Point-Attr
	nPointListCnt = aSwitchDataPointAttrList.Count();
	if (nPointCnt != nPointListCnt)
	{
		if (nPointListCnt > nPointCnt)
		{
//			aSwitchDataPointAttrList.Seek((ULONG)nPointCnt);
//			for (long i = nPointCnt; i < nPointListCnt; i++)
//				delete aSwitchDataPointAttrList.Remove();
			while (nPointListCnt-- > nPointCnt)
			{
				aSwitchDataPointAttrList.Seek((ULONG)nPointCnt);
				delete aSwitchDataPointAttrList.Remove();
			}
		}
		else for (long iii = nPointListCnt; iii < nPointCnt; iii++)
			aSwitchDataPointAttrList.Insert(NULL, LIST_APPEND);
			// Insert (new SfxItemSet(*pItemPool, nRowWhichPairs),...)
	}

	//row attr
	nRowListCnt = (short)aDataRowAttrList.Count();
	if (nCnt != nRowListCnt)
	{
		if (nRowListCnt > nCnt)
		{
			//bevor attribute geloescht werden, wird reorganisiert
			LogBookAttrData();

			//Jetzt darf erst der Ueberhang geloescht werden:
			aDataRowAttrList.Seek((ULONG)nCnt);
			for (i = nCnt; i < nRowListCnt; i++)
				delete aDataRowAttrList.Remove();
		}
		else
		{
            bool bIsCombiChart =
                ( CHSTYLE_2D_LINE_COLUMN         ==  eChartStyle ) ||
                ( CHSTYLE_2D_LINE_STACKEDCOLUMN  ==  eChartStyle );

            for (i = nRowListCnt; i < nCnt; i++)
			{
				SfxItemSet* pDataRowAttr = new SfxItemSet(*pItemPool, nRowWhichPairs);
				aDataRowAttrList.Insert(pDataRowAttr, LIST_APPEND);
				SetDefAttrRow(pDataRowAttr,i);

 				//	Change the defaults for lines in mixed line-column charts.
 				if( bIsCombiChart && IsLine( i ) )
                {
                    pDataRowAttr->ClearItem (SCHATTR_STYLE_SYMBOL);
                    pDataRowAttr->Put (XLineStyleItem (XLINE_SOLID));
                    // #101164# as more than one line is possible via GUI, those
                    // should not all be black
//                     pDataRowAttr->Put (XLineColorItem (String(), RGBColor (COL_BLACK)));
                    pDataRowAttr->Put (XLineWidthItem (0));
                }
			}
            if( ! bIsCombiChart )
                SetupLineColors( SETLINES_FILLCOLOR, nRowListCnt );
		}
	}
    LogBookAttrData();
}


/*************************************************************************
|*
|* ggf. Attribute neu Organisieren erzeugen
|*
\************************************************************************/
void ChartModel::LogBookAttrData()
{
	CHART_TRACE( "ChartModel::LogBookAttrData" );

	if(pLogBook)
	{
		if(pLogBook->IsValid())
		{
			pLogBook->SetColMode(bSwitchData);

			if(pLogBook->IsChanged())
			{
				//Alle bestehenden Attribute werden abgearbeitet, auch
				//wenn sie spaeter noch geloescht werden sollten.
				long nMax=aDataRowAttrList.Count();
				if(nMax) //Nur, wenn noch Daten da sind #47933#
				{
					long nCnt;
					long nEnd=pLogBook->GetInitial();
					long nNewId;

					//aDataRowAttrList kopieren;
					ItemSetList aTmpList(aDataRowAttrList);

					for(nCnt=0;nCnt<nMax;nCnt++)
					{
						nNewId=pLogBook->GetId(nCnt);

						//Wenn egal, dann neues Attribut erzeugen
						if(nNewId==SCH_DATALOG_ANY)
						{
							// #67541# BM what the heck is that? why skip 2 attributes?
							//nEnd+=2;  //erstes neues default-attribut

							SfxItemSet* pReplaced;
							SfxItemSet* pDataRowAttr = new SfxItemSet(*pItemPool, nRowWhichPairs);
							pReplaced = aDataRowAttrList.Replace(pDataRowAttr,nCnt);
							SwapDataPointAttr(nCnt);
							SetDefAttrRow(pDataRowAttr,nEnd);
							nEnd++;	// #67541# increase (by 1) after setting attributes
						}
						else
						{
							aDataRowAttrList.Replace(aTmpList.GetObject(nNewId),nCnt);
							SwapDataPointAttr(nCnt,nNewId);
							//wird gebraucht, also nachher nicht loeschen:
							aTmpList.Replace(NULL,nNewId);
						}
					}

				  //In TmpListe die verbleibenden Element loeschen
				  aTmpList.Seek((ULONG)0);
				  for(nCnt=0;nCnt<nMax;nCnt++)
					delete aTmpList.Remove();

				}
			}
		}

		//Wichtig: verhindert nochmalige ReOrg bzw. ReOrg mit falschen Daten!!!
		pLogBook->Reset();
	}
}
void ChartModel::SwapDataPointAttr(long n1,long n2)
{
	CHART_TRACE2( "ChartModel::SwapDataPointAttr %ld <=> %ld", n1, n2 );

	long nMax=GetColCount();
	long nMaxRow=GetRowCount();
	if(n1 > 0 && n1 < nMaxRow && n2 < nMaxRow)
	{
		SfxItemSet *pSet;
		if(n2 <0 )
		{
			for(long nCol=0;nCol<nMax;nCol++)
			{
				pSet=(SfxItemSet *)&GetDataPointAttr(nCol,n1);
				pSet->ClearItem();
			}
		}
		else
		{
			SfxItemSet aTmp(*pItemPool,nRowWhichPairs),*pSet2=NULL;
			for(long nCol=0;nCol<nMax;nCol++)
			{
				pSet=(SfxItemSet *)&GetDataPointAttr(nCol,n1);
				aTmp.ClearItem();
				aTmp.Put(*pSet);
				pSet2=(SfxItemSet *)&GetDataPointAttr(nCol,n1);
				pSet->ClearItem();
				pSet->Put(*pSet2);
				pSet2->ClearItem();
				pSet2->Put(aTmp);
			}

		}
	}
	else
	{
		DBG_TRACE("ChartModel::SwapDataPointAttr range error ?");
	}
}
/*************************************************************************
|*
|* RowAttr neu setzen:
|*
\************************************************************************/
void ChartModel::SetDefAttrRow(SfxItemSet* pDataRowAttr,const long i)
{
	DBG_ASSERT( pDefaultColors, "Invalid default color list" );
	if( ! pDefaultColors )
		return;

	CHART_TRACE1( "ChartModel::SetDefAttrRow - Row #%ld", i )

	sal_Int32 nNumDefCol = pDefaultColors->Count();
	DBG_ASSERT( nNumDefCol, "invalid default colors" );

	pDataRowAttr->Put(*pDummyAttr);
	if( nNumDefCol != 0 )
	{
		XColorEntry* pEntry = (XColorEntry*)pDefaultColors->
			GetObject(i % nNumDefCol);
		pDataRowAttr->Put(XFillColorItem(pEntry->GetName(),
										 pEntry->GetColor()));

		if(IsLine(i)) //#54870# bei Linien defaultfarbe der Linie=FillColor
		{
			pDataRowAttr->Put(XLineColorItem(pEntry->GetName(),
											 pEntry->GetColor()));
		}
	}
	else
	{
		pDataRowAttr->Put(XLineColorItem(String(), RGBColor(COL_BLACK)));
	}
}
/*************************************************************************
|*
|* ggf. Demo-Chart erzeugen
|*
\************************************************************************/

void ChartModel::InitChartData(BOOL bNewTitles)
{
	if (!pChartData)
	{
		SchMemChart* pMemChart = new SchMemChart(DEFAULT_COLCNT, DEFAULT_ROWCNT);

		pMemChart->SetMainTitle(String(SchResId(STR_TITLE_MAIN)));
		pMemChart->SetSubTitle(String(SchResId(STR_TITLE_SUB)));
		pMemChart->SetXAxisTitle(String(SchResId(STR_DIAGRAM_TITLE_X_AXIS)));
		pMemChart->SetYAxisTitle(String(SchResId(STR_DIAGRAM_TITLE_Y_AXIS)));
		pMemChart->SetZAxisTitle(String(SchResId(STR_DIAGRAM_TITLE_Z_AXIS)));

		for( short nCol = 0; nCol < DEFAULT_COLCNT; nCol++ )
		{
			pMemChart->SetColText( nCol, pMemChart->GetDefaultColumnText( nCol ));

			for( short nRow = 0; nRow < DEFAULT_ROWCNT; nRow++ )
			{
 				pMemChart->SetData( nCol, nRow, fDefaultArr[ nRow ][ nCol ] );
				pMemChart->SetRowText( nRow, pMemChart->GetDefaultRowText( nRow ));
			}
		}

		SetChartData(*pMemChart, bNewTitles);
	}
}

/*************************************************************************
|*
|* Defaultfarben erstellen
|*
\************************************************************************/

void ChartModel::CreateDefaultColors ()
{
	SchOptions* pOptions = SCH_MOD1()->GetSchOptions();
	long nCount;
	ColorData* pDefaultCol = NULL;

	if( pOptions )
	{
		const SchColorTable& aDefCols = pOptions->GetDefaultColors();
		nCount = aDefCols.size();
		pDefaultCol = new ColorData[ nCount ];
 		DBG_ASSERT( nCount == ROW_COLOR_COUNT, "Chart: dynamic default color array size not supported yet" );

		for( int i=0; i<nCount; i++ )
		{
			pDefaultCol[ i ] = aDefCols.getColorData( i );
		}
	}
	else
	{
		nCount = ROW_COLOR_COUNT;
		pDefaultCol = new ColorData[ nCount ];

		pDefaultCol[  0 ]  = RGB_COLORDATA( 0x99,  0x99, 0xff );
		pDefaultCol[  1 ]  = RGB_COLORDATA( 0x99,  0x33, 0x66 );
		pDefaultCol[  2 ]  = RGB_COLORDATA( 0xff,  0xff, 0xcc );
		pDefaultCol[  3 ]  = RGB_COLORDATA( 0xcc,  0xff, 0xff );
		pDefaultCol[  4 ]  = RGB_COLORDATA( 0x66,  0x00, 0x66 );
		pDefaultCol[  5 ]  = RGB_COLORDATA( 0xff,  0x80, 0x80 );
		pDefaultCol[  6 ]  = RGB_COLORDATA( 0x00,  0x66, 0xcc );
		pDefaultCol[  7 ]  = RGB_COLORDATA( 0xcc,  0xcc, 0xff );
		pDefaultCol[  8 ]  = RGB_COLORDATA( 0x00,  0x00, 0x80 );
		pDefaultCol[  9 ]  = RGB_COLORDATA( 0xff,  0x00, 0xff );
		pDefaultCol[ 10 ]  = RGB_COLORDATA( 0x00,  0xff, 0xff );
		pDefaultCol[ 11 ]  = RGB_COLORDATA( 0xff,  0xff, 0x00 );
	}

	// create colors from table if they exist otherwise copy default colors
 	pDefaultColors = new List;
	Color aCol;

	for( int i=0; i<nCount; i++ )
	{
		aCol.SetColor( pDefaultCol[ i ] );
		pDefaultColors->Insert( new XColorEntry( aCol, String() ), LIST_APPEND );
	}

	delete[] pDefaultCol;
}

/*************************************************************************
|*
|* Defaultfarben kopieren
|*
\************************************************************************/

void ChartModel::CopyDefaultColors (List* pOtherColors)
{
	DestroyDefaultColors ();

	pDefaultColors = new List;

	for (long nColors = 0;
			  nColors < (long) (pOtherColors->Count());
			  nColors ++)
		pDefaultColors->Insert (new XColorEntry(*((XColorEntry*) pOtherColors->GetObject (nColors))), LIST_APPEND);
}

/*************************************************************************
|*
|* Defaultfarben loeschen
|*
\************************************************************************/

void ChartModel::DestroyDefaultColors ()
{
	if (pDefaultColors)
	{
		while (pDefaultColors->Count())
			delete (XColorEntry*)pDefaultColors->Remove(pDefaultColors->Count() - 1);
		delete pDefaultColors;
	}

	pDefaultColors = 0;
}

/*************************************************************************
|*
|* Berechnung der Breite und der Hoehe eines Textes
|*
|*    Derzeit ist diese funktion totaler Muell: Im wesentlichen werden die Werte direkt gesetzt
|*    Hoehe = 2 * Texthoehe, Breite hoechstens MaximumWidth
|*
|* FG: Damit dies Funktioniert muss per SetText im Outliner (pOutliner)
|*     der Text schon gesetzt sein!
|*
\************************************************************************/
#define MAXLEGENDLINES 3  //#49908# #NACHTRAG#
#define CDEG2RAD(fAngle) (  (double)(fAngle)*F_PI/18000.0 )


void	ChartModel::SetTextAttributes	(SfxItemSet & rTextAttributes)
{
/*	static	SfxItemSet *	pLastItemSet = NULL;
	if (&rTextAttributes == pLastItemSet)
		return;
	else
		pLastItemSet = &rTextAttributes;
*/
	ULONG nParagraphCount = pOutliner->GetParagraphCount();
	for (ULONG i=0; i<nParagraphCount; i++)
		pOutliner->SetParaAttribs(i, rTextAttributes);
}


// bGetRotated sollte TRUE sein, wenn der verbrauchte Platz des Textes gemessen werden soll,
// und False, falls das TextRect berechnet und dann gedreht wird (sonst doppelte Drehung)
//	The flag bSetTextAttributes tells the method wether to set the given attributes to the
//	outliner.
Size ChartModel::CalcTextSizeOfOneText (SvxChartTextOrient eOrient,
										SfxItemSet         &rTextAttr,
										SdrOutliner        *pOutliner,
										long	MaxW,
										BOOL	bGetRotated/*=FALSE*/,
										BOOL	bUseTextAttributes)
{
	long MaximumWidth=MaxW;

	pOutliner->SetUpdateMode (FALSE);
	ULONG nParaCnt = pOutliner->GetParagraphCount();

		// FG: Jeder Absatz muss die Text-Attribute einzeln zugewiesen bekommen. (jedenfalls scheint es so)
		//     Besser waere es dass fuer alle Absaetze auf einmal setzen zu koennen.
	if (bUseTextAttributes)
		SetTextAttributes (rTextAttr);

	Size OldPaperSize = pOutliner->GetPaperSize();

	long nDegrees=GetTextRotation((SfxItemSet&)rTextAttr,eOrient);//#62531#
	double fDeg, fSin,
		fCos = 1;				// BM: Initialize Cos for if statement after if(nDegrees)-Block
	BOOL bBreakOK=TRUE; //s.u.
	if(nDegrees)
	{
		//TVM: In einigen Bereichen macht Umbruch keinen Sinn, da die Breite steigt (90 bzw.
		//270 Grad ist der triviale Fall!) Der genaue Bereich ist hier nicht festgelegt,
		//denn jeder andere Fall ist leider nicht trivial! (Abhaengig davon, wieviele Zeichen
		//und welche umgebrochen werden, 2 Beispiele:
		// 1. nur ein 'i' wird umgebrochen    => Text wird fast immer breiter (ausser bei ~ 0 Grad)
		// 2. der halbe Text wird umgebrochen => fast immer sinnvoll
		//Die genaue Berechnung erfordert einen Test und ein Undo, wenn es breiter wird
		//Im folgenden wird einfach die Mitte genommen -> 90% - Loesung
		bBreakOK =!(   ((nDegrees > 4500) && (nDegrees < 13500))
					|| ((nDegrees >22500) && (nDegrees < 31500)));

		fDeg=CDEG2RAD(nDegrees);
		fSin=fabs(sin(fDeg));
		fCos=fabs(cos(fDeg));

/*
  Hat man gedrehten Text, wird ein sinnvoller Umbruch schwierig, da

  1. bei bestimmten Winkeln und bestimmter Textlaenge der Text breiter und nicht schmaler wird
  2. Diese Funktion bei Winkeln != 0 mit MaximumWidth u.U. die Hoehe vorgegeben bekommt
  (Create2DBackplane tut dies bei gedrehten Texten an der X-Achse)
  untenstehender Code berechnet die vorzugebene MaxBreite, wenn der Text gedreht ist, dies
  waere leider nur ein Teil der notwendigen Loesung, die so schon recht viel Performance schluckt:

		if( MaximumWidth > 0 && fCos!=0)
		{
			Size aFullSize(pOutliner->CalcTextSize()); //Textgroesse ohne Umbruch
			double dW = aFullSize.Height()*fSin;	   //delta width je neue Zeile
			double Wf = aFullSize.Width();			   //Ist-Textbreite durch Soll-Textbreite des Textes ergibt die Anzahl der Zeilen

			double p_halbe			= (dW-(double)MaximumWidth)/(2*fCos);
			double p_halbe_quadrat	= p_halbe * p_halbe;
			double q				= Wf*dW/fCos;
			if(q > p_halbe_quadrat)
			{
				MaximumWidth=-1; //keine Loesung, Abbruch, nix umbrechen!
			}
			else
			{
				long nNewMax1 =(long) (- p_halbe + sqrt(p_halbe_quadrat-q) + 0.5);
				long nNewMax2 =(long) (- p_halbe - sqrt(p_halbe_quadrat-q) + 0.5);
				//Die groessere Breite ist immer die bessere
				MaximumWidth=Max(nNewMax1,nNewMax2);
			}
		}
*/
	}

	if( MaximumWidth > 0 && fCos!=0) //Kein Umbruch bei 90 und 270 Grad oder Max<=0
		pOutliner->SetPaperSize( Size( MaximumWidth, 0 ) );


	pOutliner->SetUpdateMode (TRUE);
	Size aSize = pOutliner->CalcTextSize();
	pOutliner->SetUpdateMode (FALSE);
	Size aRot(aSize);
	if(nDegrees)
	{
		aRot.Width() = (long)( (double)aSize.Width()*fCos + (double)aSize.Height()*fSin );
		aRot.Height()= (long)( (double)aSize.Width()*fSin + (double)aSize.Height()*fCos );
	}

		// FG: Diese Groesse wird nun veraendert, falls MaximumWidth > 0 und
		//     aSize.Width() > MaximumWidth, dann wird umgebrochen, genau einmal.
		//     Es kommen also hoechstens 2 Zeilen raus, der Rest wird dann abgeschnitten.
		//     An dieser Stelle werden aber nur die Attribute berechnet.

	if ((MaximumWidth > 0) && (eOrient != CHTXTORIENT_STACKED))
	{
#ifdef DBG_UTIL
		if(!(aRot.Width() <= MaximumWidth))
			DBG_WARNING("ChartModel::CalcTextSizeOfOneText:Doch breiter?" );
#endif
		ULONG nLines = 0;
		for( USHORT n = 0; n < pOutliner->GetParagraphCount(); n++ )
		{
			nLines += pOutliner->GetLineCount( n );
		}

		// Silbentrennung nur bei >MAXLEGENDLINES Zeilen oder einem zu langen wort...
		if ( bBreakOK
			&& (    ( nLines > MAXLEGENDLINES )
				 || (    ( nLines >= 2 )
					  && ( nParaCnt == 1 )
					  && ( pOutliner->GetText( pOutliner->GetParagraph( 0 ) ).Search( ' ' )
															 == STRING_NOTFOUND )
					 )
			  )
		   )
		{
			if ( nLines > MAXLEGENDLINES )
			{
				long nHeightOfRows = GetHeightOfnRows (rTextAttr, MAXLEGENDLINES);//war mal 2 statt MAX...#50395#
				aSize.Height() = nHeightOfRows;

				if(nDegrees)
				{
					aRot.Height()  =(long)( (double)MaximumWidth *fSin
										   + (double)nHeightOfRows*fCos );
					aRot.Width()   =(long)( (double)MaximumWidth *fCos
										   + (double)nHeightOfRows*fSin );
				}
			}

			ULONG nParaCnt = pOutliner->GetParagraphCount();

			for (ULONG i = 0; i < nParaCnt; i++)
			{
				// Stets Silbentrennung
				SfxItemSet aAttr(pOutliner->GetParaAttribs(i));
				aAttr.Put( SfxBoolItem(EE_PARA_HYPHENATE, TRUE) );
				pOutliner->SetParaAttribs(i, aAttr);
			}

			//#50395# durch Bindestriche vergroessert worden->
			//statt 2 werden jetzt 3 Zeilen benoetigt
			ULONG nActLines = 0;
			for( USHORT n = 0; n < pOutliner->GetParagraphCount(); n++ )
			{
				nActLines += pOutliner->GetLineCount( n );
			}
			if(nActLines>nLines)
			{
				nActLines=Min((ULONG)MAXLEGENDLINES,nActLines);
				long nHeightOfRows = GetHeightOfnRows (rTextAttr,nActLines);
				aSize.Height() = nHeightOfRows;

				if(nDegrees)
				{
					aRot.Height()  =(long)( (double)MaximumWidth *fSin
										   + (double)nHeightOfRows*fCos );
					aRot.Width()   =(long)( (double)MaximumWidth *fCos
										   + (double)nHeightOfRows*fSin );
				}
			}

		}
	}

	pOutliner->SetPaperSize(OldPaperSize);
	pOutliner->SetUpdateMode (TRUE);

	return (bGetRotated && nDegrees) ? aRot : aSize;
}

/*************************************************************************
|*
|*  Liefert die Hoehe von n Textzeilen, mit den uebergebenen Attributen
|* FG: 13.2.97 Hier wird einfach n mal die Texthoehe einer Zeile zurueckgegeben
|*
\************************************************************************/

long ChartModel::GetHeightOfnRows (const SfxItemSet &rAttr, int n)
{
	SdrTextObj* pObj = pTestTextObj;  // definiert am Modell
	pObj->SetModel(this);

	if( !pObj->GetOutlinerParaObject() )
	{
		// set test text
		String aTestStr( RTL_CONSTASCII_USTRINGPARAM( "1234567890JQ" ));
		pObj->NbcSetText( aTestStr );
	}

	pObj->SetMergedItemSet(rAttr);

	pObj->FitFrameToTextSize();
	ULONG nHeight = pObj->GetTextSize().Height();

	return (n*nHeight);
}
void ChartModel::SetDefaultColorSet(long nSet) //#50037#
{
	static long aIndices[ROW_COLOR_COUNT];

	m_nDefaultColorSet=nSet;


	// Achtung! wg. #49990# wird bit 1 als Flag missbraucht!
	// das ist leider etwas unschoen.
	// Bit=ON bedeutet im Verbunddiagramm eine schwarze Linie!

	long nWhichColors=nSet & (1);//Bit 0 gibt Farbset an #50114#
	switch(nWhichColors)
	{
			case 0:
			case 2:
				aIndices[0]  = 45;          // Blau 6
				aIndices[1]  = 24;          // Rot 1
				aIndices[2]  = 18;          // Grau 60 %
				aIndices[3]  = 61;          // Gruen 6
				aIndices[4]  = 35;          // Violett 4
				aIndices[5]  = 78;          // Orange 3
				aIndices[6]  = 79;          // Orange 4
				aIndices[7]  = 47;          // Blau 8
				aIndices[8]  = 49;          // Tuerkis 2
				aIndices[9]  = 34;          // Violett 3
				aIndices[10] = 27;          // Rot 4
				aIndices[11] = 13;          // Hellmagenta
				break;

			case 1:
			case 3:
				aIndices[7]  = 45;          // Blau 6
				aIndices[0]  = 24;          // Rot 1
				aIndices[3]  = 18;          // Grau 60 %
				aIndices[2]  = 61;          // Gruen 6
				aIndices[4]  = 35;          // Violett 4
				aIndices[6]  = 78;          // Orange 3
				aIndices[9]  = 79;          // Orange 4
				aIndices[1]  = 47;          // Blau 8
				aIndices[11]  = 49;          // Tuerkis 2
				aIndices[10]  = 34;          // Violett 3
				aIndices[5] = 27;          // Rot 4
				aIndices[8] = 13;          // Hellmagenta
				break;
	}

	XColorTable* pTable = GetColorTable();
	DBG_ASSERT( pTable, "Color table not found");

	if(IsAxisChart())
	{
		long nRows=GetRowCount();
		for(long nRow=0;nRow<nRows;nRow++)
		{
			long nColor=aIndices[nRow%12];
			XColorEntry* pEntry = pTable->GetColor(nColor);
			DBG_ASSERT( pEntry, "No entry in color table" );
			if(pEntry)
			{
				SfxItemSet aAttr(*pItemPool, nRowWhichPairs);
				aAttr.Put(XFillColorItem(String(), pEntry->GetColor()) );
				PutDataRowAttr(nRow,aAttr);
			}
		}
	}
	else
	{
		long nCols=GetColCount();
		for(long nCol=0;nCol<nCols;nCol++)
		{
			long nColor=aIndices[nCol%12];
			XColorEntry* pEntry = pTable->GetColor(nColor);
			DBG_ASSERT( pEntry, "No entry in color table" );
			if(pEntry)
			{
				SfxItemSet aAttr(*pItemPool, nRowWhichPairs);
				aAttr.Put(XFillColorItem(String(), pEntry->GetColor()) );
				PutDataPointAttr(nCol,0,aAttr);
			}
		}
	}

	if(m_nDefaultColorSet&(2+4))//#49990#
	{
		SfxItemSet aBlackAttr(*pItemPool,nRowWhichPairs);//, XATTR_START, XATTR_END, 0);
		if(m_nDefaultColorSet&2)//#49990#
		{
			//alles schwarz:
			aBlackAttr.Put(XLineColorItem(String(),0));
			aBlackAttr.Put(XFillColorItem (String (),0));
			//Flag loeschen, damit per Gui noch anders
			//attributiert werden kann
			 m_nDefaultColorSet-=2;
		}

		if(m_nDefaultColorSet&4)//#50114#
		{
			aBlackAttr.Put(XLineStyleItem (XLINE_SOLID));
			aBlackAttr.Put(XLineWidthItem(50));
			//Flag loeschen, damit per Gui noch anders
			//attributiert werden kann
			 m_nDefaultColorSet-=4;   //jetzt wohl eher fuers laden wichtig
		}
		for(long nRow=0;nRow<GetRowCount();nRow++)
			if(IsLine(nRow))
				PutDataRowAttr(nRow,aBlackAttr);
	}

	BuildChart(FALSE);
}


