/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: MtaFop.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: obo $ $Date: 2006/10/12 10:55:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _MTAFOP_HXX_
#define _MTAFOP_HXX_

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#include <utility>
#if defined _MSC_VER
#pragma warning(push, 1)
#pragma warning(disable: 4917)
#endif
#include <objidl.h>
#include <shlobj.h>
#if defined _MSC_VER
#pragma warning(pop)
#endif

#ifndef _WINIMPLHELPER_HXX_
#include "..\misc\WinImplHelper.hxx"
#endif

//----------------------------------------------------------------
// a simple helper class used to provide a buffer for different
// Win32 file and directory functions
//----------------------------------------------------------------

class CAutoPathBuff
{
public:
	CAutoPathBuff( size_t size = 0 )
	{
		if (0 == size)
			size = 32000; // max path length under Win2000
					
		pBuff = new sal_Unicode[size];

		OSL_POSTCOND(pBuff,"Could not allocate path buffer");
	}

	~CAutoPathBuff( )
	{
		delete [] pBuff;
	}

	operator sal_Unicode*( )
	{
		OSL_PRECOND( pBuff, \
			"No path buffer allocated" );
		return pBuff;
	}
	
	sal_Unicode* get( )
	{
		OSL_PRECOND( pBuff, \
			"No path buffer allocated" );
		return pBuff;
	}

private:
	sal_Unicode* pBuff;
};

//--------------------------------------------------------
// the Mta-Ole clipboard class is for internal use only!
// only one instance of this class should be created, the
// user has to ensure this!
// the class is not thread-safe because it will be used 
// only from within the clipboard service and the methods
// of the clipboard service are already synchronized
//--------------------------------------------------------

class CMtaFolderPicker
{
public:
	CMtaFolderPicker( sal_uInt32 Flags );
	virtual ~CMtaFolderPicker( );

	// shell functions	
	sal_Bool SAL_CALL browseForFolder( );
	
	virtual void  SAL_CALL setDisplayDirectory( const rtl::OUString& aDirectory );
	virtual rtl::OUString  SAL_CALL getDisplayDirectory( );
    virtual rtl::OUString SAL_CALL getDirectory( );

    virtual void SAL_CALL setDescription( const rtl::OUString& aDescription );

	virtual void SAL_CALL setTitle( const rtl::OUString& aTitle );
	rtl::OUString  SAL_CALL getTitle( );

    //-----------------------------------------------------
	// XCancellable
	//-----------------------------------------------------
    
    virtual void SAL_CALL cancel( );

protected:
	void SAL_CALL enableOk( sal_Bool bEnable );
	void SAL_CALL setSelection( const rtl::OUString& aDirectory );
	void SAL_CALL setStatusText( const rtl::OUString& aStatusText );

	virtual void SAL_CALL onInitialized( );
	virtual void SAL_CALL onSelChanged( const rtl::OUString& aNewPath ) = 0;

private:
    sal_uInt32 onValidateFailed();

	// helper functions	
	LPITEMIDLIST  SAL_CALL getItemIdListFromPath( const rtl::OUString& aDirectory );
	rtl::OUString SAL_CALL getPathFromItemIdList( LPCITEMIDLIST lpItemIdList );
	void SAL_CALL releaseItemIdList( LPITEMIDLIST lpItemIdList );	

	unsigned int run( );
	
	// create a hidden windows which serves as an request 
	// target; so we guarantee synchronization
	sal_Bool SAL_CALL createStaRequestWindow( );

	//---------------------------------------------------------------
	// message handler functions; remeber these functions are called
	// from a different thread context!
	//---------------------------------------------------------------

	sal_Bool SAL_CALL onBrowseForFolder( );	

	static LRESULT CALLBACK StaWndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
	static unsigned int WINAPI StaThreadProc( LPVOID pParam );

	static int CALLBACK FolderPickerCallback( HWND hwnd, UINT uMsg, LPARAM lParam, LPARAM lpData );

protected:
	HWND m_hwnd;
	
private:
    ATOM SAL_CALL RegisterStaRequestWindowClass( );
    void SAL_CALL UnregisterStaRequestWindowClass( );

private:
	HANDLE						m_hStaThread;
	unsigned					m_uStaThreadId;
	HANDLE						m_hEvtThrdReady;    
	HWND						m_hwndStaRequestWnd;			
	rtl::OUString				m_dialogTitle;
    rtl::OUString               m_Description;
	rtl::OUString				m_displayDir;
    rtl::OUString               m_SelectedDir;
	BROWSEINFOW					m_bi;	
	CAutoPathBuff				m_pathBuff;
    HINSTANCE                   m_hInstance;

    // the request window class has to be registered only
    // once per process, so multiple instance of this class
    // share the registered window class
    static ATOM       s_ClassAtom;
    static osl::Mutex s_Mutex;
    static sal_Int32  s_StaRequestWndRegisterCount;

// prevent copy and assignment
private:
	CMtaFolderPicker( const CMtaFolderPicker& );
	CMtaFolderPicker& operator=( const CMtaFolderPicker& );	
};

#endif
