/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: MeterHelper.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:26:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"
#include "MeterHelper.hxx"
#include "ContextHelper.hxx"
#include "ChartModelHelper.hxx"
#include "ChartTypeHelper.hxx"
#include "macros.hxx"

#ifndef _COM_SUN_STAR_CHART2_XBOUNDEDCOORDINATESYSTEMCONTAINER_HPP_
#include <com/sun/star/chart2/XBoundedCoordinateSystemContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XGRIDCONTAINER_HPP_
#include <com/sun/star/chart2/XGridContainer.hpp>
#endif

// header for class OUStringBuffer
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

//.............................................................................
namespace chart
{
//.............................................................................
using namespace ::com::sun::star;
using namespace ::com::sun::star::chart2;

//static
rtl::OUString MeterHelper::makeAxisIdentifier(
      sal_Int32 nDimensionIndex
    , sal_Int32 nCooSysIndex )
{
    //@todo: create a real unique id here
    static const ::rtl::OUString aAxisStub( C2U( "@axis-" ));
    ::rtl::OUStringBuffer aId( aAxisStub );
    aId.append( sal_Unicode( 'x' + nDimensionIndex )); // Note: nDimensionIndex should not become greater than 3
    aId.append( sal_Unicode( '-' ));
    aId.append( sal_Int32( nCooSysIndex ));

    return aId.makeStringAndClear();
}

//static
uno::Reference< XAxis > MeterHelper::createAxis(
          sal_Int32 nDimensionIndex
        , const uno::Reference< XBoundedCoordinateSystem >& xCooSys
        , const uno::Reference< XAxisContainer >& xAxisContainer
        , const uno::Reference< uno::XComponentContext > & xContext )
{
    if( !xContext.is() || !xCooSys.is() || !xAxisContainer.is())
        return NULL;
    if( nDimensionIndex >= xCooSys->getDimension() )
        return NULL;

    uno::Reference< XAxis > xAxis(NULL);

    sal_Int32 nCooSysIndex=0;//find out the index of the coordinate system
    {
        //attention: assumed that the axiscontainer is also a coordinate-system container
        uno::Reference< XBoundedCoordinateSystemContainer > xCooSysContainer( xAxisContainer, uno::UNO_QUERY );
        if(xCooSysContainer.is())
        {
            uno::Sequence< uno::Reference< XBoundedCoordinateSystem > > aCooSysList =
                xCooSysContainer->getCoordinateSystems();
            for( sal_Int32 nN = aCooSysList.getLength(); nN--; )
            {
                if( xCooSys == aCooSysList[nN] )
                {
                     nCooSysIndex = nN;
                     break;
                }
            }
        }
    }

    ContextHelper::tContextEntryMapType aContextValues(
        ContextHelper::MakeContextEntryMap(
            C2U( "Identifier" ), uno::makeAny( makeAxisIdentifier( nDimensionIndex, nCooSysIndex ) )));

    xAxis.set( xContext->getServiceManager()->createInstanceWithContext(
               C2U( "com.sun.star.chart2.Axis" ),
               ContextHelper::createContext( aContextValues, xContext ) ), uno::UNO_QUERY );
    OSL_ASSERT( xAxis.is());
    if( xAxis.is())
    {
        xAxis->attachCoordinateSystem( xCooSys, nDimensionIndex );
        xAxisContainer->addAxis( xAxis );
    }
    return xAxis;
}

//static
uno::Reference< XBoundedCoordinateSystem > MeterHelper::getBoundedCoordinateSystemByIndex(
    const uno::Reference< XDiagram >& xDiagram, sal_Int32 nIndex )
{
    uno::Reference< XBoundedCoordinateSystemContainer > xCooSysContainer( xDiagram, uno::UNO_QUERY );
    if(!xCooSysContainer.is())
        return NULL;
    uno::Sequence< uno::Reference< XBoundedCoordinateSystem > > aCooSysList = xCooSysContainer->getCoordinateSystems();
    if(nIndex<aCooSysList.getLength())
        return aCooSysList[nIndex];
    return NULL;
}

//static
rtl::OUString MeterHelper::makeGridIdentifier( sal_Int32 nDimensionIndex, sal_Int32 nCooSysIndex, bool bMainGrid )
{
    static const ::rtl::OUString aGridStub( C2U( "@grid-" ) );
    static const ::rtl::OUString aMajor( C2U( "major" ) );
    static const ::rtl::OUString aMinor( C2U( "minor" ) );

    ::rtl::OUStringBuffer aId( aGridStub );
    aId.append( sal_Unicode( 'x' + nDimensionIndex ));
    aId.append( sal_Unicode( '-' ));
    aId.append( nCooSysIndex );
    aId.append( sal_Unicode( '-' ));
    if(bMainGrid)
        aId.append( aMajor );
    else
        aId.append( aMinor );
    return aId.makeStringAndClear();
}

//static
uno::Reference< XAxis > MeterHelper::getAxis( sal_Int32 nDimensionIndex
                                , bool bMainAxis, const uno::Reference< XDiagram >& xDiagram )
{
    uno::Reference< XBoundedCoordinateSystem > xCooSys = MeterHelper::getBoundedCoordinateSystemByIndex( xDiagram, bMainAxis ? 0 : 1 );
    if(!xCooSys.is())
        return NULL;
    uno::Reference< XAxisContainer > xAxisContainer( xDiagram, uno::UNO_QUERY );
    if( !xAxisContainer.is())
        return NULL;
    uno::Sequence< uno::Reference< XAxis > > aAxisList = xAxisContainer->getAxes();
    uno::Reference< XAxis > xAxis;
    for( sal_Int32 nA = 0; nA < aAxisList.getLength(); nA++ )
    {
        xAxis = aAxisList[nA];
        if( nDimensionIndex == xAxis->getRepresentedDimension()
            && xCooSys == xAxis->getCoordinateSystem() )
            //@todo maybe there is a better way to decide on first and secondary axis ...
            //--> need left/ right property in model
            return xAxis;
    }
    return NULL;
}

//static
uno::Reference< XGrid > MeterHelper::getGrid( sal_Int32 nDimensionIndex
                                , bool bMainGrid, const uno::Reference< XDiagram >& xDiagram )
{
    ::rtl::OUString aIdentifier( makeGridIdentifier(nDimensionIndex,0,bMainGrid) );
    uno::Reference< XGridContainer > xGridCnt( xDiagram, uno::UNO_QUERY );
    return xGridCnt->getGridByIdentifier( aIdentifier );
}

//static
void MeterHelper::getMeterPossibilities( uno::Sequence< sal_Bool >& rPossibilityList
        , const uno::Reference< XDiagram>& xDiagram, sal_Bool bAxis )
{
    rPossibilityList.realloc(6);
 
    //set possibilities:
    sal_Int32 nDimIndex=0;
    uno::Reference< XChartType > xChartType = ChartModelHelper::getFirstChartType( xDiagram );
    for(nDimIndex=0;nDimIndex<3;nDimIndex++)
        rPossibilityList[nDimIndex]=ChartTypeHelper::isSupportingMainAxis(xChartType,nDimIndex);
    for(nDimIndex=3;nDimIndex<6;nDimIndex++)
        rPossibilityList[nDimIndex]=ChartTypeHelper::isSupportingSecondaryAxis(xChartType,nDimIndex);
}

//.............................................................................
} //namespace chart
//.............................................................................
