/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ChartTypeGroup.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:21:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"
#include "ChartTypeGroup.hxx"
#include "macros.hxx"
#include "algohelper.hxx"

#ifndef _COM_SUN_STAR_CHART2_XSCALEGROUP_HPP_
#include <com/sun/star/chart2/XScaleGroup.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XDATASERIES_HPP_
#include <com/sun/star/chart2/XDataSeries.hpp>
#endif

#include <algorithm>

using namespace ::com::sun::star;
using ::osl::MutexGuard;

namespace chart
{

ChartTypeGroup::ChartTypeGroup(
    const uno::Reference< uno::XComponentContext > & xContext )
        : m_xContext( xContext )
{}

ChartTypeGroup::~ChartTypeGroup()
{}

// ____ XChartTypeGroup ____
uno::Reference< chart2::XChartType > SAL_CALL ChartTypeGroup::getChartType()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return m_aChartType;
    // \--
}

void SAL_CALL ChartTypeGroup::setChartType( const uno::Reference< chart2::XChartType >& aChartType )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    m_aChartType = aChartType;
    // \--
}

// ____ XDataSeriesTreeParent ____
uno::Sequence< uno::Reference< chart2::XDataSeriesTreeNode > >
        SAL_CALL ChartTypeGroup::getChildren()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return helper::VectorToSequence( m_aChildren );
    // \--
}

void SAL_CALL ChartTypeGroup::addChild(
        const uno::Reference< chart2::XDataSeriesTreeNode >& aNode )
        throw (lang::IllegalArgumentException,
               uno::RuntimeException)
{
    if( aNode->queryInterface(
            ::getCppuType( (uno::Reference< chart2::XScaleGroup >* )(0))).hasValue() ||
        aNode->queryInterface(
            ::getCppuType( (uno::Reference< chart2::XDataSeries >* )(0))).hasValue() )
    {
        // /--
        MutexGuard aGuard( m_aMutex );
        m_aChildren.push_back( aNode );
        // \--
    }
    else
    {
        throw lang::IllegalArgumentException();
    }
}

void SAL_CALL ChartTypeGroup::removeChild(
        const uno::Reference< chart2::XDataSeriesTreeNode >& aNode )
        throw (container::NoSuchElementException,
               uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    m_tChildType::iterator aIt( ::std::find(
        m_aChildren.begin(),
        m_aChildren.end(),
        aNode ));

    if( aIt == m_aChildren.end())
    {
        throw container::NoSuchElementException();
    }
    else
    {
        m_aChildren.erase( aIt );
    }
    // \--
}

// helper for lang::XServiceInfo
uno::Sequence< ::rtl::OUString > ChartTypeGroup::getSupportedServiceNames_Static()
{
    uno::Sequence< ::rtl::OUString > aServices( 1 );
    aServices[ 0 ] = C2U( "com.sun.star.chart2.ChartTypeGroup" );
    return aServices;
}

// implement XServiceInfo methods basing upon getSupportedServiceNames_Static
APPHELPER_XSERVICEINFO_IMPL( ChartTypeGroup,
                             C2U( "com.sun.star.comp.chart2.ChartTypeGroup" ));


} //  namespace chart
