/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fsetobsh.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/28 03:00:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _FSETOBJSH_HXX
#define _FSETOBJSH_HXX

#include <bf_sfx2/objsh.hxx>
#include <bf_sfx2/docfac.hxx>
class SvStrings;
namespace binfilter {

class SfxFrameSetDescriptor;
class SfxFrameSetObjectShell_Impl;

//==========================================================================
// Eine SfxFrameSetObjectShell ist ein Dokument, das praktisch nur aus
// ::com::sun::star::sdbcx::View-Daten besteht. Es stellt eine Anweisung dar, wie andere Inhalte,
// repr"asentiert durch URLs, in SfxFrames dargestellt werden sollen. Das so
// aufgebaute SfxFrameSet umfa\st die vollst"andigen FrameSets in der
// Netscape-HTML-Erweiterung.
// Die SfxFrameSet-Dokumente bieten HTML-Import und -Export.
//==========================================================================

class SfxFrameSetObjectShell: public SfxObjectShell
{
friend class SfxFrameHTMLParser;
	SfxFrameSetDescriptor*          pDescriptor;
	SfxFrameSetObjectShell_Impl*	pImp;

protected:
public:
					TYPEINFO();
					SfxFrameSetObjectShell(SfxObjectCreateMode = SFX_CREATE_MODE_EMBEDDED);
	String			GetSource();
	void			TakeSource( const String& rSource );
};
}//end of namespace binfilter
#include <cppuhelper/weak.hxx>
#include <bf_sfx2/objuno.hxx>
#ifndef _COM_SUN_STAR_FRAME_XFRAMESETMODEL_HPP_
#include <com/sun/star/frame/XFrameSetModel.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICENAME_HPP_
#include <com/sun/star/lang/XServiceName.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
namespace com{namespace sun{namespace star{namespace lang{
class XMultiServiceFactory;
}}}}
namespace binfilter {

class SfxFrameSetModel	:	public SfxBaseModel								,
							public ::com::sun::star::frame::XFrameSetModel	,
							public ::com::sun::star::lang::XServiceInfo
{
	SfxFrameSetObjectShell* pDoc;
	::rtl::OUString				aSource;
public:
	SfxFrameSetModel( const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > & xFactory );
	SfxFrameSetModel( SfxFrameSetObjectShell *pDoc );
	virtual ~SfxFrameSetModel();

	// XInterface, XTypeProvider, XServiceInfo + Helper + createInstance + createFactory + static
	SFX_DECL_XINTERFACE_XTYPEPROVIDER_XSERVICEINFO

	// XFrameSetModel
	virtual	void SAL_CALL setSource( const ::rtl::OUString& rSource ) throw ( ::com::sun::star::uno::RuntimeException );
	virtual ::rtl::OUString SAL_CALL getSource() throw ( ::com::sun::star::uno::RuntimeException );
};

}//end of namespace binfilter
#endif

