/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: frame.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/28 02:59:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXFRAME_HXX
#define _SFXFRAME_HXX

#ifndef TF_NEWDESKTOP
#define TF_NEWDESKTOP 1
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

namespace com
{
    namespace sun
    {
        namespace star
        {
            namespace awt
            {
                class XWindow;
            }
            namespace frame
            {
                class XFrame;
                class XFrameLoader;
                class XController;
                class XDispatchProviderInterceptor;
            }
            namespace beans
            {
                struct PropertyValue;
            }
        }
    }
}


#ifndef _REF_HXX //autogen
#include <tools/ref.hxx>
#endif

#ifndef _SFXBRDCST_HXX //autogen
#include <svtools/brdcst.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
class SvBorder;
class Window;
class SfxCancellable;
class Rectangle;
class SvCompatWeakHdl;
class SfxCancelManager;
namespace binfilter {

class SfxWorkWindow;
class SfxFrame;
class SfxFrame_Impl;
class SfxObjectShell;
class SfxObjectFactory;
class SfxViewFrame;
class SfxFrameDescriptor;
class SfxFrameSetDescriptor;
class SfxMedium;
class SfxFrameHistory_Impl;
class LoadEnvironment_Impl;
class SfxDispatcher;
class SfxMedium;
class SfxRequest;
class SfxUnoControllerItem;
class SfxUnoFrame;

typedef SfxFrame* SfxFramePtr;
class SfxFrameArr_Impl;

DECLARE_LIST( TargetList, String* )//STRIP008 DECLARE_LIST( TargetList, String* );

#define SFXFRAME_INTERNAL     0x0001
#define SFXFRAME_EXTERNAL     0x0002
#define SFXFRAME_OWNSDOCUMENT 0x0004
#define SFXFRAME_PLUGIN       0x0008
#define SFXFRAME_HASTITLE     0x0010
#define SFXFRAME_SERVER       0x0020 // Is es ein Frame, der in einem Container steckt ?
#define SFXFRAME_FRAMESET     0x0040

#define BROWSE_NORMAL         0
#define BROWSE_FORWARD        1
#define BROWSE_BACKWARD       2
#define NO_BROWSE		      3
#define BROWSE_FRAME          4
#define BROWSE_MAX_MODE       10

#define SFX_BEAMER_OFF			0
#define SFX_BEAMER_ON 			1
#define SFX_BEAMER_KEEPSTATE	2
#define SFX_BEAMER_SET_ON		3

//==========================================================================
// Ein SfxFrame ist eine Verwaltungsklasse f"ur Fenster und deren Inhalte.
// Eine SfxApplication pr"asentiert sich als Hierarchie von SfxFrames, wobei
// die konkreten Inhalte in den abgeleiteten Klassen festgelegt werden.
// Die Basisklasse SfxFrame implementiert 2 Aspekte der Frames: Benennung und
// Kontrolle der Lebensdauer.
// Innerhalb einer Frames-Hierarchie kontrolliert immer der ParentFrame die
// Lebensdauer seiner ChildFrames, auch wenn sie in der Regel gar nicht von
// ihm selbst erzeugt wurden. Durch Aufruf vonn DoClose() an irgendeinem
// Frame in der Hierarchie kann ein Teil des "Frameworks" entfernt werden,
// wobei sich Frames an ihren ParentFrames selbst abmelden.
//==========================================================================

class SfxFrameArr_Impl;
class SfxFrame
{
	friend class SfxFrameIterator;
	friend class SfxUnoFrame;
	friend class SfxViewFrame; /*HACK!*/

private:
	String				aName;
	SfxFrame*			pParentFrame;
	SfxFrameArr_Impl*	pChildArr;
	SfxFrame_Impl*		pImp;
	SfxUnoFrame*		pUnoImp;


protected:
    virtual sal_Bool    Close() = 0;
	virtual         	~SfxFrame();

#if _SOLAR__PRIVATE
	void				SetIsTop_Impl( sal_Bool bIsTop = sal_True );
#endif

public:
						TYPEINFO();
						SfxFrame(SfxFrame* pParent = 0);

	SvCompatWeakHdl*    GetHdl();
	virtual Window&     GetWindow() const = 0;
	void                CancelTransfers( sal_Bool bCancelLoadEnv = sal_True );
    sal_Bool            DoClose();
    sal_uInt16          GetChildFrameCount() const;
	const String&		GetFrameName() const
						{ return aName; }
	SfxFrame*	  		GetParentFrame() const
						{ return pParentFrame; }

    static SfxFrame*    GetFirst();
    static SfxFrame*    GetNext( SfxFrame& );

    virtual sal_Bool    InsertDocument( SfxObjectShell *pDoc );
	void                DocumentInserted( SfxObjectShell* pDoc );

    SfxBroadcaster&     GetBroadcaster() const;
	SfxObjectShell*		GetCurrentDocument() const;
	SfxViewFrame*		GetCurrentViewFrame() const;
	SfxFrame*			GetTopFrame() const;
    sal_Bool            IsParent( SfxFrame* ) const;

    sal_uInt32          GetFrameType() const;
	SfxFrame*           GetContainingDocFrame_Impl( SfxFrame* pSelf );
    sal_Bool            IsTop() const;
	void				UpdateHistory(SfxObjectShell*, const String*pNew = 0 );
	void				UpdateDescriptor( SfxObjectShell *pDoc );
	void				Resize();
    sal_Bool            HasComponent() const;
    ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow >
                            GetComponent() const;
	void				ReleaseComponent();
    ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >
                            GetFrameInterface() const;
    ::com::sun::star::uno::Reference< ::com::sun::star::frame::XController >
                            GetController() const;


#if _SOLAR__PRIVATE
    sal_Bool            DoClose_Impl();
    void                SetFrameInterface_Impl( ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >& rFrame );
	void				ReleasingComponent_Impl( sal_Bool bSet );
    sal_uInt16          LoadComponent_Impl( const ::rtl::OUString& rURL,
                            const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& rArgs,
                            const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrameLoader > & rLoader,
                            SfxItemSet* pSet=0, sal_Bool bDontClose=sal_False );
    DECL_STATIC_LINK(   SfxFrame, BindingHasNewPart_Impl, void* );
    SfxCancelManager*   GetCancelManager() const;
	void                SetLoadCancelable_Impl( SfxCancellable* );
	void				SetFrameType_Impl( sal_uInt32 );
	void				Deactivate_Impl();
    sal_uInt16          PrepareClose_Impl( sal_Bool bUI, sal_Bool bForBrowsing=sal_False );
	void				SetCurrentViewFrame_Impl( SfxViewFrame* );
    sal_Bool            IsClosing_Impl() const;
	void            	SetIsClosing_Impl();
	void				SetLoadEnvironment_Impl( LoadEnvironment_Impl *);
	LoadEnvironment_Impl* GetLoadEnvironment_Impl() const;
    sal_Bool            CanBrowseForward() const;
    sal_Bool            CanBrowseBackward() const;

						// Methoden f"ur den Zugriff auf das aktuelle Set
	SfxFrameDescriptor* GetDescriptor() const;

    sal_uInt16          GetLockCount_Impl() const;
    //sal_Bool            IsLocked_Impl() const
	//					{ return GetLockCount_Impl() > 0; }
    sal_Bool            IsAutoLoadLocked_Impl() const;

	static void         InsertTopFrame_Impl( SfxFrame* pFrame );
	static void         RemoveTopFrame_Impl( SfxFrame* pFrame );
	void				SetItemSet_Impl( const SfxItemSet* pSet );
	const SfxItemSet* 	GetItemSet_Impl();
	void				SetOwnsBindings_Impl( sal_Bool bSet );
    sal_Bool            OwnsBindings_Impl() const;
	void 				InvalidateUnoControllers_Impl();
	void				RegisterUnoController_Impl( SfxUnoControllerItem* );
	void				ReleaseUnoController_Impl( SfxUnoControllerItem* );
	SfxWorkWindow*		GetWorkWindow_Impl() const;
	void 				SetToolSpaceBorderPixel_Impl( const SvBorder& );
	Rectangle			GetTopOuterRectPixel_Impl() const;
	void				CreateWorkWindow_Impl();
	const SvBorder&		GetBorder_Impl() const;
	void				GrabFocusOnComponent_Impl();
//	sal_Bool			IsPlugin_Impl() const;
#endif
};

SV_DECL_COMPAT_WEAK( SfxFrame )


//--------------------------------------------------------------------

class SfxFrameItem_Impl;
class SfxFrameItem: public SfxPoolItem
{
	SfxFrame*               pFrame;
	SfxFrameWeak  		    wFrame;
	void                    SetFramePtr_Impl( SfxFrame* pFrameP ) { pFrame = wFrame; }

public:
							TYPEINFO();

							SfxFrameItem( SfxFrame *p ):
								SfxPoolItem( 0 ),
								pFrame( p ), wFrame( p ) {}

							SfxFrameItem( sal_uInt16 nWhich, SfxFrame *p ):
								SfxPoolItem( nWhich ),
								pFrame( p ), wFrame( p ){	}

	virtual int 			operator==( const SfxPoolItem& ) const;
	virtual String			GetValueText() const{DBG_BF_ASSERT(0, "STRIP"); return String();} //STRIP001 virtual String			GetValueText() const;
	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;

    sal_Bool                FrameKilled() const { return &wFrame != pFrame; }

	SfxFrame*				GetFrame() const
							{ return wFrame; }
};

class SfxUsrAnyItem : public SfxPoolItem
{
    ::com::sun::star::uno::Any  aValue;
public:
                                TYPEINFO();
                                SfxUsrAnyItem( sal_uInt16 nWhich, const ::com::sun::star::uno::Any& rAny );
    ::com::sun::star::uno::Any  GetValue() const
                                { return aValue; }
    virtual int                 operator==( const SfxPoolItem& ) const;
    virtual String              GetValueText() const{DBG_BF_ASSERT(0, "STRIP"); return String();} //STRIP001 virtual String              GetValueText() const;
    virtual SfxPoolItem*        Clone( SfxItemPool *pPool = 0 ) const;
};

typedef SfxUsrAnyItem SfxUnoAnyItem;

}//end of namespace binfilter
#endif
