/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_zoomctrl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 21:33:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _STATUS_HXX //autogen
#include <vcl/status.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#pragma hdrstop

#include "dialogs.hrc"

#include "zoomctrl.hxx"
#include "zoomitem.hxx"
#include "stbctrls.h"
namespace binfilter {

/*N*/ SFX_IMPL_STATUSBAR_CONTROL(SvxZoomStatusBarControl,SvxZoomItem);

// class ZoomPopup_Impl --------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// class SvxZoomStatusBarControl ------------------------------------------

/*N*/ SvxZoomStatusBarControl::SvxZoomStatusBarControl( USHORT nId,
/*N*/ 												  StatusBar& rStb,
/*N*/ 												  SfxBindings& rBind ) :
/*N*/ 
/*N*/ 	SfxStatusBarControl( nId, rStb, rBind ),
/*N*/ 
/*N*/ 	nZoom( 100 ),
/*N*/ 
/*N*/ 	nValueSet( SVX_ZOOM_ENABLE_ALL )
/*N*/ 
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxZoomStatusBarControl::StateChanged( USHORT nSID, SfxItemState eState,
/*N*/ 											const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	if( SFX_ITEM_AVAILABLE != eState )
/*N*/ 	{
/*N*/ 		GetStatusBar().SetItemText( GetId(), String() );
/*N*/ 		nValueSet = 0;
/*N*/ 	}
/*N*/ 	else if ( pState->ISA( SfxUInt16Item) )
/*N*/ 	{
/*N*/ 		const SfxUInt16Item* pItem = (const SfxUInt16Item*)pState;
/*N*/ 		nZoom = pItem->GetValue();
/*N*/ 		String aStr( String::CreateFromInt32(nZoom) );
/*N*/ 		aStr += '%';
/*N*/ 		GetStatusBar().SetItemText( GetId(), aStr );
/*N*/ 
/*N*/ 		if ( pState->ISA(SvxZoomItem) )
/*N*/ 		{
/*N*/ 			nValueSet = ((const SvxZoomItem*)pState)->GetValueSet();
/*N*/ 			SvxZoomType eType = ((const SvxZoomItem*)pState)->GetType();
/*N*/ 
/*!!!
			switch ( eType )
			{
				case SVX_ZOOM_OPTIMAL:
					GetStatusBar().SetItemText( GetId(), "Opt." );
					break;
				case SVX_ZOOM_WHOLEPAGE:
					GetStatusBar().SetItemText( GetId(), "Page" );
					break;
				case SVX_ZOOM_PAGEWIDTH:
					GetStatusBar().SetItemText( GetId(), "Width" );
					break;
			}
*/
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			DBG_WARNING( "use SfxZoomItem for SID_ATTR_ZOOM" );
/*N*/ 			nValueSet = SVX_ZOOM_ENABLE_ALL;
/*N*/ 		}
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


/*N*/ ULONG SvxZoomStatusBarControl::GetDefItemWidth(const StatusBar& rStb)
/*N*/ {
/*N*/ 	long nWidth1 =  rStb.GetTextWidth(String::CreateFromAscii("XXXXX%"));
/*N*/ 	return nWidth1;
/*N*/ }


}
