/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_selctrl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 21:33:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _STATUS_HXX //autogen
#include <vcl/status.hxx>
#endif
#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#pragma hdrstop

#define _SVX_SELCTRL_CXX

#include "selctrl.hxx"
#include "dialmgr.hxx"

#include "dialogs.hrc"
namespace binfilter {

#define PAINT_OFFSET	5

/*N*/ SFX_IMPL_STATUSBAR_CONTROL(SvxSelectionModeControl, SfxUInt16Item);

// class SvxSelectionModeControl -----------------------------------------

/*N*/ SvxSelectionModeControl::SvxSelectionModeControl( USHORT nId,
/*N*/ 												  StatusBar& rStb,
/*N*/ 												  SfxBindings& rBind ) :
/*N*/ 	SfxStatusBarControl( nId, rStb, rBind ),
/*N*/ 
/*N*/ 	nState( 0 )
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxSelectionModeControl::StateChanged( USHORT nSID, SfxItemState eState,
/*N*/ 											const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	if ( SFX_ITEM_AVAILABLE != eState )
/*N*/ 		GetStatusBar().SetItemText( GetId(), String() );
/*N*/ 	else
/*N*/ 	{
/*N*/ 		DBG_ASSERT( pState->ISA( SfxUInt16Item ), "invalid item type" );
/*N*/ 		SfxUInt16Item* pItem = (SfxUInt16Item*)pState;
/*N*/ 		nState = pItem->GetValue();
/*N*/ 		DrawItemText_Impl();
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ void SvxSelectionModeControl::DrawItemText_Impl()
/*N*/ {
/*N*/ 	String sTxt;
/*N*/ 	USHORT nId = 0;
/*N*/ 
/*N*/ 	switch ( nState )
/*N*/ 	{
/*N*/ 		case 0:
/*N*/ 			nId = RID_SVXSTR_SELMODE_STD;
/*N*/ 			break;
/*N*/ 		case 1:
/*?*/ 			nId = RID_SVXSTR_SELMODE_ER;
/*?*/ 			break;
/*?*/ 		case 2:
/*?*/ 			nId = RID_SVXSTR_SELMODE_ERG;
/*?*/ 			break;
/*?*/ 		default: DBG_ERROR( "invalid selection mode!" );
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( nId )
/*N*/ 		sTxt = SVX_RESSTR( nId );
/*N*/ 	GetStatusBar().SetItemText( GetId(), sTxt );
/*N*/ }

/*N*/ ULONG SvxSelectionModeControl::GetDefItemWidth(const StatusBar& rStb)
/*N*/ {
/*N*/ 	long nWidth1 =  rStb.GetTextWidth(SVX_RESSTR(RID_SVXSTR_SELMODE_STD));
/*N*/ 	long nWidth2 =  rStb.GetTextWidth(SVX_RESSTR(RID_SVXSTR_SELMODE_ER));
/*N*/ 	long nWidth3 =  rStb.GetTextWidth(SVX_RESSTR(RID_SVXSTR_SELMODE_ERG));
/*N*/ 
/*N*/ 	if(nWidth1<nWidth2)
/*N*/ 		nWidth1=nWidth2;
/*N*/ 
/*N*/ 	if(nWidth1<nWidth3)
/*N*/ 		nWidth1=nWidth3;
/*N*/ 
/*N*/ 	return nWidth1+PAINT_OFFSET;
/*N*/ }


}
