/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: galmisc.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 12:01:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVX_GALMISC_HXX_
#define _SVX_GALMISC_HXX_

#include <svtools/imap.hxx>
#include <svtools/hint.hxx>
#include "svdio.hxx"
#include "svdobj.hxx"
#include "so3/staticbaseurl.hxx"

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
class ResMgr;
class String;
class SvStream;
class Graphic;
class ImageMap;
class GraphicFilter;
namespace binfilter {
class BfGraphicObject;

// -----------
// - Defines -
// -----------

#define IV_IMAPINFO			    (UINT32('S')*0x00000001+UINT32('D')*0x00000100+UINT32('U')*0x00010000+UINT32('D')*0x01000000)
#define	ID_IMAPINFO			    2
                                
#define USERDATA_HDL()		    (LINK(this,SgaUserDataFactory,MakeUserData))
                                
#define GAL_RESID( nId )	    ResId( nId, GetGalleryResMgr() )
#define STREAMBUF_SIZE		    16384L
                                
#define	SGA_IMPORT_NONE		    0x0000
#define	SGA_IMPORT_FILE		    0x0001
#define	SGA_IMPORT_INET		    0x0002

#define GALLERY_PROGRESS_RANGE  10000

#define GALLERY_FG_COLOR        Application::GetSettings().GetStyleSettings().GetWindowTextColor()
#define GALLERY_BG_COLOR        Application::GetSettings().GetStyleSettings().GetWindowColor()
#define GALLERY_DLG_COLOR       Application::GetSettings().GetStyleSettings().GetDialogColor()

// -------------
// - Functions -
// -------------

class FmFormModel;
class Gallery;



// ---------------
// - SgaIMapInfo -
// ---------------

class SgaIMapInfo : public SdrObjUserData, public SfxListener
{
	ImageMap				aImageMap;

public:
							SgaIMapInfo() : SdrObjUserData( IV_IMAPINFO, ID_IMAPINFO, 0 ) {};

							SgaIMapInfo( const ImageMap& rImageMap) :
								SdrObjUserData( IV_IMAPINFO, ID_IMAPINFO, 0 ),
								aImageMap( rImageMap ) {};

	virtual 				~SgaIMapInfo() {};

	virtual SdrObjUserData* Clone( SdrObject* pObj ) const
							{
								SgaIMapInfo* pInfo = new SgaIMapInfo;
								pInfo->aImageMap = aImageMap;
								return pInfo;
							}

	virtual void			ReadData( SvStream& rIStm )
							{
								SdrObjUserData::ReadData( rIStm );
								SdrDownCompat	aIO( rIStm, STREAM_READ, TRUE );
								UINT16			nVer;
								rIStm >> nVer;
								aImageMap.Read(
                                    rIStm,
                                    so3::StaticBaseUrl::GetBaseURL(
                                        INetURLObject::NO_DECODE));
							}

	virtual void			WriteData( SvStream& rOStm )
							{
								SdrObjUserData::WriteData( rOStm );
								SdrDownCompat	aIO( rOStm, STREAM_WRITE, TRUE );
								const UINT16	nVer = 1;
								rOStm << nVer;
								aImageMap.Write(
                                    rOStm,
                                    so3::StaticBaseUrl::GetBaseURL(
                                        INetURLObject::NO_DECODE));
							}

	const ImageMap&			GetImageMap() const { return aImageMap; }
};

// ----------------------
// - SgaUserDataFactory -
// ----------------------


// -------------------
// - GalleryProgress -
// -------------------



// -----------------------
// - GalleryTransferable -
// -----------------------

class Gallery;
class GalleryTheme;


// ---------------
// - GalleryHint -
// ---------------

#define GALLERY_HINT_NONE				0x00000000
#define GALLERY_HINT_CLOSE_THEME		0x00000001
#define GALLERY_HINT_THEME_REMOVED		0x00000002
#define GALLERY_HINT_THEME_RENAMED		0x00000004
#define GALLERY_HINT_THEME_CREATED		0x00000008
#define GALLERY_HINT_THEME_UPDATEVIEW	0x00000010

// -----------------------------------------------------------------------------

class GalleryHint : public SfxHint
{
private:

	ULONG			mnType;
	String			maThemeName;
	String			maStringData;
	ULONG			mnData1;
	ULONG			mnData2;

public:
		
					GalleryHint( ULONG nType, const String& rThemeName, ULONG nData1 = 0UL, ULONG nData2 = 0UL ) :
						mnType( nType ), maThemeName( rThemeName ), mnData1( nData1 ), mnData2( nData2 ) {}
					
					GalleryHint( ULONG nType, const String& rThemeName, const String& rStringData, ULONG nData1 = 0UL, ULONG nData2 = 0UL ) :
						mnType( nType ), maThemeName( rThemeName ), maStringData( rStringData ), mnData1( nData1 ), mnData2( nData2 ) {}

	ULONG			GetType() const { return mnType; }
	const String&	GetThemeName() const { return maThemeName; }
	const String&	GetStringData() const { return maStringData; }
	ULONG			GetData1() const { return mnData1; }
	ULONG			GetData2() const { return mnData2; }
};
}//end of namespace binfilter
#endif
