/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tbxform.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 21:00:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif



#pragma hdrstop

#ifndef _SVX_DIALOGS_HRC
#include "dialogs.hrc"
#endif


#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#ifndef _TBXDRAW_HXX
#include "tbxdraw.hxx"
#endif
#ifndef _SVX_TBXFORM_HXX
#include "tbxform.hxx"
#endif
#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif
#ifndef _SVX_FMHELP_HRC
#include "fmhelp.hrc"
#endif

#ifndef _SFXVIEWFRM_HXX
#include <bf_sfx2/viewfrm.hxx>
#endif
namespace binfilter {

//========================================================================
// class FmInputRecordNoDialog
//========================================================================


//========================================================================
// class SvxFmAbsRecWin
//========================================================================

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------


//========================================================================
// class SvxFmConfigWin
//========================================================================

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

//-----------------------------------------------------------------------

//========================================================================
// class SvxFmTbxCtlConfig
//========================================================================

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxCtlConfig, SfxUInt16Item );

//-----------------------------------------------------------------------
/*N*/ SvxFmTbxCtlConfig::SvxFmTbxCtlConfig( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings)
/*N*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*N*/ 	,nLastSlot( 0 )
/*N*/ {
/*N*/ }

//-----------------------------------------------------------------------
/*N*/ void SvxFmTbxCtlConfig::StateChanged(USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	if (nSID == SID_FM_CONFIG)
/*N*/ 	{
/*N*/ 		UINT16 nSlot   = 0;
/*N*/ 		if (eState >= SFX_ITEM_AVAILABLE)
/*N*/ 			nSlot = ((SfxUInt16Item*)pState)->GetValue();
/*N*/ 
/*N*/ 		switch( nSlot )
/*N*/ 		{
/*N*/ 			case SID_FM_PUSHBUTTON:
/*N*/ 			case SID_FM_RADIOBUTTON:
/*N*/ 			case SID_FM_CHECKBOX:
/*N*/ 			case SID_FM_FIXEDTEXT:
/*N*/ 			case SID_FM_GROUPBOX:
/*N*/ 			case SID_FM_LISTBOX:
/*N*/ 			case SID_FM_COMBOBOX:
/*N*/ 			case SID_FM_URLBUTTON:
/*N*/ 			case SID_FM_EDIT:
/*N*/ 			case SID_FM_DBGRID:
/*N*/ 			case SID_FM_IMAGEBUTTON:
/*N*/ 			case SID_FM_IMAGECONTROL:
/*N*/ 			case SID_FM_FILECONTROL:
/*N*/ 			case SID_FM_DATEFIELD:
/*N*/ 			case SID_FM_TIMEFIELD:
/*N*/ 			case SID_FM_NUMERICFIELD:
/*N*/ 			case SID_FM_CURRENCYFIELD:
/*N*/ 			case SID_FM_PATTERNFIELD:
/*N*/ 			case SID_FM_DESIGN_MODE:
/*N*/ 			case SID_FM_FORMATTEDFIELD:
/*N*/ 			{	// set a new image, matching to this slot
/*N*/                 SfxViewFrame* pFrame = GetBindings().GetDispatcher()->GetFrame();
/*N*/ 				GetToolBox().SetItemImage( SID_FM_CONFIG, pFrame->GetImageManager()->GetImage( nSlot, GetToolBox().GetDisplayBackground().GetColor().IsDark() ) );
/*N*/ 				nLastSlot = nSlot;
/*N*/ 			}
/*N*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	SfxToolBoxControl::StateChanged( nSID, eState,pState );
/*N*/ }

//-----------------------------------------------------------------------

//-----------------------------------------------------------------------

//-----------------------------------------------------------------------


//========================================================================
// class SvxFmTbxCtlAbsRec
//========================================================================

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxCtlAbsRec, SfxInt32Item );
//-----------------------------------------------------------------------
/*?*/ SvxFmTbxCtlAbsRec::SvxFmTbxCtlAbsRec( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	DBG_CTOR(SvxFmTbxCtlAbsRec,NULL);
/*?*/ }

//-----------------------------------------------------------------------

//-----------------------------------------------------------------------

//-----------------------------------------------------------------------


//========================================================================
// SvxFmTbxCtlRecText
//========================================================================

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxCtlRecText, SfxBoolItem );
//-----------------------------------------------------------------------
/*?*/ SvxFmTbxCtlRecText::SvxFmTbxCtlRecText( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	DBG_CTOR(SvxFmTbxCtlRecText,NULL);
/*?*/ }

//-----------------------------------------------------------------------

//-----------------------------------------------------------------------


//========================================================================
// SvxFmTbxCtlRecFromText
//========================================================================

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxCtlRecFromText, SfxBoolItem );
//-----------------------------------------------------------------------
/*?*/ SvxFmTbxCtlRecFromText::SvxFmTbxCtlRecFromText( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	DBG_CTOR(SvxFmTbxCtlRecFromText,NULL);
/*?*/ }

//-----------------------------------------------------------------------

//-----------------------------------------------------------------------


//========================================================================
// SvxFmTbxCtlRecTotal
//========================================================================
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxCtlRecTotal, SfxStringItem );

//-----------------------------------------------------------------------
/*?*/ SvxFmTbxCtlRecTotal::SvxFmTbxCtlRecTotal( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ 	,pFixedText( NULL )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	DBG_CTOR(SvxFmTbxCtlRecTotal,NULL);
/*?*/ }

//-----------------------------------------------------------------------

//-----------------------------------------------------------------------

//-----------------------------------------------------------------------

/*
//========================================================================
// SvxFmTbxCtlRecTotal
//========================================================================
SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxCtlFilterText, SfxBoolItem );

//-----------------------------------------------------------------------
SvxFmTbxCtlFilterText::SvxFmTbxCtlFilterText( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
	:SfxToolBoxControl( nId, rTbx, rBindings )
	,pFixedText( NULL )
	,aText(SVX_RES(RID_STR_FORM_FILTERED))
{
}

//-----------------------------------------------------------------------
SvxFmTbxCtlFilterText::~SvxFmTbxCtlFilterText()
{
}

//-----------------------------------------------------------------------
Window*	SvxFmTbxCtlFilterText::CreateItemWindow( Window* pParent )
{
	pFixedText = new FixedText( pParent );
	Size aSize = pFixedText->GetTextSize( aText );
	aSize.Width() += 6;
	pFixedText->SetSizePixel( aSize );

	return pFixedText;
}

//-----------------------------------------------------------------------
void SvxFmTbxCtlFilterText::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
{
	//////////////////////////////////////////////////////////////////////
	// Setzen des FixedTextes
	if (GetId() != SID_FM_FORM_FILTERED)
		return;

	if (pState && ((SfxBoolItem*)pState)->GetValue())
		pFixedText->SetText( aText );
	else
		pFixedText->SetText( "" );

	SfxToolBoxControl::StateChanged( nSID, eState,pState );
}	  */

//========================================================================
// SvxFmTbxNextRec
//========================================================================
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxNextRec, SfxBoolItem );

//-----------------------------------------------------------------------
/*?*/ SvxFmTbxNextRec::SvxFmTbxNextRec( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	rTbx.SetItemBits(nId, rTbx.GetItemBits(nId) | TIB_REPEAT);
/*?*/ }

//========================================================================
// SvxFmTbxPrevRec
//========================================================================
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxPrevRec, SfxBoolItem );

//-----------------------------------------------------------------------
/*?*/ SvxFmTbxPrevRec::SvxFmTbxPrevRec( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	rTbx.SetItemBits(nId, rTbx.GetItemBits(nId) | TIB_REPEAT);
/*?*/ }


}
