/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fmshell.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 20:57:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _SVX_FMSHELL_HXX
#include "fmshell.hxx"
#endif
#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif





#ifndef _SFXVIEWFRM_HXX
#include <bf_sfx2/viewfrm.hxx>
#endif



#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif



#ifndef _SFXOBJFACE_HXX //autogen
#include <bf_sfx2/objface.hxx>
#endif

#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif

#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif



#ifndef _SVX_FMPAGE_HXX
#include "fmpage.hxx"
#endif



#ifndef _SVX_SVXIDS_HRC
#include "svxids.hrc"
#endif


#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif


#ifndef _SVX_FMGLOB_HXX
#include "fmglob.hxx"
#endif




#ifndef _SVX_FMMODEL_HXX
#include "fmmodel.hxx"
#endif

#ifndef _SVX_DIALMGR_HXX
#include "dialmgr.hxx"
#endif

#ifndef _COM_SUN_STAR_SDBC_XROWSETLISTENER_HPP_
#include <com/sun/star/sdbc/XRowSetListener.hpp>
#endif

#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif

#ifndef _SVX_FMSHIMP_HXX
#include "fmshimp.hxx"
#endif

#ifndef _SVDPAGV_HXX //autogen
#include "svdpagv.hxx"
#endif

#ifndef _SFX_OBJITEM_HXX //autogen
#include <bf_sfx2/objitem.hxx>
#endif

#ifndef _SFXVIEWSH_HXX //autogen
#include <bf_sfx2/viewsh.hxx>
#endif


#ifndef _SVX_FMEXPL_HXX
#include "fmexpl.hxx"
#endif


#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include <connectivity/dbtools.hxx>
#endif
namespace binfilter {

#define HANDLE_SQL_ERRORS( action, successflag, context, message )			\
	try 																	\
	{																		\
		successflag = sal_False;												\
		action; 															\
		successflag = sal_True; 												\
	}																		\
	catch(::com::sun::star::sdbc::SQLException& e)													\
	{																		\
		::com::sun::star::sdb::SQLContext eExtendedInfo =											\
		GetImpl()->prependContextInfo(e, Reference< XInterface > (), context, ::rtl::OUString());			   \
		displayException(eExtendedInfo);									\
	}																		\
	catch(Exception&)															\
	{																		\
		DBG_ERROR(message); 												\
	}																		\


#define DO_SAFE_WITH_ERROR( action, message ) try { action; } catch(Exception&) { DBG_ERROR(message); }


extern SfxType0 aSfxVoidItem_Impl;

#define FmFormShell
#include <svxslots.hxx>
} //namespace binfilter
#ifndef _SVX_SVXIDS_HRC
#include <svxids.hrc>
#endif


namespace binfilter {//STRIP009
// wird fuer Invalidate verwendet -> mitpflegen
// aufsteigend sortieren !!!!!!
sal_uInt16 ControllerSlotMap[] =	// slots des Controllers
{
	SID_FM_CONFIG,
	SID_FM_PUSHBUTTON,
	SID_FM_RADIOBUTTON,
	SID_FM_CHECKBOX,
	SID_FM_FIXEDTEXT,
	SID_FM_GROUPBOX,
	SID_FM_EDIT,
	SID_FM_LISTBOX,
	SID_FM_COMBOBOX,
	SID_FM_URLBUTTON,
	SID_FM_DBGRID,
	SID_FM_IMAGEBUTTON,
	SID_FM_FILECONTROL,
	SID_FM_CTL_PROPERTIES,
	SID_FM_PROPERTIES,
	SID_FM_TAB_DIALOG,
	SID_FM_ADD_FIELD,
	SID_FM_DESIGN_MODE,
	SID_FM_SHOW_FMEXPLORER,
	SID_FM_SHOW_PROPERTIES,
	SID_FM_FMEXPLORER_CONTROL,
	SID_FM_DATEFIELD,
	SID_FM_TIMEFIELD,
	SID_FM_NUMERICFIELD,
	SID_FM_CURRENCYFIELD,
	SID_FM_PATTERNFIELD,
	SID_FM_OPEN_READONLY,
	SID_FM_IMAGECONTROL,
	SID_FM_USE_WIZARDS,
	SID_FM_FORMATTEDFIELD,
	SID_FM_FILTER_NAVIGATOR,
	SID_FM_AUTOCONTROLFOCUS,

	0
};

sal_uInt16 DatabaseSlotMap[] =	// slots des Controllers
{
	SID_FM_RECORD_FIRST,
	SID_FM_RECORD_NEXT,
	SID_FM_RECORD_PREV,
	SID_FM_RECORD_LAST,
	SID_FM_RECORD_NEW,
	SID_FM_RECORD_DELETE,
	SID_FM_RECORD_ABSOLUTE,
	SID_FM_RECORD_TOTAL,
	SID_FM_RECORD_SAVE,
	SID_FM_RECORD_UNDO,
	SID_FM_REMOVE_FILTER_SORT,
	SID_FM_SORTUP,
	SID_FM_SORTDOWN,
	SID_FM_ORDERCRIT,
	SID_FM_AUTOFILTER,
	SID_FM_FORM_FILTERED,
	SID_FM_REFRESH,
	SID_FM_SEARCH,
	SID_FM_FILTER_START,
	SID_FM_VIEW_AS_GRID,
	0
};

sal_uInt16 AutoSlotMap[] =
{
	SID_FM_SORTUP,
	SID_FM_SORTDOWN,
	SID_FM_AUTOFILTER,
	0
};
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::form;
using namespace ::binfilter::svxform;//STRIP008 using namespace ::svxform;

//========================================================================
//========================================================================
//#ifdef NOOLDSV
////------------------------------------------------------------------------
///*?*/ FmFormShell::FormShellWaitObject::FormShellWaitObject(const FmFormShell* _pShell)
///*?*/ 	:m_pWindow(NULL)
///*?*/ {
///*?*/ 	const OutputDevice* pDevice = _pShell ? _pShell->GetCurrentViewDevice() : NULL;
///*?*/ 	m_pWindow = pDevice && (pDevice->GetOutDevType() == OUTDEV_WINDOW) ? const_cast<Window*>(static_cast<const Window*>(pDevice)) : NULL;
///*?*/ 
///*?*/ 	if (m_pWindow)
///*?*/ 		m_pWindow->EnterWait();
///*?*/ 	else
///*?*/ 		DBG_ERROR("FormShellWaitObject::FormShellWaitObject : could not find a window for the waitcursor !");
///*?*/ }
///*?*/ //------------------------------------------------------------------------
///*?*/ FmFormShell::FormShellWaitObject::~FormShellWaitObject()
///*?*/ {
///*?*/ 	if (m_pWindow)
///*?*/ 		m_pWindow->LeaveWait();
///*?*/ }
//#else
//class FormShellWaitObject : public WaitObject
//{
//public:
///*?*/ 	FormShellWaitObject(FmFormShell* _pShell) { }
//};
//#endif
//========================================================================
//------------------------------------------------------------------------

//------------------------------------------------------------------------

//------------------------------------------------------------------------

#if SUPD>500
//========================================================================
// class FmDesignModeChangedHint
//========================================================================
/*N*/ TYPEINIT1( FmDesignModeChangedHint, SfxHint );

//------------------------------------------------------------------------
/*N*/ FmDesignModeChangedHint::FmDesignModeChangedHint( sal_Bool bDesMode )
/*N*/ 	:m_bDesignMode( bDesMode )
/*N*/ {
/*N*/ }

//------------------------------------------------------------------------
/*N*/ FmDesignModeChangedHint::~FmDesignModeChangedHint()
/*N*/ {
/*N*/ }
#endif

//========================================================================
const sal_uInt32 FM_UI_FEATURE_SHOW_DATABASEBAR 	= 0x00000001;
const sal_uInt32 FM_UI_FEATURE_SHOW_FIELD			= 0x00000002;
const sal_uInt32 FM_UI_FEATURE_SHOW_PROPERTIES		= 0x00000004;
const sal_uInt32 FM_UI_FEATURE_SHOW_EXPLORER			= 0x00000008;
const sal_uInt32 FM_UI_FEATURE_SHOW_FILTERBAR		= 0x00000010;
const sal_uInt32 FM_UI_FEATURE_SHOW_FILTERNAVIGATOR = 0x00000020;

/*N*/ SFX_IMPL_INTERFACE(FmFormShell, SfxShell, SVX_RES(RID_STR_FORMSHELL))
/*N*/ {
/*N*/ 	SFX_FEATURED_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_NAVIGATION|SFX_VISIBILITY_STANDARD|SFX_VISIBILITY_READONLYDOC,
/*N*/ 		SVX_RES(RID_SVXTBX_FORM_NAVIGATION),
/*N*/ 		FM_UI_FEATURE_SHOW_DATABASEBAR );
/*N*/ 
/*N*/ 	SFX_FEATURED_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_NAVIGATION|SFX_VISIBILITY_STANDARD|SFX_VISIBILITY_READONLYDOC,
/*N*/ 		SVX_RES(RID_SVXTBX_FORM_FILTER),
/*N*/ 		FM_UI_FEATURE_SHOW_FILTERBAR );
/*N*/ 
/*N*/ 	SFX_FEATURED_CHILDWINDOW_REGISTRATION(SID_FM_ADD_FIELD, FM_UI_FEATURE_SHOW_FIELD);
/*N*/ 	SFX_FEATURED_CHILDWINDOW_REGISTRATION(SID_FM_SHOW_PROPERTIES, FM_UI_FEATURE_SHOW_PROPERTIES);
/*N*/ 	SFX_FEATURED_CHILDWINDOW_REGISTRATION(SID_FM_SHOW_FMEXPLORER, FM_UI_FEATURE_SHOW_EXPLORER);
/*N*/ 	SFX_FEATURED_CHILDWINDOW_REGISTRATION(SID_FM_FILTER_NAVIGATOR, FM_UI_FEATURE_SHOW_FILTERNAVIGATOR);
/*N*/ }

//========================================================================
/*N*/ TYPEINIT1(FmFormShell,SfxShell)

//------------------------------------------------------------------------
/*N*/ FmFormShell::FmFormShell( SfxViewShell* _pParent, FmFormView* pView )
/*N*/ 			:SfxShell(_pParent)
/*N*/ 			,m_pFormView( pView )
/*N*/ 			,m_pFormModel( NULL )
/*N*/ 			,m_pImpl(new FmXFormShell(this, _pParent->GetViewFrame()))
/*N*/ 			,m_nLastSlot( 0 )
/*N*/ 			,m_bDesignMode( sal_True )
/*N*/ 			,m_bHasForms(sal_False)
/*N*/ 			,m_pParentShell(_pParent)
/*N*/ {
/*N*/ 	m_pImpl->acquire();
/*N*/ 	SetPool( &SFX_APP()->GetPool() );
/*N*/ 	String sName;
/*N*/ 	sName.AssignAscii("Form");
/*N*/ 	SetName( sName );
/*N*/ 	// SetHelpId( SVX_INTERFACE_FORM_SH );
/*N*/ 
/*N*/ 	SetView(m_pFormView);
/*N*/ }

//------------------------------------------------------------------------
/*N*/ FmFormShell::~FmFormShell()
/*N*/ {
/*N*/ 	if (m_pFormView)
/*N*/ 		GetImpl()->ResetForms();
/*N*/ 
/*N*/ 	m_pImpl->dispose();
/*N*/ 	m_pImpl->release();
/*N*/ 	
/*N*/ 	if (m_pFormView)
/*N*/ 	{
/*N*/ 		m_pFormView->SetFormShell(NULL);
/*N*/ 		m_pFormView  = NULL;
/*N*/ 	}
/*N*/ 	
/*N*/ 
/*N*/ 	// reset the model after disposing the shell !
/*N*/ 	m_pFormModel = NULL;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmFormShell::NotifyMarkListChanged(FmFormView* pWhichView)
/*N*/ {
/*N*/ 	FmNavViewMarksChanged aChangeNotification(pWhichView);
/*N*/ 	Broadcast(aChangeNotification);
/*N*/ }

//------------------------------------------------------------------------
/*N*/ sal_uInt16 FmFormShell::PrepareClose(sal_Bool bUI, sal_Bool bForBrowsing)
/*N*/ {
/*N*/ 	if ( GetImpl()->m_bPreparedClose )
/*N*/ 		// we already did a PrepareClose for the current modifications of the current form
/*N*/ 		// 2002-11-12 #104702# - fs@openoffice.org
/*N*/ 		return sal_True;
/*N*/ 
/*N*/ 	sal_Bool nResult = sal_True;
/*N*/ 	// Save the data records, not in DesignMode and FilterMode
/*N*/ 	if (!m_bDesignMode && !GetImpl()->isInFilterMode() &&
/*N*/ 		m_pFormView && m_pFormView->GetActualOutDev() &&
/*N*/ 		m_pFormView->GetActualOutDev()->GetOutDevType() == OUTDEV_WINDOW)
/*N*/ 	{
/*N*/ 		if (GetImpl()->HasAnyPendingCursorAction())
/*?*/			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 			GetImpl()->CancelAnyPendingCursorAction();
/*?*/ 
/*N*/ 		SdrPageView* pCurPageView = m_pFormView->GetPageViewPvNum(0);
/*N*/ 		sal_uInt16 nPos = pCurPageView ? pCurPageView->GetWinList().Find((OutputDevice*)m_pFormView->GetActualOutDev()) : SDRPAGEVIEWWIN_NOTFOUND;
/*N*/ 		if (nPos != SDRPAGEVIEWWIN_NOTFOUND)
/*N*/ 		{
/*N*/ 			// Zunaechst werden die aktuellen Inhalte der Controls gespeichert
/*N*/ 			// Wenn alles glatt gelaufen ist, werden die modifizierten Datensaetze gespeichert
/*N*/ 			Reference< ::com::sun::star::form::XFormController >  xController(GetImpl()->getActiveController());
/*N*/ 			if (xController.is() && FmXFormShell::CommitCurrent(xController))
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP");//STRIP001 
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return nResult;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmFormShell::SetDesignMode(sal_Bool bDesign)
/*N*/ {
/*N*/ 	if (m_pFormView)
/*N*/ 	{
/*N*/ 		if (!bDesign)
/*N*/ 			m_nLastSlot = SID_FM_DESIGN_MODE;
/*N*/ 
/*N*/ 		GetImpl()->SetDesignMode(bDesign);
/*N*/ 		// mein m_bDesignMode wird auch von der Impl gesetzt ...
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/ 		m_bHasForms = sal_False;
/*?*/ 		m_bDesignMode = bDesign;
/*?*/ 		UIFeatureChanged();
/*N*/ 	}
/*N*/ 
/*N*/ 	GetViewShell()->GetViewFrame()->GetBindings().Invalidate(ControllerSlotMap);
/*N*/ }

//------------------------------------------------------------------------
/*N*/ sal_Bool FmFormShell::HasUIFeature( sal_uInt32 nFeature )
/*N*/ {
/*N*/ 	sal_Bool bResult = sal_False;
/*N*/ 	if ((nFeature & FM_UI_FEATURE_SHOW_DATABASEBAR) == FM_UI_FEATURE_SHOW_DATABASEBAR)
/*N*/ 	{
/*N*/ 		// nur wenn auch formulare verfuegbar
/*N*/ 		bResult = !m_bDesignMode && GetImpl()->hasDatabaseBar() && !GetImpl()->isInFilterMode();
/*N*/ 	}
/*N*/ 	else if ((nFeature & FM_UI_FEATURE_SHOW_FILTERBAR) == FM_UI_FEATURE_SHOW_FILTERBAR)
/*N*/ 	{
/*N*/ 		// nur wenn auch formulare verfuegbar
/*N*/ 		bResult = !m_bDesignMode && GetImpl()->hasDatabaseBar() && GetImpl()->isInFilterMode();
/*N*/ 	}
/*N*/ 	else if ((nFeature & FM_UI_FEATURE_SHOW_FILTERNAVIGATOR) == FM_UI_FEATURE_SHOW_FILTERNAVIGATOR)
/*N*/ 	{
/*N*/ 		bResult = !m_bDesignMode && GetImpl()->hasDatabaseBar() && GetImpl()->isInFilterMode();
/*N*/ 	}
/*N*/ 	else if ((nFeature & FM_UI_FEATURE_SHOW_FIELD) == FM_UI_FEATURE_SHOW_FIELD)
/*N*/ 	{
/*N*/ 		bResult = m_bDesignMode && m_pFormView && m_bHasForms;
/*N*/ 	}
/*N*/ 	else if ((nFeature & FM_UI_FEATURE_SHOW_PROPERTIES) == FM_UI_FEATURE_SHOW_PROPERTIES)
/*N*/ 	{
/*N*/ 		bResult = m_bDesignMode && m_pFormView && m_bHasForms;
/*N*/ 	}
/*N*/ 	else if ((nFeature & FM_UI_FEATURE_SHOW_EXPLORER) == FM_UI_FEATURE_SHOW_EXPLORER)
/*N*/ 	{
/*N*/ 		bResult = m_bDesignMode; // OJ #101593# && m_pFormView && m_bHasForms;
/*N*/ 	}
/*N*/ 	return bResult;
/*N*/ }
} //namespace binfilter
namespace binfilter {//STRIP009
//------------------------------------------------------------------------
/*N*/ void FmFormShell::Execute(SfxRequest &rReq)
/*N*/ {
/*N*/ 	sal_uInt16 nSlot = rReq.GetSlot();
/*N*/ 
/*N*/ 	//////////////////////////////////////////////////////////////////////
/*N*/ 	// MasterSlot setzen
/*N*/ 	switch( nSlot )
/*N*/ 	{
/*N*/ 		case SID_FM_PUSHBUTTON:
/*N*/ 		case SID_FM_RADIOBUTTON:
/*N*/ 		case SID_FM_CHECKBOX:
/*N*/ 		case SID_FM_FIXEDTEXT:
/*N*/ 		case SID_FM_GROUPBOX:
/*N*/ 		case SID_FM_LISTBOX:
/*N*/ 		case SID_FM_COMBOBOX:
/*N*/ 		case SID_FM_URLBUTTON:
/*N*/ 		case SID_FM_EDIT:
/*N*/ 		case SID_FM_DBGRID:
/*N*/ 		case SID_FM_IMAGEBUTTON:
/*N*/ 		case SID_FM_IMAGECONTROL:
/*N*/ 		case SID_FM_FILECONTROL:
/*N*/ 		case SID_FM_DATEFIELD:
/*N*/ 		case SID_FM_TIMEFIELD:
/*N*/ 		case SID_FM_NUMERICFIELD:
/*N*/ 		case SID_FM_CURRENCYFIELD:
/*N*/ 		case SID_FM_PATTERNFIELD:
/*N*/ 		case SID_FM_FORMATTEDFIELD:
/*?*/ 			m_nLastSlot = nSlot;
/*?*/ 			GetViewShell()->GetViewFrame()->GetBindings().Invalidate( SID_FM_CONFIG );
/*?*/ 			break;
/*N*/ 		case SID_FM_DESIGN_MODE:	// gibt es was zu tun?
/*N*/ 		{
/*N*/ 			// if we are moving our data source cursor currently ....
/*N*/ 			if (GetImpl()->HasAnyPendingCursorAction())
/*N*/ 				// ... cancel this
/*?*/				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				GetImpl()->CancelAnyPendingCursorAction();
/*N*/ 
/*N*/ 			SFX_REQUEST_ARG(rReq, pDesignItem, SfxBoolItem, nSlot, sal_False);
/*N*/ 			if (!pDesignItem || pDesignItem->GetValue() != m_bDesignMode)
/*N*/ 			{
/*N*/ 				m_nLastSlot = nSlot;
/*N*/ 				GetViewShell()->GetViewFrame()->GetBindings().Invalidate( SID_FM_CONFIG );
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				rReq.Done();
/*N*/ 				return;
/*N*/ 			}
/*N*/ 		}	break;
/*N*/ 	}
/*N*/ 
/*N*/ 	//////////////////////////////////////////////////////////////////////
/*N*/ 	// Identifier und Inventor des Uno-Controls setzen
/*N*/ 	sal_uInt16 nIdentifier = 0;
/*N*/ 	switch( nSlot )
/*N*/ 	{
/*?*/ 		case SID_FM_CHECKBOX:
/*?*/ 			nIdentifier = OBJ_FM_CHECKBOX;
/*?*/ 			break;
/*?*/ 		case SID_FM_PUSHBUTTON:
/*?*/ 			nIdentifier = OBJ_FM_BUTTON;
/*?*/ 			break;
/*?*/ 		case SID_FM_FIXEDTEXT:
/*?*/ 			nIdentifier = OBJ_FM_FIXEDTEXT;
/*?*/ 			break;
/*?*/ 		case SID_FM_LISTBOX:
/*?*/ 			nIdentifier = OBJ_FM_LISTBOX;
/*?*/ 			break;
/*?*/ 		case SID_FM_EDIT:
/*?*/ 			nIdentifier = OBJ_FM_EDIT;
/*?*/ 			break;
/*?*/ 		case SID_FM_RADIOBUTTON:
/*?*/ 			nIdentifier = OBJ_FM_RADIOBUTTON;
/*?*/ 			break;
/*?*/ 		case SID_FM_GROUPBOX:
/*?*/ 			nIdentifier = OBJ_FM_GROUPBOX;
/*?*/ 			break;
/*?*/ 		case SID_FM_COMBOBOX:
/*?*/ 			nIdentifier = OBJ_FM_COMBOBOX;
/*?*/ 			break;
/*?*/ 		case SID_FM_DBGRID:
/*?*/ 			nIdentifier = OBJ_FM_GRID;
/*?*/ 			break;
/*?*/ 		case SID_FM_IMAGEBUTTON:
/*?*/ 			nIdentifier = OBJ_FM_IMAGEBUTTON;
/*?*/ 			break;
/*?*/ 		case SID_FM_IMAGECONTROL:
/*?*/ 			nIdentifier = OBJ_FM_IMAGECONTROL;
/*?*/ 			break;
/*?*/ 		case SID_FM_FILECONTROL:
/*?*/ 			nIdentifier = OBJ_FM_FILECONTROL;
/*?*/ 			break;
/*?*/ 		case SID_FM_DATEFIELD:
/*?*/ 			nIdentifier = OBJ_FM_DATEFIELD;
/*?*/ 			break;
/*?*/ 		case SID_FM_TIMEFIELD:
/*?*/ 			nIdentifier = OBJ_FM_TIMEFIELD;
/*?*/ 			break;
/*?*/ 		case SID_FM_NUMERICFIELD:
/*?*/ 			nIdentifier = OBJ_FM_NUMERICFIELD;
/*?*/ 			break;
/*?*/ 		case SID_FM_CURRENCYFIELD:
/*?*/ 			nIdentifier = OBJ_FM_CURRENCYFIELD;
/*?*/ 			break;
/*?*/ 		case SID_FM_PATTERNFIELD:
/*?*/ 			nIdentifier = OBJ_FM_PATTERNFIELD;
/*?*/ 			break;
/*?*/ 		case SID_FM_FORMATTEDFIELD:
/*?*/ 			nIdentifier = OBJ_FM_FORMATTEDFIELD;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	switch ( nSlot )
/*N*/ 	{
/*N*/ 		case SID_FM_CHECKBOX:
/*N*/ 		case SID_FM_PUSHBUTTON:
/*N*/ 		case SID_FM_FIXEDTEXT:
/*N*/ 		case SID_FM_LISTBOX:
/*N*/ 		case SID_FM_EDIT:
/*N*/ 		case SID_FM_RADIOBUTTON:
/*N*/ 		case SID_FM_COMBOBOX:
/*N*/ 		case SID_FM_GROUPBOX:
/*N*/ 		case SID_FM_DBGRID:
/*N*/ 		case SID_FM_IMAGEBUTTON:
/*N*/ 		case SID_FM_IMAGECONTROL:
/*N*/ 		case SID_FM_FILECONTROL:
/*N*/ 		case SID_FM_DATEFIELD:
/*N*/ 		case SID_FM_TIMEFIELD:
/*N*/ 		case SID_FM_NUMERICFIELD:
/*N*/ 		case SID_FM_CURRENCYFIELD:
/*N*/ 		case SID_FM_PATTERNFIELD:
/*N*/ 		case SID_FM_FORMATTEDFIELD:
/*N*/ 		{
/*?*/ 			SFX_REQUEST_ARG( rReq, pGrabFocusItem, SfxBoolItem, SID_FM_GRABCONTROLFOCUS, sal_False );
/*?*/ 			if ( pGrabFocusItem && pGrabFocusItem->GetValue() )
/*?*/ 			{	// see below
/*?*/ 				SfxViewShell* pShell = GetViewShell();
/*?*/ 				Window* pShellWnd = pShell ? pShell->GetWindow() : NULL;
/*?*/ 				if ( pShellWnd )
/*?*/ 					pShellWnd->GrabFocus();
/*?*/ 				break;
/*?*/ 			}
/*?*/ 
/*?*/ 			SfxUInt16Item aIdentifierItem( SID_FM_CONTROL_IDENTIFIER, nIdentifier );
/*?*/ 			SfxUInt32Item aInventorItem( SID_FM_CONTROL_INVENTOR, FmFormInventor );
/*?*/ 			const SfxPoolItem* pArgs[] =
/*?*/ 			{
/*?*/ 				&aIdentifierItem, &aInventorItem, NULL
/*?*/ 			};
/*?*/ 			const SfxPoolItem* pInternalArgs[] =
/*?*/ 			{
/*?*/ 				NULL
/*?*/ 			};
/*?*/ 
/*?*/ 			GetViewShell()->GetViewFrame()->GetDispatcher()->Execute( SID_FM_CREATE_CONTROL, SFX_CALLMODE_ASYNCHRON,
/*?*/ 									  pArgs, rReq.GetModifier(), pInternalArgs );
/*?*/ 
/*?*/ 			if ( rReq.GetModifier() & KEY_MOD1 )
/*?*/ 			{
/*?*/ 				//	#99013# if selected with control key, return focus to current view
/*?*/ 				// do this asynchron, so that the creation can be finished first
/*?*/ 				// reusing the SID_FM_GRABCONTROLFOCUS is somewhat hacky ... which it wouldn't if it would have another
/*?*/ 				// name, so I do not really have a big problem with this ....
/*?*/ 				SfxBoolItem aGrabFocusIndicatorItem( SID_FM_GRABCONTROLFOCUS, sal_True );
/*?*/ 				GetViewShell()->GetViewFrame()->GetDispatcher()->Execute( nSlot, SFX_CALLMODE_ASYNCHRON,
/*?*/ 										  &aGrabFocusIndicatorItem, NULL );
/*?*/ 			}
/*?*/ 
/*?*/ 			rReq.Done();
/*N*/ 		}	break;
/*N*/ 	}
/*N*/ 
/*N*/ 	sal_Bool bSortUp = sal_True;
/*N*/ 	// Individuelle Aktionen
	switch( nSlot )
/*?*/ 	{{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 
/*?*/ 	}
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmFormShell::GetState(SfxItemSet &rSet)
/*N*/ {
/*N*/ 	SfxWhichIter aIter( rSet );
/*N*/ 	sal_uInt16 nWhich = aIter.FirstWhich();
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		switch( nWhich )
/*N*/ 		{
/*N*/ 			case SID_FM_FILTER_EXECUTE:
/*N*/ 			case SID_FM_FILTER_EXIT:
/*?*/ 				if (!GetImpl()->isInFilterMode())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_FM_USE_WIZARDS:
/*?*/ 				if (!m_bDesignMode || !GetFormModel())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 					rSet.Put( SfxBoolItem(nWhich, GetImpl()->GetWizardUsing() ) );
/*?*/ 				break;
/*?*/ 			case SID_FM_AUTOCONTROLFOCUS:
/*?*/ 				if (!m_bDesignMode || !GetFormModel())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 					rSet.Put( SfxBoolItem(nWhich, GetFormModel()->GetAutoControlFocus() ) );
/*?*/ 				break;
/*?*/ 			case SID_FM_OPEN_READONLY:
/*?*/ 				if (!m_bDesignMode || !GetFormModel())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 					rSet.Put( SfxBoolItem(nWhich, GetFormModel()->GetOpenInDesignMode() ) );
/*?*/ 				break;
/*?*/ 			case SID_FM_RADIOBUTTON:
/*?*/ 			case SID_FM_COMBOBOX:
/*?*/ 			case SID_FM_URLBUTTON:
/*?*/ 			case SID_FM_GROUPBOX:
/*?*/ 			case SID_FM_CHECKBOX:
/*?*/ 			case SID_FM_PUSHBUTTON:
/*?*/ 			case SID_FM_FIXEDTEXT:
/*?*/ 			case SID_FM_LISTBOX:
/*?*/ 			case SID_FM_EDIT:
/*?*/ 			case SID_FM_DBGRID:
/*?*/ 			case SID_FM_IMAGEBUTTON:
/*?*/ 			case SID_FM_IMAGECONTROL:
/*?*/ 			case SID_FM_FILECONTROL:
/*?*/ 			case SID_FM_DATEFIELD:
/*?*/ 			case SID_FM_TIMEFIELD:
/*?*/ 			case SID_FM_NUMERICFIELD:
/*?*/ 			case SID_FM_CURRENCYFIELD:
/*?*/ 			case SID_FM_PATTERNFIELD:
/*?*/ 			case SID_FM_FORMATTEDFIELD:
/*?*/ 				if (!m_bDesignMode)
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 				{
/*?*/ 					sal_Bool bLayerLocked = sal_False;
/*?*/ 					if (m_pFormView)
/*?*/ 					{
/*?*/ 						// Ist der ::com::sun::star::drawing::Layer gelocked, so mssen die Slots disabled werden. #36897
/*?*/ 						SdrPageView* pPV = m_pFormView->GetPageViewPvNum(0);
/*?*/ 						bLayerLocked = pPV->IsLayerLocked(m_pFormView->GetActiveLayer());
/*?*/ 					}
/*?*/ 					if (bLayerLocked)
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 					else
/*?*/ 						rSet.Put( SfxBoolItem(nWhich, (nWhich==m_nLastSlot)) );
/*?*/ 				}
/*?*/ 				break;
/*?*/ 			case SID_FM_FILTER_NAVIGATOR_CONTROL:
/*?*/ 			{
/*?*/ 				if (GetImpl()->isInFilterMode())
/*?*/ 					rSet.Put(SfxObjectItem(nWhich, this));
/*?*/ 				else
/*?*/ 					rSet.Put(SfxObjectItem(nWhich));
/*?*/ 			}	break;
/*?*/ 			case SID_FM_FIELDS_CONTROL:
/*?*/ 			case SID_FM_PROPERTY_CONTROL:
/*?*/ 			{
/*?*/ 				if (!m_bDesignMode || !m_pFormView || !m_bHasForms)
/*?*/ 					rSet.Put(SfxObjectItem(nWhich));
/*?*/ 				else
/*?*/ 					rSet.Put(SfxObjectItem(nWhich, this));
/*?*/ 
/*?*/ 			}	break;
/*?*/ 			case SID_FM_FMEXPLORER_CONTROL:
/*?*/ 			{
/*?*/ 				if (!m_bDesignMode || !m_pFormView)
/*?*/ 					rSet.Put(SfxObjectItem(nWhich));
/*?*/ 				else
/*?*/ 					rSet.Put(SfxObjectItem(nWhich, this));
/*?*/ 
/*?*/ 			}	break;
/*?*/ 			case SID_FM_ADD_FIELD:
/*?*/ 			case SID_FM_SHOW_FMEXPLORER:
/*?*/ 			case SID_FM_SHOW_PROPERTIES:
/*?*/ 			case SID_FM_FILTER_NAVIGATOR:
/*?*/ 			{
/*?*/ 				if ( GetViewShell()->GetViewFrame()->KnowsChildWindow(nWhich) )
/*?*/ 					rSet.Put( SfxBoolItem( nWhich, GetViewShell()->GetViewFrame()->HasChildWindow(nWhich)) );
/*?*/ 				else
/*?*/ 					rSet.DisableItem(nWhich);
/*?*/ 			}	break;
/*?*/ 
/*?*/ 			case SID_FM_SHOW_PROPERTY_BROWSER:
/*?*/ 			{
/*?*/ 				rSet.Put(SfxBoolItem(GetImpl()->IsPropBrwOpen()));
/*?*/ 			} break;
/*?*/ 
/*?*/ 			case SID_FM_CTL_PROPERTIES:
/*?*/ 			{
/*?*/ 				// der Impl eventuell die Moeglichjkeit geben, ihre an der aktuellen MarkList ausgerichteten Objekte
/*?*/ 				// auf den neuesten Stand zu bringen
/*?*/ 				if (GetImpl()->IsSelectionUpdatePending())
/*?*/					 DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					GetImpl()->ForceUpdateSelection(sal_False);
/*?*/ 
/*?*/ 				if (!m_pFormView || !m_bDesignMode || !GetImpl()->getCurControl().is())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 				{
/*?*/ 					sal_Bool bChecked  = GetImpl()->IsPropBrwOpen() && (GetImpl()->getSelObject() == GetImpl()->getCurControl());
/*?*/ 					rSet.Put(SfxBoolItem(nWhich, bChecked));
/*?*/ 				}
/*?*/ 			}	break;
/*?*/ 
/*?*/ 			case SID_FM_PROPERTIES:
/*?*/ 			{
/*?*/ 				// der Impl eventuell die Moeglichjkeit geben, ihre an der aktuellen MarkList ausgerichteten Objekte
/*?*/ 				// auf den neuesten Stand zu bringen
/*?*/ 				if (GetImpl()->IsSelectionUpdatePending())
/*?*/					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					GetImpl()->ForceUpdateSelection(sal_False);
/*?*/ 
/*?*/ 				if (!m_pFormView || !m_bDesignMode || !GetImpl()->getCurForm().is())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 				{
/*?*/ 					// aktuelle form
/*?*/ 					Reference< ::com::sun::star::form::XForm >	xForm(GetImpl()->getSelObject(), UNO_QUERY);
/*?*/ 					sal_Bool bChecked = GetImpl()->IsPropBrwOpen() && xForm.is();
/*?*/ 					rSet.Put(SfxBoolItem(nWhich, bChecked));
/*?*/ 				}
/*?*/ 			}	break;
/*?*/ 			case SID_FM_TAB_DIALOG:
/*?*/ 				// der Impl eventuell die Moeglichjkeit geben, ihre an der aktuellen MarkList ausgerichteten Objekte
/*?*/ 				// auf den neuesten Stand zu bringen
/*?*/ 				if (GetImpl()->IsSelectionUpdatePending())
/*?*/					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					GetImpl()->ForceUpdateSelection(sal_False);
/*?*/ 
/*?*/ 				if (!m_pFormView || !m_bDesignMode || !GetImpl()->getCurForm().is() )
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				break;
/*N*/ 			case SID_FM_CONFIG:
/*N*/ 				rSet.Put(SfxUInt16Item(nWhich, m_nLastSlot));
/*N*/ 				break;
/*N*/ 			case SID_FM_DESIGN_MODE:
/*N*/ 				if (!m_pFormView)
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				else
/*N*/ 					rSet.Put( SfxBoolItem(nWhich, m_bDesignMode) );
/*N*/ 				break;
/*N*/ 			case SID_FM_SEARCH:
/*N*/ 			case SID_FM_RECORD_FIRST:
/*N*/ 			case SID_FM_RECORD_NEXT:
/*N*/ 			case SID_FM_RECORD_PREV:
/*N*/ 			case SID_FM_RECORD_LAST:
/*N*/ 			case SID_FM_RECORD_NEW:
/*N*/ 			case SID_FM_RECORD_DELETE:
/*N*/ 			case SID_FM_RECORD_ABSOLUTE:
/*N*/ 			case SID_FM_RECORD_TOTAL:
/*N*/ 			case SID_FM_RECORD_SAVE:
/*N*/ 			case SID_FM_RECORD_UNDO:
/*N*/ 			case SID_FM_FORM_FILTERED:
/*N*/ 			case SID_FM_REMOVE_FILTER_SORT:
/*N*/ 			case SID_FM_SORTUP:
/*N*/ 			case SID_FM_SORTDOWN:
/*N*/ 			case SID_FM_ORDERCRIT:
/*N*/ 			case SID_FM_FILTER_START:
/*N*/ 			case SID_FM_AUTOFILTER:
/*N*/ 			case SID_FM_REFRESH:
/*N*/ 			case SID_FM_VIEW_AS_GRID:
/*?*/				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 				GetFormState(rSet,nWhich);
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_FM_CHANGECONTROLTYPE:
/*?*/ 			{
/*?*/ 				if (!m_pFormView || !m_bDesignMode || !GetImpl()->getCurControl().is())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 				{
/*?*/ 					Reference< ::com::sun::star::form::XFormComponent >  xSelAsComp(GetImpl()->getCurControl(), UNO_QUERY);
/*?*/ 					if (!xSelAsComp.is())
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 				}
/*?*/ 			} break;
/*?*/ 
/*?*/ 			case SID_FM_CONVERTTO_EDIT			:
/*?*/ 			case SID_FM_CONVERTTO_BUTTON			:
/*?*/ 			case SID_FM_CONVERTTO_FIXEDTEXT 	:
/*?*/ 			case SID_FM_CONVERTTO_LISTBOX		:
/*?*/ 			case SID_FM_CONVERTTO_CHECKBOX		:
/*?*/ 			case SID_FM_CONVERTTO_RADIOBUTTON	:
/*?*/ 			case SID_FM_CONVERTTO_GROUPBOX		:
/*?*/ 			case SID_FM_CONVERTTO_COMBOBOX		:
/*?*/ 			case SID_FM_CONVERTTO_GRID			:
/*?*/ 			case SID_FM_CONVERTTO_IMAGEBUTTON	:
/*?*/ 			case SID_FM_CONVERTTO_FILECONTROL	:
/*?*/ 			case SID_FM_CONVERTTO_DATE			:
/*?*/ 			case SID_FM_CONVERTTO_TIME			:
/*?*/ 			case SID_FM_CONVERTTO_NUMERIC		:
/*?*/ 			case SID_FM_CONVERTTO_CURRENCY		:
/*?*/ 			case SID_FM_CONVERTTO_PATTERN		:
/*?*/ 			case SID_FM_CONVERTTO_IMAGECONTROL	:
/*?*/ 			case SID_FM_CONVERTTO_FORMATTED 	:
/*?*/ 			{
/*?*/ 				if (!m_pFormView || !m_bDesignMode || !GetImpl()->getCurControl().is())
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 				{
/*?*/					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					Reference< ::com::sun::star::beans::XPropertySet >	xSelProps(GetImpl()->getCurControl(), UNO_QUERY);
/*?*/ 						// just to have a defined state (available and not checked)
/*N*/ 				}
/*N*/ 			} break;
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------

//------------------------------------------------------------------------
/*N*/ FmFormPage* FmFormShell::GetCurPage() const
/*N*/ {
/*N*/ 	FmFormPage* pP = NULL;
/*N*/ 	if (m_pFormView && m_pFormView->GetPageViewPvNum(0))
/*N*/ 		pP = PTR_CAST(FmFormPage,m_pFormView->GetPageViewPvNum(0)->GetPage());
/*N*/ 	return pP;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmFormShell::SetView(FmFormView* pView)
/*N*/ {
/*N*/ 	if (m_pFormView)
/*N*/ 	{
/*N*/ 		m_pFormView->SetFormShell( NULL );
/*N*/ 		GetImpl()->ResetForms();
/*N*/ 		m_pFormModel = NULL;
/*N*/ 	}
/*N*/ 	if (pView)
/*N*/ 	{
/*N*/ 		m_pFormView = pView;
/*N*/ 		m_pFormView->SetFormShell( this );
/*N*/ 		m_pFormModel = (FmFormModel*)m_pFormView->GetModel();
/*N*/ 
/*N*/ 		SetDesignMode(pView->IsDesignMode());
/*N*/ 
/*N*/ 		// We activate our view if we are activated ourself, but sometimes the Activate precedes the SetView.
/*N*/ 		// But here we know both the view and our activation state so we at least are able to pass the latter
/*N*/ 		// to the former.
/*N*/ 		// FS - 30.06.99 - 67308
/*N*/ 		if ( IsActive() )
/*?*/ 			GetImpl()->viewActivated( m_pFormView );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		m_pFormView = NULL;
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmFormShell::DetermineForms(sal_Bool bInvalidate)
/*N*/ {
/*N*/ 	// Existieren Formulare auf der aktuellen Page
/*N*/ 	sal_Bool bForms = GetImpl()->hasForms();
/*N*/ 	if (bForms != m_bHasForms)
/*N*/ 	{
/*N*/ 		m_bHasForms = bForms;
/*N*/ 		if (bInvalidate)
/*N*/ 			UIFeatureChanged();
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------

//------------------------------------------------------------------------

//------------------------------------------------------------------------
/*N*/ void FmFormShell::Activate(sal_Bool bMDI)
/*N*/ {
/*N*/ 	SfxShell::Activate(bMDI);
/*N*/ 
/*N*/ 	GetImpl()->viewActivated( m_pFormView, sal_True );
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmFormShell::Deactivate(sal_Bool bMDI)
/*N*/ {
/*N*/ 	SfxShell::Deactivate(bMDI);
/*N*/ 
/*N*/ 	GetImpl()->viewDeactivated( m_pFormView, sal_False );
/*N*/ }
/*N*/ 

}
