/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_viewsh.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:53:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif

#include <tools/urlobj.hxx>
#include <svtools/pathoptions.hxx>
#ifndef INCLUDED_SVTOOLS_INTERNALOPTIONS_HXX
#include <svtools/internaloptions.hxx>
#endif


#pragma hdrstop

#include "viewimp.hxx"

#include "sfxresid.hxx"
#include "request.hxx"
#include "printer.hxx"
#include "docfile.hxx"
#include "dispatch.hxx"
#include "arrdecl.hxx"
#include "ipenv.hxx"
#include "intfrm.hxx"
#include "docfac.hxx"
#include "view.hrc"
#include "mnumgr.hxx"
#include "virtmenu.hxx"
#include "sfxlocal.hrc"
#include "frameobj.hxx"
#include "sfxbasecontroller.hxx"
#include "topfrm.hxx"
#include "event.hxx"
#include "fcontnr.hxx"

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;

//=========================================================================
/*N*/ DBG_NAME(SfxViewShell)

#define SfxViewShell
#include "so3/staticbaseurl.hxx"
namespace binfilter {
#include "sfxslots.hxx"

//=========================================================================

/*N*/ SFX_IMPL_INTERFACE(SfxViewShell,SfxShell,SfxResId(0))
/*N*/ {
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION( SID_MAIL_CHILDWIN );
/*N*/ }

/*N*/ TYPEINIT2(SfxViewShell,SfxShell,SfxListener);

//--------------------------------------------------------------------


//--------------------------------------------------------------------

/*N*/ void SfxViewShell::ExecMisc_Impl( SfxRequest &rReq )
/*N*/ {
/*N*/ 	const USHORT nId = rReq.GetSlot();
/*N*/ 	switch( nId )
/*N*/ 	{
/*N*/ 		case SID_STYLE_FAMILY :
/*N*/ 		{
/*N*/ 			SFX_REQUEST_ARG(rReq, pItem, SfxUInt16Item, nId, FALSE);
/*N*/ 			if (pItem)
/*N*/ 				pImp->nFamily = pItem->GetValue();
/*N*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/ 		case SID_STYLE_CATALOG:
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxTemplateCatalog aCatalog(
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/ 		// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
/*N*/ 
/*N*/ 		case SID_MAIL_SENDDOCASPDF:
/*N*/ 		case SID_MAIL_SENDDOC:
/*?*/             if ( SvtInternalOptions().MailUIEnabled() )
/*?*/             {
/*?*/                 GetViewFrame()->SetChildWindow( SID_MAIL_CHILDWIN, TRUE );
/*?*/             }
/*?*/             else
/*?*/             {
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxMailModel_Impl	aModel( &GetViewFrame()->GetBindings() );
/*?*/ 			}
/*?*/ 
/*?*/ 			break;
/*?*/ 
/*?*/ 		// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
/*?*/ 
/*?*/ 		case SID_PLUGINS_ACTIVE:
/*?*/ 		{
/*?*/ 			SFX_REQUEST_ARG(rReq, pShowItem, SfxBoolItem, nId, FALSE);
/*?*/ 			BOOL bActive = pShowItem ? pShowItem->GetValue() : !pImp->bPlugInsActive;
/*?*/ 			// ggf. recorden
/*?*/ 			if ( !rReq.IsAPI() )
/*?*/ 				rReq.AppendItem( SfxBoolItem( nId, bActive ) );
/*?*/ 
/*?*/ 			// Jetzt schon DONE aufrufen, da die Argumente evtl. einen Pool
/*?*/ 			// benutzen, der demn"achst weg ist
/*?*/ 			rReq.Done(TRUE);
/*?*/ 
/*?*/ 			// ausfuehren
/*?*/ 			if ( !pShowItem || bActive != pImp->bPlugInsActive )
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxFrame *pFrame = GetFrame()->GetTopFrame();
/*?*/ 			}
/*?*/ 
/*?*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::GetState_Impl( SfxItemSet &rSet )
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxViewShell, 0);
/*N*/ 
/*N*/ 	SfxWhichIter aIter( rSet );
/*N*/ 	for ( USHORT nSID = aIter.FirstWhich(); nSID; nSID = aIter.NextWhich() )
/*N*/ 	{
/*N*/ 		switch ( nSID )
/*N*/ 		{
/*N*/ 			case SID_STYLE_CATALOG:
/*N*/ 			{
/*N*/                 if ( !GetViewFrame()->KnowsChildWindow( SID_STYLE_DESIGNER ) )
/*?*/ 					rSet.DisableItem( nSID );
/*N*/ 				break;
/*N*/ 			}
/*N*/ 
/*N*/ 			// Printer-Funktionen
/*N*/ 			case SID_PRINTDOC:
/*N*/ 			case SID_PRINTDOCDIRECT:
/*N*/ 			case SID_SETUPPRINTER:
/*N*/ 			{
/*N*/ 				BOOL bEnabled = pImp->bCanPrint && !pImp->nPrinterLocks;
/*N*/ 				if ( bEnabled )
/*N*/ 				{
/*N*/ 					SfxPrinter *pPrinter = GetPrinter(FALSE);
/*N*/ 					bEnabled = !pPrinter || !pPrinter->IsPrinting();
/*N*/ 				}
/*N*/ 				if ( !bEnabled )
/*N*/ 				{
/*?*/ 					rSet.DisableItem( SID_PRINTDOC );
/*?*/ 					rSet.DisableItem( SID_PRINTDOCDIRECT );
/*?*/ 					rSet.DisableItem( SID_SETUPPRINTER );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 			}
/*N*/ 
/*N*/ 			// Mail-Funktionen
/*N*/ 			case SID_MAIL_SENDDOCASPDF:
/*N*/ 			case SID_MAIL_SENDDOC:
/*N*/ 			{
/*?*/                 BOOL bEnable = !GetViewFrame()->HasChildWindow( SID_MAIL_CHILDWIN );
/*?*/ 				if ( !bEnable )
/*?*/ 					rSet.DisableItem( nSID );
/*?*/ 				else if ( nSID == SID_MAIL_SENDDOCASPDF )
/*?*/ 				{
/*?*/ 					SfxObjectShellRef xDocShell = GetViewFrame()->GetObjectShell();
/*?*/ 					if ( xDocShell.Is() )
/*?*/ 					{
/*?*/ 						// Get PDF Filter from container
/*?*/ 						SfxFactoryFilterContainer* pFilterContainer = xDocShell->GetFactory().GetFilterContainer();
/*?*/ 						if ( pFilterContainer )
/*?*/ 						{
/*?*/ 							String aPDFExtension = String::CreateFromAscii( ".pdf" );
/*?*/ 							const SfxFilter* pFilter = pFilterContainer->GetFilter4Extension( aPDFExtension, SFX_FILTER_EXPORT );
/*?*/ 							if ( pFilter != NULL )
/*?*/ 								break;
/*?*/ 						}
/*?*/ 					}
/*?*/ 
/*?*/ 					rSet.DisableItem( nSID );
/*?*/ 				}
/*?*/ 
/*?*/ 				break;
/*N*/ 			}
/*N*/ 
/*N*/ 			// PlugIns running
/*N*/ 			case SID_PLUGINS_ACTIVE:
/*N*/ 			{
/*?*/                 rSet.Put( SfxBoolItem( SID_PLUGINS_ACTIVE, !pImp->bPlugInsActive) );
/*?*/ 				break;
/*N*/ 			}
/*
			// SelectionText
			case SID_SELECTION_TEXT:
			{
				rSet.Put( SfxStringItem( SID_SELECTION_TEXT, GetSelectionText() ) );
				break;
			}

			// SelectionTextExt
			case SID_SELECTION_TEXT_EXT:
			{
				rSet.Put( SfxStringItem( SID_SELECTION_TEXT_EXT, GetSelectionText(TRUE) ) );
				break;
			}
*/
/*N*/ 			case SID_STYLE_FAMILY :
/*N*/ 			{
/*N*/ 				rSet.Put( SfxUInt16Item( SID_STYLE_FAMILY, pImp->nFamily ) );
/*N*/ 				break;
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::SetZoomFactor( const Fraction &rZoomX,
/*N*/ 								  const Fraction &rZoomY )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//--------------------------------------------------------------------


/*  [Beschreibung]

	"Uber diese Factory-Methode erzeugt der SFx spezielle SfxShell-Instanzen,
	die als Stellvertreter f"ur InPlace-Objekte dienen. Solle  auf Callbacks
	dieser Stellvertreter reagiert werden, die dieses "uber eine eigene
	SfxInPlaceClient-Subklasse zu realisieren und diese Factory zu "uberladen.
*/


//--------------------------------------------------------------------


/*  [Beschreibung]

	Dieser Handler wird gerufen, wenn ein mit der Methode
	<SfxViewShell::DoVerb()> angesteuertes Objekt aktiviert
	wurde.

	Die Basisimplementation braucht nicht gerufen zu werden.


	[Querverweise]
	<SfxViewShell::UIDeactivate(SvInPlaceObject)>
*/


//--------------------------------------------------------------------


/*  [Beschreibung]

	Dieser Handler wird gerufen, wenn ein mit der Methode
	<SfxViewShell::DoVerb()> aktiviertes Objekt deaktiviert
	wurde. Dies kann von der Server-Applikation oder durch die Client-
	Applikation hervorgerufen worden sein.

	Die Basisimplementation braucht nicht gerufen zu werden.


	[Querverweise]
	<SfxViewShell::UIDeactivate(SvInPlaceObject)>
*/


//--------------------------------------------------------------------


/*  [Beschreibung]

	[Beispiel]

	ErrCode SwView::DoVerb( SwSoNode *pSoNode, long nVerb )
	{
		SwIPClientRef xIPCli = (SwIPClient*)
				pViewSh->FindIPClient( pSoNode->GetObject() );
		if ( !xIPCli.Is() )
			xIPCli = new SwIPClient( pViewSh, pEditWin, .... );
		pSoNode->GetObject()->DoConnect( xIPCli );
		xIPCli->GetEnv()->SetObjArea( Rectangle( ... ) );
		...
		return DoVerb( xIPCli, nVerb );
	}
*/


//--------------------------------------------------------------------

/*N*/ SfxInPlaceClient* SfxViewShell::FindIPClient
/*N*/ (
	SvEmbeddedObject*   pObj,           /*  <SfxInPlaceClient> f"ur dieses
											<SvEmbeddedObject> suchen */
	Window*             pObjParentWin   /*  SfxInPlaceClient, der in diesem
											Window dargestellt wird */
/*N*/ )   const

/*  [Beschreibung]

	Sucht nach einem exisitierenden SfxInPlaceClient f"ur das angegebene
	Objekt/Window-Paar.

	Wird keins gefunden, wird 0 zur"uckgegeben.


	[Querverweise]

	<SfxViewShell::DoVerb(SfxInPlaceClient*,long)>
*/

/*N*/ {
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( !pClients )
/*N*/ 		return 0;
/*N*/ 
/*N*/ 	if( !pObjParentWin )
/*N*/ 		pObjParentWin = GetWindow();
/*N*/ 	for (USHORT n=0; n < pClients->Count(); n++)
/*N*/ 	{
/*?*/ 		SfxInPlaceClient *pIPClient = (SfxInPlaceClient*) pClients->GetObject(n);
/*?*/ 		if ( pIPClient->GetEmbedObj() == pObj &&
/*?*/ 			 pIPClient->GetEnv()->GetEditWin() == pObjParentWin )
/*?*/ 			return pIPClient;
/*N*/ 	}
/*N*/ 
/*N*/ 	return 0;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxInPlaceClient* SfxViewShell::GetIPClient() const
/*N*/ {
/*N*/ 	return GetUIActiveClient();
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxInPlaceClient* SfxViewShell::GetUIActiveClient() const
/*N*/ {
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( !pClients )
/*N*/ 		return 0;
/*N*/ 
/*N*/ 	SvInPlaceClient *pIPClient=0;
/*N*/ 	SvInPlaceClientRef aIPClient;
/*N*/ 
/*N*/ 	for (USHORT n=0; n < pClients->Count(); n++)
/*N*/ 	{
/*?*/ 		aIPClient = pClients->GetObject(n);
/*?*/ 		if( aIPClient.Is() )
/*?*/ 		{
/*?*/ 			if (aIPClient->GetProtocol().IsUIActive())
/*?*/ 			{
/*?*/ 				pIPClient = aIPClient;
/*?*/ 				break;
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	return (SfxInPlaceClient*) pIPClient;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::Activate( BOOL bMDI )
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxViewShell, 0);
/*N*/ 	if ( bMDI )
/*N*/ 	{
/*N*/ 		SfxObjectShell *pSh = GetViewFrame()->GetObjectShell();
/*N*/ 		if ( pSh->GetModel().is() )
/*N*/ 			pSh->GetModel()->setCurrentController( GetViewFrame()->GetFrame()->GetController() );
/*N*/ 		if ( pSh && pSh->GetMedium() && pSh->GetMedium()->GetName().Len() )
/*N*/ 			so3::StaticBaseUrl::SetBaseURL( pSh->GetBaseURL() );
/*N*/ 		else
/*N*/ 		{
/*N*/             INetURLObject aObject( SvtPathOptions().GetWorkPath() );
/*N*/ 			aObject.setFinalSlash();
/*N*/ 			so3::StaticBaseUrl::SetBaseURL( aObject.GetMainURL( INetURLObject::NO_DECODE ) );
/*N*/ 		}
/*N*/ 
/*N*/ 		SfxObjectShell::SetWorkingDocument( pSh );
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::Deactivate(BOOL bMDI)
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxViewShell, 0);
/*N*/ }

//--------------------------------------------------------------------



//--------------------------------------------------------------------


/*  [Beschreibung]

	Diese virtuelle Methode wird gerufen, wenn das Fenster, in dem die
	SfxViewShell dargestellt wird eine StarView-Move() Nachricht erh"alt.

	Die Basisimplementierung braucht nicht gerufen zu werden.


	[Anmerkung]

	Diese Methode kann dazu verwendet werden, eine Selektion abzubrechen,
	um durch das Moven des Fensters erzeugte Maus-Bewegungen anzufangen.

	Zur Zeit funktioniert die Benachrichtigung nicht In-Place.
*/


//--------------------------------------------------------------------

/*N*/ void SfxViewShell::OuterResizePixel
/*N*/ (
/*N*/ 	const Point&    rToolOffset,// linke obere Ecke der Tools im Frame-Window
/*N*/ 	const Size&     rSize       // gesamte zur Verf"ugung stehende Gr"o\se
/*N*/ )

/*  [Beschreibung]

	Diese Methode mu berladen werden, um auf "Anderungen der Gre
	der View zu reagieren. Dabei definieren wir die View als das Edit-Window
	zuz"uglich der um das Edit-Window angeordnenten Tools (z.B. Lineale).

	Das Edit-Window darf weder in Gr"o\se noch Position ver"andert werden.

	Die Vis-Area der SfxObjectShell, dessen Skalierung und Position
	d"urfen hier ver"andert werden. Der Hauptanwendungsfall ist dabei,
	das Ver"andern der Gr"o\se der Vis-Area.

	"Andert sich durch die neue Berechnung der Border, so mu\s dieser
	mit <SfxViewShell::SetBorderPixel(const SvBorder&)> gesetzt werden.
	Erst nach Aufruf von 'SetBorderPixel' ist das Positionieren von
	Tools erlaubt.


	[Beispiel]

	void AppViewSh::OuterViewResizePixel( const Point &rOfs, const Size &rSz )
	{
		// Tool-Positionen und Gr"o\sen von au\sen berechnen, NICHT setzen!
		// (wegen folgender Border-Berechnung)
		Point aHLinPos...; Size aHLinSz...;
		...

		// Border f"ur Tools passend zu rSize berechnen und setzen
		SvBorder aBorder...
		SetBorderPixel( aBorder ); // ab jetzt sind Positionierungen erlaubt

		// Tools anordnen
		pHLin->SetPosSizePixel( aHLinPos, aHLinSz );
		...
	}


	[Querverweise]

	<SfxViewShell::InnerResizePixel(const Point&,const Size& rSize)>
*/

/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxViewShell, 0);
/*N*/ 	SetBorderPixel( SvBorder() );
/*N*/ }

//--------------------------------------------------------------------


/*  [Beschreibung]

	Diese Methode mu berladen werden, um auf "Anderungen der Gre
	des Edit-Windows zu reagieren.

	Das Edit-Window darf weder in Gr"o\se noch Position ver"andert werden.
	Weder die Vis-Area der SfxObjectShell noch dessen Skalierung oder
	Position d"urfen ver"andert werden.

	"Andert sich durch die neue Berechnung der Border, so mu\s dieser
	mit <SfxViewShell::SetBorderPixel(const SvBorder&)> gesetzt werden.
	Erst nach Aufruf von 'SetBorderPixel' ist das Positionieren von
	Tools erlaubt.


	[Beispiel]

	void AppViewSh::InnerViewResizePixel( const Point &rOfs, const Size &rSz )
	{
		// Tool-Positionen und Gr"o\sen von innen berechnen, NICHT setzen!
		// (wegen folgender Border-Berechnung)
		Point aHLinPos...; Size aHLinSz...;
		...

		// Border f"ur Tools passend zu rSz berechnen und setzen
		SvBorder aBorder...
		SetBorderPixel( aBorder ); // ab jetzt sind Positionierungen erlaubt

		// Tools anordnen
		pHLin->SetPosSizePixel( aHLinPos, aHLinSz );
		...
	}


	[Querverweise]

	<SfxViewShell::OuterResizePixel(const Point&,const Size& rSize)>
*/


//--------------------------------------------------------------------

/*N*/ void SfxViewShell::InvalidateBorder()
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxViewShell, 0);
/*N*/ 	DBG_ASSERT( GetViewFrame(), "SfxViewShell without SfxViewFrame" );
/*N*/ 
/*N*/ 	GetViewFrame()->InvalidateBorderImpl( this );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::SetBorderPixel( const SvBorder &rBorder )
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxViewShell, 0);
/*N*/ 	DBG_ASSERT( GetViewFrame(), "SfxViewShell without SfxViewFrame" );
/*N*/ 
/*N*/ 	GetViewFrame()->SetBorderPixelImpl( this, rBorder );
/*N*/ }

//--------------------------------------------------------------------


//--------------------------------------------------------------------

/*N*/ void SfxViewShell::SetWindow
/*N*/ (
/*N*/ 	Window*     pViewPort   // Pointer auf das Datenfenster bzw. 0 im Destruktor
/*N*/ )

/*  [Beschreibung]

	Mit dieser Methode wird der SfxViewShell das Datenfenster mitgeteilt.
	Dieses wird f"ur den In-Place-Container und f"ur das korrekte
	Wiederherstellen des Focus ben"otigt.

	Selbst In-Place-aktiv ist das Umsetzen des ViewPort-Windows verboten.
*/

/*N*/ {
/*N*/ 	if( pWindow == pViewPort )
/*N*/ 		return;
/*N*/ 
/*N*/ 	// ggf. vorhandene IP-Clients disconnecten
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( pClients )
/*N*/ 	{
/*N*/ 		SvInPlaceClientRef aIPClient;
/*N*/ 		USHORT nCount = (USHORT)pClients->Count();
/*N*/ 		for (USHORT n=0; n<nCount; n++)
/*N*/ 		{
/*?*/ 			// Da beim DisConnect der Client immer aus der Liste entfernt wird,
/*?*/ 			// immer das 0-te Element holen
/*?*/ 			aIPClient = pClients->GetObject(0);
/*?*/ 			if( aIPClient.Is() )
/*?*/ 			{
/*?*/ 				if (aIPClient->GetIPObj())
/*?*/ 				{
/*?*/ 					aIPClient->DoDisconnect();
/*?*/ 					aIPClient.Clear();
/*?*/ 				}
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// View-Port austauschen
/*N*/     BOOL bHadFocus = pWindow ? pWindow->HasChildPathFocus( TRUE ) : FALSE;
/*N*/ 	pWindow = pViewPort;
/*N*/ 
/*N*/     if( pWindow )
/*N*/     {
/*N*/         // Disable automatic GUI mirroring (right-to-left) for document windows
/*N*/         pWindow->EnableRTL( FALSE );
/*N*/     }
/*N*/ 
/*N*/     if ( bHadFocus && pWindow )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 SFX_APP()->GrabFocus( pWindow );
/*N*/ }

//--------------------------------------------------------------------


//------------------------------------------------------------------------

/*N*/ SfxViewShell::SfxViewShell
/*N*/ (
	SfxViewFrame*   pViewFrame,     /*  <SfxViewFrame>, in dem diese View
										dargestellt wird */
	USHORT          nFlags          /*  siehe <SfxViewShell-Flags> */
/*N*/ )

/*N*/ :   SfxShell(this),
/*N*/     pImp( new SfxViewShell_Impl ),
/*N*/ #if !SFX_VIEWSH_INCLUDES_CLIENTSH_HXX
/*N*/ 	pIPClientList( 0 ),
/*N*/ #endif
/*N*/ 	pWindow(0),
/*N*/ 	pFrame(pViewFrame),
/*N*/ 	pSubShell(0),
/*N*/ 	bOptimizeEach(0 != (nFlags & SFX_VIEW_OPTIMIZE_EACH)),
/*N*/ 	bMaximizeFirst( 0 != (nFlags & SFX_VIEW_MAXIMIZE_FIRST) )
/*N*/ 	,bNoNewWindow( 0 != (nFlags & SFX_VIEW_NO_NEWWINDOW) )
/*N*/ {
/*N*/ 	DBG_CTOR(SfxViewShell, 0);
/*N*/ 
/*N*/     pImp->pController = 0;
/*N*/ 	pImp->bIsShowView =
/*N*/ 		!(SFX_VIEW_NO_SHOW == (nFlags & SFX_VIEW_NO_SHOW));
/*N*/ 	pImp->bUseObjectSize =
/*N*/ 		SFX_CREATE_MODE_EMBEDDED==pFrame->GetObjectShell()->GetCreateMode() &&
/*N*/ 		SFX_VIEW_OBJECTSIZE_EMBEDDED == (nFlags & SFX_VIEW_OBJECTSIZE_EMBEDDED);
/*N*/ 	pImp->bCanPrint = SFX_VIEW_CAN_PRINT == (nFlags & SFX_VIEW_CAN_PRINT);
/*N*/ 	pImp->bFrameSetImpl = nFlags & SFX_VIEW_IMPLEMENTED_AS_FRAMESET;
/*N*/ 	pImp->bHasPrintOptions =
/*N*/ 		SFX_VIEW_HAS_PRINTOPTIONS == (nFlags & SFX_VIEW_HAS_PRINTOPTIONS);
/*N*/ 	pImp->bPlugInsActive = TRUE;
/*N*/ 	pImp->bGotOwnerShip = FALSE;
/*N*/ 	if ( pFrame->GetParentViewFrame() )
/*?*/ 		pImp->bPlugInsActive = pFrame->GetParentViewFrame()->GetViewShell()->pImp->bPlugInsActive;
/*N*/ 	pImp->eScroll = SCROLLING_DEFAULT;
/*N*/ 	pImp->pSetDescr = NULL;
/*N*/ 	pImp->nPrinterLocks = 0;
/*N*/ 	pImp->pMenuBarResId = 0;
/*N*/ 	pImp->pAccelResId = 0;
/*N*/ 	pImp->pAccel = 0;
/*N*/ 	pImp->pMenu = 0;
/*N*/ 	pImp->bControllerSet = FALSE;
/*N*/     pImp->bOwnsMenu = TRUE;
/*N*/ 	pImp->nFamily = 0xFFFF;					// undefined, default set by TemplateDialog
/*N*/ 	SetMargin( pFrame->GetMargin_Impl() );
/*N*/ 
/*N*/ 	SetPool( &pViewFrame->GetObjectShell()->GetPool() );
/*N*/ 	StartListening(*SFX_APP());
/*N*/ 
/*N*/ 	// in Liste eintragen
/*N*/ 	const SfxViewShell *pThis = this; // wegen der kranken Array-Syntax
/*N*/ 	SfxViewShellArr_Impl &rViewArr = SFX_APP()->GetViewShells_Impl();
/*N*/ 	rViewArr.Insert(pThis, rViewArr.Count() );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxViewShell::~SfxViewShell()
/*N*/ {
/*N*/ 	DBG_DTOR(SfxViewShell, 0);
/*N*/ 
/*N*/ 	// aus Liste austragen
/*N*/ 	const SfxViewShell *pThis = this;
/*N*/ 	SfxViewShellArr_Impl &rViewArr = SFX_APP()->GetViewShells_Impl();
/*N*/ 	rViewArr.Remove( rViewArr.GetPos(pThis) );
/*N*/ //	if ( GetViewFrame()->GetFrame()->GetFrameSet_Impl() == pImp->pSetDescr )
/*N*/ //		GetViewFrame()->GetFrame()->SetFrameSet_Impl( NULL );
/*N*/ //	delete pImp->pSetDescr;
/*N*/ 
/*N*/     if ( pImp->pMenu && pImp->bOwnsMenu )
/*N*/ 	{
/*N*/         SfxTopViewFrame* pTopView = PTR_CAST( SfxTopViewFrame, GetViewFrame()->GetTopViewFrame() );
/*N*/         SfxTopFrame *pTop = pTopView ? pTopView->GetTopFrame_Impl() : NULL;
/*N*/         if ( pTop )
/*N*/         {
/*N*/             Menu* pMenu = pImp->pMenu->GetMenu()->GetSVMenu();
/*N*/             if ( pMenu == pTop->GetMenuBar_Impl() )
/*N*/                 pTop->SetMenuBar_Impl( 0 );
/*N*/         }
/*N*/ 
/*N*/         delete pImp->pMenu;
/*N*/ 	}
/*N*/ 
/*N*/     if ( pImp->pController )
/*N*/     {
/*N*/         pImp->pController->ReleaseShell_Impl();
/*N*/         pImp->pController->release();
/*N*/     }
/*N*/ 
/*N*/ 	delete pImp->pMenuBarResId;
/*N*/ 	delete pImp;
/*N*/ 
/*N*/ #if !SFX_VIEWSH_INCLUDES_CLIENTSH_HXX
/*N*/ 	delete pIPClientList;
/*N*/ #endif
/*N*/ }

//--------------------------------------------------------------------

/*N*/ USHORT SfxViewShell::PrepareClose
/*N*/ (
/*N*/ 	BOOL    bUI,     // TRUE: Dialoge etc. erlaubt, FALSE: silent-mode
/*N*/ 	BOOL bForBrowsing
/*N*/ )
/*N*/ {
/*N*/ 	SfxPrinter *pPrinter = GetPrinter();
/*N*/ 	if ( pPrinter && pPrinter->IsPrinting() )
/*N*/ 	{
/*?*/ 		if ( bUI )
/*?*/ 		{
/*?*/ 			InfoBox aInfoBox( &GetViewFrame()->GetWindow(), SfxResId( MSG_CANT_CLOSE ) );
/*?*/ 			aInfoBox.Execute();
/*?*/ 		}
/*?*/ 
/*?*/ 		return FALSE;
/*N*/ 	}
/*N*/ 
/*N*/ 	if( GetViewFrame()->IsInModalMode() )
/*N*/ 		return FALSE;
/*N*/ 
/*N*/ 	return TRUE;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxViewShell* SfxViewShell::Current()
/*N*/ {
/*N*/     SfxViewFrame *pCurrent = SfxViewFrame::Current();
/*N*/     return pCurrent ? pCurrent->GetViewShell() : NULL;
/*N*/ }

//--------------------------------------------------------------------


/*	[Beschreibung]

	Diese virtuelle Methode mu\s von den Subklassen "uberladen werden, wenn
	der Property-Editor zur Verf"ugung stehen soll.

	Die Default-Implementierung liefert immer 0.
*/


//--------------------------------------------------------------------


/*  [Beschreibung]

	Diese Methode kann von Anwendungsprogrammierer "uberladen werden,
	um einen Text zur"uckzuliefern, der in der aktuellen Selektion
	steht. Dieser wird z.B. beim Versenden (email) verwendet.

	Mit bCompleteWords == TRUE ger"ufen, reicht z.B. auch der Cursor,
	der in einer URL steht, um die gesamte URL zu liefern.
*/


//--------------------------------------------------------------------


/*  [Beschreibung]

	Mit dieser virtuellen Methode kann z.B. ein Dialog abfragen, ob in der
	aktuellen View etwas selektiert ist. Wenn der Parameter <BOOL> TRUE ist,
	wird abgefragt, ob Text selektiert ist.
*/


//--------------------------------------------------------------------


/*  [Beschreibung]

	Mit dieser Methode kann eine Selektions- oder Cursor-Shell angemeldet
	werden, die automatisch unmittelbar nach der SfxViewShell auf den
	SfxDispatcher gepusht wird, und automatisch umittelbar vor ihr
	gepoppt wird.

	Ist die SfxViewShell-Instanz bereits gepusht, dann wird pShell
	sofort ebenfalls gepusht. Wird mit SetSubShell eine andere SfxShell
	Instanz angemeldet, als vorher angemeldet war, wird die zuvor angemeldete
	ggf. automatisch gepoppt. Mit pShell==0 kann daher die aktuelle
	Sub-Shell abgemeldet werden.
*/


/*N*/ void SfxViewShell::AddSubShell( SfxShell& rShell )
/*N*/ {
/*N*/ 	pImp->aArr.Insert( &rShell, pImp->aArr.Count() );
/*N*/ 	SfxDispatcher *pDisp = pFrame->GetDispatcher();
/*N*/ 	if ( pDisp->IsActive(*this) )
/*N*/ 	{
/*?*/ 		pDisp->Push(rShell);
/*?*/ 		pDisp->Flush();
/*N*/ 	}
/*N*/ }

/*N*/ void SfxViewShell::RemoveSubShell( SfxShell* pShell )
/*N*/ {
/*N*/ 	SfxDispatcher *pDisp = pFrame->GetDispatcher();
/*N*/ 	if ( !pShell )
/*N*/ 	{
/*N*/ 		USHORT nCount = pImp->aArr.Count();
/*N*/ 		if ( pDisp->IsActive(*this) )
/*N*/ 		{
/*?*/ 			for ( USHORT n=nCount; n>0; n-- )
/*?*/ 				pDisp->Pop( *pImp->aArr[n-1] );
/*?*/ 			pDisp->Flush();
/*N*/ 		}
/*N*/ 
/*N*/ 		pImp->aArr.Remove(0, nCount);
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/ 		USHORT nPos = pImp->aArr.GetPos( pShell );
/*?*/ 		if ( nPos != 0xFFFF )
/*?*/ 		{
/*?*/ 			pImp->aArr.Remove( nPos );
/*?*/ 			if ( pDisp->IsActive(*this) )
/*?*/ 			{
/*?*/ 				pDisp->RemoveShell_Impl( *pShell );
/*?*/ 				pDisp->Flush();
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ }


/*N*/ void SfxViewShell::PushSubShells_Impl( BOOL bPush )
/*N*/ {
/*N*/ 	USHORT nCount = pImp->aArr.Count();
/*N*/ 	SfxDispatcher *pDisp = pFrame->GetDispatcher();
/*N*/ 	if ( bPush )
/*N*/ 	{
/*N*/ 		for ( USHORT n=0; n<nCount; n++ )
/*N*/ 			pDisp->Push( *pImp->aArr[n] );
/*N*/ 
/*N*/ //		HACK(evtl. PushSubShells fuer SW virtuell machen oder im SW umbauen)
/*N*/ //		Notify( *this, SfxSimpleHint( SFX_HINT_RESERVED4 ) );
/*N*/ 	}
/*N*/ 	else if ( nCount )
/*N*/ 	{
/*N*/ 		pDisp->Pop( *pImp->aArr[0], SFX_SHELL_POP_UNTIL );
/*N*/ 
/*N*/ //		HACK(evtl. PushSubShells fuer SW virtuell machen oder im SW umbauen)
/*N*/ //		Notify( *this, SfxSimpleHint( SFX_HINT_RESERVED3 ) );
/*N*/ 	}
/*N*/ 
/*N*/ 	pDisp->Flush();
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::WriteUserData( String &, BOOL bBrowse )
/*N*/ {
/*N*/ }

//--------------------------------------------------------------------


/*N*/ void SfxViewShell::WriteUserDataSequence ( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >&, sal_Bool bBrowse )
/*N*/ {
/*N*/ }


//--------------------------------------------------------------------
// returns the first shell of spec. type viewing the specified doc.

/*N*/ SfxViewShell* SfxViewShell::GetFirst
/*N*/ (
/*N*/ 	const TypeId*	pType,
/*N*/ 	BOOL			bOnlyVisible
/*N*/ )
/*N*/ {
/*N*/ 	SfxViewShellArr_Impl &rShells = SFX_APP()->GetViewShells_Impl();
/*N*/ 
/*N*/ 	// search for a SfxViewShell of the specified type
/*N*/ 	for ( USHORT nPos = 0; nPos < rShells.Count(); ++nPos )
/*N*/ 	{
/*N*/ 		SfxViewShell *pShell = rShells.GetObject(nPos);
/*N*/ 		if ( !pType || pShell->IsA(*pType) )
/*N*/ 			return pShell;
/*N*/ 	}
/*N*/ 
/*N*/ 	return 0;
/*N*/ }

//--------------------------------------------------------------------
// returns the next shell of spec. type viewing the specified doc.

/*N*/ SfxViewShell* SfxViewShell::GetNext
/*N*/ (
/*N*/ 	const SfxViewShell&	rPrev,
/*N*/ 	const TypeId*		pType,
/*N*/ 	BOOL				bOnlyVisible
/*N*/ )
/*N*/ {
/*N*/ 	SfxViewShellArr_Impl &rShells = SFX_APP()->GetViewShells_Impl();
/*N*/ 
/*N*/ 	// refind the specified predecessor
/*N*/ 	USHORT nPos;
/*N*/ 	for ( nPos = 0; nPos < rShells.Count(); ++nPos )
/*N*/ 		if ( rShells.GetObject(nPos) == &rPrev )
/*N*/ 			break;
/*N*/ 
/*N*/ 	// search for a Frame of the specified type
/*N*/ 	for ( ++nPos; nPos < rShells.Count(); ++nPos )
/*N*/ 	{
/*?*/ 		SfxViewShell *pShell = rShells.GetObject(nPos);
/*?*/ 		if ( !pType || pShell->IsA(*pType) )
/*?*/ 			return pShell;
/*N*/ 	}
/*N*/ 	return 0;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::SFX_NOTIFY( SfxBroadcaster& rBC,
/*N*/ 							const TypeId& rBCType,
/*N*/ 							const SfxHint& rHint,
/*N*/ 							const TypeId& rHintType )
/*N*/ {
/*N*/ //! (pb) do we need here new implementation?
///*N*/ #ifndef NOOLDSV
///*N*/ 	if ( rHint.ISA(SfxSysChangeHint) && SETTINGS_CHANGE_PRINTER ==
///*N*/ 		 ( (const SfxSysChangeHint &)rHint ).GetChangeType() )
///*N*/ 	{
///*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxPrinter *pPrinter = GetPrinter();
///*N*/ 	}
///*N*/ #endif
/*N*/ 
/*N*/     if ( rHint.IsA(TYPE(SfxEventHint)) )
/*N*/     {
/*N*/         switch ( ((SfxEventHint&)rHint).GetEventId() )
/*N*/         {
/*N*/             case SFX_EVENT_LOADFINISHED:
/*N*/             {
/*?*/                 if ( GetController().is() )
/*?*/                 {
/*?*/                     SfxItemSet* pSet = GetObjectShell()->GetMedium()->GetItemSet();
/*?*/                     SFX_ITEMSET_ARG( pSet, pItem, SfxUsrAnyItem, SID_VIEW_DATA, sal_False );
/*?*/                     if ( pItem )
/*?*/                         pImp->pController->restoreViewData( pItem->GetValue() );
/*?*/                     pSet->ClearItem( SID_VIEW_DATA );
/*?*/                 }
/*?*/                 break;
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ }

//--------------------------------------------------------------------


/*  [Beschreibung]

	Diese Methode f"uhrt das KeyEvent 'rKeyEvent' "uber die an dieser
	SfxViewShell direkt oder indirekt (z.B. via Applikation) konfigurierten
	Tasten (Accelerator) aus.


	[R"uckgabewert]

	FASTBOOL                TRUE
							die Taste ist konfiguriert, der betreffende
							Handler wurde gerufen

							FALSE
							die Taste ist nicht konfiguriert, es konnte
							also kein Handler gerufen werden


	[Querverweise]
	<SfxApplication::KeyInput(const KeyEvent&)>
*/


//--------------------------------------------------------------------

/*N*/ void SfxViewShell::ShowCursor( FASTBOOL bOn )

/*  [Beschreibung]

	Diese Methode mu\s von Subklassen "uberladen werden, damit vom SFx
	aus der Cursor ein- und ausgeschaltet werden kann. Dies geschieht
	z.B. bei laufendem <SfxProgress>.
*/

/*N*/ {
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::GotFocus() const

/*  [Beschreibung]

	Diese Methode mu\s vom Applikationsentwickler gerufen werden, wenn
	das Edit-Window den Focus erhalten hat. Der SFx hat so z.B. die
	M"oglichkeit, den Accelerator einzuschalten.


	[Anmerkung]

	<StarView> liefert leider keine M"oglichkeit, solche Events
	'von der Seite' einzuh"angen.
*/

/*N*/ {
/*N*/ }

//--------------------------------------------------------------------


/*  [Beschreibung]

	Virtuelle Methode, um am selektierten Objekt ein Verb auszuf"uhren.
	Da dieses Objekt nur den abgeleiteten Klassen bekannt ist, mu DoVerb
	dort "uberlschrieben werden.

*/


//--------------------------------------------------------------------

/*N*/ void SfxViewShell::DisconnectClients_Impl(SvInPlaceClient *pIP)

/*  [Beschreibung]

	Diese Methode dient dazu, bei UI-Aktivierung eins IPClients alle anderen
	noch bestehenden Verbindungen zu trennen.

*/

/*N*/ {
/*N*/ 
/*N*/ 	// SO2 stellt sicher, da\s nur ein Object gleichzeitig UI-aktiv ist.
/*N*/ 	// Aus Speicherplatzgr"unden werden aber alle Objekte, die nicht aktiv
/*N*/ 	// sind oder sein m"ussen, disconnected.
/*N*/ 
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( !pClients )
/*N*/ 		return;
/*N*/ 
/*N*/ 	SvInPlaceClientRef aIPClient;
/*N*/     for ( USHORT n=0; n < pClients->Count(); n++ )
/*N*/ 	{
/*?*/ 		aIPClient = pClients->GetObject(n);
/*?*/ 		if( aIPClient.Is() && aIPClient != pIP && aIPClient->GetIPObj() &&
/*?*/ 				!(aIPClient->GetIPObj()->GetMiscStatus() & SVOBJ_MISCSTATUS_ACTIVATEWHENVISIBLE) )
/*?*/             aIPClient->GetProtocol().Reset2Connect();
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::DisconnectAllClients()
/*N*/ {
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( !pClients )
/*N*/ 		return;
/*N*/ 
/*N*/ 	SvInPlaceClientRef aIPClient;
/*N*/ 	for ( USHORT n=0; n<pClients->Count(); )
/*N*/ 	{
/*?*/ 		aIPClient = pClients->GetObject(n);
/*?*/ 		if( aIPClient.Is() && aIPClient->GetIPObj() )
/*?*/ 			aIPClient->DoDisconnect();
/*?*/ 		else
/*?*/ 			n++;
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ BOOL SfxViewShell::UseObjectSize() const
/*N*/ {
/*N*/ 	return pImp->bUseObjectSize;
/*N*/ }

//--------------------------------------------------------------------


//--------------------------------------------------------------------


//--------------------------------------------------------------------

/*N*/ void SfxViewShell::VisAreaChanged(const Rectangle& rVisArea)
/*N*/ {
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( !pClients )
/*N*/ 		return;
/*N*/ 
/*N*/ 	SvInPlaceClientRef aIPClient;
/*N*/ 	for (USHORT n=0; n < pClients->Count(); n++)
/*N*/ 	{
/*?*/ 		// Die Liste enth"alt alle connected clients
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 aIPClient = pClients->GetObject(n);
/*N*/ 	}
/*N*/ }


//--------------------------------------------------------------------


//--------------------------------------------------------------------


//--------------------------------------------------------------------

/*N*/ void SfxViewShell::DiscardClients_Impl()

/*  [Beschreibung]

	Diese Methode dient dazu, vor dem Schlie\sen eines Dokuments das
	Speichern der Objekte zu verhindern, wenn der Benutzer Schlie\en ohne
	Speichern gew"ahlt hatte.
*/

/*N*/ {
/*N*/ 	SvInPlaceClientMemberList *pClients = GetIPClientList_Impl(FALSE);
/*N*/ 	if ( !pClients )
/*N*/ 		return;
/*N*/ 
/*N*/ 	SvInPlaceClientRef aIPClient;
/*N*/ 	for (USHORT n=0; n < pClients->Count(); n++)
/*N*/ 	{
/*?*/ 		aIPClient = pClients->GetObject(n);
/*?*/ 		if( aIPClient.Is() )
/*?*/ 		{
/*?*/ 			if (aIPClient->GetIPObj())
/*?*/ 			{
/*?*/ 				aIPClient->GetIPObj()->SetAutoSave(FALSE);
/*?*/ 				aIPClient->DoDisconnect();
/*?*/ 				aIPClient.Clear();
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxScrollingMode SfxViewShell::GetScrollingMode() const
/*N*/ {
/*N*/ 	return pImp->eScroll;
/*N*/ }

//--------------------------------------------------------------------


//--------------------------------------------------------------------


//--------------------------------------------------------------------


//--------------------------------------------------------------------

/*N*/ SfxObjectShell* SfxViewShell::GetObjectShell()
/*N*/ {
/*N*/ 	return GetViewFrame()->GetObjectShell();
/*N*/ }

//--------------------------------------------------------------------

/*N*/ const Size& SfxViewShell::GetMargin() const
/*N*/ {
/*N*/ 	return pImp->aMargin;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::SetMargin( const Size& rSize )
/*N*/ {
/*N*/ 	// Der default-Margin wurde "geeicht" mit www.apple.com !!
/*N*/ 	Size aMargin = rSize;
/*N*/ 	if ( aMargin.Width() == -1 )
/*N*/ 		aMargin.Width() = DEFAULT_MARGIN_WIDTH;
/*N*/ 	if ( aMargin.Height() == -1 )
/*N*/ 		aMargin.Height() = DEFAULT_MARGIN_HEIGHT;
/*N*/ 
/*N*/ 	if ( aMargin != pImp->aMargin )
/*N*/ 	{
/*N*/ 		pImp->aMargin = aMargin;
/*N*/ 		MarginChanged();
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewShell::MarginChanged()
/*N*/ {
/*N*/ }

//--------------------------------------------------------------------

/*N*/ BOOL SfxViewShell::IsShowView_Impl() const
/*N*/ {
/*N*/ 	return pImp->bIsShowView;
/*N*/ }

//--------------------------------------------------------------------


//--------------------------------------------------------------------

/*N*/ BOOL SfxViewShell::IsImplementedAsFrameset_Impl( ) const
/*N*/ {
/*N*/ 	return pImp->bFrameSetImpl;
/*N*/ }

//------------------------------------------------------------------------


//------------------------------------------------------------------------

#if !SFX_VIEWSH_INCLUDES_CLIENTSH_HXX




#endif


/*N*/ SfxMenuBarManager* SfxViewShell::GetMenuBar_Impl( BOOL bPlugin )
/*N*/ {
/*N*/ 	// get the accelerators
/*N*/ 	GetAccMgr_Impl();
/*N*/ 	if ( !pImp->pMenu )
/*N*/         pImp->pMenu = GetObjectShell()->CreateMenuBarManager_Impl( GetViewFrame() );
/*N*/ 	return pImp->pMenu;
/*N*/ }

/*N*/ SfxAcceleratorManager* SfxViewShell::GetAccMgr_Impl()
/*N*/ {
/*N*/ 	// all views of a document share the accelerators
/*N*/ #if SUPD>633
/*N*/     return GetObjectShell()->GetAccMgr_Impl();
/*N*/ #else
/*N*/     return GetObjectShell()->GetFactory().GetAccMgr_Impl();
/*N*/ #endif
/*N*/ }

/*
void SfxViewShell::SetMenuBar_Impl( const ResId& rId )
{
	if ( !pImp->pMenuBarResId ||
		rId.GetId() != pImp->pMenuBarResId->GetId() ||
		rId.GetResMgr() != pImp->pMenuBarResId->GetResMgr() )
	{
		DELETEZ( pImp->pMenuBarResId );

        if ( pImp->pMenu )
		{
            if ( pImp->bOwnsMenu )
            {
                SfxTopViewFrame* pTopView = PTR_CAST( SfxTopViewFrame, GetViewFrame()->GetTopViewFrame() );
                SfxTopFrame *pTop = pTopView ? pTopView->GetTopFrame_Impl() : NULL;
                if ( pTop )
                {
                    Menu* pMenu = pImp->pMenu->GetMenu()->GetSVMenu();
                    if ( pMenu == pTop->GetMenuBar_Impl() )
                        pTop->SetMenuBar_Impl( 0 );
                }

                DELETEZ( pImp->pMenu );
            }
            else
                pImp->pMenu = NULL;
		}

		if ( rId.GetId() )
			pImp->pMenuBarResId = new ResId(rId);
	}
}
*/

/*N*/ void SfxViewShell::SetController( SfxBaseController* pController )
/*N*/ {
/*N*/     pImp->pController = pController;
/*N*/     pImp->pController->acquire();
/*N*/     pImp->bControllerSet = TRUE;
/*N*/ }

/*N*/ Reference < XController > SfxViewShell::GetController()
/*N*/ {
/*N*/     if ( !pImp->pController )
/*N*/         new SfxBaseController( this );
/*N*/     return pImp->pController;
/*N*/ }




/*?*/ void Change( Menu* pMenu, SfxViewShell* pView )
/*?*/ {{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 
/*?*/ }








}
