/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_viewfrm.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:53:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <stdio.h>


#ifndef _IPENV_HXX //autogen
#include <so3/ipenv.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _UNDO_HXX //autogen
#include <svtools/undo.hxx>
#endif
#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif



#include <com/sun/star/uno/Reference.h>
#include <com/sun/star/ucb/XContent.hpp>



using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::ucb;
using namespace ::com::sun::star::frame;

#pragma hdrstop

#include "objshimp.hxx"
#include "dispatch.hxx"
#include "loadenv.hxx"
#include "arrdecl.hxx"
#include "newhdl.hxx"
#include "request.hxx"
#include "viewfac.hxx"
#include "event.hxx"
#include "fsetobsh.hxx"
#include "docfile.hxx"
#include "interno.hxx"
#include "topfrm.hxx"
#include "fsetvwsh.hxx"
#include "sfxbasecontroller.hxx"
#include "sfx.hrc"
#include "view.hrc"
#include "frmdescr.hxx"
#include "workwin.hxx"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxconf.hxx"
#include "tbxcust.hxx"

//STRIP002 #ifndef _LEGACYBINFILTERMGR_HXX
//STRIP002 #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
//STRIP002 #endif

//-------------------------------------------------------------------------
/*N*/ DBG_NAME(SfxViewFrame)

#define SfxViewFrame
namespace binfilter {
#include "sfxslots.hxx"

//-------------------------------------------------------------------------

/*N*/ SFX_IMPL_INTERFACE(SfxViewFrame,SfxShell,SfxResId(0))
/*N*/ {
/*N*/     SFX_CHILDWINDOW_REGISTRATION( SID_BROWSER );
/*N*/     SFX_CHILDWINDOW_REGISTRATION( SID_RECORDING_FLOATWINDOW );
/*N*/ }

/*N*/ TYPEINIT2(SfxViewFrame,SfxShell,SfxListener);

//=========================================================================

struct SfxViewFrame_Impl
{
    SvBorder            aBorder;
    Size                aMargin;
    Size                aSize;
    String              aViewData;
    String              aFrameTitle;
    TypeId              aLastType;
	String				aActualURL;
	String				aActualPresentationURL;
    SfxFrame*           pFrame;
    SfxCancelManager*   pCancelMgr;
    svtools::AsynchronLink* pReloader;
	SfxInPlaceFrame*	pIPFrame;
	Window*				pWindow;
    SfxViewFrame*       pActiveChild;
    SfxViewFrame*       pParentViewFrame;
    SfxObjectShell*     pImportShell;
    Window*             pFocusWin;
    SfxMacro*           pMacro;
    SfxMenuBarManager*  pMenuBar;
    sal_uInt16          nDocViewNo;
    sal_uInt16          nCurViewId;
    sal_Bool            bResizeInToOut:1;
    sal_Bool            bDontOverwriteResizeInToOut:1;
    sal_Bool            bObjLocked:1;
    sal_Bool            bRestoreView:1;
    sal_Bool            bSetViewFrameLocked:1;
    sal_Bool            bReloading:1;
    sal_Bool            bIsDowning:1;
    sal_Bool            bInCtor:1;
    sal_Bool            bModal:1;
    sal_Bool            bEnabled:1;

                        SfxViewFrame_Impl()
                        : pReloader(0 )
                        , pMacro( 0 )
                        {}

                        ~SfxViewFrame_Impl()
                        {
                            delete pReloader;
                            delete pCancelMgr;
                        }
};

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::SetDowning_Impl()
/*N*/ {
/*N*/     pImp->bIsDowning = sal_True;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ sal_Bool SfxViewFrame::IsDowning_Impl() const
/*N*/ {
/*N*/     return pImp->bIsDowning;
/*N*/ }


//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
/*N*/ sal_Bool SfxViewFrame::IsSetViewFrameAllowed_Impl() const
/*N*/ {
/*N*/     return !pImp->bSetViewFrameLocked;
/*N*/ }

//-------------------------------------------------------------------------

//--------------------------------------------------------------------


class SfxViewNotificatedFrameList_Impl :
    public SfxListener, public SfxViewFrameArr_Impl
{
public:

    void InsertViewFrame( SfxViewFrame* pFrame )
    {
        StartListening( *pFrame );
        C40_INSERT( SfxViewFrame, pFrame, Count() );
    }
};

//-------------------------------------------------------------------------

//-------------------------------------------------------------------------


/*N*/ void SfxViewFrame::ExecReload_Impl( SfxRequest& rReq, sal_Bool bAsync )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

/*N*/ void SfxViewFrame::ExecReload_Impl( SfxRequest& rReq )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::StateReload_Impl( SfxItemSet& rSet )
/*N*/ {
/*N*/     SfxObjectShell* pSh = GetObjectShell();
/*N*/ 	if ( !pSh )
/*N*/ 		// Ich bin gerade am Reloaden und Yielde so vor mich hin ...
/*N*/ 		return;
/*N*/ 
/*N*/     SfxFrame *pParent = GetFrame()->GetParentFrame();
/*N*/     SfxWhichIter aIter( rSet );
/*N*/     for ( sal_uInt16 nWhich = aIter.FirstWhich(); nWhich; nWhich = aIter.NextWhich() )
/*N*/     {
/*N*/ 		if ( GetFrame()->HasComponent() )
/*N*/ 		{
/*N*/ 			// Wenn die Komponente es nicht selbst dispatched, dann
/*N*/ 			// macht es auch keinen Sinn!
/*?*/ 			rSet.DisableItem( nWhich );
/*?*/ 			continue;
/*N*/ 		}
/*N*/ 
/*N*/         switch ( nWhich )
/*N*/         {
/*N*/             case SID_EDITDOC:
/*N*/             {
/*N*/ 		        if ( !pSh || !pSh->HasName() || !( pSh->Get_Impl()->nLoadedFlags &  SFX_LOADED_MAINDOCUMENT ) )
/*N*/ 		            rSet.DisableItem( SID_EDITDOC );
/*N*/ 		        else
/*N*/ 				{
/*N*/ 					SFX_ITEMSET_ARG( pSh->GetMedium()->GetItemSet(), pItem, SfxBoolItem, SID_EDITDOC, sal_False );
/*N*/ 					if ( pItem && !pItem->GetValue() )
/*N*/ 						rSet.DisableItem( SID_EDITDOC );
/*N*/ 					else
/*N*/ 						rSet.Put( SfxBoolItem( nWhich, !pSh->IsReadOnly() ) );
/*N*/ 				}
/*N*/                 break;
/*N*/             }
/*N*/ 
/*N*/             case SID_RELOAD:
/*N*/             {
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxFrame* pFrame = GetTopFrame();
/*?*/                 break;
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ }


//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::ExecHistory_Impl( SfxRequest &rReq )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::StateHistory_Impl( SfxItemSet &rSet )
/*N*/ {
/*N*/     // Undo-Manager suchen
/*N*/     SfxShell *pSh = GetDispatcher()->GetShell(0);
/*N*/ 	if ( !pSh )
/*N*/ 		// Ich bin gerade am Reloaden und Yielde so vor mich hin ...
/*N*/ 		return;
/*N*/ 
/*N*/     SfxUndoManager *pUndoMgr = pSh->GetUndoManager();
/*N*/     if ( !pUndoMgr )
/*N*/     {
/*N*/         // der SW hat eigenes Undo an der ::com::sun::star::sdbcx::View
/*N*/         SfxWhichIter aIter( rSet );
/*N*/         SfxViewShell *pViewSh = GetViewShell();
/*N*/         if( !pViewSh ) return;
/*N*/         for ( sal_uInt16 nSID = aIter.FirstWhich(); nSID; nSID = aIter.NextWhich() )
/*N*/             pViewSh->GetSlotState( nSID, 0, &rSet );
/*N*/         return;
/*N*/     }
/*N*/ 
/*N*/     if ( pUndoMgr->GetUndoActionCount() == 0 &&
/*N*/          pUndoMgr->GetRedoActionCount() == 0 &&
/*N*/          pUndoMgr->GetRepeatActionCount() == 0 )
/*N*/         rSet.DisableItem( SID_CLEARHISTORY );
/*N*/ 
/*N*/     if ( pUndoMgr && pUndoMgr->GetUndoActionCount() )
/*N*/ 	{
/*N*/         String aTmp( SfxResId( STR_UNDO ) );
/*N*/ 		aTmp += pUndoMgr->GetUndoActionComment(0);
/*N*/ 		rSet.Put( SfxStringItem( SID_UNDO, aTmp ) );
/*N*/ 	}
/*N*/     else
/*N*/         rSet.DisableItem( SID_UNDO );
/*N*/ 
/*N*/     if ( pUndoMgr && pUndoMgr->GetRedoActionCount() )
/*N*/ 	{
/*?*/         String aTmp( SfxResId(STR_REDO) );
/*?*/ 		aTmp += pUndoMgr->GetRedoActionComment(0);
/*?*/ 		rSet.Put( SfxStringItem( SID_REDO, aTmp ) );
/*N*/ 	}
/*N*/     else
/*N*/         rSet.DisableItem( SID_REDO );
/*N*/     SfxRepeatTarget *pTarget = pSh->GetRepeatTarget();
/*N*/     if ( pUndoMgr && pTarget && pUndoMgr->GetRepeatActionCount() &&
/*N*/          pUndoMgr->CanRepeat(*pTarget, 0) )
/*N*/ 	{
/*N*/         String aTmp( SfxResId(STR_REPEAT) );
/*N*/ 		aTmp += pUndoMgr->GetRepeatActionComment(*pTarget, 0);
/*N*/ 		rSet.Put( SfxStringItem( SID_REPEAT, aTmp ) );
/*N*/ 	}
/*N*/     else
/*N*/         rSet.DisableItem( SID_REPEAT );
/*N*/ }

//--------------------------------------------------------------------

/*  [Beschreibung]

    Diese Methode setzt eine <SfxObjectShell> in den SfxViewFrame ein.

    Zuvor mu\s die vorherige SfxObjectShell, insofern schein eine gesetzt
    wurde, mit der Methode ReleaseObjectShell() entfernt worden sein. Somit
    kann durch Aufruf von ReleaseObjectShell() und SetObjectShell() die
    SfxObjectShell ausgetauscht werden.


    [Querverweise]

    <SfxViewFrame::ReleaseObjectShell()>
*/


//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::ReleaseObjectShell_Impl( sal_Bool bStoreView )

/*  [Beschreibung]

    Diese Methode entleert den SfxViewFrame, d.h. nimmt die <SfxObjectShell>
    vom Dispatcher und beendet seine <SfxListener>-Beziehung zu dieser
    SfxObjectShell (wodurch sie sich ggf. selbst zerst"ort).

    Somit kann durch Aufruf von ReleaseObjectShell() und SetObjectShell()
    die SfxObjectShell ausgetauscht werden.

    Zwischen RealeaseObjectShell() und SetObjectShell() darf die Kontrolle
    nicht an das ::com::sun::star::chaos::System abgegeben werden.


    [Querverweise]

    <SfxViewFrame::SetObjectShell(SfxObjectShell&)>
*/
/*N*/ {
/*N*/     DBG_CHKTHIS(SfxViewFrame, 0);
/*N*/     DBG_ASSERT( xObjSh.Is(), "no SfxObjectShell to release!" );
/*N*/ 
/*N*/ 	GetFrame()->ReleasingComponent_Impl( sal_True );
/*N*/ 	SfxViewShell *pDyingViewSh = GetViewShell();
/*N*/     pImp->aLastType = xObjSh->Type();
/*N*/ 
/*N*/     HACK(MI weiss nicht wie !pSh sein kann - nach PlugIns isses aber so)
/*N*/     if ( pDyingViewSh )
/*N*/     {
/*N*/         // Gibt es noch andere Views auf mein Doc?
/*N*/         SfxViewFrame *pView = GetFirst(xObjSh);
/*N*/         while( pView )
/*N*/         {
/*N*/             if ( pView != this )
/*N*/                 break;
/*N*/             pView = GetNext( *pView, xObjSh );
/*N*/         }
/*N*/ 
/*N*/         if ( !pView )
/*N*/         {
/*N*/             // Ich bin die letzte ::com::sun::star::sdbcx::View
/*N*/             SfxObjectFactory *pFactory = &xObjSh->GetFactory();
/*N*/             if ( pFactory && pFactory->GetFlags() & SFXOBJECTSHELL_HASOPENDOC )
/*N*/ 			{
/*N*/                 // Event nur bei echten Dokumenten
/*N*/ 				xObjSh->Get_Impl()->bInCloseEvent = sal_True;
/*N*/                 SFX_APP()->NotifyEvent( SfxEventHint(SFX_EVENT_CLOSEDOC, xObjSh) );
/*N*/ 				xObjSh->Get_Impl()->bInCloseEvent = sal_False;
/*N*/ 			}
/*N*/         }
/*N*/ 
/*N*/         SetRestoreView_Impl( bStoreView );
/*N*/         if ( bStoreView )
/*?*/             {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pDyingViewSh->WriteUserData( GetViewData_Impl(), sal_True );
/*N*/ 
/*N*/ 	    // Falls es SubFrames gibt, m"ussen diese deleted werden, solange noch
/*N*/ 	    // die FramesetViewShell da ist, sonst gibt es Probleme.
/*N*/ 		// Um Flackern bei den Objectbars zu vermeiden, werden die SubFrames
/*N*/ 		// zerst"ort, solange die FrameSetView noch da ist.
/*N*/ 	    if ( pDyingViewSh->IsA( TYPE(SfxFrameSetViewShell) ) )
/*N*/ 	    {
/*?*/ 	        DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Window *pWindow = pDyingViewSh->GetWindow();
/*N*/ 	    }
/*N*/ 
/*N*/         // Jetzt alle SubShells wechhauen
/*N*/ 		pDyingViewSh->PushSubShells_Impl( sal_False );
/*N*/         sal_uInt16 nLevel = pDispatcher->GetShellLevel( *pDyingViewSh );
/*N*/         if ( nLevel && nLevel != USHRT_MAX )
/*N*/         {
/*N*/             // Es gibt immer nocht SubShells
/*N*/             SfxShell *pSubShell = pDispatcher->GetShell( nLevel-1 );
/*N*/             if ( pSubShell == pDyingViewSh->GetSubShell() )
/*N*/                 //"Echte" Subshells nicht deleten
/*?*/                 pDispatcher->Pop( *pSubShell, SFX_SHELL_POP_UNTIL );
/*N*/             else
/*N*/                 pDispatcher->Pop( *pSubShell, SFX_SHELL_POP_UNTIL | SFX_SHELL_POP_DELETE );
/*N*/         }
/*N*/         pDispatcher->Pop( *pDyingViewSh );
/*N*/     }
/*N*/ #ifdef DBG_UTIL
/*N*/     else
/*N*/         DBG_ERROR("Keine Shell");
/*N*/ #endif
/*N*/ 
/*N*/     GetDispatcher()->Flush();
/*N*/ 
/*N*/ 	if ( GetWindow().HasChildPathFocus( sal_True ) )
/*N*/ 	{
/*N*/ 		DBG_ASSERT( !GetActiveChildFrame_Impl(), "Wrong active child frame!" );
/*N*/ 		GetWindow().GrabFocus();
/*N*/ 	}
/*N*/ 
/*N*/ 	pDyingViewSh->DisconnectClients_Impl( NULL );
/*N*/     SetViewShell_Impl(0);
/*N*/     delete pDyingViewSh;
/*N*/ 
/*N*/     pDispatcher->Pop( *xObjSh );
/*N*/     SfxModule* pModule = xObjSh->GetModule();
/*N*/     if( pModule )
/*N*/         pDispatcher->RemoveShell_Impl( *pModule );
/*N*/ 
/*N*/     pDispatcher->Flush();
/*N*/     EndListening( *xObjSh );
/*N*/     SFX_NOTIFY( *xObjSh, xObjSh->Type(),
/*N*/             SfxSimpleHint(SFX_HINT_TITLECHANGED),
/*N*/             TYPE(SfxSimpleHint) );
/*N*/ 
/*N*/     SFX_NOTIFY( *xObjSh, xObjSh->Type(),
/*N*/             SfxSimpleHint(SFX_HINT_DOCCHANGED),
/*N*/             TYPE(SfxSimpleHint) );
/*N*/ 
/*N*/     // Damit ::com::sun::star::script::JavaScript Objekte das ::com::sun::star::script::JavaScript ueber
/*N*/     // Frame->ViewFrame->DocShell->Medium bei CloseEvents besorgen koennen
/*N*/     SfxViewFrame* pFrame = SfxViewFrame::GetFirst( xObjSh, TYPE(SfxInPlaceFrame ) );
/*N*/     if ( 1 == xObjSh->GetOwnerLockCount() && pImp->bObjLocked && !pFrame )
/*N*/         xObjSh->DoClose();
/*N*/     SfxObjectShellRef xDyingObjSh = xObjSh;
/*N*/     xObjSh.Clear();
/*N*/     if( ( GetFrameType() & SFXFRAME_HASTITLE ) && pImp->nDocViewNo )
/*N*/         xDyingObjSh->GetNoSet_Impl().ReleaseIndex(pImp->nDocViewNo-1);
/*N*/     if ( pImp->bObjLocked )
/*N*/     {
/*N*/         xDyingObjSh->OwnerLock( sal_False );
/*N*/         pImp->bObjLocked = sal_False;
/*N*/     }
/*N*/ 
/*N*/ 	GetDispatcher()->SetDisableFlags( 0 );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ String SfxViewFrame::UpdateTitle()

/*  [Beschreibung]

    Mit dieser Methode kann der SfxMDIFrame gezwungen werden, sich sofort
    den neuen Titel vom der <SfxObjectShell> zu besorgen.

    [Anmerkung]

    Dies ist z.B. dann notwendig, wenn man der SfxObjectShell als SfxListener
    zuh"ort und dort auf den <SfxSimpleHint> SFX_HINT_TITLECHANGED reagieren
    m"ochte, um dann die Titel seiner Views abzufragen. Diese Views (SfxMDIFrames)
    jedoch sind ebenfalls SfxListener und da die Reihenfolge der Benachrichtigung
    nicht feststeht, mu\s deren Titel-Update vorab erzwungen werden.


    [Beispiel]

    void SwDocShell::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
    {
        if ( rHint.IsA(TYPE(SfxSimpleHint)) )
        {
            switch( ( (SfxSimpleHint&) rHint ).GetId() )
            {
                case SFX_HINT_TITLECHANGED:
                    for ( SfxMDIFrame *pMDI = (SfxMDIFrame*)
                                SfxViewFrame::GetFirst(this, TYPE(SfxMDIFrame));
                          pMDI;
                          pMDI = (SfxMDIFrame*)
                                SfxViewFrame::GetNext(this, TYPE(SfxMDIFrame));
                    {
                        pMDI->UpdateTitle();
                        ... pMDI->GetName() ...
                    }
                    break;
                ...
            }
        }
    }
*/

/*N*/ {
/*N*/     SfxObjectShell *pObjSh = GetObjectShell();
/*N*/ 	if ( !pObjSh )
/*N*/         return String();
/*N*/ 
/*N*/     if  ( pObjSh->GetInPlaceObject() && pObjSh->GetInPlaceObject()->GetProtocol().IsEmbed() )
/*N*/         // kein UpdateTitle mit Embedded-ObjectShell
/*N*/         return String();
/*N*/ 
/*N*/     const SfxMedium *pMedium = pObjSh->GetMedium();
/*N*/ 	String aURL;
/*N*/ 	SfxFrame *pFrm = GetFrame();
/*N*/     if ( pObjSh->HasName() )
/*N*/ 	{
/*N*/ 		INetURLObject aTmp( pMedium->GetName() );
/*N*/         aURL = aTmp.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET );
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( aURL != pImp->aActualURL )
/*N*/         // URL hat sich ge"andert
/*N*/ 		pImp->aActualURL = aURL;
/*N*/ 
/*N*/     // gibt es noch eine weitere View?
/*N*/     sal_uInt16 nViews=0;
/*N*/     for ( SfxViewFrame *pView= GetFirst(pObjSh);
/*N*/           pView && nViews<2;
/*N*/           pView = GetNext(*pView,pObjSh) )
/*N*/         if ( ( pView->GetFrameType() & SFXFRAME_HASTITLE ) &&
/*N*/              !IsDowning_Impl())
/*N*/             nViews++;
/*N*/ 
/*N*/     // Titel des Fensters
/*N*/     String aTitle;
/*N*/     if ( nViews == 2 || pImp->nDocViewNo > 1 )
/*N*/         // dann die Nummer dranh"angen
/*?*/         aTitle = pObjSh->UpdateTitle( NULL, pImp->nDocViewNo );
/*N*/     else
/*N*/         aTitle = pObjSh->UpdateTitle();
/*N*/ 
/*N*/     // Name des SbxObjects
/*N*/     String aSbxName = pObjSh->SfxShell::GetName();
/*N*/     if ( IsVisible() )
/*N*/     {
/*N*/         aSbxName += ':';
/*N*/         aSbxName += String::CreateFromInt32(pImp->nDocViewNo);
/*N*/     }
/*N*/ 
/*N*/     SetName( aSbxName );
/*N*/     pImp->aFrameTitle = aTitle;
/*N*/     GetBindings().Invalidate( SID_FRAMETITLE );
/*N*/     GetBindings().Invalidate( SID_CURRENT_URL );
/*N*/     return aTitle;
/*N*/ }


//--------------------------------------------------------------------
/*N*/ sal_Bool SfxViewFrame::Close()
/*N*/ {
/*N*/     DBG_CHKTHIS(SfxViewFrame, 0);
/*N*/ 
/*N*/     DBG_ASSERT( GetFrame()->IsClosing_Impl() || !GetFrame()->GetFrameInterface().is(), "ViewFrame closed too early!" );
/*N*/ 
/*N*/ 	// Wenn bis jetzt noch nicht gespeichert wurde, sollen eingebettete Objekte
/*N*/ 	// auch nicht mehr automatisch gespeichert werden!
/*N*/ 	if ( GetViewShell() )
/*N*/ 		GetViewShell()->DiscardClients_Impl();
/*N*/ 	Broadcast( SfxSimpleHint(SFX_HINT_DYING) );
/*N*/ 
/*N*/     return sal_True;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewFrame::DoActivate( sal_Bool bUI, SfxViewFrame* pOldFrame )
/*N*/ {
/*N*/     DBG_CHKTHIS(SfxViewFrame, 0);
/*N*/     SfxApplication *pSfxApp = SFX_APP();
/*N*/ 
/*N*/ #ifdef WIN
/*N*/     pSfxApp->TestFreeResources_Impl();
/*N*/ #endif
/*N*/ 
/*N*/     pDispatcher->DoActivate_Impl( bUI );
/*N*/ 
/*N*/     // Wenn ich einen parent habe und dieser ist kein parent des alten
/*N*/     // ViewFrames, erh"alt er ein ParentActivate
/*N*/     if ( bUI )
/*N*/     {
/*
		SfxMedium* pMed = GetObjectShell() ? GetObjectShell()->GetMedium() : NULL;
		if( pMed )
		{
            SFX_ITEMSET_ARG(
                pMed->GetItemSet(), pInterceptorItem, SfxSlotInterceptorItem,
                SID_INTERCEPTOR, sal_False );
			if( pInterceptorItem )
			{
				SfxSlotInterceptor* pInter = pInterceptorItem->GetValue();
				if( !pInter->GetBindings() )
					pInter->SetBindings( &GetBindings() );
				pInter->Activate( sal_True );
			}
		}
 */
/*N*/         SfxViewFrame *pFrame = GetParentViewFrame();
/*N*/         while ( pFrame )
/*N*/         {
/*?*/             DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( !pOldFrame || !pOldFrame->GetFrame()->IsParent( pFrame->GetFrame() ) )
/*N*/         }
/*N*/     }
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::DoDeactivate(sal_Bool bUI, SfxViewFrame* pNewFrame )
/*N*/ {
/*N*/     DBG_CHKTHIS(SfxViewFrame, 0);
/*N*/     SfxApplication *pSfxApp = SFX_APP();
/*N*/     pDispatcher->DoDeactivate_Impl( bUI );
/*N*/ 
/*N*/     // Wenn ich einen parent habe und dieser ist kein parent des neuen
/*N*/     // ViewFrames, erh"alt er ein ParentDeactivate
/*N*/     if ( bUI )
/*N*/     {
/*N*/ //        if ( GetFrame()->GetWorkWindow_Impl() )
/*N*/ //            GetFrame()->GetWorkWindow_Impl()->SaveStatus_Impl();
/*
		SfxMedium* pMed = GetObjectShell() ? GetObjectShell()->GetMedium() : NULL;
		if( pMed )
		{
            SFX_ITEMSET_ARG(
                pMed->GetItemSet(), pInterceptorItem, SfxSlotInterceptorItem,
                SID_INTERCEPTOR, sal_False );
			if( pInterceptorItem )
				pInterceptorItem->GetValue()->Activate( sal_False );
		}
*/
/*N*/         SfxViewFrame *pFrame = GetParentViewFrame();
/*N*/         while ( pFrame )
/*N*/         {
/*N*/             if ( !pNewFrame || !pNewFrame->GetFrame()->IsParent( pFrame->GetFrame() ) )
/*N*/                 pFrame->pDispatcher->DoParentDeactivate_Impl();
/*N*/             pFrame = pFrame->GetParentViewFrame();
/*N*/         }
/*N*/     }
/*N*/ #ifdef WIN
/*N*/     pSfxApp->TestFreeResources_Impl();
/*N*/ #endif
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void SfxViewFrame::InvalidateBorderImpl
/*N*/ (
/*N*/     const SfxViewShell* pSh
/*N*/ )
/*N*/ 
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//------------------------------------------------------------------------
/*N*/ sal_Bool SfxViewFrame::SetBorderPixelImpl
/*N*/ (
/*N*/     const SfxViewShell* pSh,
/*N*/     const SvBorder&     rBorder
/*N*/ )
/*N*/ 
/*N*/ {
/*N*/     pImp->aBorder = rBorder;
/*N*/     return sal_True;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ const SvBorder& SfxViewFrame::GetBorderPixelImpl
/*N*/ (
/*N*/     const SfxViewShell* pSh
/*N*/ )   const
/*N*/ 
/*N*/ {
/*N*/     return pImp->aBorder;
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/     {DBG_CHKTHIS(SfxViewFrame, 0);}
/*N*/     if ( !xObjSh.Is() )
/*N*/         return;
/*N*/ 
/*N*/     if ( rHint.IsA(TYPE(SfxSimpleHint)) )
/*N*/     {
/*N*/         switch( ( (SfxSimpleHint&) rHint ).GetId() )
/*N*/         {
/*N*/             case SFX_HINT_MODECHANGED:
/*N*/             {
/*N*/                 // r/o Umschaltung?
/*N*/                 SfxDispatcher *pDispat = GetDispatcher();
/*N*/                 sal_Bool bWasReadOnly = pDispat->GetReadOnly_Impl();
/*N*/                 sal_Bool bIsReadOnly = xObjSh->IsReadOnly();
/*N*/                 if ( !bWasReadOnly != !bIsReadOnly )
/*N*/             	{
/*?*/ 					// Dann auch TITLE_CHANGED
/*?*/ 					UpdateTitle();
/*?*/ 	                GetBindings().Invalidate( SID_FILE_NAME );
/*?*/ 	                GetBindings().Invalidate( SID_DOCINFO_TITLE );
/*?*/ 
/*?*/                     pDispat->GetBindings()->InvalidateAll(sal_True);
/*?*/                     pDispat->SetReadOnly_Impl( bIsReadOnly );
/*?*/ 
/*?*/ 					// Dispatcher-Update nur erzwingen, wenn es nicht sowieso
/*?*/ 					// demn"achst kommt, anderenfalls ist Zappelei oder gar
/*?*/ 					// GPF m"oglich, da Writer z.B. gerne mal im Resize irgendwelche
/*?*/ 					// Aktionen t"atigt, die ein SetReadOnlyUI am Dispatcher zur
/*?*/ 					// Folge haben!
/*?*/ 					if ( pDispat->IsUpdated_Impl() )
/*?*/                     	pDispat->Update_Impl(sal_True);
/*N*/                 }
/*N*/ 
/*N*/                 Enable( !xObjSh->IsInModalMode() );
/*N*/ 				break;
/*N*/             }
/*N*/ 
/*N*/             case SFX_HINT_TITLECHANGED:
/*N*/             {
/*N*/ 				UpdateTitle();
/*N*/                 GetBindings().Invalidate( SID_FILE_NAME );
/*N*/                 GetBindings().Invalidate( SID_DOCINFO_TITLE );
/*N*/                 break;
/*N*/             }
/*N*/ 
/*N*/             case SFX_HINT_DYING:
/*N*/             case SFX_HINT_DEINITIALIZING:
/*N*/                 // when the Object is being deleted, destroy the view too
/*?*/                 if ( xObjSh.Is() )
/*?*/                     ReleaseObjectShell_Impl();
/*?*/                 else
/*?*/                     GetFrame()->DoClose();
/*N*/                 break;
/*N*/ 
/*N*/         }
/*N*/     }
/*N*/     else if ( rHint.IsA(TYPE(SfxEventHint)) )
/*N*/     {
/*N*/         // Wenn das Document asynchron geladen wurde, wurde der Dispatcher
/*N*/         // auf ReadOnly gesetzt, was zur"ckgenommen werden mu\s, wenn
/*N*/         // das Document selbst nicht ReadOnly ist und das Laden fertig ist.
/*N*/         switch ( ((SfxEventHint&)rHint).GetEventId() )
/*N*/         {
/*N*/             case SFX_EVENT_MODIFYCHANGED:
/*N*/             {
/*N*/                 SfxBindings& rBind = GetBindings();
/*N*/                 rBind.Invalidate( SID_DOC_MODIFIED );
/*N*/                 rBind.Invalidate( SID_SAVEDOC );
/*N*/                 rBind.Invalidate( SID_RELOAD );
/*N*/                 break;
/*N*/             }
/*N*/ 
/*N*/             case SFX_EVENT_OPENDOC:
/*N*/             case SFX_EVENT_CREATEDOC:
/*N*/             {
/*N*/                 if ( !xObjSh->IsReadOnly() )
/*N*/                 {
/*N*/                     // Im Gegensatz zu oben (TITLE_CHANGED) mu\s das UI nicht
/*N*/                     // upgedated werden, da es nicht gehidet war!
/*N*/                     GetDispatcher()->GetBindings()->InvalidateAll(sal_True);
/*N*/                 }
/*N*/ 
/*N*/                 break;
/*N*/             }
/*N*/ 
/*N*/             case SFX_EVENT_LOADFINISHED:
/*N*/             {
/*N*/                 // Ein fertig geladenes Dokument kann das Event nicht selbst ausl"osen,
/*N*/                 // weil es nicht wei\s, ob schon eine ::com::sun::star::sdbcx::View erzeugt wurde
/*?*/                 xObjSh->PostActivateEvent_Impl();
/*?*/                 break;
/*N*/             }
/*N*/ 
/*N*/             case SFX_EVENT_TOGGLEFULLSCREENMODE:
/*N*/             {
/*?*/                 if ( GetFrame()->OwnsBindings_Impl() )
/*?*/                     GetBindings().GetDispatcher_Impl()->Update_Impl( sal_True );
/*?*/                 break;
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ #if 0	// (dv)
/*N*/ 	else if ( &rBC == (SfxBroadcaster*) (CntAnchor*) pImp->xAnchor )
/*N*/ 	{
/*N*/ 		CntAnchorHint* pCHint = PTR_CAST(CntAnchorHint, &rHint);
/*N*/ 		if ( pCHint )
/*N*/ 		{
/*N*/ 			CntAction eAction = pCHint->GetAction();
/*N*/ 			switch( eAction )
/*N*/ 			{
/*N*/ 				case CNT_ACTION_EXCHANGED :
/*N*/ 				{
/*N*/ 					SfxMedium* pMedium = GetObjectShell()->GetMedium();
/*N*/ 					pMedium->RefreshName_Impl();
/*N*/ 					Reference< XController >  xController =
/*N*/ 						GetFrame()->GetFrameInterface()->getController();
/*N*/ 					Reference< XModel >  xModel = xController->getModel();
/*N*/ 					if ( xModel.is() )
/*N*/ 						xModel->attachResource( S2U( pMedium->GetName() ), xModel->getArgs() );
/*N*/ 					UpdateTitle();
/*N*/                     pBindings->Invalidate( SID_CURRENT_URL, sal_True, sal_False );
/*N*/                     pBindings->Update( SID_CURRENT_URL );
/*N*/ 					break;
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ #endif	// (dv)
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void SfxViewFrame::Construct_Impl( SfxObjectShell *pObjSh )
/*N*/ {
/*N*/     pImp->pFrame->DocumentInserted( pObjSh );
/*N*/     pImp->pMenuBar = NULL;
/*N*/     pImp->bInCtor = sal_True;
/*N*/     pImp->pParentViewFrame = 0;
/*N*/     pImp->bResizeInToOut = sal_True;
/*N*/     pImp->bDontOverwriteResizeInToOut = sal_False;
/*N*/     pImp->pImportShell = 0;
/*N*/     pImp->bObjLocked = sal_False;
/*N*/     pImp->pFocusWin = 0;
/*N*/     pImp->pActiveChild = NULL;
/*N*/     pImp->bRestoreView = sal_False;
/*N*/     pImp->nCurViewId = 0;
/*N*/     pImp->bSetViewFrameLocked = sal_False;
/*N*/     pImp->bReloading = sal_False;
/*N*/     pImp->bIsDowning = sal_False;
/*N*/     pImp->bModal = sal_False;
/*N*/     pImp->bEnabled = sal_True;
/*N*/     pImp->nDocViewNo = 0;
/*N*/     pImp->aMargin = Size( -1, -1 );
/*N*/     pImp->pCancelMgr = 0;
/*N*/ 	pImp->pWindow = 0;
/*N*/ 	pImp->pIPFrame = 0;
/*N*/ 
/*N*/ 	SetPool( &SFX_APP()->GetPool() );
/*N*/     pDispatcher = new SfxDispatcher(this);
/*N*/     if ( !GetBindings().GetDispatcher() )
/*N*/         GetBindings().SetDispatcher( pDispatcher );
/*N*/ 
/*N*/     xObjSh = pObjSh;
/*N*/ 	if ( xObjSh.Is() && xObjSh->IsPreview() )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 SetQuietMode_Impl( sal_True );
/*N*/ 
/*N*/     if ( pObjSh && pObjSh->IsA( TYPE( SfxFrameSetObjectShell ) ) )
/*?*/         GetFrame()->SetFrameType_Impl( GetFrameType() | SFXFRAME_FRAMESET );
/*N*/     else
/*N*/         GetFrame()->SetFrameType_Impl( GetFrameType() & ~SFXFRAME_FRAMESET );
/*N*/ 
/*N*/     if ( pObjSh )
/*N*/     {
/*N*/         pDispatcher->Push( *SFX_APP() );
/*N*/         SfxModule* pModule = xObjSh->GetModule();
/*N*/         if( pModule )
/*N*/             pDispatcher->Push( *pModule );
/*N*/         pDispatcher->Push( *this );
/*N*/         pDispatcher->Push( *pObjSh );
/*N*/         pDispatcher->Flush();
/*N*/         StartListening( *pObjSh );
/*N*/         pObjSh->ViewAssigned();
/*N*/         Notify( *pObjSh, SfxSimpleHint(SFX_HINT_TITLECHANGED) );
/*N*/         Notify( *pObjSh, SfxSimpleHint(SFX_HINT_DOCCHANGED) );
/*N*/         pDispatcher->SetReadOnly_Impl( pObjSh->IsReadOnly() );
/*N*/     }
/*N*/     else
/*N*/     {
/*?*/         pDispatcher->Push( *SFX_APP() );
/*?*/         pDispatcher->Push( *this );
/*?*/         pDispatcher->Flush();
/*N*/     }
/*N*/ 
/*N*/     SfxViewFrame *pThis = this; // wegen der kranken Array-Syntax
/*N*/     SfxViewFrameArr_Impl &rViewArr = SFX_APP()->GetViewFrames_Impl();
/*N*/     rViewArr.C40_INSERT(SfxViewFrame, pThis, rViewArr.Count() );
/*N*/ 
/*N*/     pImp->bInCtor = sal_False;
/*N*/ }

//------------------------------------------------------------------------

//------------------------------------------------------------------------

/*N*/ SfxViewFrame::SfxViewFrame( SfxBindings& rBindings, SfxFrame *pFrame,
/*N*/         SfxObjectShell *pDoc, sal_uInt32 nType )
/*N*/     : pImp( new SfxViewFrame_Impl )
/*N*/     , pDispatcher(0)
/*N*/     , pBindings(&rBindings)
/*N*/     , nAdjustPosPixelLock( 0 )
/*N*/ {
/*N*/     DBG_CTOR(SfxViewFrame, 0);
/*N*/ 
/*N*/     SetFrame_Impl( pFrame );
/*N*/     pImp->pFrame->SetCurrentViewFrame_Impl( this );
/*N*/     GetFrame()->SetFrameType_Impl( GetFrameType() | nType );
/*N*/     Construct_Impl( pDoc);
/*N*/ }

//------------------------------------------------------------------------
/*N*/ SfxViewFrame::~SfxViewFrame()
/*N*/ {
/*N*/     DBG_DTOR(SfxViewFrame, 0);
/*N*/ 
/*N*/     if ( GetFrame() && GetFrame()->GetCurrentViewFrame() == this )
/*N*/         GetFrame()->SetCurrentViewFrame_Impl( NULL );
/*N*/ 
/*N*/     SfxObjectShell* pSh = pImp->pImportShell;
/*N*/     if( pSh )
/*?*/         pSh->AbortImport();
/*N*/ 
/*N*/     // von Frame-Liste abmelden
/*N*/     SfxApplication *pSfxApp = SFX_APP();
/*N*/     SfxViewFrameArr_Impl &rFrames = pSfxApp->GetViewFrames_Impl();
/*N*/     const SfxViewFrame *pThis = this;
/*N*/     rFrames.Remove( rFrames.GetPos(pThis) );
/*N*/ 
/*N*/     // Member l"oschen
/*N*/     KillDispatcher_Impl();
/*N*/ 
/*N*/     SfxNewHdl::Get()->TryAllocBuffer();
/*N*/     delete pImp;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void SfxViewFrame::KillDispatcher_Impl()

// Dispatcher abr"aumen und l"oschen

/*N*/ {
/*N*/     DBG_CHKTHIS(SfxViewFrame, 0);
/*N*/ 
/*N*/     SfxModule* pModule = xObjSh.Is() ? xObjSh->GetModule() : 0;
/*N*/     if ( xObjSh.Is() )
/*N*/         ReleaseObjectShell_Impl();
/*N*/     if ( pDispatcher )
/*N*/     {
/*N*/         if( pModule )
/*?*/ 			pDispatcher->Pop( *pModule, SFX_SHELL_POP_UNTIL );
/*N*/         else
/*N*/ 			pDispatcher->Pop( *this );
/*N*/         DELETEZ(pDispatcher);
/*N*/     }
/*N*/ }

//------------------------------------------------------------------------
/*N*/ SfxViewFrame* SfxViewFrame::Current()
/*N*/ {
/*N*/     return SFX_APP() ? SFX_APP()->GetViewFrame() : NULL;
/*N*/ }

//--------------------------------------------------------------------

/*  [Beschreibung]

    Liefert die Anzahl der sichtbaren <SfxViewFrame>-Instanzen vom Typ
    'aType' bzw. aller sichtbaren, falls 'aType==0' (default).
*/


//--------------------------------------------------------------------
// returns the first window of spec. type viewing the specified doc.
/*N*/ SfxViewFrame* SfxViewFrame::GetFirst
/*N*/ (
/*N*/     const SfxObjectShell*   pDoc,
/*N*/     TypeId                  aType,
/*N*/     sal_Bool                    bOnlyIfVisible
/*N*/ )
/*N*/ {
/*N*/     SfxApplication *pSfxApp = SFX_APP();
/*N*/     SfxViewFrameArr_Impl &rFrames = pSfxApp->GetViewFrames_Impl();
/*N*/ 
/*N*/     // search for a SfxDocument of the specified type
/*N*/     for ( sal_uInt16 nPos = 0; nPos < rFrames.Count(); ++nPos )
/*N*/     {
/*N*/         SfxViewFrame *pFrame = rFrames.GetObject(nPos);
/*N*/         if ( ( !pDoc || pDoc == pFrame->GetObjectShell() ) &&
/*N*/              ( !aType || pFrame->IsA(aType) ) &&
/*N*/              ( !bOnlyIfVisible || pFrame->IsVisible()) )
/*N*/             return pFrame;
/*N*/     }
/*N*/ 
/*N*/     return 0;
/*N*/ }
//--------------------------------------------------------------------

// returns thenext window of spec. type viewing the specified doc.
/*N*/ SfxViewFrame* SfxViewFrame::GetNext
/*N*/ (
/*N*/     const SfxViewFrame&     rPrev,
/*N*/     const SfxObjectShell*   pDoc,
/*N*/     TypeId                  aType,
/*N*/     sal_Bool                    bOnlyIfVisible
/*N*/ )
/*N*/ {
/*N*/     SfxApplication *pSfxApp = SFX_APP();
/*N*/     SfxViewFrameArr_Impl &rFrames = pSfxApp->GetViewFrames_Impl();
/*N*/ 
/*N*/     // refind the specified predecessor
/*N*/ 	sal_uInt16 nPos;
/*N*/     for ( nPos = 0; nPos < rFrames.Count(); ++nPos )
/*N*/         if ( rFrames.GetObject(nPos) == &rPrev )
/*N*/             break;
/*N*/ 
/*N*/     // search for a Frame of the specified type
/*N*/     for ( ++nPos; nPos < rFrames.Count(); ++nPos )
/*N*/     {
/*N*/         SfxViewFrame *pFrame = rFrames.GetObject(nPos);
/*N*/         if ( ( !pDoc || pDoc == pFrame->GetObjectShell() ) &&
/*N*/              ( !aType || pFrame->IsA(aType) ) &&
/*N*/              ( !bOnlyIfVisible || pFrame->IsVisible()) )
/*N*/             return pFrame;
/*N*/     }
/*N*/     return 0;
/*N*/ }


//--------------------------------------------------------------------
/*N*/ SfxProgress* SfxViewFrame::GetProgress() const
/*N*/ {
/*N*/     SfxObjectShell *pObjSh = GetObjectShell();
/*N*/     return pObjSh ? pObjSh->GetProgress() : 0;
/*N*/ }

//--------------------------------------------------------------------

//--------------------------------------------------------------------


//--------------------------------------------------------------------
#ifdef ENABLE_INIMANAGER//MUSTINI
SfxIniManager* SfxViewFrame::GetIniManager() const
{
/*  SfxIniManager *pIniMgr = GetObjectShell()
            ? GetObjectShell()->GetFactory().GetIniManager()
            : 0;
    if ( !pIniMgr )*/ //!
        return SFX_APP()->GetAppIniManager();
//  return pIniMgr;
}
#endif

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::DoAdjustPosSizePixel //! teilen in Inner.../Outer...
/*N*/ (
/*N*/     SfxViewShell*   pSh,
/*N*/     const Point&    rPos,
/*N*/     const Size&     rSize
/*N*/ )
/*N*/ {
/*N*/     DBG_CHKTHIS(SfxViewFrame, 0);
/*N*/ 
/*N*/ 	// Components benutzen diese Methode nicht!
/*N*/     if( pSh && pSh->GetWindow() && !nAdjustPosPixelLock )
/*N*/     {
/*N*/         nAdjustPosPixelLock++;
/*N*/         if ( pImp->bResizeInToOut )
/*?*/             {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pSh->InnerResizePixel( rPos, rSize );
/*N*/         else
/*N*/             pSh->OuterResizePixel( rPos, rSize );
/*N*/         nAdjustPosPixelLock--;
/*N*/     }
/*N*/ }

//========================================================================

/*N*/ int SfxViewFrameItem::operator==( const SfxPoolItem &rItem ) const
/*N*/ {
/*?*/      return PTR_CAST(SfxViewFrameItem, &rItem)->pFrame== pFrame;
/*N*/ }

//--------------------------------------------------------------------
/*N*/ String SfxViewFrameItem::GetValueText() const
/*N*/ {
/*N*/     return String();
/*N*/ }

//--------------------------------------------------------------------

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::SetViewShell_Impl( SfxViewShell *pVSh )

/*  [Beschreibung]

    Interne Methode zum setzen der jeweils aktuellen <SfxViewShell>-Instanz,
    die in diesem SfxViewFrame aktiv ist.
*/

/*N*/ {
/*N*/     SfxShell::SetViewShell_Impl( pVSh );
/*N*/     if ( pVSh && !IsA(TYPE(SfxInPlaceFrame)) && !pVSh->UseObjectSize() )
/*N*/         pImp->bResizeInToOut = sal_False;
/*N*/ }

#if SUPD<604
//--------------------------------------------------------------------

/*  [Beschreibung]

    Liefert, sofern existent, die zur Zeit in diesem SfxViewFrame aktive
    <SfxViewShell>. Dieser kann sich bei speziellen Multi-::com::sun::star::sdbcx::View-Frames
    von Zeit zu Zeit "ndern. Der R"uckgabewert ist nur im aktuellen
    Stack-Frame g"ultig.
*/

#endif

//--------------------------------------------------------------------
/*
    Beschreibung:
    Der ParentViewFrame ist der ViewFrame des Containers bei internem InPlace
*/


//--------------------------------------------------------------------
/*
    Beschreibung:
    Der ParentViewFrame ist der ViewFrame des Containers bei internem InPlace
*/

/*N*/ SfxViewFrame* SfxViewFrame::GetParentViewFrame_Impl() const
/*N*/ {
/*N*/     return pImp->pParentViewFrame;
/*N*/ }

//--------------------------------------------------------------------

/*?*/ void SfxViewFrame::ForceInnerResize_Impl(sal_Bool bOn)
/*?*/ {
/*?*/ 	pImp->bDontOverwriteResizeInToOut = bOn;
/*?*/ }

//--------------------------------------------------------------------
/*N*/ sal_Bool SfxViewFrame::IsResizeInToOut_Impl() const
/*N*/ {
/*N*/     return pImp->bResizeInToOut;
/*N*/ }
//--------------------------------------------------------------------

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::GetDocNumber_Impl()
/*N*/ {
/*N*/     DBG_ASSERT( GetObjectShell(), "Kein Dokument!" );
/*N*/     GetObjectShell()->SetNamedVisibility_Impl();
/*N*/     pImp->nDocViewNo = GetObjectShell()->GetNoSet_Impl().GetFreeIndex()+1;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewFrame::Enable( sal_Bool bEnable )
/*N*/ {
/*N*/     if ( bEnable != pImp->bEnabled )
/*N*/     {
/*N*/         pImp->bEnabled = bEnable;
/*N*/ 
/*N*/         // e.g. InPlace-Frames have a parent...
/*N*/         SfxViewFrame *pParent = GetParentViewFrame_Impl();
/*N*/         if ( pParent )
/*N*/         {
/*?*/             pParent->Enable( bEnable );
/*N*/         }
/*N*/         else
/*N*/         {
/*N*/             Window *pWindow = &GetFrame()->GetTopFrame()->GetWindow();
/*N*/             while ( !pWindow->IsSystemWindow() )
/*N*/                 pWindow = pWindow->GetParent();
/*N*/             pWindow->EnableInput( bEnable, TRUE );
/*N*/         }
/*N*/ 
/*N*/         // cursor and focus
/*N*/         SfxViewShell* pViewSh = GetViewShell();
/*N*/         if ( bEnable )
/*N*/         {
/*N*/             // show cursor
/*N*/             if ( pViewSh )
/*N*/                 pViewSh->ShowCursor();
/*N*/         }
/*N*/         else
/*N*/         {
/*N*/             // hide cursor
/*N*/             if ( pViewSh )
/*N*/                 pViewSh->ShowCursor(sal_False);
/*N*/         }
/*
        if ( !bEnable )
            GetBindings().ENTERREGISTRATIONS();
        GetDispatcher()->Lock( !bEnable );
        if ( bEnable )
            GetBindings().LEAVEREGISTRATIONS();
*/
/*N*/     }
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::Show()

/*  [Beschreibung]

    Diese Methode macht das Frame-Window sichtbar und ermittelt vorher
    den Fenstername. Au\serdem wird das Dokument festgehalten. Man darf
    i.d.R. nie das Window direkt showen!
*/

/*N*/ {
/*N*/     // zuerst locken damit in UpdateTitle() gilt: IsVisible() == sal_True (:#)
/*N*/     if ( xObjSh.Is() )
/*N*/     {
/*N*/         if ( !pImp->bObjLocked )
/*N*/             LockObjectShell_Impl( sal_True );
/*N*/ 
/*N*/         // Doc-Shell Titel-Nummer anpassen, get unique view-no
/*N*/         if ( 0 == pImp->nDocViewNo && !(GetFrameType() & SFXFRAME_PLUGIN ) )
/*N*/         {
/*N*/             GetDocNumber_Impl();
/*N*/             UpdateTitle();
/*N*/         }
/*N*/     }
/*N*/     else
/*?*/         UpdateTitle();
/*N*/ 
/*N*/     // Frame-Window anzeigen, aber nur wenn der ViewFrame kein eigenes Window
/*N*/ 	// hat oder wenn er keine Component enth"alt
/*N*/ 	if ( &GetWindow() == &GetFrame()->GetWindow() || !GetFrame()->HasComponent() )
/*N*/     	GetWindow().Show();
/*N*/ 
/*N*/     if ( GetFrame()->GetFrameInterface()->isActive() && SfxViewFrame::Current() != this && !GetActiveChildFrame_Impl() )
/*?*/         MakeActive_Impl( FALSE );
/*N*/ }

//--------------------------------------------------------------------
/*N*/ sal_Bool SfxViewFrame::IsVisible() const
/*N*/ {
/*N*/     Window *pWin = pImp->bInCtor ? 0 : &GetWindow();
/*N*/     return GetFrame()->HasComponent() || pImp->bObjLocked || ( pWin && pWin->IsVisible() );
/*N*/ }

//--------------------------------------------------------------------

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::LockObjectShell_Impl( sal_Bool bLock )
/*N*/ {
/*N*/     DBG_ASSERT( pImp->bObjLocked != bLock, "Falscher Locked-Status!" );
/*N*/ 
/*N*/     DBG_ASSERT( GetObjectShell(), "Kein Dokument!" );
/*N*/     GetObjectShell()->OwnerLock(bLock);
/*N*/     pImp->bObjLocked = bLock;
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::MakeActive_Impl( BOOL bGrabFocus )
/*N*/ {
/*N*/ 	if ( GetViewShell() && !GetFrame()->IsClosing_Impl() )
/*N*/ 	{
/*N*/         if ( IsVisible() )
/*N*/         {
/*N*/             if ( GetViewShell() )
/*N*/             {
/*N*/                 BOOL bPreview = FALSE;
/*N*/                 SfxApplication *pSfxApp = SFX_APP();
/*N*/                 if ( GetObjectShell()->IsPreview() )
/*N*/                 {
/*N*/                     bPreview = TRUE;
/*N*/                 }
/*N*/                 else
/*N*/                 {
/*N*/                     SfxViewFrame* pParent = GetParentViewFrame();
/*N*/                     if ( pParent )
/*?*/                         {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pParent->SetActiveChildFrame_Impl( this );
/*N*/                 }
/*N*/ 
/*N*/                 SfxViewFrame* pCurrent = SfxViewFrame::Current();
/*N*/                 if ( GetFrame()->GetFrameInterface()->isActive() || !bPreview && ( !pCurrent || bGrabFocus ) )
/*N*/                 {
/*N*/                     pSfxApp->SetViewFrame( this );
/*N*/                     GetBindings().SetActiveFrame( ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > () );
/*N*/                     if ( bGrabFocus )
/*N*/                     {
/*N*/                         SvInPlaceClient *pCli = GetViewShell()->GetIPClient();
/*N*/                         if ( ( !pCli || !pCli->GetProtocol().IsUIActive() ) &&
/*N*/                             ( !pCurrent || pCurrent->GetParentViewFrame_Impl() != this ) )
/*N*/                                 GetFrame()->GrabFocusOnComponent_Impl();
/*N*/                     }
/*N*/                 }
/*N*/                 else
/*N*/                 {
/*?*/                     GetBindings().SetDispatcher( GetDispatcher() );
/*?*/                     GetBindings().SetActiveFrame( ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > () );
/*?*/                     GetDispatcher()->Update_Impl( TRUE );
/*N*/                 }
/*N*/             }
/*N*/         }
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------


/*  [Beschreibung]

    Erzeugt eine SfxViewShell f"ur diesen SfxViewFrame. Wird auch aus
    <SfxObjectShell::LoadWindows_Impl()>
    gerufen.
*/


//-------------------------------------------------------------------------

//-------------------------------------------------------------------------


//-------------------------------------------------------------------------

/*N*/ SfxObjectShell* SfxViewFrame::GetObjectShell()
/*N*/ {
/*N*/     return xObjSh;
/*N*/ }


/*N*/ const Size& SfxViewFrame::GetMargin_Impl() const
/*N*/ {
/*N*/     return pImp->aMargin;
/*N*/ }


/*N*/ SfxViewFrame* SfxViewFrame::GetActiveChildFrame_Impl() const
/*N*/ {
/*N*/     SfxViewFrame *pViewFrame = pImp->pActiveChild;
/*
    if ( !pViewFrame )
    {
        // Wenn es keinen aktiven ChildFrame gibt, irgendeinen nehmen
        for ( sal_uInt16 n=0; n<GetChildFrameCount(); n++ )
        {
            pViewFrame =
                PTR_CAST( SfxViewFrame, GetChildFrame(n)->GetChildFrame(0) );
            if ( pViewFrame )
                break;
        }
    }

    pImp->pActiveChild = pViewFrame;
*/
/*N*/     return pViewFrame;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ sal_Bool SfxViewFrame::SwitchToViewShell_Impl
/*N*/ (
    sal_uInt16  nViewId,        /*  > 0
                                Registrierungs-Id der ::com::sun::star::sdbcx::View, auf die umge-
                                schaltet werden soll, bzw. die erstmalig
                                erzeugt werden soll.

                                == 0
                                Es soll die Default-::com::sun::star::sdbcx::View verwendet werden. */

    sal_Bool    bIsIndex        /*  sal_True
                                'nViewId' ist keine Registrations-Id sondern
                                ein ::com::sun::star::sdbcx::Index in die f"ur die in diesem
                                <SfxViewFrame> dargestellte <SfxObjectShell>.
                                */
/*N*/ )

/*  [Beschreibung]

    Interne Methode zum Umschalten auf eine andere <SfxViewShell>-Subklasse,
    die in diesem SfxMDIFrame erzeugt werden soll. Existiert noch
    keine SfxViewShell in diesem SfxMDIFrame, so wird erstmalig eine
    erzeugt.


    [R"uckgabewert]

    sal_Bool                        sal_True
                                die angeforderte SfxViewShell wurde erzeugt
                                und eine ggf. bestehende gel"oscht

                                sal_False
                                die angeforderte SfxViewShell konnte nicht
                                erzeugt werden, die bestehende SfxViewShell
                                existiert daher weiterhin
*/

/*N*/ {
/*N*/     DBG_ASSERT( GetObjectShell(), "Kein Dokument!" );
/*N*/ 
/*N*/     SfxObjectFactory &rDocFact = GetObjectShell()->GetFactory();
/*N*/ 
/*N*/     // die Indizes der neuen und alten ::com::sun::star::sdbcx::View-Shell finden
/*N*/     sal_uInt16 nOldNo = USHRT_MAX, nNewNo = USHRT_MAX;
/*N*/     bIsIndex |= 0 == nViewId;
/*N*/     for ( sal_uInt16 nNo = 0; nNo < rDocFact.GetViewFactoryCount(); ++nNo )
/*N*/     {
/*N*/         sal_uInt16 nFoundId = rDocFact.GetViewFactory(nNo).GetOrdinal();
/*N*/         if ( nNewNo == USHRT_MAX )
/*N*/         {
/*N*/             if ( bIsIndex && nViewId == nNo )
/*N*/             {
/*N*/                 nNewNo = nNo;
/*N*/                 nViewId = nFoundId; // fuer nViewId == 0
/*N*/             }
/*N*/             else if ( !bIsIndex && nViewId == nFoundId )
/*N*/                nNewNo = nNo;
/*N*/         }
/*N*/         if ( pImp->nCurViewId == nFoundId )
/*N*/             nOldNo = nNo;
/*N*/     }
/*N*/ 
/*N*/     if ( nNewNo == USHRT_MAX )
/*N*/ 	{
/*N*/ 		// Bei unbekannter Id die Dafault-Id nehmen
/*?*/         sal_uInt16 nFoundId = rDocFact.GetViewFactory(0).GetOrdinal();
/*?*/ 		nNewNo = 0;
/*?*/ 		nViewId = nFoundId;
/*?*/         if ( pImp->nCurViewId == nFoundId )
/*?*/             nOldNo = 0;
/*N*/ 	}
/*N*/ 
/*N*/     SfxViewShell *pSh = GetViewShell();
/*N*/ 
/*N*/     DBG_ASSERT( !pSh || nOldNo != USHRT_MAX, "old shell id not found" );
/*N*/ 
/*N*/     // existiert schon eine ViewShell?
/*N*/ 	sal_Bool bHasFocus = sal_False;
/*N*/     SfxViewShell *pOldSh = pSh;
/*N*/     if ( pOldSh )
/*N*/     {
/*?*/ 		if ( !bHasFocus )
/*?*/ 			bHasFocus = pOldSh->GetWindow() && pOldSh->GetWindow()->HasChildPathFocus( sal_True );
/*?*/ 
/*?*/         // dann diese schlie\sen
/*?*/         if ( !pOldSh->PrepareClose() )
/*?*/             return sal_False;
/*?*/ 
/*?*/         // Jetzt alle SubShells wechhauen
/*?*/ 		pOldSh->PushSubShells_Impl( sal_False );
/*?*/         sal_uInt16 nLevel = pDispatcher->GetShellLevel( *pOldSh );
/*?*/         if ( nLevel )
/*?*/         {
/*?*/             // Es gibt SubShells
/*?*/             SfxShell *pSubShell = pDispatcher->GetShell( nLevel-1 );
/*?*/             if ( pSubShell == pOldSh->GetSubShell() )
/*?*/                 //"Echte" Subshells nicht deleten
/*?*/                 pDispatcher->Pop( *pSubShell, SFX_SHELL_POP_UNTIL );
/*?*/             else
/*?*/                 pDispatcher->Pop( *pSubShell, SFX_SHELL_POP_UNTIL | SFX_SHELL_POP_DELETE );
/*?*/         }
/*?*/         pDispatcher->Pop( *pOldSh );
/*?*/         GetBindings().Invalidate( nOldNo + SID_VIEWSHELL0 );
/*N*/     }
/*N*/ 
/*N*/     // Id der neuen ViewShell eintragen
/*N*/     pImp->nCurViewId = nViewId;
/*N*/     GetBindings().Invalidate( nNewNo + SID_VIEWSHELL0 );
/*N*/ 
/*N*/     // neue ViewShell erzeugen
/*N*/     SfxViewFactory &rViewFactory = rDocFact.GetViewFactory( nNewNo );
/*N*/     LockAdjustPosSizePixel();
/*N*/ 
/*N*/ 	GetBindings().ENTERREGISTRATIONS();
/*N*/     pSh = rViewFactory.CreateInstance(this, pOldSh);
/*N*/     Window *pEditWin = pSh->GetWindow();
/*N*/     DBG_ASSERT( !pEditWin || !pEditWin->IsReallyVisible(), "don`t show your ViewShell`s Window by yourself!" );
/*N*/ 
/*N*/     // neue ViewShell in Frame einsetzen
/*N*/ 	GetDispatcher()->SetDisableFlags( 0 );
/*N*/     SetViewShell_Impl(pSh);
/*N*/ 
/*N*/     Reference < ::com::sun::star::awt::XWindow > xWindow(
/*N*/         GetFrame()->GetWindow().GetComponentInterface(), UNO_QUERY );
/*N*/     Reference < XFrame > xFrame( GetFrame()->GetFrameInterface() );
/*N*/     if ( !pSh->GetController().is() )
/*?*/         pSh->SetController( new SfxBaseController( pSh ) );
/*N*/     Reference < XController > xController( pSh->GetController() );
/*N*/     xFrame->setComponent( xWindow, xController );
/*N*/     xController->attachFrame( xFrame );
/*N*/     Reference < XModel > xModel( GetObjectShell()->GetModel() );
/*N*/     if ( xModel.is() )
/*N*/     {
/*N*/         xController->attachModel( xModel );
/*N*/         xModel->connectController( xController );
/*N*/         xModel->setCurrentController( xController );
/*N*/     }
/*N*/ 
/*N*/     GetDispatcher()->Push( *pSh );
/*N*/     if ( pSh->GetSubShell() )
/*?*/         GetDispatcher()->Push( *pSh->GetSubShell() );
/*N*/ 	pSh->PushSubShells_Impl();
/*N*/     GetDispatcher()->Flush();
/*N*/ 
/*N*/     // ggf. UserData restaurieren
/*N*/     if ( pImp->bRestoreView && pImp->aViewData.Len() )
/*N*/     {
/*?*/         DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pSh->ReadUserData( pImp->aViewData, sal_True );
/*N*/     }
/*N*/ 
/*N*/ 	// Tools anordnen, bevor die Gr"os\se gesetzt wird
/*N*/ 	if ( SfxViewFrame::Current() == this )
/*?*/ 		GetDispatcher()->Update_Impl( sal_True );
/*N*/ 
/*N*/     // ggf. Resize ausl"osen
/*N*/     UnlockAdjustPosSizePixel();
/*N*/ 
/*N*/ 	Window* pFrameWin = &GetWindow();
/*N*/     if ( pFrameWin != &GetFrame()->GetWindow() )
/*N*/ 		pFrameWin->Show();
/*N*/ 
/*N*/     if ( GetWindow().IsReallyVisible() )
/*N*/         DoAdjustPosSizePixel( pSh, Point(), GetWindow().GetOutputSizePixel() );
/*N*/ 
/*N*/     if ( pEditWin && pSh->IsShowView_Impl() )
/*N*/     {
/*N*/         pEditWin->Show();
/*N*/ 		if ( bHasFocus )
/*?*/ 			GetFrame()->GrabFocusOnComponent_Impl();
/*N*/     }
/*N*/ 
/*N*/ 	GetBindings().LEAVEREGISTRATIONS();
/*N*/     delete pOldSh;
/*N*/     return sal_True;
/*N*/ }
//--------------------------------------------------------------------


//-------------------------------------------------------------------------

//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::SetRestoreView_Impl( sal_Bool bOn )
/*N*/ {
/*N*/     pImp->bRestoreView = bOn;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ sal_uInt16 SfxViewFrame::GetCurViewId() const
/*N*/ {
/*N*/     return pImp->nCurViewId;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::ExecView_Impl
/*N*/ (
/*N*/     SfxRequest& rReq        // der auszuf"uhrende <SfxRequest>
/*N*/ )

/*  [Beschreibung]

    Interne Methode zum Ausf"uhren der f"ur die <SfxShell> Subklasse
    SfxViewFrame in der <SVIDL> beschriebenen Slots.
*/

/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::StateView_Impl
/*N*/ (
    SfxItemSet&     rSet            /*  leeres <SfxItemSet> mit <Which-Ranges>,
                                        welche die Ids der zu erfragenden
                                        Slots beschreiben. */
/*N*/ )

/*  [Beschreibung]

    Diese interne Methode liefert in 'rSet' die Status der f"ur die
    <SfxShell> Subklasse SfxViewFrame in der <SVIDL> beschriebenen <Slots>.

    In 'rSet' sind dabei genau die vom SFx als ung"ultig erkannten
    Slot-Ids als Which-ranges enthalten. Falls der an dieser Shell gesetzte
    <SfxItemPool> f"ur einzelne Slot-Ids ein Mapping hat, werden die
    entsprechenden Which-Ids verwendet, so da\s Items ggf. direkt mit
    einer mit Which-Ids arbeitenden Core-::com::sun::star::script::Engine ausgetauscht werden
    k"onnen.
*/

/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::GetState_Impl( SfxItemSet &rSet )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
/*N*/ SfxViewFrame* SfxViewFrame::GetParentViewFrame() const
/*
    Beschreibung:
    Der ParentViewFrame ist der ViewFrame des ParentFrames
*/
/*N*/ {
/*N*/     SfxFrame *pFrame = GetFrame()->GetParentFrame();
/*N*/     return pFrame ? pFrame->GetCurrentViewFrame() : NULL;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ SfxFrame* SfxViewFrame::GetFrame() const
/*
    Beschreibung:
    GetFrame liefert den Frame, in dem sich der ViewFrame befindet
*/
/*N*/ {
/*N*/     return pImp->pFrame;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::SetFrame_Impl( SfxFrame *pFrame )
/*N*/ {
/*N*/     pImp->pFrame = pFrame;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ SfxViewFrame* SfxViewFrame::GetTopViewFrame() const
/*N*/ {
/*N*/     return GetFrame()->GetTopFrame()->GetCurrentViewFrame();
/*N*/ }

//-------------------------------------------------------------------------

//-------------------------------------------------------------------------

/*N*/ SfxCancelManager *SfxViewFrame::GetCancelManager() const

/*  <H3>Description</H3>

    Returns a pointer to the <SfxCancelManager> of the top-view-frame of
    this view-frame.
*/

/*N*/ {
/*N*/ 	return GetTopViewFrame()->GetFrame()->GetCancelManager();
/*N*/ }

/*N*/ void SfxViewFrame::SetWindow_Impl( Window *pWin )
/*N*/ {
/*N*/ 	pImp->pWindow = pWin;
/*N*/ }

/*N*/ Window& SfxViewFrame::GetWindow() const
/*N*/ {
/*N*/ 	return pImp->pWindow ? *pImp->pWindow : GetFrame()->GetWindow();
/*N*/ }

/*?*/ sal_Bool SfxViewFrame::DoClose()
/*?*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 return GetFrame()->DoClose();
/*?*/ }



/*N*/ String SfxViewFrame::GetActualPresentationURL_Impl() const
/*N*/ {
/*N*/ 	if ( xObjSh.Is() )
/*N*/ 		return xObjSh->GetMedium()->GetName();
/*?*/ 	return pImp->aActualPresentationURL;
/*N*/ }


/*N*/ BOOL SfxViewFrame::IsInModalMode() const
/*N*/ {
/*N*/     return pImp->bModal || GetFrame()->GetWindow().IsInModalMode();
/*N*/ }

/*N*/ void SfxViewFrame::Resize( BOOL bForce )
/*N*/ {
/*N*/     Size aSize = GetWindow().GetOutputSizePixel();
/*N*/     if ( bForce || aSize != pImp->aSize )
/*N*/     {
/*N*/         pImp->aSize = aSize;
/*N*/         SfxViewShell *pShell = GetViewShell();
/*N*/         if ( pShell )
/*N*/         {
/*N*/             if ( pShell->UseObjectSize() )
/*?*/                 {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ForceOuterResize_Impl(TRUE);
/*N*/             DoAdjustPosSizePixel( pShell, Point(), GetWindow().GetOutputSizePixel() );
/*N*/             if ( pShell->UseObjectSize() )
/*?*/                 {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ForceOuterResize_Impl(FALSE);
/*N*/             SfxViewFrame* pActFrame = this;
/*N*/             while ( pActFrame->GetActiveChildFrame_Impl() )
/*?*/                 pActFrame = pActFrame->GetActiveChildFrame_Impl();
/*N*/ 
/*N*/             // bugfix #86009#: release objectshell in internal frame causes resize, ViewShell already gone!
/*N*/             SvInPlaceClient *pCli = pActFrame->GetViewShell() ? pActFrame->GetViewShell()->GetIPClient() : NULL;
/*N*/             if ( pCli && pCli->GetProtocol().IsUIActive() )
/*N*/             {
/*?*/                 if ( !GetParentViewFrame() )
/*?*/                     pCli->GetEnv()->GetIPEnv()->DoTopWinResize();
/*?*/                 pCli->GetEnv()->GetIPEnv()->DoDocWinResize();
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ }

#define LINE_SEP 0x0A


/*
    add new recorded dispatch macro script into the application global basic lib container
    It generates a new unique id for it and insert the macro by using this number as name for
    the modul
 */

/*N*/ void SfxViewFrame::MiscExec_Impl( SfxRequest& rReq )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

/*N*/ void SfxViewFrame::MiscState_Impl(SfxItemSet &rSet)
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	int bSearchedMDI = FALSE;
/*N*/ 	int bFoundNormMDI = FALSE;
/*N*/ 	int bFoundMiniMDI = FALSE;
/*N*/ 	int bFoundNonDesktopMDI = FALSE;
/*N*/ 
/*N*/ 	const USHORT *pRanges = rSet.GetRanges();
/*N*/ 	DBG_ASSERT(pRanges && *pRanges, "Set ohne Bereich");
/*N*/ 	while ( *pRanges )
/*N*/ 	{
/*N*/ 		for(USHORT nWhich = *pRanges++; nWhich <= *pRanges; ++nWhich)
/*N*/ 		{
/*N*/ 			switch(nWhich)
/*N*/ 			{
/*N*/                 case SID_CURRENT_URL:
/*N*/                 {
/*N*/                     // Bei internem InPlace den ContainerFrame nehmen
/*N*/                     SfxViewFrame *pFrame = this;
/*N*/                     if ( pFrame->GetParentViewFrame_Impl() )
/*?*/                         pFrame = pFrame->GetParentViewFrame_Impl();
/*N*/                     rSet.Put( SfxStringItem( nWhich, pFrame->GetActualPresentationURL_Impl() ) );
/*N*/ 	                break;
/*N*/                 }
/*N*/ 
/*N*/                 case SID_RECORDMACRO :
/*N*/                 {
/*N*/ 					const char* pName = GetObjectShell()->GetFactory().GetShortName();
/*N*/ 					if (  strcmp(pName,"swriter") && strcmp(pName,"scalc") )
/*N*/ 					{
/*N*/                         rSet.DisableItem( nWhich );
/*N*/ 						break;
/*N*/ 					}
/*N*/ 
/*N*/                     ::rtl::OUString sProperty = ::rtl::OUString::createFromAscii("DispatchRecorderSupplier");
/*N*/                     ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > xSet(
/*N*/                             GetFrame()->GetFrameInterface(),
/*N*/                             ::com::sun::star::uno::UNO_QUERY);
/*N*/ 
/*N*/                     ::com::sun::star::uno::Any aProp = xSet->getPropertyValue(sProperty);
/*N*/                     ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorderSupplier > xSupplier;
/*N*/                     if ( aProp >>= xSupplier )
/*N*/                         rSet.Put( SfxBoolItem( nWhich, xSupplier.is() ) );
/*N*/                     else
/*?*/                         rSet.DisableItem( nWhich );
/*N*/                     break;
/*N*/                 }
/*N*/ 
/*N*/                 case SID_STOP_RECORDING :
/*N*/                 {
/*?*/ 					const char* pName = GetObjectShell()->GetFactory().GetShortName();
/*?*/ 					if (  strcmp(pName,"swriter") && strcmp(pName,"scalc") )
/*?*/ 					{
/*?*/                         rSet.DisableItem( nWhich );
/*?*/ 						break;
/*?*/ 					}
/*?*/ 
/*?*/                     ::rtl::OUString sProperty = ::rtl::OUString::createFromAscii("DispatchRecorderSupplier");
/*?*/                     ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > xSet(
/*?*/                             GetFrame()->GetFrameInterface(),
/*?*/                             ::com::sun::star::uno::UNO_QUERY);
/*?*/ 
/*?*/                     ::com::sun::star::uno::Any aProp = xSet->getPropertyValue(sProperty);
/*?*/                     ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorderSupplier > xSupplier;
/*?*/                     if ( !(aProp >>= xSupplier) || !xSupplier.is() )
/*?*/                         rSet.DisableItem( nWhich );
/*?*/                     break;
/*N*/                 }
/*N*/ 
/*N*/ 				case SID_TOGGLESTATUSBAR:
/*N*/ 				{
/*?*/                     rSet.Put( SfxBoolItem( nWhich, GetObjectShell()->GetToolBoxConfig_Impl()->IsStatusBarVisible() ) );
/*?*/ 					break;
/*N*/ 				}
/*N*/ 
/*N*/ 				case SID_WIN_FULLSCREEN:
/*N*/                 {
/*N*/                     SfxTopViewFrame *pTop= PTR_CAST( SfxTopViewFrame, GetTopViewFrame() );
/*N*/                     if ( pTop )
/*N*/                     {
/*N*/                         WorkWindow* pWork = (WorkWindow*) pTop->GetTopFrame_Impl()->GetTopWindow_Impl();
/*N*/                         if ( pWork )
/*N*/                         {
/*N*/                             rSet.Put( SfxBoolItem( nWhich, pWork->IsFullScreenMode() ) );
/*N*/                             break;
/*N*/                         }
/*N*/                     }
/*N*/ 
/*?*/                     rSet.DisableItem( nWhich );
/*N*/ 					break;
/*N*/                 }
/*N*/ 
/*N*/ 				default:
/*N*/ 					//! DBG_ASSERT(FALSE, "Falscher Server fuer GetState");
/*N*/ 					break;
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		++pRanges;
/*N*/ 	}
/*N*/ }

/*N*/ void SfxViewFrame::ChildWindowExecute( SfxRequest &rReq )

/* 	[Beschreibung]

	Diese Methode kann in der Execute-Methode f"ur das ein- und ausschalten
	von Child-Windows eingesetzt werden, um dieses inkl. API-Anbindung zu
	implementieren.

	Einfach in der IDL als 'ExecuteMethod' eintragen.
*/

/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewFrame::ChildWindowState( SfxItemSet& rState )

/* 	[Beschreibung]

	Diese Methode kann in der Status-Methode f"ur das Ein- und Ausschalt-
	Zustand von Child-Windows eingesetzt werden, um dieses zu implementieren.

	Einfach in der IDL als 'StateMethod' eintragen.
*/

/*N*/ {
/*N*/ 	SfxWhichIter aIter( rState );
/*N*/ 	for ( USHORT nSID = aIter.FirstWhich(); nSID; nSID = aIter.NextWhich() )
/*N*/ 	{
/*N*/         if ( nSID == SID_VIEW_DATA_SOURCE_BROWSER )
/*N*/         {
/*N*/             rState.Put( SfxBoolItem( nSID, HasChildWindow( SID_BROWSER ) ) );
/*N*/         }
/*N*/         else if ( nSID == SID_HYPERLINK_DIALOG )
/*N*/ 		{
/*N*/ 			const SfxPoolItem* pDummy = NULL;
/*N*/             SfxItemState eState = GetDispatcher()->QueryState( SID_HYPERLINK_SETLINK, pDummy );
/*N*/ 			if ( SFX_ITEM_DISABLED == eState )
/*N*/ 				rState.DisableItem(nSID);
/*N*/ 			else
/*N*/ 			{
/*N*/ 				if ( KnowsChildWindow(nSID) )
/*N*/ 					rState.Put( SfxBoolItem( nSID, HasChildWindow(nSID)) );
/*N*/ 				else
/*?*/ 					rState.DisableItem(nSID);
/*N*/ 			}
/*N*/ 		}
/*N*/         else if ( nSID == SID_BROWSER )
/*N*/ 		{
/*?*/ 			Reference < XFrame > xFrame = GetFrame()->GetTopFrame()->GetFrameInterface()->
/*?*/ 							findFrame( DEFINE_CONST_UNICODE("_beamer"), FrameSearchFlag::CHILDREN );
/*?*/ 			if ( !xFrame.is() )
/*?*/ 				rState.DisableItem( nSID );
/*?*/ 			else if ( KnowsChildWindow(nSID) )
/*?*/ 				rState.Put( SfxBoolItem( nSID, HasChildWindow(nSID) ) );
/*N*/ 		}
/*N*/ 		else if ( KnowsChildWindow(nSID) )
/*N*/ 			rState.Put( SfxBoolItem( nSID, HasChildWindow(nSID) ) );
/*N*/ 		else
/*N*/ 			rState.DisableItem(nSID);
/*N*/ 	}
/*N*/ }

/*N*/ void SfxViewFrame::ToolboxExec_Impl( SfxRequest &rReq )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//------------------------------------------------------------------------


/*N*/ void SfxViewFrame::ToolboxState_Impl( SfxItemSet &rSet )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//--------------------------------------------------------------------
/*N*/ SfxWorkWindow* SfxViewFrame::GetWorkWindow_Impl( USHORT nId )
/*N*/ {
/*N*/     SfxWorkWindow* pWork = 0;
/*N*/     if ( IsA( TYPE(SfxInPlaceFrame) ) )
/*N*/ 	{
/*?*/ 		SfxShell* pShell;
/*?*/ 		const SfxSlot* pSlot;
/*?*/         if( !GetDispatcher()->GetShellAndSlot_Impl( nId, &pShell, &pSlot, FALSE, TRUE ) && GetParentViewFrame_Impl() )
/*?*/ 			// Containerslot !
/*?*/             pWork = GetParentViewFrame_Impl()->GetFrame()->GetWorkWindow_Impl();
/*?*/         else
/*?*/             pWork = GetFrame()->GetWorkWindow_Impl();
/*N*/     }
/*N*/     else
/*N*/         pWork = GetFrame()->GetWorkWindow_Impl();
/*N*/ 
/*N*/     return pWork;
/*N*/ }

/*
void SfxViewFrame::SetChildWindow(USHORT nId, BOOL bOn)
{
    SetChildWindow( nId, bOn, TRUE );
}*/

/*N*/ void SfxViewFrame::SetChildWindow(USHORT nId, BOOL bOn, BOOL bSetFocus )
/*N*/ {
/*N*/     SfxWorkWindow* pWork = GetWorkWindow_Impl( nId );
/*N*/     if ( pWork )
/*N*/         pWork->SetChildWindow_Impl( nId, bOn, bSetFocus );
/*N*/ }

//--------------------------------------------------------------------


//--------------------------------------------------------------------

/*N*/ BOOL SfxViewFrame::HasChildWindow( USHORT nId )
/*N*/ {
/*N*/ 	SfxWorkWindow* pWork = GetWorkWindow_Impl( nId );
/*N*/ 	return pWork ? pWork->HasChildWindow_Impl(nId) : FALSE;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ BOOL SfxViewFrame::KnowsChildWindow( USHORT nId )
/*N*/ {
/*N*/     SfxWorkWindow* pWork = GetWorkWindow_Impl( nId );
/*N*/ 	return pWork ? pWork->KnowsChildWindow_Impl(nId) : FALSE;
/*N*/ }

//--------------------------------------------------------------------


//--------------------------------------------------------------------

/*N*/ SfxChildWindow* SfxViewFrame::GetChildWindow(USHORT nId)
/*N*/ {
/*N*/     SfxWorkWindow* pWork = GetWorkWindow_Impl( nId );
/*N*/ 	return pWork ? pWork->GetChildWindow_Impl(nId) : NULL;
/*N*/ }

/*N*/ SfxImageManager* SfxViewFrame::GetImageManager()
/*N*/ {
/*N*/     return GetObjectShell()->GetImageManager_Impl();
/*N*/ }

}
