/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_frmload.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: kz $ $Date: 2006/11/08 15:32:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "frmload.hxx"


#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_WRAPPEDTARGETRUNTIMEEXCEPTION_HPP_
#include <com/sun/star/lang/WrappedTargetRuntimeException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_COMMANDABORTEDEXCEPTION_HPP_
#include <com/sun/star/ucb/CommandAbortedException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVEAPPEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveAppException.hpp>
#endif



#ifndef _UCBHELPER_SIMPLEINTERACTIONREQUEST_HXX
#include <ucbhelper/simpleinteractionrequest.hxx>
#endif

#include <rtl/ustring.h>
#include <rtl/logfile.hxx>
#include <svtools/eitem.hxx>
#include <svtools/stritem.hxx>
#include <tools/urlobj.hxx>
#include <vos/mutex.hxx>
#include <svtools/sfxecode.hxx>
#include <svtools/ehdl.hxx>
#include <sot/storinfo.hxx>

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::task;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::ucb;
using namespace ::rtl;

#include "request.hxx"
#include "sfxsids.hrc"
#include "dispatch.hxx"
#include "topfrm.hxx"
#include "docfac.hxx"
#include "fcontnr.hxx"
#include "loadenv.hxx"
#include "docfile.hxx"
#include "brokenpackageint.hxx"
#include <appuno.hxx>
namespace binfilter {

/*N*/ SfxFrameLoader_Impl::SfxFrameLoader_Impl( const REFERENCE < ::com::sun::star::lang::XMultiServiceFactory >& xFactory )
/*N*/     : pMatcher( 0 )
/*N*/     , pLoader( 0 )
/*N*/ 	, bLoadDone( sal_False )
/*N*/ 	, bLoadState( sal_False )
/*N*/ {
/*N*/ }

/*N*/ SfxFrameLoader_Impl::~SfxFrameLoader_Impl()
/*N*/ {
/*N*/     delete pMatcher;
/*N*/ }

/*N*/ sal_Bool SAL_CALL SfxFrameLoader_Impl::load( const Sequence< PropertyValue >& rArgs, const REFERENCE< XFrame >& rFrame ) throw( RuntimeException )
/*N*/ {
/*N*/     // this methods assumes that the filter is detected before, usually by calling the detect() method below
/*N*/     ::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/
/*N*/ 	RTL_LOGFILE_CONTEXT( aLog, "sfx2 (mb93783) ::SfxFrameLoader::load" );
/*N*/
/*N*/     if ( !rFrame.is() )
/*N*/         return sal_False;
/*N*/
/*N*/     String rURL;
/*N*/     String aTypeName;
/*N*/ 	sal_uInt32 nPropertyCount = rArgs.getLength();
/*N*/     sal_Bool bReadOnlyTest = sal_False;
/*N*/ 	::com::sun::star::uno::Reference< XInteractionHandler > xInteraction;
/*N*/ 	::com::sun::star::uno::Reference < XModel > xModel;
/*N*/ 	for( sal_uInt32 nProperty=0; nProperty<nPropertyCount; ++nProperty )
/*N*/ 	{
/*N*/         if( rArgs[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("URL")) )
/*N*/ 		{
/*N*/ 			::rtl::OUString sTemp;
/*N*/ 			rArgs[nProperty].Value >>= sTemp;
/*N*/ 			rURL = sTemp;
/*N*/ 		}
/*N*/         else if( !rURL.Len() && rArgs[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("FileName")) )
/*N*/ 		{
/*?*/ 			::rtl::OUString sTemp;
/*?*/             rArgs[nProperty].Value >>= sTemp;
/*?*/             rURL = sTemp;
/*N*/ 		}
/*N*/         if( rArgs[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("TypeName")) )
/*N*/ 		{
/*N*/             // the name of the file type detected so far (or provided by the client code)
/*N*/ 			::rtl::OUString sTemp;
/*N*/ 			rArgs[nProperty].Value >>= sTemp;
/*N*/             aTypeName = sTemp;
/*N*/ 		}
/*N*/ 		if( rArgs[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("FilterName")) )
/*N*/ 		{
/*N*/             // the name of the desired filter, usually to prevent us from using the default
/*N*/             // filter for the detected type
/*N*/ 			::rtl::OUString sTemp;
/*N*/ 			rArgs[nProperty].Value >>= sTemp;
/*N*/             aFilterName = sTemp;
/*N*/ 		}
/*N*/ 		if( rArgs[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("Model")) )
/*N*/ 			rArgs[nProperty].Value >>= xModel;
/*N*/ 		if( rArgs[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("ReadOnly")) )
/*N*/             rArgs[nProperty].Value >>= bReadOnlyTest;
/*N*/         else if( rArgs[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("InteractionHandler")) )
/*N*/             rArgs[nProperty].Value >>= xInteraction;
/*N*/ 	}
/*N*/
/*N*/     const SfxFilter*  pFilter  = NULL;
/*N*/     SfxFilterMatcher& rMatcher = SFX_APP()->GetFilterMatcher();
/*N*/
    /* special mode: use already loaded model ...
        In such case no filter name will be selected and no URL will be given!
        Such informations are not neccessary. We have to create a new view only
        and call setComponent() at the corresponding frame. */
/*N*/     if (!aFilterName.Len() && !xModel.is())
/*N*/     {
/*?*/         // try to find a filter with SFX filter detection using the typename
/*?*/         SfxFilterFlags    nMust    = SFX_FILTER_IMPORT;
/*?*/         SfxFilterFlags    nDont    = SFX_FILTER_NOTINSTALLED;
/*?*/         if ( aTypeName.Len() )
/*?*/         	pFilter = rMatcher.GetFilter4EA( aTypeName, nMust, nDont );
/*?*/         if ( !pFilter )
/*?*/ 		{
/*?*/             if ( xInteraction.is() )
/*?*/             {
/*?*/                 ::framework::RequestFilterSelect* pRequest = new ::framework::RequestFilterSelect( rURL );
/*?*/                 ::com::sun::star::uno::Reference< XInteractionRequest > xRequest ( pRequest );
/*?*/                 xInteraction->handle( xRequest );
/*?*/                 if( !pRequest->isAbort() )
/*?*/                 {
/*?*/                     aFilterName = pRequest->getFilter();
/*?*/ 					pFilter = rMatcher.GetFilter( aFilterName );
/*?*/                 }
/*?*/             }
/*?*/
/*?*/ 			if ( pFilter )
/*?*/ 				aTypeName = pFilter->GetTypeName();
/*?*/ 			else
/*?*/ 				return sal_False;
/*?*/ 		}
/*?*/         else
/*?*/             // use filter names without prefix
/*N*/             aFilterName = pFilter->GetFilterName();
/*N*/ 	}
/*N*/
/*N*/     xFrame = rFrame;
/*N*/
/*N*/     // Achtung: beim Abrumen der Objekte kann die SfxApp destruiert werden, vorher noch Deinitialize_Impl rufen
/*N*/     SfxApplication* pApp = SFX_APP();
/*N*/
/*N*/     SfxAllItemSet aSet( pApp->GetPool() );
/*N*/     TransformParameters( SID_OPENDOC, rArgs, aSet );
/*N*/
/*N*/     SFX_ITEMSET_ARG( &aSet, pRefererItem, SfxStringItem, SID_REFERER, FALSE );
/*N*/     if ( !pRefererItem )
/*N*/         aSet.Put( SfxStringItem( SID_REFERER, String() ) );
/*N*/
/*N*/     SfxFrame* pFrame=0;
/*N*/     for ( pFrame = SfxFrame::GetFirst(); pFrame; pFrame = SfxFrame::GetNext( *pFrame ) )
/*N*/     {
/*?*/         if ( pFrame->GetFrameInterface() == xFrame )
/*?*/             break;
/*N*/     }
/*N*/
/*N*/     if ( !pFrame )
/*N*/         pFrame = SfxTopFrame::Create( rFrame );
/*N*/
/*N*/ 	if ( xModel.is() )
/*N*/ 	{
/*?*/ 		for ( SfxObjectShell* pDoc = SfxObjectShell::GetFirst( NULL, FALSE ); pDoc; pDoc = SfxObjectShell::GetNext( *pDoc, NULL, FALSE ) )
/*?*/ 		{
/*?*/ 			if ( xModel == pDoc->GetModel() )
/*?*/ 				return pFrame->InsertDocument( pDoc );
/*N*/ 		}
/*N*/ 	}
/*N*/
/*N*/     // check for the URL pattern of our factory URLs
/*N*/     BOOL bFactoryURL = FALSE;
/*N*/ 	const SfxObjectFactory* pFactory = 0;
/*N*/ 	String aPrefix = String::CreateFromAscii( "private:factory/" );
/*N*/     String aFact( rURL );
/*N*/ 	if ( aPrefix.Len() == aFact.Match( aPrefix ) )
/*N*/     {
/*N*/         // it's a factory URL
/*N*/ 		aFact.Erase( 0, aPrefix.Len() );
/*N*/
/*N*/         // look for parameters
/*N*/         String aParam;
/*N*/         USHORT nPos = aFact.Search( '?' );
/*N*/         if ( nPos != STRING_NOTFOUND )
/*N*/         {
/*N*/             // currently only the "slot" parameter is supported
/*?*/             USHORT nParamPos = aFact.Search( String::CreateFromAscii("slot="), nPos );
/*?*/             if ( nParamPos != STRING_NOTFOUND )
/*?*/                 aParam = aFact.Copy( nParamPos+5, aFact.Len() );
/*?*/             aFact.Erase( nPos, aFact.Len() );
/*N*/         }
/*N*/
/*N*/         WildCard aSearchedFac( aFact.EraseAllChars('4').ToUpperAscii() );
/*N*/         for( USHORT n = SfxObjectFactory::GetObjectFactoryCount_Impl(); !pFactory && n--; )
/*N*/         {
/*N*/             pFactory = &SfxObjectFactory::GetObjectFactory_Impl( n );
/*N*/             if( !aSearchedFac.Matches( String::CreateFromAscii( pFactory->GetShortName() ).ToUpperAscii() ) )
/*N*/                 pFactory = 0;
/*N*/         }
/*N*/
/*N*/         if ( pFactory )
/*N*/         {
/*N*/ 			// in case an application has no import&export filter it can not be open for edit
/*N*/ 			const SfxFilter* pCombinedFilters = NULL;
/*N*/         	SfxFactoryFilterContainer* pCont = pFactory->GetFilterContainer();
/*N*/ 			if ( pCont )
/*N*/ 			{
/*N*/ 				SfxFilterFlags    nMust    = SFX_FILTER_IMPORT | SFX_FILTER_EXPORT;
/*N*/     			SfxFilterFlags    nDont    = SFX_FILTER_NOTINSTALLED;
/*N*/ 				pCombinedFilters = pCont->GetAnyFilter( nMust, nDont );
/*N*/ 			}
/*N*/
/*N*/     		SFX_ITEMSET_ARG( &aSet, pDocumentTitleItem, SfxStringItem, SID_DOCINFO_TITLE, FALSE );
/*N*/
/*N*/ 			if ( pCombinedFilters )
/*N*/ 			{
/*N*/             	INetURLObject aObj( rURL );
/*N*/             	if ( aParam.Len() )
/*N*/             	{
/*?*/                 	// slots are executed on the module shell
/*?*/                 	sal_uInt16 nSlotId = (sal_uInt16) aParam.ToInt32();
/*?*/                 	SfxModule* pMod = pFactory->GetModule()->Load();
/*?*/                 	SfxRequest aReq( nSlotId, SFX_CALLMODE_SYNCHRON, pMod->GetPool() );
/*?*/                 	aReq.AppendItem( SfxStringItem ( SID_FILE_NAME, rURL ) );
/*?*/                 	aReq.AppendItem( SfxFrameItem ( SID_DOCFRAME, pFrame ) );
/*?*/
/*?*/                 	// the next parameter is especially needed for Impress, because they want to know
/*?*/                 	// wether their slot is called directly (like from Autopilot menue) or as part
/*?*/                 	// of a "NewDocument" request
/*?*/                 	aReq.AppendItem( SfxBoolItem ( SID_NEWDOCDIRECT, TRUE ) );
/*?*/
/*?*/ 					if ( pDocumentTitleItem )
/*?*/ 						aReq.AppendItem( *pDocumentTitleItem );
/*?*/
/*?*/                 	const SfxPoolItem* pRet = pMod->ExecuteSlot( aReq );
/*?*/                 	if ( pRet )
/*?*/                 	{
/*?*/                     	bLoadState = sal_True;
/*?*/                 	}
/*?*/                 	else
/*?*/                 	{
/*?*/                     	SfxObjectShell* pDoc = pFrame->GetCurrentDocument();
/*?*/                     	if ( !pDoc )
/*?*/                     	{
/*?*/                         	REFERENCE< XFrame > aXFrame;
/*?*/                         	pFrame->SetFrameInterface_Impl( aXFrame );
/*?*/                         	pFrame->DoClose();
/*?*/                     	}
/*?*/
/*?*/                     	bLoadState = sal_False;
/*?*/                 	}
/*?*/
/*?*/                 	return bLoadState;
/*N*/             	}
/*N*/
/*N*/             	if( pFactory->GetStandardTemplate().Len() )
/*N*/             	{
/*N*/                 	// standard template set -> load it "AsTemplate"
/*?*/                 	aSet.Put( SfxStringItem ( SID_FILE_NAME, pFactory->GetStandardTemplate() ) );
/*?*/                 	aSet.Put( SfxBoolItem( SID_TEMPLATE, sal_True ) );
/*N*/             	}
/*N*/             	else
/*N*/             	{
/*N*/                 	// execute "NewDocument" request
                    /* Attention!
                        #107913#
                        Pointers can't be used to check if two objects are equals!
                        E.g. the memory manager can reuse freed memory ...
                        and then the holded copy of a pointer will point to another
                        (and different!) object - may using the same type then before.
                        In such case we compare one object with itself ...
                     */
/*N*/                 	SfxRequest aReq( SID_NEWDOCDIRECT, SFX_CALLMODE_SYNCHRON, aSet );
/*N*/                 	aReq.AppendItem( SfxFrameItem( SID_DOCFRAME, pFrame ) );
/*N*/                 	aReq.AppendItem( SfxStringItem( SID_NEWDOCDIRECT, String::CreateFromAscii(pFactory->GetShortName()) ) );
/*N*/
/*N*/ 					if ( pDocumentTitleItem )
/*?*/ 						aReq.AppendItem( *pDocumentTitleItem );
/*N*/
/*N*/                 	const SfxPoolItem* pRet = pApp->ExecuteSlot( aReq );
/*N*/                     if (pRet)
/*N*/                 	{
/*N*/                     	bLoadState = sal_True;
/*N*/                 	}
/*N*/                 	else if ( xListener.is() )
/*N*/                 	{
/*?*/                     	if ( !pFrame->GetCurrentDocument() )
/*?*/                     	{
/*?*/                         	REFERENCE< XFrame > aXFrame;
/*?*/                         	pFrame->SetFrameInterface_Impl( aXFrame );
/*?*/                         	pFrame->DoClose();
/*?*/                     	}
/*?*/
/*?*/                     	bLoadState = sal_False;
/*N*/                 	}
/*N*/
/*N*/                 	xFrame = REFERENCE< XFrame >();
/*N*/                 	return bLoadState;
/*N*/             	}
/*N*/         	}
/*N*/     	}
/*N*/ 	}
/*N*/     else
/*N*/     {
/*N*/         // load the desired file
/*N*/         aSet.Put( SfxStringItem ( SID_FILE_NAME, rURL ) );
/*N*/     }
/*N*/
/*N*/     aSet.Put( SfxFrameItem( SID_DOCFRAME, pFrame ) );
/*N*/     aSet.Put( SfxStringItem( SID_FILTER_NAME, aFilterName ) );
/*N*/
/*N*/ 	SfxAllItemSet aResSet( aSet );
/*N*/
/*N*/     if ( !pFactory )
/*N*/     {
/*N*/         pFilter = rMatcher.GetFilter4FilterName( aFilterName );
/*N*/         SfxFactoryFilterContainer* pCont = pFilter ? (SfxFactoryFilterContainer*) pFilter->GetFilterContainer() : NULL;
/*N*/         if ( pCont )
/*N*/             pFactory = &pCont->GetFactory();
/*N*/     }
/*N*/
/*N*/ 	if ( pFactory )
/*N*/ 	{
/*N*/ 		// in case an application has no import&export filter it should be used in readonly mode
/*N*/ 		SfxFilterFlags    nMust    = SFX_FILTER_IMPORT | SFX_FILTER_EXPORT;
/*N*/     	SfxFilterFlags    nDont    = SFX_FILTER_NOTINSTALLED;
/*N*/         SfxFactoryFilterContainer* pCont = pFactory->GetFilterContainer();
/*N*/ 		if ( pCont )
/*N*/ 		{
/*N*/ 			const SfxFilter* pCombinedFilters = pCont->GetAnyFilter( nMust, nDont );
/*N*/ 			if ( !pCombinedFilters )
/*N*/ 			{
/*N*/     			aSet.Put( SfxBoolItem( SID_DOC_READONLY, sal_True ) );
/*N*/     			aSet.Put( SfxBoolItem( SID_EDITDOC, sal_False ) );
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/
/*N*/    	// create LoadEnvironment and set link for callback when it is finished
/*N*/    	pLoader = LoadEnvironment_Impl::Create( aSet );
/*N*/    	pLoader->AddRef();
/*N*/    	pLoader->SetDoneLink( LINK( this, SfxFrameLoader_Impl, LoadDone_Impl ) );
/*N*/
/*N*/     if ( pFactory )
/*N*/     {
/*N*/         bLoadDone = sal_False;
/*N*/         pMatcher = new SfxFilterMatcher( pFactory->GetFilterContainer() );
/*N*/
/*N*/         pLoader->SetFilterMatcher( pMatcher );
/*N*/         pLoader->Start();
/*N*/
/*N*/         // wait for callback
/*N*/         while( bLoadDone == sal_False )
/*N*/             Application::Yield();
/*N*/
/*N*/ 		if ( pLoader->GetError() == ERRCODE_IO_BROKENPACKAGE && xInteraction.is() )
/*N*/ 		{
/*?*/ 		    OUString aDocName = INetURLObject(rURL).getName( INetURLObject::LAST_SEGMENT, true,
/*?*/                                                       INetURLObject::DECODE_WITH_CHARSET );
/*?*/
/*?*/     		SFX_ITEMSET_ARG( &aSet, pRepairItem, SfxBoolItem, SID_REPAIRPACKAGE, FALSE );
/*?*/     		if ( !pRepairItem || !pRepairItem->GetValue() )
/*?*/ 			{
/*?*/             	RequestPackageReparation* pRequest = new RequestPackageReparation( aDocName );
/*?*/             	::com::sun::star::uno::Reference< XInteractionRequest > xRequest ( pRequest );
/*?*/             	xInteraction->handle( xRequest );
/*?*/             	if( pRequest->isApproved() )
/*?*/ 				{
/*?*/     				aResSet.Put( SfxBoolItem( SID_REPAIRPACKAGE, sal_True ) );
/*?*/                 	aResSet.Put( SfxBoolItem( SID_TEMPLATE, sal_True ) );
/*?*/ 					aResSet.Put( SfxStringItem( SID_DOCINFO_TITLE, aDocName ) );
/*?*/ 					pLoader->ReleaseRef();
/*?*/     				pLoader = LoadEnvironment_Impl::Create( aResSet );
/*?*/     				pLoader->AddRef();
/*?*/     				pLoader->SetDoneLink( LINK( this, SfxFrameLoader_Impl, LoadDone_Impl ) );
/*?*/
/*?*/         			bLoadDone = sal_False;
/*?*/         			pLoader->SetFilterMatcher( pMatcher );
/*?*/         			pLoader->Start();
/*?*/
/*?*/         			// wait for callback
/*?*/         			while( bLoadDone == sal_False )
/*?*/ 						Application::Yield();
/*?*/
/*?*/ 					if ( pLoader->GetError() == ERRCODE_IO_BROKENPACKAGE )
/*?*/ 					{
/*?*/ 	           			NotifyBrokenPackage* pNotifyRequest = new NotifyBrokenPackage( aDocName );
/*?*/            				xRequest = ::com::sun::star::uno::Reference< XInteractionRequest >( pNotifyRequest );
/*?*/            				xInteraction->handle( xRequest );
/*?*/ 					}
/*?*/ 				}
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 	           	NotifyBrokenPackage* pNotifyRequest = new NotifyBrokenPackage( aDocName );
/*?*/             	::com::sun::star::uno::Reference< XInteractionRequest > xRequest ( pNotifyRequest );
/*?*/            		xInteraction->handle( xRequest );
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/
/*N*/     if ( pLoader->GetError() )
/*N*/     {
/*N*/         SfxFrame* pFrame = pLoader->GetFrame();
/*N*/         if ( pFrame && !pFrame->GetCurrentDocument() )
/*N*/         {
/*N*/             ::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/             REFERENCE< XFrame > aXFrame;
/*N*/             pFrame->SetFrameInterface_Impl( aXFrame );
/*N*/             pFrame->DoClose();
/*N*/         }
/*N*/ 	}
/*N*/
/*N*/     xFrame = REFERENCE< XFrame >();
/*N*/     xListener = REFERENCE< XLoadEventListener >();
/*N*/
/*N*/     if ( pLoader )
/*N*/ 	{
/*N*/         pLoader->ReleaseRef();
/*N*/ 		pLoader = 0;
/*N*/ 	}
/*N*/
/*N*/ 	return bLoadState;
/*N*/ }

/*N*/ void SfxFrameLoader_Impl::cancel() throw( RUNTIME_EXCEPTION )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001
/*N*/ }

/*N*/ IMPL_LINK( SfxFrameLoader_Impl, LoadDone_Impl, void*, pVoid )
/*N*/ {
/*N*/     DBG_ASSERT( pLoader, "No Loader created, but LoadDone ?!" );
/*N*/
/*N*/     if ( pLoader->GetError() )
/*N*/     {
/*?*/ 		bLoadDone  = sal_True ;
/*?*/ 		bLoadState = sal_False;
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/ 		bLoadDone  = sal_True;
/*N*/ 		bLoadState = sal_True;
/*N*/     }
/*N*/
/*N*/     return NULL;
/*N*/ }

/*N*/ ::rtl::OUString SAL_CALL SfxFrameLoader_Impl::detect( ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& lDescriptor ) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/     // This method detects (or verifies) the file type of the content to load. It also detects the filter, because SFX
/*N*/     // detects type through filters, so detecting the filter later in the load method would be double work.
/*N*/     // It can detect all types for that an internal filter is known, even if the preselected filter is an external one.
/*N*/     // Internal filters should be exactly as described in the configuration, but they may also have filter names with a
/*N*/     // module prefix as in the old SFX-API, this is handled inside this method; but all filter names that are inserted
/*N*/     // into the media descriptor by this method will be without prefix
/*N*/     // examples for supported formats for filter names:
/*N*/     //  with module prefix  : "swriter: StarWriter 5.0"
/*N*/     //  without             : "StarWriter 5.0"
/*N*/
/*N*/ 	RTL_LOGFILE_CONTEXT( aLog, "sfx2 (mb93783) ::SfxFrameLoader::detect" );
/*N*/
/*N*/     REFERENCE< XInputStream > xStream;
/*N*/     REFERENCE< XContent > xContent;
/*N*/     REFERENCE< XInteractionHandler > xInteraction;
/*N*/     String aURL;
/*N*/ 	::rtl::OUString sTemp;
/*N*/     ::rtl::OUString aTypeName;            // a name describing the type (from MediaDescriptor, usually from flat detection)
/*N*/     String aPreselectedFilterName;      // a name describing the filter to use (from MediaDescriptor, usually from UI action)
/*N*/     const SfxFilter* pFilter = NULL, *pExternalFilter = NULL;
/*N*/
/*N*/ 	// opening as template is done when a parameter tells to do so and a template filter can be detected
/*N*/     // (otherwise no valid filter would be found) or if the detected filter is a template filter and
/*N*/ 	// there is no parameter that forbids to open as template
/*N*/ 	sal_Bool bOpenAsTemplate = sal_False;
/*N*/     sal_Bool bWasReadOnly = sal_False, bReadOnly = sal_False;
/*N*/
/*N*/ 	// now some parameters that can already be in the array, but may be overwritten or new inserted here
/*N*/ 	// remember their indices in the case new values must be added to the array
/*N*/ 	sal_Int32 nPropertyCount = lDescriptor.getLength();
/*N*/     sal_Int32 nIndexOfFilterName = -1;
/*N*/     sal_Int32 nIndexOfInputStream = -1;
/*N*/     sal_Int32 nIndexOfContent = -1;
/*N*/     sal_Int32 nIndexOfReadOnlyFlag = -1;
/*N*/     sal_Int32 nIndexOfTemplateFlag = -1;
/*N*/     for( sal_Int32 nProperty=0; nProperty<nPropertyCount; ++nProperty )
/*N*/ 	{
/*N*/         // extract properties
/*N*/         if( lDescriptor[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("URL")) )
/*N*/ 		{
/*N*/ 			lDescriptor[nProperty].Value >>= sTemp;
/*N*/ 			aURL = sTemp;
/*N*/ 		}
/*N*/         else if( !aURL.Len() && lDescriptor[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("FileName")) )
/*N*/ 		{
/*?*/ 			lDescriptor[nProperty].Value >>= sTemp;
/*?*/ 			aURL = sTemp;
/*N*/ 		}
/*N*/         else if( lDescriptor[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("TypeName")) )
/*N*/ 		{
/*N*/ 			lDescriptor[nProperty].Value >>= sTemp;
/*N*/             aTypeName = sTemp;
/*N*/ 		}
/*N*/         else if( lDescriptor[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("FilterName")) )
/*N*/ 		{
/*?*/ 			lDescriptor[nProperty].Value >>= sTemp;
/*?*/             aPreselectedFilterName = sTemp;
/*?*/
/*?*/             // if the preselected filter name is not correct, it must be erased after detection
/*?*/             // remember index of property to get access to it later
/*?*/             nIndexOfFilterName = nProperty;
/*N*/ 		}
/*N*/         else if( lDescriptor[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("InputStream")) )
/*N*/             nIndexOfInputStream = nProperty;
/*N*/         else if( lDescriptor[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("ReadOnly")) )
/*N*/             nIndexOfReadOnlyFlag = nProperty;
/*N*/         else if( lDescriptor[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("UCBContent")) )
/*N*/             nIndexOfContent = nProperty;
/*N*/         else if( lDescriptor[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("AsTemplate")) )
/*N*/ 		{
/*?*/ 			lDescriptor[nProperty].Value >>= bOpenAsTemplate;
/*?*/             nIndexOfTemplateFlag = nProperty;
/*N*/ 		}
/*N*/         else if( lDescriptor[nProperty].Name == OUString(RTL_CONSTASCII_USTRINGPARAM("InteractionHandler")) )
/*N*/             lDescriptor[nProperty].Value >>= xInteraction;
/*N*/ 	}
/*N*/
/*N*/     // can't check the type for external filters, so set the "dont" flag accordingly
/*N*/     ::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/     SfxFilterFlags nMust = SFX_FILTER_IMPORT, nDont = SFX_FILTER_NOTINSTALLED;
/*N*/     SfxFilterMatcher& rMatcher = SFX_APP()->GetFilterMatcher();
/*N*/     if ( aPreselectedFilterName.Len() )
/*N*/     {
/*?*/         // the preselected filter name itself may be valid SFX filter name
/*?*/         // the method "GetFilter" supports both formats, so there is no need to deal with module prefixes here
/*?*/         pFilter = rMatcher.GetFilter( aPreselectedFilterName );
/*?*/         if ( pFilter )
/*?*/         {
/*?*/             if ( pFilter->GetFilterFlags() & SFX_FILTER_STARONEFILTER )
/*?*/             {
/*?*/                 // external filters can't be detected with this service ( only their type may be used )
/*?*/                 pExternalFilter = pFilter;
/*?*/             }
/*?*/         }
/*?*/         else
/*?*/         {
/*?*/             // the preselected filter does not belong to a valid type, so forget it
/*?*/             aPreselectedFilterName.Erase();
/*?*/         }
/*N*/     }
/*N*/
/*N*/     if ( !pFilter && aTypeName.getLength() )
/*N*/     {
/*N*/         // now try the type from the shallow detection or extracted from the preselected filter,
/*N*/         // though the filter itself was not valid
/*N*/         // look for a filter registered for the desired type that is not an external one
/*N*/         // this will be the default filter for that type
/*N*/         pFilter = rMatcher.GetFilter4EA( aTypeName, nMust, SFX_FILTER_NOTINSTALLED );
/*N*/         if ( pFilter && pFilter->GetFilterFlags() & SFX_FILTER_STARONEFILTER )
/*N*/         {
/*N*/             // external filters can't be detected with this service ( only their type may be used )
/*N*/             pExternalFilter = pFilter;
/*N*/         }
/*N*/         // No filter - return the original given typename.
/*N*/         // It's neccessary for our beamer db components. Because the have no filter
/*N*/         // but a frame loader. If we return noting here such components not loadable any longer :-(
/*N*/         else if (!pFilter)
/*N*/                 return aTypeName;
/*N*/     }
/*N*/
/*N*/ 	String aPrefix = String::CreateFromAscii( "private:factory/" );
/*N*/ 	if( aURL.Match( aPrefix ) == aPrefix.Len() )
/*N*/ 	{
/*N*/         // private:factory URLs are used to create new documents, so nothing must be detected
/*N*/         // use the result of the shallow detection
/*N*/         if ( pFilter )
/*N*/         {
/*N*/             // use format without prefix
/*N*/             aFilterName = pFilter->GetFilterName();
/*N*/             if ( nIndexOfFilterName != -1 )
/*?*/                 lDescriptor[nIndexOfFilterName].Value <<= ::rtl::OUString( aFilterName );
/*N*/             else
/*N*/             {
/*N*/                 lDescriptor.realloc( nPropertyCount + 1 );
/*N*/                 lDescriptor[nPropertyCount].Name = ::rtl::OUString::createFromAscii("FilterName");
/*N*/                 lDescriptor[nPropertyCount].Value <<= ::rtl::OUString( aFilterName );
/*N*/                 nPropertyCount++;
/*N*/             }
/*N*/         }
/*N*/         else
/*N*/             DBG_ERROR( "Illegal type for factory URL!" );
/*N*/         return aTypeName;
/*N*/ 	}
/*N*/     else if ( !pExternalFilter )
/*N*/     {
/*N*/         // Try a SFX filter detection
/*N*/         // This is only possible for non-external filters!
/*N*/         SfxErrorContext aCtx( ERRCTX_SFX_OPENDOC, aURL );
/*N*/         const SfxFilter* pOldFilter = pFilter;
/*N*/
/*N*/         // transform parameters into an SfxItemSet
/*N*/         SfxApplication* pApp = SFX_APP();
/*N*/         SfxAllItemSet *pSet = new SfxAllItemSet( pApp->GetPool() );
/*N*/         TransformParameters( SID_OPENDOC, lDescriptor, *pSet );
/*N*/         SFX_ITEMSET_ARG( pSet, pItem, SfxBoolItem, SID_DOC_READONLY, FALSE );
/*N*/
/*N*/         bWasReadOnly = pItem && pItem->GetValue();
/*N*/
/*N*/         // ctor of SfxMedium uses owner transition of ItemSet
/*N*/         SfxMedium aMedium( aURL, bWasReadOnly ? STREAM_STD_READ : STREAM_STD_READWRITE, FALSE, NULL, pSet );
/*N*/         aMedium.UseInteractionHandler( TRUE );
/*N*/
/*N*/         BOOL bIsStorage = aMedium.IsStorage();
/*N*/         if ( aMedium.GetErrorCode() == ERRCODE_NONE )
/*N*/         {
/*N*/             // remember input stream and content and put them into the descriptor later
/*N*/ 			// should be done here since later the medium can switch to a version
/*N*/             xStream = aMedium.GetInputStream();
/*N*/ 			xContent = aMedium.GetContent();
/*N*/
/*N*/             // maybe that IsStorage() already created an error!
/*N*/             if ( bIsStorage )
/*N*/ 			{
/*N*/                 aMedium.GetStorage();
/*N*/ 				if ( aMedium.GetLastStorageCreationState() != ERRCODE_NONE )
/*N*/ 				{
/*N*/ 					// error during storage creation means _here_ that the medium
/*N*/ 					// is broken, but we can not handle it in medium since unpossibility
/*N*/ 					// to create a storage does not _always_ means that the medium is broken
/*N*/
/*?*/ 					aMedium.SetError( aMedium.GetLastStorageCreationState() );
/*?*/
/*?*/ 					if ( xInteraction.is() )
/*?*/ 					{
/*?*/ 						OUString empty;
/*?*/ 						try
/*?*/ 						{
/*?*/ 							InteractiveAppException xException( empty,
/*?*/ 															REFERENCE< XInterface >(),
/*?*/ 															InteractionClassification_ERROR,
/*?*/ 															aMedium.GetError() );
/*?*/
/*?*/ 							REFERENCE< XInteractionRequest > xRequest(
/*?*/ 								new ucbhelper::SimpleInteractionRequest( makeAny( xException ),
/*?*/ 																 	 ucbhelper::CONTINUATION_APPROVE ) );
/*?*/ 							xInteraction->handle( xRequest );
/*?*/ 						}
/*?*/ 						catch ( Exception & ) {};
/*N*/ 					}
/*N*/ 				}
/*N*/ 			}
/*N*/             else
/*?*/                 aMedium.GetInStream();
/*N*/
/*N*/             // special filters that can or must(!) be detected inside the medium without further investigation
/*N*/             // f.e. disk spanned jar files
/*N*/             if ( aMedium.GetFilter() )
/*?*/                 pFilter = aMedium.GetFilter();
/*N*/
/*N*/             bReadOnly = aMedium.IsReadOnly();
/*N*/         }
/*N*/
/*N*/         if ( aMedium.GetErrorCode() == ERRCODE_NONE && !aMedium.GetFilter() )
/*N*/         {
/*N*/             // check the filter detected so far (if any)
/*N*/             ErrCode nErr = ERRCODE_ABORT;
/*N*/             if ( pFilter )
/*N*/             {
/*?*/                 // type or filter name matched to a valid filter name detectable with this service
/*?*/                 const SfxFilter* pOldFilter = pFilter;
/*?*/                 SfxFilterFlags nFlags = pFilter->GetFilterFlags();
/*?*/                 if ( ( nFlags & nMust ) == nMust && ( nFlags & nDont ) == 0 )
/*?*/                 {
/*?*/                     // some detection methods need the filter name in the ItemSet
/*?*/                     pSet->Put( SfxStringItem( SID_FILTER_NAME, pFilter->GetFilterName() ) );
/*?*/                     nErr = pFilter->GetFilterContainer()->GetFilter4Content( aMedium, &pFilter, nMust, nDont );
/*?*/                     if ( pOldFilter == pFilter && nErr != ERRCODE_NONE )
/*?*/                         pFilter = NULL;
/*?*/                 }
/*?*/                 else
/*?*/                     // filterflags don't fit
/*?*/                     pFilter = NULL;
/*?*/
/*?*/                 if ( !pFilter )
/*?*/                 {
/*?*/                     // the filter exists, but deep detection regrets it ( or filter flags don't match )
/*?*/                     if ( aPreselectedFilterName.Len() )
/*?*/                     {
/*?*/                         // the filter we just tried was the preselected filter
/*?*/                         // it doesn't fit, so erase the filter name from media descriptor
/*?*/                         lDescriptor[nIndexOfFilterName].Value <<= ::rtl::OUString();
/*?*/
/*?*/                         // try the typename instead ( if any )
/*?*/                         if ( aTypeName.getLength() )
/*?*/                         {
/*?*/                             pFilter = rMatcher.GetFilter4EA( aTypeName, nMust, nDont );
/*?*/                             if ( pFilter && pFilter->GetFilterFlags() & SFX_FILTER_STARONEFILTER )
/*?*/                             {
/*?*/                                 // external filters can't be detected with this service ( only their type may be used )
/*?*/                                 pExternalFilter = pFilter;
/*?*/                             }
/*?*/
/*?*/                             if ( !pExternalFilter )
/*?*/                             {
/*?*/                                 // no deep detection for external filters
/*?*/                                 if ( pFilter == pOldFilter )
/*?*/                                     // filter was already checked
/*?*/                                     pFilter = NULL;
/*?*/                                 else
/*?*/                                     pOldFilter = pFilter;
/*?*/
/*?*/                                 if ( pFilter )
/*?*/                                 {
/*?*/                                     SfxFilterFlags nFlags = pFilter->GetFilterFlags();
/*?*/                                     if ( ( nFlags & nMust ) == nMust && ( nFlags & nDont ) == 0 )
/*?*/                                     {
/*?*/                                         // some detection methods need the filter name in the ItemSet
/*?*/                                         pSet->Put( SfxStringItem( SID_FILTER_NAME, pFilter->GetFilterName() ) );
/*?*/                                         nErr = pFilter->GetFilterContainer()->GetFilter4Content( aMedium, &pFilter );
/*?*/                                         if ( pOldFilter == pFilter && nErr != ERRCODE_NONE )
/*?*/                                             pFilter = NULL;
/*?*/                                     }
/*?*/                                     else
/*?*/                                         // filterflags don't fit
/*?*/                                         pFilter = NULL;
/*?*/                                 }
/*?*/                             }
/*?*/                         }
/*?*/                     }
/*?*/                 }
/*?*/                 else if ( aPreselectedFilterName.Len() && nErr == ERRCODE_SFX_CONSULTUSER )
/*?*/                 {
/*?*/                     // preselected filter could not be detected, but the detection function is
/*?*/                     // known to be a little bit "fuzzy"
/*?*/                     // ask user for his decision between two detected filters
/*?*/                     if( !xInteraction.is() )
/*?*/                     {
/*?*/                         // no interaction => pFilter wins
/*?*/                         nErr = ERRCODE_NONE;
/*?*/                         aMedium.SetError(nErr);
/*?*/                     }
/*?*/                     else
/*?*/                     {
/*?*/                         ::rtl::OUString aSelectedFilter( aPreselectedFilterName );  // name of pOldFilter
/*?*/                         ::rtl::OUString aDetectedFilter( pFilter->GetName()     );
/*?*/
/*?*/ 						try
/*?*/ 						{
/*?*/                         	::framework::RequestAmbigousFilter* pRequest = new ::framework::RequestAmbigousFilter( aURL, aSelectedFilter, aDetectedFilter );
/*?*/                         	REFERENCE< ::com::sun::star::task::XInteractionRequest > xRequest( static_cast< ::com::sun::star::task::XInteractionRequest* >(pRequest), ::com::sun::star::uno::UNO_QUERY );
/*?*/
/*?*/                         	xInteraction->handle( xRequest );
/*?*/ 	                        if( pRequest->isAbort() )
/*?*/ 	                        {
/*?*/ 	                            nErr = ERRCODE_ABORT;
/*?*/ 	                            aMedium.SetError(nErr);
/*?*/ 	                        }
/*?*/ 	                        else
/*?*/ 	                        {
/*?*/ 	                            if( pRequest->getFilter() == aSelectedFilter )
/*?*/ 	                            {
/*?*/ 	                                nErr = ERRCODE_NONE;
/*?*/ 	                                aMedium.SetError(nErr);
/*?*/ 	                                pFilter = pOldFilter;
/*?*/ 	                            }
/*?*/ 	                        }
/*?*/ 						}
/*?*/ 						catch ( Exception & ) {};
/*?*/                     }
/*?*/                 }
/*N*/             }
/*N*/
/*N*/             // No error while reading from medium ?
/*N*/             if ( !pFilter && aMedium.GetErrorCode() == ERRCODE_NONE )
/*N*/             {
/*N*/                 // file extension ".vor" is ambigious, so perhaps the flat detection gave the wrong
/*N*/                 // template filter that was discarded in the deep detection
/*N*/                 // searching the filter for the clipboard Id usually gives the document filter, not
/*N*/                 // the template filter, so set the  "must" flags accordingly
/*N*/                 if ( INetURLObject( aURL ).GetExtension().compareToAscii("vor") == 0 )
/*N*/                     nMust |= SFX_FILTER_TEMPLATEPATH;
/*N*/
/*N*/                 // no filter found until now
/*N*/                 if ( bIsStorage )
/*N*/                 {
/*N*/                     // try simplest file lookup: clipboard format in storage
/*N*/                     SvStorageRef aStor = aMedium.GetStorage();
/*N*/                     if ( aStor.Is() )
/*N*/                         pFilter = rMatcher.GetFilter4ClipBoardId( aStor->GetFormat(), nMust, nDont );
/*N*/                 }
/*N*/
/*N*/                 // no filter found : try everything possible
/*N*/                 if ( aMedium.GetErrorCode() == ERRCODE_NONE && ( !pFilter || !pFilter->IsOwnFormat() ) )
/*?*/                     {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 nErr = rMatcher.GetFilter4Content( aMedium, &pFilter, nMust, nDont );
/*N*/             }
/*N*/         }
/*N*/
/*N*/         if ( aMedium.GetErrorCode() != ERRCODE_NONE )
/*N*/         {
/*N*/             // when access to medium gives an error, the filter can't be valid
/*N*/             pFilter = NULL;
/*N*/             ::com::sun::star::lang::WrappedTargetRuntimeException exPacked;
/*N*/             ::com::sun::star::ucb::CommandAbortedException        exAbort ;
/*N*/             exPacked.TargetException <<= exAbort;
/*N*/             throw exPacked;
/*N*/         }
/*N*/ 		else if ( !pFilter && aMedium.GetStorage() )
/*N*/ 		{
/*N*/ 			SvStorageInfoList aList;
/*N*/             aMedium.GetStorage()->FillInfoList( &aList );
/*N*/             if ( pOldFilter && !aList.Count() && !aMedium.GetStorage()->IsOLEStorage() && pOldFilter->UsesStorage() && pOldFilter->GetVersion() >= SOFFICE_FILEFORMAT_60 )
/*N*/ 			{
/*N*/ 				// possibly broken package
/*N*/ 				pFilter = pOldFilter;
/*N*/ 			}
/*N*/ 		}
/*N*/
/*N*/         // may be - w4w filter doesn't close the stream
/*N*/         // so we should do that here.
/*N*/         if( !aMedium.IsOpen() )
/*N*/             xStream = NULL;
/*N*/     }
/*N*/
/*N*/     if ( pFilter )
/*N*/     {
/*N*/         // successful detection, get the filter name (without prefix)
/*N*/         aTypeName = pFilter->GetTypeName();
/*N*/         aFilterName = pFilter->GetFilterName();
/*N*/         if ( nIndexOfFilterName != -1 )
/*N*/             // convert to format with factory ( makes load more easy to implement )
/*?*/             lDescriptor[nIndexOfFilterName].Value <<= ::rtl::OUString( aFilterName );
/*N*/         else
/*N*/         {
/*N*/             lDescriptor.realloc( nPropertyCount + 1 );
/*N*/             lDescriptor[nPropertyCount].Name = ::rtl::OUString::createFromAscii("FilterName");
/*N*/             lDescriptor[nPropertyCount].Value <<= ::rtl::OUString( aFilterName );
/*N*/             nPropertyCount++;
/*N*/         }
/*N*/
/*N*/         if ( pFilter->IsOwnTemplateFormat() && nIndexOfTemplateFlag == -1 )
/*N*/ 		{
/*?*/             lDescriptor.realloc( nPropertyCount + 1 );
/*?*/             lDescriptor[nPropertyCount].Name = ::rtl::OUString::createFromAscii("AsTemplate");
/*?*/             lDescriptor[nPropertyCount].Value <<= sal_True;
/*?*/             nPropertyCount++;
/*N*/ 		}
/*N*/     }
/*N*/     else
/*N*/     {
/*?*/         aFilterName.Erase();
/*?*/         aTypeName = ::rtl::OUString();
/*N*/     }
/*N*/
/*N*/     if ( nIndexOfInputStream == -1 && xStream.is() )
/*N*/     {
/*?*/         // if input stream wasn't part of the descriptor, now it should be, otherwise the content would be opend twice
/*?*/         lDescriptor.realloc( nPropertyCount + 1 );
/*?*/         lDescriptor[nPropertyCount].Name = ::rtl::OUString::createFromAscii("InputStream");
/*?*/         lDescriptor[nPropertyCount].Value <<= xStream;
/*?*/         nPropertyCount++;
/*N*/     }
/*N*/
/*N*/     if ( nIndexOfContent == -1 && xContent.is() )
/*N*/     {
/*?*/         // if input stream wasn't part of the descriptor, now it should be, otherwise the content would be opend twice
/*?*/         lDescriptor.realloc( nPropertyCount + 1 );
/*?*/         lDescriptor[nPropertyCount].Name = ::rtl::OUString::createFromAscii("UCBContent");
/*?*/         lDescriptor[nPropertyCount].Value <<= xContent;
/*?*/         nPropertyCount++;
/*N*/     }
/*N*/
/*N*/     if ( bReadOnly != bWasReadOnly )
/*N*/     {
/*?*/         if ( nIndexOfReadOnlyFlag == -1 )
/*?*/         {
/*?*/             lDescriptor.realloc( nPropertyCount + 1 );
/*?*/             lDescriptor[nPropertyCount].Name = ::rtl::OUString::createFromAscii("ReadOnly");
/*?*/             lDescriptor[nPropertyCount].Value <<= bReadOnly;
/*?*/             nPropertyCount++;
/*?*/         }
/*?*/         else
/*?*/             lDescriptor[nIndexOfReadOnlyFlag].Value <<= bReadOnly;
/*N*/     }
/*N*/
/*N*/     return aTypeName;
/*N*/ }

/*N*/ SFX_IMPL_SINGLEFACTORY( SfxFrameLoader_Impl )

/* XServiceInfo */
/*N*/ UNOOUSTRING SAL_CALL SfxFrameLoader_Impl::getImplementationName() throw( UNORUNTIMEEXCEPTION )
/*N*/ {
/*N*/     return impl_getStaticImplementationName();
/*N*/ }
                                                                                                                                \
/* XServiceInfo */
/*N*/ sal_Bool SAL_CALL SfxFrameLoader_Impl::supportsService( const UNOOUSTRING& sServiceName ) throw( UNORUNTIMEEXCEPTION )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001
/*N*/     return sal_False ;
/*N*/ }

/* XServiceInfo */
/*N*/ UNOSEQUENCE< UNOOUSTRING > SAL_CALL SfxFrameLoader_Impl::getSupportedServiceNames() throw( UNORUNTIMEEXCEPTION )
/*N*/ {
/*N*/     return impl_getStaticSupportedServiceNames();
/*N*/ }

/* Helper for XServiceInfo */
/*N*/ UNOSEQUENCE< UNOOUSTRING > SfxFrameLoader_Impl::impl_getStaticSupportedServiceNames()
/*N*/ {
/*N*/     UNOMUTEXGUARD aGuard( UNOMUTEX::getGlobalMutex() );
/*N*/     UNOSEQUENCE< UNOOUSTRING > seqServiceNames( 2 );
/*N*/     seqServiceNames.getArray() [0] = UNOOUSTRING::createFromAscii( "com.sun.star.frame.SynchronousFrameLoader" );
/*N*/     seqServiceNames.getArray() [1] = UNOOUSTRING::createFromAscii( "com.sun.star.frame.ExtendedTypeDetection"  );
/*N*/     return seqServiceNames ;
/*N*/ }

/* Helper for XServiceInfo */
/*N*/ UNOOUSTRING SfxFrameLoader_Impl::impl_getStaticImplementationName()
/*N*/ {
/*N*/     return UNOOUSTRING::createFromAscii( "com.sun.star.comp.office.FrameLoader" );
/*N*/ }

/* Helper for registry */
/*N*/ UNOREFERENCE< UNOXINTERFACE > SAL_CALL SfxFrameLoader_Impl::impl_createInstance( const UNOREFERENCE< UNOXMULTISERVICEFACTORY >& xServiceManager ) throw( UNOEXCEPTION )
/*N*/ {
/*N*/     return UNOREFERENCE< UNOXINTERFACE >( *new SfxFrameLoader_Impl( xServiceManager ) );
/*N*/ }

}
