/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_frame.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:48:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_UTIL_XCLOSEABLE_HPP_
#include <com/sun/star/util/XCloseable.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#include <vcl/msgbox.hxx>

#pragma hdrstop

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#include "arrdecl.hxx"
#include "dispatch.hxx"
#include "docfile.hxx"
#include "appdata.hxx"
#include "urlframe.hxx"
#include "request.hxx"
#include "fcontnr.hxx"
#include "impframe.hxx"
#include "topfrm.hxx"
#include "workwin.hxx"
#include "objshimp.hxx"

#ifdef DBG_UTIL
#endif
namespace binfilter {

static SfxFrameArr_Impl* pFramesArr_Impl=0;

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::frame;

/*N*/ TYPEINIT1(SfxFrame, SfxListener);
/*N*/ TYPEINIT1(SfxFrameItem, SfxPoolItem);
/*N*/ TYPEINIT1(SfxUsrAnyItem, SfxPoolItem);

/*N*/ void SfxFrame::SetLoadCancelable_Impl( SfxCancellable* pCbl )
/*N*/ {
/*N*/ 	delete pImp->pLoadCancellable;
/*N*/ 	pImp->pLoadCancellable = pCbl;
/*N*/ }

/*N*/ SfxFrame::SfxFrame(SfxFrame* pParent):
/*N*/ 	pParentFrame( pParent ),
/*N*/     pChildArr(0),
/*N*/     pUnoImp(0)
/*N*/ {
/*N*/ 	pImp = new SfxFrame_Impl( this );
/*N*/     if ( pParent )
/*?*/         {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pParent->InsertChildFrame_Impl( this );
/*N*/     if ( !pFramesArr_Impl )
/*N*/         pFramesArr_Impl = new SfxFrameArr_Impl;
/*N*/     pFramesArr_Impl->Insert( this, pFramesArr_Impl->Count() );
/*N*/ }

/*N*/ SvCompatWeakHdl* SfxFrame::GetHdl()
/*N*/ {
/*N*/ 	return pImp->GetHdl();
/*N*/ }

/*N*/ SfxCancelManager* SfxFrame::GetCancelManager() const
/*N*/ {
/*N*/ 	SfxFrame *pFrame = GetTopFrame();
/*N*/ 	SfxCancelManager*& rpMgr = pFrame->pImp->pCancelMgr;
/*N*/ 	if ( !rpMgr )
/*N*/ 	{
/*N*/ 		rpMgr = new SfxCancelManager( SFX_APP()->GetCancelManager() );
/*N*/ 		pFrame->pImp->StartListening( *rpMgr );
/*N*/ 	}
/*N*/ 	return rpMgr;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxFrame::~SfxFrame()
/*N*/ {
/*N*/     pFramesArr_Impl->Remove( pFramesArr_Impl->GetPos( this ) );
/*N*/ 
/*N*/     if ( pParentFrame )
/*N*/     {
/*?*/         DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pParentFrame->RemoveChildFrame_Impl( this );
/*N*/     }
/*N*/ 
/*N*/ 	// Nur TopLevel-Frames verwalten ihren Descriptor selbst, bei den anderen
/*N*/ 	// tut es das Frameset
/*N*/ 	if ( pImp->pDescr && !pImp->pDescr->GetParent() )
/*N*/ 		delete pImp->pDescr;
/*N*/ 
/*N*/ 	if ( pChildArr )
/*N*/ 	{
/*?*/ 		DBG_ASSERT( !pChildArr->Count(), "Childs nicht entfernt!" );
/*?*/ 		delete pChildArr;
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pImp;
/*N*/ }

/*N*/ sal_Bool SfxFrame::DoClose()
/*N*/ {
/*N*/ 	// Eigentlich wird noch ein PrepareClose gebraucht !!!
/*N*/     BOOL bRet = FALSE;
/*N*/ 	if ( !pImp->bClosing )
/*N*/ 	{
/*N*/ 		pImp->bClosing = sal_True;
/*N*/ 		CancelTransfers();
/*N*/ 
/*N*/         // now close frame; it will be deleted if this call is successful, so don't use any members after that!
/*N*/         bRet = TRUE;
/*N*/         try
/*N*/         {
/*N*/             Reference< XCloseable > xCloseable  ( pImp->xFrame, UNO_QUERY );
/*N*/             if ( (!GetCurrentDocument() || !GetCurrentDocument()->Get_Impl()->bDisposing ) && xCloseable.is())
/*?*/                 xCloseable->close(sal_True);
/*N*/             else if ( pImp->xFrame.is() )
/*N*/ 			{
/*N*/ 				Reference < XFrame > xFrame = pImp->xFrame;
/*N*/ 				xFrame->setComponent( Reference < ::com::sun::star::awt::XWindow >(), Reference < XController >() );
/*N*/                 xFrame->dispose();
/*N*/ 			}
/*N*/             else
/*?*/                 bRet = DoClose_Impl();
/*N*/         }
/*N*/         catch( ::com::sun::star::util::CloseVetoException& )
/*N*/         {
/*N*/             pImp->bClosing = sal_False;
/*N*/             bRet = FALSE;
/*N*/         }
/*N*/         catch( ::com::sun::star::lang::DisposedException& )
/*N*/         {
/*N*/         }
/*N*/     }
/*N*/ 
/*N*/     return bRet;
/*N*/ }

/*N*/ sal_Bool SfxFrame::DoClose_Impl()
/*N*/ {
/*N*/     sal_Bool bRet = sal_True;
/*N*/     SfxBindings* pBindings = NULL;
/*N*/     if ( pImp->pCurrentViewFrame )
/*N*/         pBindings = &pImp->pCurrentViewFrame->GetBindings();
/*N*/ 
/*N*/     // Bei internen Tasks m"ussen Controller und Tools abger"aumt werden
/*N*/     if ( pImp->pWorkWin )
/*N*/         pImp->pWorkWin->DeleteControllers_Impl();
/*N*/ 
/*N*/     if ( pImp->pCurrentViewFrame )
/*N*/         bRet = pImp->pCurrentViewFrame->Close();
/*N*/ 
/*N*/     if ( pImp->bOwnsBindings )
/*N*/         DELETEZ( pBindings );
/*N*/ 
/*N*/     bRet = Close();
/*N*/     DBG_ASSERT( bRet, "Impossible state: frame closes, but controller refuses!");
/*N*/     return bRet;
/*N*/ }




/*N*/ sal_uInt16 SfxFrame::PrepareClose_Impl( sal_Bool bUI, sal_Bool bForBrowsing )
/*N*/ {
/*N*/ 	sal_uInt16 nRet = RET_OK;
/*N*/ 
/*N*/     // prevent recursive calls
/*N*/ 	if( !pImp->bPrepClosing )
/*N*/ 	{
/*N*/ 		pImp->bPrepClosing = sal_True;
/*N*/ 
/*N*/         SfxObjectShell* pCur = GetCurrentDocument() ;
/*N*/         if( pCur )
/*N*/         {
/*N*/             // SFX components have a known behaviour
/*N*/             // First check if this frame is the only view to its current document
/*N*/             int bOther = sal_False;
/*N*/             for ( const SfxViewFrame *pFrame = SfxViewFrame::GetFirst( pCur );
/*N*/                     !bOther && pFrame; pFrame = SfxViewFrame::GetNext( *pFrame, pCur ) )
/*N*/             {
/*N*/                 bOther = ( pFrame->GetFrame() != this );
/*N*/             }
/*N*/ 
/*N*/             if ( bOther )
/*N*/                 // if there are other views only the current view of this frame must be asked
/*?*/                 nRet = GetCurrentViewFrame()->GetViewShell()->PrepareClose( bUI, bForBrowsing );
/*N*/             else
/*N*/                 // otherwise ask the document
/*N*/                 nRet = pCur->PrepareClose( bUI, bForBrowsing );
/*N*/         }
/*N*/ 
/*N*/         if ( nRet == RET_OK )
/*N*/         {
/*N*/             // if this frame has child frames, ask them too
/*N*/             for( USHORT nPos = GetChildFrameCount(); nRet == RET_OK && nPos--; )
/*?*/                 nRet = pChildArr->GetObject( nPos )->PrepareClose_Impl( bUI, bForBrowsing );
/*N*/         }
/*N*/ 
/*N*/ 		pImp->bPrepClosing = sal_False;
/*N*/ 	}
/*N*/ 
/*N*/     if ( nRet == RET_OK && pImp->pWorkWin )
/*N*/         // if closing was accepted by the component the UI subframes must be asked also
/*N*/         nRet = pImp->pWorkWin->PrepareClose_Impl();
/*N*/ 
/*N*/     return nRet;
/*N*/ }

//--------------------------------------------------------------------







/*N*/ SfxFrame* SfxFrame::GetTopFrame() const
/*N*/ {
/*N*/ 	SfxFrame *pParent = (SfxFrame*) this;
/*N*/ 	while ( pParent->pParentFrame )
/*N*/ 		pParent = pParent->pParentFrame;
/*N*/ 	return pParent;
/*N*/ }


/*N*/ sal_Bool SfxFrame::IsClosing_Impl() const
/*N*/ {
/*N*/ 	return pImp->bClosing;
/*N*/ }

/*?*/ void SfxFrame::SetIsClosing_Impl()
/*?*/ {
/*?*/ 	pImp->bClosing = TRUE;
/*?*/ }

/*N*/ void SfxFrame::DocumentInserted( SfxObjectShell* pDoc )
/*N*/ {
/*N*/ }

/*N*/ sal_uInt16 SfxFrame::GetChildFrameCount() const
/*N*/ {
/*N*/ 	return pChildArr ? pChildArr->Count() : 0;
/*N*/ }

/*N*/ sal_Bool SfxFrame::InsertDocument( SfxObjectShell *pDoc )
/*N*/ {
/*N*/ 	DocumentInserted( pDoc );
/*N*/ 	return sal_True;
/*N*/ }

/*N*/ void SfxFrame::SetLoadEnvironment_Impl( LoadEnvironment_Impl* pEnv )
/*N*/ {
/*N*/ 	if ( pImp->pLoadEnv )
/*N*/ 		pImp->pLoadEnv->EndListening( *pImp );
/*N*/ 
/*N*/ 	pImp->pLoadEnv = pEnv;
/*N*/ 
/*N*/ 	if ( pImp->pLoadEnv && !pImp->pLoadEnv->IsListening( *pImp ) )
/*N*/ 		pImp->pLoadEnv->StartListening( *pImp );
/*N*/ }

/*N*/ LoadEnvironment_Impl* SfxFrame::GetLoadEnvironment_Impl() const
/*N*/ {
/*N*/ 	return pImp->pLoadEnv;
/*N*/ }

/*N*/ void SfxFrame::CancelTransfers( sal_Bool bCancelLoadEnv )
/*N*/ {
/*N*/ 	if( !pImp->bInCancelTransfers )
/*N*/ 	{
/*N*/ 		pImp->bInCancelTransfers = sal_True;
/*N*/ 		SfxObjectShell* pObj = GetCurrentDocument();
/*N*/ 		if( pObj ) //&& !( pObj->Get_Impl()->nLoadedFlags & SFX_LOADED_ALL ))
/*N*/ 		{
/*N*/ 			SfxViewFrame* pFrm;
/*N*/ 			for( pFrm = SfxViewFrame::GetFirst( pObj );
/*N*/ 				 pFrm && pFrm->GetFrame() == this;
/*N*/ 				 pFrm = SfxViewFrame::GetNext( *pFrm, pObj ) );
/*N*/ 			// Keine anderer Frame mehr auf Doc -> Cancel
/*N*/ 			if( !pFrm )
/*N*/ 			{
/*N*/ 				pObj->CancelTransfers();
/*N*/                 GetCurrentDocument()->Broadcast( SfxSimpleHint(SFX_HINT_TITLECHANGED) );
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		// zuerst Nachladende Frames stoppen
/*N*/ 		SfxURLFrame* pURLFrame = PTR_CAST( SfxURLFrame, this );
/*N*/ 		if( pURLFrame )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pURLFrame->CancelActivate_Impl();
/*N*/ 		sal_uInt16 nCount = GetChildFrameCount();
/*N*/ 		for( sal_uInt16 n = 0; n<nCount; n++ )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 GetChildFrame( n )->CancelTransfers();
/*N*/ 
/*N*/ 		//  ggf. StarOne-Loader canceln
/*N*/ 		SfxFrameWeak wFrame( this );
/*N*/         if( wFrame.Is() && pImp->pLoadEnv && bCancelLoadEnv )
/*?*/ 			pImp->pLoadEnv->CancelTransfers();
/*N*/ 
/*N*/ 		if (wFrame.Is())
/*N*/ 			pImp->bInCancelTransfers = sal_False;
/*N*/ 	}
/*N*/ }

/*N*/ SfxViewFrame* SfxFrame::GetCurrentViewFrame() const
/*N*/ {
/*N*/ 	return pImp->pCurrentViewFrame;
/*N*/ }


/*N*/ SfxObjectShell* SfxFrame::GetCurrentDocument() const
/*N*/ {
/*N*/ 	return pImp->pCurrentViewFrame ?
/*N*/ 			pImp->pCurrentViewFrame->GetObjectShell() :
/*N*/ 			pImp->pCurrentObjectShell;
/*N*/ }


/*N*/ void SfxFrame::SetCurrentViewFrame_Impl( SfxViewFrame *pFrame )
/*N*/ {
/*N*/ 	pImp->pCurrentViewFrame = pFrame;
/*N*/ }

/*N*/ sal_uInt32 SfxFrame::GetFrameType() const
/*N*/ {
/*N*/ 	return pImp->nType;
/*N*/ }

/*N*/ void SfxFrame::SetFrameType_Impl( sal_uInt32 n )
/*N*/ {
/*N*/ 	pImp->nType = n;
/*N*/ }










/*N*/ void SfxFrame::UpdateHistory( SfxObjectShell *pDocSh, const String* pNew  )
/*N*/ {
/*N*/ }



/*N*/ void SfxFrame::UpdateDescriptor( SfxObjectShell *pDoc )
/*N*/ {
/*N*/ 	// Beim InsertDocument wird der Descriptor des Frames aktualisiert
/*N*/ 	// und sein ItemSet neu initialisiert. Alle Daten, die f"ur ein sp"ateres
/*N*/ 	// Restaurieren der ::com::sun::star::sdbcx::View n"otig sind, sind damit festgehalten.
/*N*/ 	// Soll das Dokument ersetzt werden, wird durch GetViewData_Impl (s.o.)
/*N*/ 	// die neueste Information hinzugef"ugt. Alles zusammen wird dann in der
/*N*/ 	// Browse-History gesichert. Beim Aktivieren eines solchen FramePickEntry
/*N*/ 	// wird das komplette ItemSet und der Descriptor im OpenDoc mitgeschickt.
/*N*/ 	// Hier werden nur die festen Eigenschaften gesichert; die "anderbaren werden
/*N*/ 	// durch GetViewData geholt ( spart Zeit ).
/*N*/ 	DBG_ASSERT( pDoc, "NULL-Document inserted ?!" );
/*N*/ 
/*N*/ 	SfxFrame *pParent = GetParentFrame();
/*N*/ 	const SfxMedium *pMed = pDoc->GetMedium();
/*N*/ 	GetDescriptor()->SetActualURL( pMed->GetOrigURL() );
/*N*/ 
/*N*/ 	SFX_ITEMSET_ARG( pMed->GetItemSet(), pItem, SfxBoolItem, SID_EDITDOC, sal_False );
/*N*/ 	sal_Bool bEditable = ( !pItem || pItem->GetValue() );
/*N*/ 
/*N*/ 	GetDescriptor()->SetEditable( bEditable );
/*N*/ 
/*N*/ 	// FileOpen-Parameter merken
/*N*/ 	SfxItemSet* pItemSet = pMed->GetItemSet();
/*N*/ 	String aName( pMed->GetName() );
/*N*/ 
/*N*/ 	const SfxFilter* pFilter = pMed->GetOrigFilter();
/*N*/ 	String aFilter;
/*N*/ 	if ( pFilter )
/*N*/         aFilter = pFilter->GetFilterName();
/*N*/ 
/*N*/ 	SFX_ITEMSET_ARG( pItemSet, pRefererItem, SfxStringItem, SID_REFERER, sal_False);
/*N*/ 	SFX_ITEMSET_ARG( pItemSet, pOptionsItem, SfxStringItem, SID_FILE_FILTEROPTIONS, sal_False);
/*N*/ 	SFX_ITEMSET_ARG( pItemSet, pTitle1Item, SfxStringItem, SID_DOCINFO_TITLE, sal_False);
/*N*/ 
/*N*/ 	SfxItemSet *pSet = GetDescriptor()->GetArgs();
/*N*/ 
/*N*/ 	// Alle alten Items l"oschen
/*N*/ 	pSet->ClearItem();
/*N*/ 
/*N*/ 	if ( pRefererItem )
/*N*/ 		pSet->Put( *pRefererItem );
/*N*/ 	else
/*N*/ 		pSet->Put( SfxStringItem( SID_REFERER, String() ) );
/*N*/ 
/*N*/ 	if ( pOptionsItem )
/*?*/ 		pSet->Put( *pOptionsItem );
/*N*/ 
/*N*/ 	if ( pTitle1Item )
/*?*/ 		pSet->Put( *pTitle1Item );
/*N*/ 
/*N*/ 	pSet->Put( SfxStringItem( SID_FILTER_NAME, aFilter ));
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ sal_Bool SfxFrame::CanBrowseBackward() const
/*N*/ {
/*N*/     return FALSE;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ sal_Bool SfxFrame::CanBrowseForward() const
/*N*/ {
/*N*/     return FALSE;
/*N*/ }

//-------------------------------------------------------------------------


//-------------------------------------------------------------------------

/*N*/ SfxFrameDescriptor* SfxFrame::GetDescriptor() const
/*N*/ {
/*N*/ 	// On Demand einen FrameDescriptor anlegen; wenn es kein TopLevel-Frame
/*N*/ 	// ist, f"uhrt es zu Fehlern, da keine g"ulige Verkettung hergestellt wird
/*N*/ 
/*N*/ 	if ( !pImp->pDescr )
/*N*/ 	{
/*N*/ 		DBG_ASSERT( !GetParentFrame(), "Kein TopLevel-Frame, aber kein Descriptor!" );
/*N*/ 		pImp->pDescr = new SfxFrameDescriptor( NULL );
/*N*/ 		if ( GetCurrentDocument() )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pImp->pDescr->SetURL( GetCurrentDocument()->GetMedium()->GetOrigURL() );
/*N*/ 	}
/*N*/ 	return pImp->pDescr;
/*N*/ }


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------




//-------------------------------------------------------------------------



//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


/*  [Description]

	Internal Activate-Handler, called from derived classes which supports
	Activate-Handling.
*/


/*N*/ SfxBroadcaster& SfxFrame::GetBroadcaster() const
/*N*/ {
/*N*/ 	return *pImp;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxFrame::Deactivate_Impl()

/*  [Description]

	Internal Deactivate-Handler, called from derived classes which supports
	Activate-Handling.
*/

/*N*/ {
/*N*/     if( GetParentFrame() )
/*?*/         GetParentFrame()->Deactivate_Impl();
/*N*/ }



/*N*/ sal_Bool SfxFrame::IsParent( SfxFrame *pFrame ) const
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	return sal_False;
/*N*/ }

/*N*/ void SfxFrame::InsertTopFrame_Impl( SfxFrame* pFrame )
/*N*/ {
/*N*/ 	SfxFrameArr_Impl& rArr = *SFX_APP()->Get_Impl()->pTopFrames;
/*N*/ 	rArr.Insert( pFrame, rArr.Count() );
/*N*/ }

/*N*/ void SfxFrame::RemoveTopFrame_Impl( SfxFrame* pFrame )
/*N*/ {
/*N*/ 	SfxFrameArr_Impl& rArr = *SFX_APP()->Get_Impl()->pTopFrames;
/*N*/ 	rArr.Remove( rArr.GetPos( pFrame ) );
/*N*/ }


/*N*/ int SfxFrameItem::operator==( const SfxPoolItem &rItem ) const
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return 0; //STRIP001 
/*N*/ }

//--------------------------------------------------------------------


/*N*/ SfxPoolItem* SfxFrameItem::Clone( SfxItemPool *) const
/*N*/ {
/*N*/ 	SfxFrameItem* pNew = new SfxFrameItem( wFrame);
/*N*/ 	pNew->SetFramePtr_Impl( pFrame );
/*N*/ 	return pNew;
/*N*/ }

/*N*/ SfxUsrAnyItem::SfxUsrAnyItem( sal_uInt16 nWhich, const ::com::sun::star::uno::Any& rAny )
/*N*/ 	: SfxPoolItem( nWhich )
/*N*/ {
/*N*/ 	aValue = rAny;
/*N*/ }

/*N*/ int SfxUsrAnyItem::operator==( const SfxPoolItem &rItem ) const
/*N*/ {
/*N*/ //   return rItem.ISA( SfxUsrAnyItem ) && ((SfxUsrAnyItem&)rItem).aValue == aValue;
/*N*/ 	return sal_False;
/*N*/ }


/*N*/ SfxPoolItem* SfxUsrAnyItem::Clone( SfxItemPool *) const
/*N*/ {
/*N*/     return new SfxUsrAnyItem( Which(), aValue );
/*N*/ }












/*N*/ sal_Bool SfxFrame::IsTop() const
/*N*/ {
/*N*/     return GetFrameInterface().is() ? GetFrameInterface()->isTop() : sal_False;
/*N*/ }

/*N*/ sal_Bool SfxFrame::HasComponent() const
/*N*/ {
/*N*/     return sal_False;
/*N*/ }

/*N*/ ::com::sun::star::uno::Reference< ::com::sun::star::frame::XController > SfxFrame::GetController() const
/*N*/ {
/*N*/     if ( pImp->pCurrentViewFrame && pImp->pCurrentViewFrame->GetViewShell() )
/*N*/         return pImp->pCurrentViewFrame->GetViewShell()->GetController();
/*N*/     else
/*N*/         return ::com::sun::star::uno::Reference< ::com::sun::star::frame::XController > ();
/*N*/ }

/*N*/ ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >  SfxFrame::GetFrameInterface() const
/*N*/ {
/*N*/     return pImp->xFrame;
/*N*/ }

/*N*/ void SfxFrame::SetFrameInterface_Impl( ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >& rFrame )
/*N*/ {
/*N*/     pImp->xFrame = rFrame;
/*N*/     ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorder > xRecorder;
/*N*/ 	if ( !rFrame.is() && GetCurrentViewFrame() )
/*N*/ 		GetCurrentViewFrame()->GetBindings().SetRecorder_Impl( xRecorder );
/*N*/ }

/*N*/ void SfxFrame::SetItemSet_Impl( const SfxItemSet* pSet )
/*N*/ {
/*N*/ 	pImp->pSet = pSet;
/*N*/ }

/*N*/ const SfxItemSet* SfxFrame::GetItemSet_Impl()
/*N*/ {
/*N*/ 	return pImp->pSet;
/*N*/ }



/*N*/ void SfxFrame::SetOwnsBindings_Impl( sal_Bool bSet )
/*N*/ {
/*N*/ 	pImp->bOwnsBindings = bSet;
/*N*/ }

/*N*/ sal_Bool SfxFrame::OwnsBindings_Impl() const
/*N*/ {
/*N*/ 	return pImp->bOwnsBindings;
/*N*/ }

/*N*/ void SfxFrame::SetToolSpaceBorderPixel_Impl( const SvBorder& rBorder )
/*N*/ {
/*N*/     pImp->aBorder = rBorder;
/*N*/     SfxViewFrame *pF = GetCurrentViewFrame();
/*N*/     if ( pF )
/*N*/     {
/*N*/         Point aPos ( rBorder.Left(), rBorder.Top() );
/*N*/         Size aSize( GetWindow().GetOutputSizePixel() );
/*N*/         long nDeltaX = rBorder.Left() + rBorder.Right();
/*N*/         if ( aSize.Width() > nDeltaX )
/*N*/             aSize.Width() -= nDeltaX;
/*N*/         else
/*N*/             aSize.Width() = 0;
/*N*/ 
/*N*/         long nDeltaY = rBorder.Top() + rBorder.Bottom();
/*N*/         if ( aSize.Height() > nDeltaY )
/*N*/             aSize.Height() -= nDeltaY;
/*N*/         else
/*N*/             aSize.Height() = 0;
/*N*/ 
/*N*/         if ( GetParentFrame() )
/*N*/         {
/*?*/             sal_Bool bHasTools = rBorder.Left() != rBorder.Right() || rBorder.Top() != rBorder.Bottom();
/*?*/             pF->GetWindow().SetBorderStyle( bHasTools ? WINDOW_BORDER_NORMAL : WINDOW_BORDER_NOBORDER );
/*N*/         }
/*N*/ 
/*N*/         pF->GetWindow().SetPosSizePixel( aPos, aSize );
/*N*/     }
/*N*/ }

/*N*/ Rectangle SfxFrame::GetTopOuterRectPixel_Impl() const
/*N*/ {
/*N*/ 	Size aSize( GetWindow().GetOutputSizePixel() );
/*N*/ 	Point aPoint;
/*N*/ 	return ( Rectangle ( aPoint, aSize ) );
/*N*/ }

/*N*/ SfxWorkWindow* SfxFrame::GetWorkWindow_Impl() const
/*N*/ {
/*N*/ 	if ( pImp->pWorkWin )
/*N*/ 		return pImp->pWorkWin;
/*N*/ 	else if ( pParentFrame )
/*?*/ 		return pParentFrame->GetWorkWindow_Impl();
/*N*/     else
/*N*/         return NULL;
/*N*/ }


/*N*/ void SfxFrame::CreateWorkWindow_Impl()
/*N*/ {
/*N*/ 	pImp->pWorkWin = new SfxFrameWorkWin_Impl( &GetWindow(), this );
/*N*/ }


/*N*/ void SfxFrame::GrabFocusOnComponent_Impl()
/*N*/ {
/*N*/ 	if ( pImp->bReleasingComponent )
/*N*/ 	{
/*?*/ 		GetWindow().GrabFocus();
/*?*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/     Window* pWindow = &GetWindow();
/*N*/     if ( GetCurrentViewFrame() && GetCurrentViewFrame()->GetViewShell() && GetCurrentViewFrame()->GetViewShell()->GetWindow() )
/*N*/         pWindow = GetCurrentViewFrame()->GetViewShell()->GetWindow();
/*N*/ 
/*N*/     if( !pWindow->HasChildPathFocus() )
/*N*/         pWindow->GrabFocus();
/*N*/ }



/*N*/ void SfxFrame::ReleasingComponent_Impl( sal_Bool bSet )
/*N*/ {
/*N*/ 	pImp->bReleasingComponent = bSet;
/*N*/ }




/*N*/ void SfxFrame::Resize()
/*N*/ {
/*N*/     if ( IsClosing_Impl() )
/*N*/         return;
/*N*/ 
/*N*/     if ( OwnsBindings_Impl() )
/*N*/ 	{
/*N*/         SfxWorkWindow *pWork = GetWorkWindow_Impl();
/*N*/         if ( pWork )
/*N*/         {
/*N*/             pWork->ArrangeChilds_Impl();
/*N*/             pWork->ShowChilds_Impl();
/*N*/         }
/*N*/ 
/*N*/         // problem in presence of UIActive object: when the window is resized, but the toolspace border
/*N*/         // remains the same, setting the toolspace border at the ContainerEnvironment doesn't force a
/*N*/         // resize on the IPEnvironment; without that no resize is called for the SfxViewFrame. So always
/*N*/         // set the window size of the SfxViewFrame explicit.
/*N*/         SetToolSpaceBorderPixel_Impl( pImp->aBorder );
/*N*/ 	}
/*N*/     else if ( pImp->pCurrentViewFrame )
/*N*/     {
/*?*/         pImp->pCurrentViewFrame->GetWindow().SetSizePixel( GetWindow().GetOutputSizePixel() );
/*N*/     }
/*N*/ 
/*N*/ }

/*N*/ SfxFrame* SfxFrame::GetFirst()
/*N*/ {
/*N*/     if ( !pFramesArr_Impl )
/*N*/         return 0;
/*N*/     return pFramesArr_Impl->Count() ? pFramesArr_Impl->GetObject(0) : 0;
/*N*/ }

/*N*/ SfxFrame* SfxFrame::GetNext( SfxFrame& rFrame )
/*N*/ {
/*N*/     USHORT nPos = pFramesArr_Impl->GetPos( &rFrame );
/*N*/     if ( nPos+1 < pFramesArr_Impl->Count() )
/*?*/         return pFramesArr_Impl->GetObject(nPos+1);
/*N*/     else
/*N*/         return NULL;
/*N*/ }



}
