/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_tbxmgr.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:46:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#include <svtools/miscopt.hxx>

#ifndef __FRAMEWORK_CLASSES_ADDONSOPTIONS_HXX_
#include <framework/addonsoptions.hxx>
#endif


#ifndef __FRAMEWORK_CLASSES_ADDONMENU_HXX_
#include <framework/addonmenu.hxx>
#endif


#pragma hdrstop


#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxmgr.hxx"
#include "dispatch.hxx"
#include "tbxctrl.hxx"
#include "sfxtypes.hxx"
#include "toolbox.hrc"
#include "sfxresid.hxx"
#include "msgpool.hxx"

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#include "statcach.hxx"
#include "ipfrm.hxx"
#include "ipenv.hxx"
#include "tbxchild.hxx"
#include "tbxconf.hxx"
#include "sfxsids.hrc"
namespace binfilter {

static const USHORT nVersion = 13;

// ID's for AddOns toolbox buttons
static const USHORT nAddOnsStartID	= 2000;
static const USHORT nAddOnsEndID	= 2500;

static const char   TOOLBOXITEM_SEPARATOR_STR[] = "private:separator";
static const USHORT TOOLBOXITEM_SEPARATOR_STR_LEN = sizeof( TOOLBOXITEM_SEPARATOR_STR )-1;

using namespace ::framework;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;

//====================================================================

/*?*/ DECL_PTRARRAY(SfxToolBoxControlArr_Impl, SfxToolBoxControl*, 8, 8 )//STRIP008 ;

//---------------------------------------------------------------------------
// Da SV den Customize-Handler nur an der Source-ToolBox aufruft, SFX aber
// auch der TargetBox etwas ausf"uhren mu\s (z.B. Controllererzeugung), stellt
// diese Klasse den public-Zugriff auf die protected-Methode Customize her.

/*?*/ class TbAccess_Impl : public SfxToolbox
/*?*/ {
/*?*/ public :
/*?*/ 
/*?*/ 	TbAccess_Impl ( SfxToolBoxManager &rMgr, Window *pParent, WinBits nBits )
/*?*/ 	  : SfxToolbox(rMgr,pParent,nBits)
/*?*/ 	{}
/*?*/ 
/*?*/ 	inline void CustomizeToolBox (const ToolBoxCustomizeEvent& rCEvt)
/*?*/ 		{ Customize(rCEvt); }
/*?*/ };

// static array to define all runtime item ID's which should not be stored
// nor be configurable
/*?*/ USHORT SfxToolBoxManager::nRuntimeIDs[SFXTOOLBOX_RUNTIMEITEM_COUNT] =
/*?*/ {
/*?*/ 	SID_ADDONS
/*?*/ };

// Structure to hold additional information about a runtime toolbox item
struct TbRuntimeItemData
{
	::rtl::OUString	aImageId;
	::rtl::OUString	aTarget;
};

//====================================================================
/*?*/ SfxToolBoxManager::SfxToolBoxManager( SfxConfigManager* pMgr, USHORT nId )
/*?*/ 	: SfxConfigItem( nId, pMgr ),
/*?*/ 	pParent(0),
/*?*/ 	pBox(0),
/*?*/ 	pControls(0),
/*?*/ 	eSymbolsSize(SFX_SYMBOLS_SIZE_SMALL),
/*?*/ 	nIteratorPos(0),
/*?*/ 	pResMgr(0),
/*?*/ 	pBindings(0),
/*?*/ 	pFrame(0),
/*?*/     pIFace(0),
/*?*/     bInternal(FALSE),
/*?*/ 	bHiContrast(FALSE),
/*?*/ 	bConfigMode(FALSE)
/*?*/ {
/*?*/ }

// ctor for non-objectbars
// they are NOT configurable and so they are not inserted into the configmanager

/*?*/ SfxToolBoxManager::SfxToolBoxManager( Window* _pParent,
/*?*/ 									  SfxBindings &rBindings,
/*?*/ 									  const ResId& rResId  ) :
/*?*/     SfxConfigItem(rResId.GetId(), /*rBindings.GetConfigManager( rResId.GetId() ) */ NULL ),
/*?*/ 	pParent(_pParent),
/*?*/ 	pBox(0),
/*?*/ 	pControls(0),
/*?*/ 	eSymbolsSize(SFX_SYMBOLS_SIZE_SMALL),
/*?*/ 	nIteratorPos(0),
/*?*/ 	pResMgr(rResId.GetResMgr()),
/*?*/ 	pBindings(&rBindings),
/*?*/ 	pFrame(0),
/*?*/     pIFace(0),
/*?*/     bInternal(TRUE),
/*?*/ 	bHiContrast(FALSE),
/*?*/ 	bConfigMode(FALSE)
/*?*/ {
/*?*/ 	DBG_MEMTEST();
/*?*/ 
/*?*/ 	// Dieser ctor ist f"ur nicht konfigurierbare Toolboxen; alle Daten
/*?*/ 	// werden aus der Resource geladen und k"onnen nicht ver"andert werden
/*?*/ }

//--------------------------------------------------------------------

/*N*/ SfxToolBoxManager::SfxToolBoxManager( Window* _pParent,
/*N*/ 									  SfxBindings &rBindings,
/*N*/ 									  const ResId& rResId,
/*N*/ 									  SfxInterface *pInterFace,
/*N*/ 									  USHORT nPos, SfxShell* pTask )
/*
	Beschreibung
	ctor f"ur Objectbars; diese merken sich das Modul, aus dem sie erzeugt
	wurden.
*/

/*N*/     : SfxConfigItem(rResId.GetId(), rBindings.GetConfigManager( rResId.GetId() ) ),
/*N*/ 	pParent(_pParent),
/*N*/ 	pBox(0),
/*N*/ 	pControls(0),
/*N*/ 	eSymbolsSize(SFX_SYMBOLS_SIZE_SMALL),
/*N*/ 	nIteratorPos(0),
/*N*/ 	pResMgr(rResId.GetResMgr()),
/*N*/ 	pBindings(&rBindings),
/*N*/ 	pFrame(0),
/*N*/     pIFace(pInterFace),
/*N*/     bInternal(FALSE),
/*N*/ 	bHiContrast(FALSE),
/*N*/ 	bConfigMode(FALSE)
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ }

//--------------------------------------------------------------------


//-------------------------------------------------------------------------

/*?*/ SfxToolBoxManager::SfxToolBoxManager( const ResId& rResId,
/*?*/ 		SfxInterface *pInterFace,
/*?*/ 		const String& rName, SfxToolBoxManager *pTbx, SfxShell *pTask)
/*?*/     : SfxConfigItem(rResId.GetId(), pTbx->pBindings->GetConfigManager( rResId.GetId() ) ),
/*?*/ 	pParent(pTbx->pParent),
/*?*/ 	pBox(pTbx->pBox),
/*?*/ 	pControls(pTbx->pControls),
/*?*/ 	eSymbolsSize(pTbx->eSymbolsSize),
/*?*/ 	nIteratorPos(0),
/*?*/ 	pResMgr(rResId.GetResMgr()),
/*?*/ 	pBindings(pTbx->pBindings),
/*?*/ 	pFrame(0),
/*?*/     pIFace(pInterFace),
/*?*/     bInternal(FALSE),
/*?*/ 	bHiContrast(FALSE),
/*?*/ 	bConfigMode(FALSE)

/*
	Beschreibung
	copy-ctor f"ur Objectbars; diese merken sich das Modul, aus dem sie erzeugt
	wurden.
*/

/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//--------------------------------------------------------------------

/*N*/ SfxToolBoxManager::~SfxToolBoxManager()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	// unregister bindings
/*N*/ 	Clear();
/*N*/ 	if (pBox)
/*N*/ 	{
/*N*/ 		Hide();
/*N*/ 
/*N*/         SfxImageManager* pImgMgr = pBindings->GetImageManager();
/*N*/         if ( pImgMgr )
/*N*/             pImgMgr->ReleaseToolBox(pBox);
/*N*/ 
/*N*/ 		// Remove runtime information
/*N*/ 		USHORT nCount = pBox->GetItemCount();
/*N*/ 		for ( USHORT nPos=0; nPos < nCount; nPos++ )
/*N*/ 		{
/*N*/ 			USHORT nId = pBox->GetItemId( nPos );
/*N*/ 			if (( pBox->GetItemType(nPos) == TOOLBOXITEM_BUTTON ) && IsRuntimeItem( nId ))
/*N*/ 			{
/*?*/ 				TbRuntimeItemData* pRuntimeItemData = (TbRuntimeItemData*)pBox->GetItemData( nId );
/*?*/ 				if ( pRuntimeItemData )
/*?*/ 					delete pRuntimeItemData;
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		delete pBox;
/*N*/ 		pBox = 0;
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::Construct()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	// set the handlers
/*N*/ 	pBox->SetSelectHdl( LINK(this, SfxToolBoxManager, Select) );
/*N*/ 	pBox->SetActivateHdl( LINK(this, SfxToolBoxManager, Activate) );
/*N*/ 	pBox->SetDeactivateHdl( LINK(this, SfxToolBoxManager, Deactivate) );
/*N*/ 
/*N*/ 	// Nach dem Umkonfigurieren m"ussen die Hilfetexte neu geholt werden
/*N*/ 	((SfxToolbox*)pBox)->bHelpInitialized = FALSE;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::CreateFromSVToolBox()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	if (pBox->GetItemCount() == 0)
/*N*/ 	{
/*?*/ 										// SV austricksen, damit die Groesse
/*?*/ 										// stimmt
/*?*/ 		((SfxToolbox*)pBox)->SetEmpty(TRUE);
/*?*/ 		USHORT nId = SID_NEWDOC;
/*?*/ 		pBox->InsertItem( nId, String());
/*?*/         pBox->SetItemImage(nId, pBindings->GetImageManager()->GetImage(nId, pIFace ? pIFace->GetModule() : 0));
/*?*/ 		pBox->HideItem(nId);
/*N*/ 	}
/*N*/ 
/*N*/ 	// reflect the StarView toolbox in a bindings table
/*N*/ 	if (!pControls)
/*N*/ 		pControls = new SfxToolBoxControlArr_Impl;
/*N*/ 	SfxSlotPool& rSlotPool = pIFace && pIFace->GetModule() ? *pIFace->GetModule()->GetSlotPool() : SFX_APP()->GetSlotPool();
/*N*/ 	((SfxToolbox*)pBox)->ClearItemText_Impl();
/*N*/ 	pBindings->ENTERREGISTRATIONS();
/*N*/ 	for ( USHORT nPos = 0; nPos < pBox->GetItemCount(); ++nPos )
/*N*/ 	{
/*N*/ 		if ( pBox->GetItemType(nPos) == TOOLBOXITEM_BUTTON )
/*N*/ 		{
/*N*/ 			// register binding
/*N*/ 			USHORT nId = pBox->GetItemId(nPos);
/*N*/ 
/*N*/ #ifdef DBG_UTIL
/*N*/ 			const SfxSlot *pSlot = rSlotPool.GetSlot( nId );
/*N*/ 			if ( pSlot && !pSlot->IsMode( SFX_SLOT_TOOLBOXCONFIG ) )
/*N*/ 			{
/*?*/ 				ByteString aStr( "Slot " );
/*?*/ 				aStr += ByteString::CreateFromInt32( nId );
/*?*/ 				aStr += ByteString( " : ToolboxConfig fehlt!" );
/*?*/ 				DBG_ERROR( aStr.GetBuffer() );
/*N*/ 			}
/*N*/ #endif
/*N*/             if ( !pBox->GetHelpId( nId ) )
/*N*/                 pBox->SetHelpId( nId, (ULONG) nId );
/*N*/ 			if ( !pBox->GetItemText(nId).Len() )
/*N*/ 				pBox->SetItemText( nId, rSlotPool.GetSlotName_Impl( nId ) );
/*N*/ 			else
/*N*/ 				((SfxToolbox*)pBox)->SetItemText_Impl( nId, TRUE );
/*N*/ 
/*N*/ 			SfxToolBoxControl *pControl;
/*N*/ 			if ( pBox->GetItemCommand( nId ).CompareToAscii(".uno:", 5 ) == COMPARE_EQUAL )
/*N*/ 				pBox->SetItemCommand( nId, String() );	// Remove .uno commands to be compatible with 6.0/src641
/*N*/ 
/*N*/             if ( pBox->GetItemCommand( nId ).Len() )
/*?*/             {DBG_BF_ASSERT(0, "STRIP"); }//STRIP001     pControl = SfxToolBoxControl::CreateControl( pBox->GetItemCommand( nId ), nId, pBox, *pBindings );
/*N*/ 			else
/*N*/                 pControl = SfxToolBoxControl::CreateControl( nId, pBox, *pBindings, pIFace ? pIFace->GetModule() : 0 );
/*N*/ 
/*N*/ 			pControls->Append( pControl );
/*N*/ 			Window *pItemWin = pControl->CreateItemWindow(pBox);
/*N*/ 			if ( pItemWin )
/*N*/             {
/*N*/                 WindowType nType = pItemWin->GetType();
/*N*/                 if ( nType == WINDOW_LISTBOX || nType == WINDOW_MULTILISTBOX || nType == WINDOW_COMBOBOX )
/*N*/                     pItemWin->SetAccessibleName( pBox->GetItemText( nId ) );
/*N*/ 				pBox->SetItemWindow( nId, pItemWin );
/*N*/             }
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( !bConfigMode )
/*N*/ 		CreateRuntimeItems();
/*N*/ 
/*N*/ 	pBindings->LEAVEREGISTRATIONS();
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::CreateRuntimeItems()
/*N*/ {
/*N*/ 	if ( GetType() == 560 )
/*N*/ 	{
/*N*/ 		if ( framework::AddonsOptions().HasAddonsMenu() &&
/*N*/ 			 pBox->GetItemPos( SID_ADDONS) == TOOLBOX_ITEM_NOTFOUND )
/*?*/ 		{
/*?*/ 		    Reference< ::com::sun::star::frame::XFrame > xFrame;
/*?*/ 		    SfxDispatcher* pDisp = pBindings->GetDispatcher_Impl();
/*?*/ 		    if ( pDisp )
/*?*/ 			    xFrame = pDisp->GetFrame()->GetFrame()->GetFrameInterface();
/*?*/ 
/*?*/             PopupMenu* pMenu = framework::AddonMenuManager::CreateAddonMenu( xFrame );
/*?*/             
/*?*/             // Check if there is at least one menu item for our addon menu. Due to context info
/*?*/             // given in the configuration we can have an empty menu and then we shouldn't display
/*?*/             // the addon menu button at all!
/*?*/             if ( pMenu && pMenu->GetItemCount() > 0 )
/*?*/             {
/*?*/ 			    // Special handling for functionbar. Create a addons button for accessing the addons popup menu
/*?*/ 			    SfxToolBoxControl *pControl;
/*?*/ 			    String aAddonTbxString( SfxResId( STR_ADDONSBUTTONTEXT ));
/*?*/ 
/*?*/ 			    // We need a separator before the Add-On button if there is none
/*?*/ 			    USHORT nCount = pBox->GetItemCount();
/*?*/ 			    if ( nCount > 0 && pBox->GetItemType( nCount-1 ) != TOOLBOXITEM_SEPARATOR )
/*?*/ 				    pBox->InsertSeparator();
/*?*/ 
/*?*/ 			    pBox->InsertItem( SID_ADDONS, aAddonTbxString );
/*?*/ 			    pBox->SetItemImage( SID_ADDONS, pBindings->GetImageManager()->GetImage( SID_ADDONS, pBox->GetBackground().GetColor().IsDark(), pIFace ? pIFace->GetModule() : 0 ));
/*?*/ 			    pBox->SetHelpId( SID_ADDONS, SID_ADDONS );
/*?*/ 			    pControl = SfxToolBoxControl::CreateControl( SID_ADDONS, pBox, *pBindings, pIFace ? pIFace->GetModule() : 0 );
/*?*/ 			    pControls->Append( pControl );
/*?*/ 			}
/*?*/ 			delete pMenu;
/*?*/ 		}
/*N*/ 
/*N*/ 		// Append Add-Ons toolbox items
/*N*/ 		AppendAddOnsItems();
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------



//--------------------------------------------------------------------

void SfxToolBoxManager::AppendAddOnsItems()
{
}

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::UseDefault()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/     SfxImageManager *pImgMgr = pBindings->GetImageManager();
/*N*/ 	if ( pBox && pBox->GetItemCount() )
/*N*/ 	{
/*N*/ 		// reconfigure toolbox
/*N*/ 		// remove controllers, item windows, items and item texts
/*?*/ 		Clear();
/*?*/ 		pBox->Clear();
/*?*/ 		((SfxToolbox*)pBox)->ClearItemText_Impl();
/*N*/ 	}
/*N*/ 
/*N*/ 	// ResId f"ur die ToolBox zusammenbasteln
/*N*/ 	// Wenn es keine passende Resource gibt, wird eine leere Toolbox erzeugt
/*N*/ 	// Dies ist der Fall bei UserDefined Toolboxen.
/*N*/ 	ResId aResId(GetType());
/*N*/ 	aResId.SetRT(RSC_TOOLBOX);
/*N*/ 	aResId.SetResMgr(pResMgr);
/*N*/ 
/*N*/ 	if ( Resource::GetResManager()->IsAvailable(aResId) )
/*N*/ 	{
/*N*/ 		BOOL bOwnImageList = FALSE;
/*N*/ 		if ( pBox )
/*N*/ 		{
/*N*/             pBindings->GetImageManager()->ReleaseToolBox( pBox );
/*N*/ 
/*N*/ 			// Konfigurierbare Toolboxen sind SFX-Objectbars; sie laden nur
/*N*/ 			// ihren Inhalt aus der Resource, der Rest kommt aus der
/*N*/ 			// SfxToolboxConfig
/*N*/ 			ToolBox *pTb = new ToolBox ( pParent, aResId );
/*N*/ 			if ( pTb->GetImageList().GetImageCount() )
/*N*/ 				bOwnImageList = TRUE;
/*N*/ 
/*N*/ 			pBox->EnableCustomize( !bOwnImageList );
/*N*/ 
/*N*/ 			pBox->CopyItems( *pTb );
/*N*/ 			pBox->SetHelpId( pTb->GetHelpId() );
/*N*/ 			pBox->SetHelpText( String() );
/*N*/ 			delete pTb;
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*?*/ 			// Nicht konfigurierbare Toolboxen werden komplett aus der
/*?*/ 			// Resource geladen
/*?*/ 			pBox = new SfxToolbox( *this, pParent, aResId );
/*?*/ 			pBox->SetUniqueId( aResId.GetId() );
/*?*/ 			if ( pBox->GetImageList().GetImageCount() )
/*?*/ 				bOwnImageList = TRUE;
/*?*/ 
/*?*/ 			pBox->EnableCustomize( FALSE );
/*?*/ 			pBox->SetButtonType( BUTTON_SYMBOL );
/*?*/             pBox->SetOutStyle( SvtMiscOptions().GetToolboxStyle() );
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( !bOwnImageList )
/*N*/ 		{
/*N*/ 			// Retrieve images and check for high contrast mode
/*N*/ 			pImgMgr->SetImages( *pBox, pIFace ? pIFace->GetModule() : 0, pBox->GetBackground().GetColor().IsDark() );
/*N*/             pImgMgr->RegisterToolBoxManager( this, 0xFFFF );
/*N*/ 		}
/*N*/ 		else
/*N*/             pImgMgr->RegisterToolBox( pBox, SFX_TOOLBOX_CHANGEOUTSTYLE );
/*N*/ 	}
/*N*/ 	else if ( !pBox )
/*N*/ 		DBG_ERROR( "Toolbox-Resource fehlt!" );
/*N*/ 
/*N*/ 	// Handler setzen
/*N*/ 	Construct();
/*N*/ 
/*N*/ 	// Controller und ItemWindows erzeugen
/*N*/ 	CreateFromSVToolBox();
/*N*/ 
/*N*/ 	// Gr"o\se berechnen
/*N*/ 	Align();
/*N*/ 	((SfxToolbox*)pBox)->SetConstructed(TRUE);
/*N*/ 
/*N*/ 	// StatusUpdate anwerfen
/*N*/ 	Activate(0);
/*N*/ 
/*N*/     SetDefault( TRUE );
/*N*/ }

//--------------------------------------------------------------------
/*?*/ int SfxToolBoxManager::Load( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return 0; //STRIP001 
/*?*/ }

//--------------------------------------------------------------------

/*?*/ BOOL SfxToolBoxManager::Store( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

//--------------------------------------------------------------------

/*?*/ BOOL SfxToolBoxManager::Import( SvStream& rInStream, SvStream& rOutStream )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

/*?*/ BOOL SfxToolBoxManager::Export( SvStream& rInStream, SvStream& rOutStream )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE; //STRIP001 
/*?*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::Align()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	if ( pBox->IsFloatingMode() )
/*N*/ 		return;
/*N*/ 
/*N*/ 	Size aOldSize = pBox->GetSizePixel();
/*N*/ 	Size aSize = pBox->CalcWindowSizePixel();
/*N*/     if ( !aSize.Width() )
/*N*/         aSize.Width() = aOldSize.Width();
/*N*/     else if ( !aSize.Height() )
/*N*/         aSize.Height() = aOldSize.Height();
/*N*/ 
/*N*/ 	if (aSize.Width() && aSize.Width() != pBox->GetSizePixel().Width() ||
/*N*/             aSize.Height() && aSize.Height() != pBox->GetSizePixel().Height())
/*N*/ 		pBox->SetPosSizePixel( pBox->GetPosPixel(), aSize );
/*N*/ }

//--------------------------------------------------------------------

/*?*/ void SfxToolBoxManager::RefreshImages_Impl()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::Clear()
/*N*/ {
/*N*/ 	if (pControls)
/*N*/ 	{
/*N*/ 		pBindings->ENTERREGISTRATIONS();
/*N*/ 		for ( USHORT n = 0; n < pControls->Count(); ++n )
/*N*/ 		{
/*N*/ 			SfxToolBoxControl *pControl = pControls->GetObject(n);
/*N*/ 			USHORT nId = pControl->GetId();
/*N*/ 			Window *pItemWin = pBox->GetItemWindow(nId);
/*N*/ 			if ( pItemWin )
/*N*/ 			{
/*N*/ 				pItemWin->Hide();
/*N*/ 				delete pItemWin;
/*N*/ 				pBox->SetItemWindow( nId, 0 );
/*N*/ 			}
/*N*/ 			delete pControl;
/*N*/ 		}
/*N*/ 		pControls->Clear();
/*N*/ 		DELETEZ(pControls);
/*N*/ 		pBindings->LEAVEREGISTRATIONS();
/*N*/ 	}
/*N*/ }


//--------------------------------------------------------------------

/*N*/ SfxToolBoxControl* SfxToolBoxManager::FindControl_Impl( USHORT nId ) const
/*N*/ {
/*N*/ 	for ( USHORT nPos = 0; nPos < pControls->Count(); ++nPos )
/*N*/ 		if ( pControls->GetObject(nPos)->GetId() == nId )
/*N*/ 			return pControls->GetObject(nPos);
/*N*/ 	return 0;
/*N*/ }

//--------------------------------------------------------------------

// updates all state-information

/*N*/ IMPL_LINK( SfxToolBoxManager, Activate, ToolBox *, pSVBox )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	SfxToolbox *pTbx = (SfxToolbox*) pBox;
/*N*/ 	SfxBindings *pBindinx = pBindings;
/*N*/ 
/*N*/ 	// Es kann passieren, da\s diese Toolbox im Verlauf des jetzt erzwungenen
/*N*/ 	// Updates ausgetauscht werden m"u\ste. Daher merken wir uns, da\s wir auf
/*N*/ 	// keinen Fall ausgetauscht oder gel"oscht werden wollen.
/*N*/ 	if ( pSVBox )
/*N*/ 		pTbx->bActivated = TRUE;
/*N*/ 
/*N*/ 	if ( !pBindinx->GetDispatcher_Impl()->IsLocked() && !pTbx->bReconfigure)
/*N*/ 	{
/*N*/ 		pBindinx->GetDispatcher_Impl()->Flush();
/*N*/ 		if (!pTbx->bDeleteToolBox)			// noch nicht versucht zu deleten
/*N*/ 		{
/*N*/ 			// update all states-information of each item in this menu
/*N*/ 			for ( short nPos = pTbx->GetItemCount(); nPos >= 0; --nPos )
/*N*/ 			{	USHORT nId = pTbx->GetItemId(nPos);
/*N*/ 				if ( nId != 0 )
/*N*/ 					pBindinx->Update( nId );
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		SfxStateCache *pCache = pBindinx->GetStateCache( SID_IMAGE_ORIENTATION );
/*N*/ 		if ( pCache )
/*N*/ 			pCache->SetCachedState();
/*N*/ 	}
/*N*/ 
/*N*/ 	return 0;
/*N*/ }

//--------------------------------------------------------------------

// removes the context

/*N*/ IMPL_LINK( SfxToolBoxManager, Deactivate, ToolBox *, pToolBox )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	((SfxToolbox*)pBox)->bActivated = FALSE;
/*N*/ 	return 0;
/*N*/ }


//--------------------------------------------------------------------

// executes the selected function

/*N*/ IMPL_LINK( SfxToolBoxManager, Select, ToolBox *, pBox )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	// Wenn die ToolBox zum Deleten vorgemerkt ist, soll nichts mehr
/*N*/ 	// selektiert werden koennen.
/*N*/ 	if ( ((SfxToolbox*)pBox)->bDeleteToolBox )
/*N*/ 		return 0;
/*N*/ 
/*N*/ 	SfxToolBoxControl *pControl = FindControl_Impl( pBox->GetCurItemId() );
/*N*/ 	if ( pControl )
/*N*/ 	{
/*N*/ 		SfxToolbox *pTbx = (SfxToolbox*) pBox;
/*N*/ 		// Auch beim Select darf nicht zwischendurch die ToolBox oder das
/*N*/ 		// selektierte Item verschwinden; da Select erst nach Deactivate kommt,
/*N*/ 		// mu\s die ToolBox noch einmal "geblockt" werden.
/*N*/ 		pTbx->bActivated = 2;
/*N*/ 		pControl->Select( pBox->GetModifier() );
/*N*/ 		pTbx->bActivated = FALSE;
/*N*/ 	}
/*N*/ 	return 0;
/*N*/ }


//--------------------------------------------------------------------

// resets the item iterator, FALSE if none

/*?*/ BOOL SfxToolBoxManager::FirstItem()
/*?*/ {
/*?*/ 	nIteratorPos = 0;
/*?*/ 	return nIteratorPos < pBox->GetItemCount();
/*?*/ }


//--------------------------------------------------------------------

// skips to the next item, FALSE if no more

/*?*/ BOOL SfxToolBoxManager::NextItem()
/*?*/ {
/*?*/ 	++nIteratorPos;
/*?*/ 	return nIteratorPos < pBox->GetItemCount();
/*?*/ }


//--------------------------------------------------------------------

// TRUE if current item is a binding



//--------------------------------------------------------------------

// TRUE if current item is a separator



//--------------------------------------------------------------------

// id of current binding if IsBinding()


//--------------------------------------------------------------------

/*?*/ void SfxToolBoxManager::InsertItem( USHORT nId, Image& aImage, USHORT nTargetPos, USHORT nHelpId, String aItemText )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void SfxToolBoxManager::RemoveItem( USHORT nId, USHORT nSourcePos )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//--------------------------------------------------------------------

/*N*/ BOOL SfxToolBoxManager::IsRuntimeItem( USHORT nId )
/*N*/ {
/*N*/ 	// Return true for ID's which are created during runtime and shouldn't be stored nor
/*N*/ 	// accessible through the configuration dialogs!
/*N*/ 	if (( nId >= nAddOnsStartID ) && ( nAddOnsEndID > nId ))
/*N*/ 		return TRUE;
/*N*/ 	else
/*N*/ 	{
/*N*/ 		for ( USHORT n = 0; n < SFXTOOLBOX_RUNTIMEITEM_COUNT; n++ )
/*N*/ 			if ( nId == nRuntimeIDs[n] )
/*N*/ 				return TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	return FALSE;
/*N*/ }

//--------------------------------------------------------------------

/*?*/ void SfxToolBoxManager::Customize( const ToolBoxCustomizeEvent& rCEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::UpdateControls_Impl()

/*	Interne Methode zum erneuten Updaten aller SfxToolBoxContoller in
	diesem SfxToolBoxManager. Z.B. nach Umschaltung der Button-Art.
*/

/*N*/ {
/*N*/ 	for ( USHORT n = 0; n < pControls->Count(); ++n )
/*N*/ 	{
/*N*/ 		SfxToolBoxControl *pControl = pControls->GetObject(n);
/*N*/ 		if ( pControl->IsBound() )
/*N*/ 			pBindings->GetStateCache( pControl->GetId() )->SetCachedState();
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

/*?*/ void SfxToolBoxManager::Show()
/*?*/ {
//	  if (pBox->IsFloatingMode() == FALSE)
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	pBox->Show();
/*?*/ }


//--------------------------------------------------------------------

/*N*/ void SfxToolBoxManager::Hide()
/*N*/ {
/*N*/ //	  if (pBox->IsFloatingMode() == FALSE)
/*N*/ 		pBox->Hide();
/*N*/ }


// ------------------------------------------------------------------------

/*?*/ String SfxToolBoxManager::GetStreamName() const
/*?*/ {
/*
	if (pBox)
		return pBox->GetText();

	ResId aResId(GetType());
	aResId.SetRT(RSC_STRING);
	aResId.SetResMgr(pResMgr);
	if (Resource::GetResManager()->IsAvailable(aResId))
		return String(aResId);
	else
		return String();
*/
/*?*/     return SfxConfigItem::GetStreamName( GetType() );
/*?*/ }

/*?*/ BOOL SfxToolBoxManager::ReInitialize()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

/*N*/ void SfxToolBoxManager::Reconfigure_Impl( SfxToolBoxConfig* pTbxCfg )
/*N*/ {
/*N*/ }

//---------------------------------------------------------------------------
// ObjectBars werden niemals direkt "uber den dtor, sondern nur "uber diese
// Methode gel"oscht. Falls diese Toolbox gerade aktiv ist, stehen wir mitten
// im SV und m"u\sen daher asynchron l"oschen.


/*?*/ void SfxToolBoxManager::Delete()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------
// Diese statische Methode erkennt an der "ubergebenen Id, ob es sich um eine
// benutzerdefinierte Toolbox handelt.


/*?*/ BOOL SfxToolBoxManager::IsUserDefToolBox_Impl(USHORT nId)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

//-------------------------------------------------------------------------
// Mit dieser statischen Methode kann eine f"ur die Lebensdauer der Toolbox
// g"ultige, eindeutige Id f"ur eine benutzerdefinierte ToolBox angefordert
// werden.


/*?*/ USHORT SfxToolBoxManager::GetUserDefToolBoxId_Impl()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }



/*N*/ USHORT SfxToolBoxManager::GetNextToolBox_Impl( String *pStr )
/*N*/ {
/*N*/ 	SfxDispatcher* pDisp = GetBindings().GetDispatcher_Impl();
/*N*/ 	if ( pDisp )
/*N*/ 		return pDisp->GetNextToolBox_Impl( ((SfxToolbox*)pBox)->nPos, GetType(), pStr );
/*N*/ 	else
/*N*/ 		return 0;
/*N*/ }

/*?*/ void SfxToolBoxManager::SetItemText( USHORT nId, const String& rText )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ BOOL SfxToolBoxManager::IsInternal()
/*?*/ {
/*?*/     return bInternal;
/*?*/ }

/*?*/ void SfxToolBoxManager::CreateConfiguration( SfxConfigManager* pMgr, USHORT nId )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void SfxToolBoxManager::RemoveConfiguration( SfxConfigManager* pMgr, USHORT nId )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }
}
