/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_tbxchild.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:45:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers


#include <svtools/imageitm.hxx>


#pragma hdrstop

#include "tbxchild.hxx"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxmgr.hxx"
#include "dispatch.hxx"
#include "viewfrm.hxx"
#include "toolbox.hrc"
#include "tbxconf.hxx"
#include "msgpool.hxx"
#include "virtmenu.hxx"
namespace binfilter {

using namespace rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::util;

/*N*/ class SfxToolBoxImageControl_Impl : public SfxControllerItem
/*N*/ {
/*N*/     SfxToolbox*         pToolBox;
/*N*/     long                lRotation;
/*N*/     BOOL                bIsMirrored;
/*N*/ 
/*N*/ protected:
/*N*/     virtual void        StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );
/*N*/ public:
/*N*/                         SfxToolBoxImageControl_Impl( USHORT nSlotId, SfxBindings& rBindings, SfxToolbox* pBox )
/*N*/                             : SfxControllerItem( nSlotId, rBindings )
/*N*/                             , pToolBox( pBox )
/*N*/                             , lRotation( 0 )
/*N*/                             , bIsMirrored( FALSE )
/*N*/                         {}
/*N*/     void                Update();
/*N*/ };

/*N*/ void SfxToolBoxImageControl_Impl::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ {
/*N*/     const SfxImageItem* pItem = PTR_CAST( SfxImageItem, pState );
/*N*/     if ( pItem )
/*N*/     {
/*N*/         lRotation = pItem->GetRotation();
/*N*/         bIsMirrored = pItem->IsMirrored();
/*N*/     }
/*N*/ 
/*N*/     Update();
/*N*/ }

/*N*/ void SfxToolBoxImageControl_Impl::Update()
/*N*/ {
/*N*/     SfxViewFrame* pViewFrame = GetBindings().GetDispatcher_Impl()->GetFrame();
/*N*/     SfxSlotPool& rPool = SFX_APP()->GetSlotPool( pViewFrame );
/*N*/     for (USHORT nPos = 0; nPos<pToolBox->GetItemCount(); nPos++)
/*N*/     {
/*N*/         USHORT nId = pToolBox->GetItemId( nPos );
/*N*/         const SfxSlot* pSlot = rPool.GetSlot( nId );
/*N*/         if ( pSlot && pSlot->IsMode( SFX_SLOT_IMAGEROTATION ) )
/*N*/         {
/*N*/             pToolBox->SetItemImageMirrorMode( nId, FALSE );
/*N*/             pToolBox->SetItemImageAngle( nId, lRotation );
/*N*/         }
/*N*/         if ( pSlot && pSlot->IsMode( SFX_SLOT_IMAGEREFLECTION ) )
/*N*/             pToolBox->SetItemImageMirrorMode( nId, bIsMirrored );
/*N*/     }
/*N*/ }

/*N*/ class SfxToolBox_Impl
/*N*/ {
/*N*/ public:
/*N*/     Timer                   aTimer;
/*N*/     Point                   aPos;
/*N*/     Point                   aFloatPos;
/*N*/     SfxToolBoxControl*      pControl;
/*N*/     SfxToolbox*             pToolBox;
/*N*/     SfxToolBoxImageControl_Impl*
/*N*/                             pImageControl;
/*N*/ 
/*N*/ 						SfxToolBox_Impl( SfxToolbox *pBox )
/*N*/ 							: pControl( 0 )
/*N*/                             , pImageControl( 0 )
/*N*/ 							, pToolBox( pBox )
/*N*/ 						{
/*N*/ 							aTimer.SetTimeout( 250 );
/*N*/ 							aTimer.SetTimeoutHdl( LINK( this, SfxToolBox_Impl, TimerHdl ) );
/*N*/ 						}
/*N*/ 
/*N*/ 	DECL_LINK(			PopupDeleted, void* );
/*N*/ 	DECL_LINK( 			TimerHdl, Timer* );
/*N*/ 	void				EndPopupMode();
/*N*/ };

/*N*/ IMPL_LINK( SfxToolBox_Impl, PopupDeleted, void*, pVoid )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 	return 0L;
/*N*/ }

/*N*/ IMPL_LINK( SfxToolBox_Impl, TimerHdl, Timer*, pTimer )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 	return 0L;
/*N*/ }

/*N*/ void SfxToolBox_Impl::EndPopupMode()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

// Hilfsfunktion zum Umrechnen eines SfxChildAlignments in ein SV-WindowAlign
/*N*/ WindowAlign ConvertAlign_Impl( SfxChildAlignment eAlign )
/*N*/ {
/*N*/ 	switch ( eAlign )
/*N*/ 	{
/*N*/ 		case SFX_ALIGN_HIGHESTTOP:
/*N*/ 		case SFX_ALIGN_TOOLBOXTOP:
/*N*/ 		case SFX_ALIGN_LOWESTTOP:
/*N*/ 		case SFX_ALIGN_TOP:
/*N*/ 			return WINDOWALIGN_TOP;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ALIGN_LOWESTBOTTOM:
/*N*/ 		case SFX_ALIGN_BOTTOM:
/*N*/ 		case SFX_ALIGN_TOOLBOXBOTTOM:
/*N*/ 		case SFX_ALIGN_HIGHESTBOTTOM:
/*N*/ 			return WINDOWALIGN_BOTTOM;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ALIGN_FIRSTLEFT:
/*N*/ 		case SFX_ALIGN_LEFT:
/*N*/ 		case SFX_ALIGN_LASTLEFT:
/*N*/ 		case SFX_ALIGN_TOOLBOXLEFT:
/*N*/ 			return WINDOWALIGN_LEFT;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ALIGN_LASTRIGHT:
/*N*/ 		case SFX_ALIGN_RIGHT:
/*N*/ 		case SFX_ALIGN_FIRSTRIGHT:
/*N*/ 		case SFX_ALIGN_TOOLBOXRIGHT:
/*N*/ 			return WINDOWALIGN_RIGHT;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	DBG_ERROR("Toolboxalign im FloatingMode ?" );
/*N*/ 	return WINDOWALIGN_TOP;
/*N*/ }

/*N*/ SfxToolbox::~SfxToolbox()
/*N*/ {
/*N*/     delete pImp->pImageControl;
/*N*/ 	delete pImp;
/*N*/ }

/*N*/ SfxToolbox::SfxToolbox( SfxToolBoxManager &rMgr, Window *pParent, WinBits nBits ):
/*N*/ 	ToolBox( pParent, nBits ),
/*N*/ 	bEmpty(FALSE),
/*N*/ 	bConstructed(FALSE),
/*N*/ 	bHelpInitialized(FALSE),
/*N*/ 	bCopyCtor(FALSE),
/*N*/ 	pMgr( &rMgr ),
/*N*/ 	bActivated(FALSE),
/*N*/ 	bDeleteToolBox(FALSE),
/*N*/ 	bReconfigure(FALSE),
/*N*/ 	nPos(0xFFFF),
/*N*/ 	aLink( LINK( this, SfxToolbox, TimeHdl ) ),
/*N*/ 	nActivated(0)
/*N*/ {
/*N*/ 	Construct();
/*N*/ }

/*N*/ SfxToolbox::SfxToolbox( SfxToolBoxManager &rMgr, Window *pParent, ResId &rResId ):
/*N*/ 	ToolBox( pParent, rResId ),
/*N*/ 	bConstructed(FALSE),
/*N*/ 	bHelpInitialized(FALSE),
/*N*/ 	bCopyCtor(FALSE),
/*N*/ 	bEmpty(FALSE),
/*N*/ 	bWaitSuppressed(FALSE),
/*N*/ 	pMgr( &rMgr ),
/*N*/ 	bActivated(FALSE),
/*N*/ 	bDeleteToolBox(FALSE),
/*N*/ 	bReconfigure(FALSE),
/*N*/ 	nPos(0xFFFF),
/*N*/ 	aLink( LINK( this, SfxToolbox, TimeHdl ) ),
/*N*/ 	nActivated(0)
/*N*/ {
/*N*/ 	Construct();
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxToolbox::Construct()
/*N*/ {
/*N*/ 	pImp = new SfxToolBox_Impl( this );
/*N*/     pMgr->GetBindings().ENTERREGISTRATIONS();
/*N*/     pImp->pImageControl = new SfxToolBoxImageControl_Impl( SID_IMAGE_ORIENTATION, pMgr->GetBindings(), this );
/*N*/     pMgr->GetBindings().LEAVEREGISTRATIONS();
/*N*/ 	pControl = 0;
/*N*/ 	bMod1 = bMod2 = bShift = FALSE;
/*N*/ 	aTimer.SetTimeout( 250 );
/*N*/ 	aTimer.SetTimeoutHdl( LINK( this, SfxToolbox, TimeHdl ) );
/*N*/ 	aAsyncStoreCfgTimer.SetTimeout( 100 );
/*N*/ 	aAsyncStoreCfgTimer.SetTimeoutHdl( LINK( this, SfxToolbox, AsyncStoreCfgHdl ) );
/*N*/ 	pMgr->SetHiContrast( IsHiContrastMode() );
/*N*/ //    EnableDrop(TRUE);
/*N*/ }

//--------------------------------------------------------------------

/*?*/ IMPL_LINK( SfxToolbox, Delete, void *, pvoid )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 	return 0;
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ long SfxToolbox::Notify( NotifyEvent& rNEvt )
/*N*/ {
/*N*/ 	return ToolBox::Notify( rNEvt );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ BOOL SfxToolbox::IsHiContrastMode()
/*N*/ {
/*N*/ 	Color aBackColor = GetBackground().GetColor();
/*N*/ 	if ( aBackColor.IsDark() )
/*N*/ 		return TRUE;
/*N*/ 	else
/*N*/ 		return FALSE;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxToolbox::StateChanged( StateChangedType nType )
/*N*/ {
/*N*/ 	ToolBox::StateChanged( nType );
/*N*/ 
/*N*/ 	if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
/*N*/ 	{
/*N*/ 		// Check if we need to get new images for normal/high contrast mode
/*?*/ 		CheckAndUpdateImages();
/*N*/ 	}
/*N*/ 	else if ( nType == STATE_CHANGE_TEXT )
/*N*/ 	{
/*N*/ 		// The physical toolbar changed its outlook and shows another logical toolbar!
/*N*/ 		// We have to set the correct high contrast mode on the new tbx manager.
/*N*/ 		pMgr->SetHiContrast( IsHiContrastMode() );
/*N*/ 	}
/*N*/ 	else if ( nType == STATE_CHANGE_INITSHOW && pMgr->GetType() == 558 ) // fullscreenbar
/*N*/ 	{
/*N*/ 		// This code is a special implementation for the fullscreenbar!!
/*N*/ 		if ( aFloatPos.X() == LONG_MAX && aFloatPos.Y() == LONG_MAX )
/*N*/ 		{
/*?*/ 			// Place the fullscreenbar to the right-bottom corner of the window
/*?*/ 			// if we don't have a user position!
/*?*/ 			Window*		pFloatWindow	= GetFloatingWindow();
/*?*/             // use absolute screen coordinates here, otherwise floating windows do not include their decoration
/*?*/ 			Rectangle   aRect			= pFloatWindow ? pFloatWindow->GetWindowExtentsRelative( NULL ) : GetWindowExtentsRelative( NULL );
/*?*/             Size        aSize( aRect.GetSize() );
/*?*/ 			Size		aWinSize		= GetParent()->GetSizePixel(); // the full screen size
/*?*/ 
/*?*/ 			Point	aNewPos( aWinSize.Width() - 1 - aSize.Width(),
/*?*/ 							 aWinSize.Height() - 1 - aSize.Height() );
/*?*/ 
/*?*/ 			const StyleSettings& rSettings = Application::GetSettings().GetStyleSettings();
/*?*/ 			long				 aDecoSize = rSettings.GetBorderSize();
/*?*/ 
/*?*/             Window* pParent = &(pMgr->GetBindings().GetDispatcher()->GetFrame()->GetWindow());
/*?*/             if ( pParent->IsScrollable() )
/*?*/                 aDecoSize += rSettings.GetScrollBarSize();
/*?*/ 
/*?*/ 			// Fullscreen mode does always show horz. and vertical scrollbar. Currently it is not possible
/*?*/ 			// to detect that a window shows it scrollbars. VCL limitation.
/*?*/ 			aNewPos.X() -= aDecoSize;
/*?*/ 			aNewPos.Y() -= aDecoSize;
/*?*/ 
/*?*/ 			SetPosPixel( GetParent()->AbsoluteScreenToOutputPixel( aNewPos ));
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*?*/ void SfxToolbox::DataChanged( const DataChangedEvent& rDCEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxToolbox::CheckAndUpdateImages()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ USHORT SfxToolbox::GetItemAt( const CommandEvent &rEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
/*?*/ }


//-------------------------------------------------------------------------

/*N*/ void SfxToolbox::MouseMove( const MouseEvent& rMEvt )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*
	if ( SID_BROWSE_STOP == GetItemId( rMEvt.GetPosPixel() ) )
	{
		Application::LeaveWait();
		bWaitSuppressed = TRUE;
	}
	else if ( bWaitSuppressed )
		Application::EnterWait();
*/
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxToolbox::MouseButtonDown( const MouseEvent& rMEvt )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxToolbox::MouseButtonUp( const MouseEvent& rMEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxToolbox::Click()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxToolbox::Deactivate()
/*N*/ {
/*N*/ 	aTimer.Stop();
/*N*/ 	ToolBox::Deactivate();
/*N*/ }


//-------------------------------------------------------------------------

/*?*/ IMPL_LINK_INLINE_START( SfxToolbox, TimeHdl, Timer *, pTimer )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 	return 0;
/*?*/ }
/*?*/ IMPL_LINK_INLINE_END( SfxToolbox, TimeHdl, Timer *, pTimer )


/*?*/ IMPL_LINK( SfxToolbox, AsyncStoreCfgHdl, Timer *, pTimer )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/       return 0;
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxToolbox::Command ( const CommandEvent& rCEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ void SfxToolbox::NextToolBox()
/*?*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pMgr->NextToolBox();
/*?*/ }

//-------------------------------------------------------------------------



//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHandler; die Docking rectangles
//	werden gesetzt, die alten Attribute zu Vergleichszwecken aufgehoben.



//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Ueber den Dispatcher
//  wird das parent window benachrichtigt und die Funktion ausgefuehrt.
//	Die neuen Attribute werden mit den alten verglichen und ggf. eine
//	Veraenderung registriert.



//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Die Daten des floating
//  window werden gemerkt. Wenn in den floating mode umgeschaltet werden
//	soll und aktuell noch keine FloatingMode-Daten gesetzt waren, werden
//	defaults ausgerechnet.



//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Ueber den Dispatcher
//  wird das parent window benachrichtigt und die Funktion ausgefuehrt.


//-------------------------------------------------------------------------


/*N*/ void SfxToolbox::Highlight()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	USHORT nId = GetCurItemId();
/*N*/ 	if ( nId && !GetHelpText(nId).Len() )
/*N*/ 	{
/*?*/ 		SfxSlotPool &rSlotPool = SFX_SLOTPOOL();
/*?*/ 		SetHelpText( nId, rSlotPool.GetSlotHelpText_Impl(nId) );
/*N*/ 	}
/*N*/ 
/*N*/ 	ToolBox::Highlight();
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxToolbox::RequestHelp( const HelpEvent& rHEvt )
/*N*/ {
/*N*/ 	if ( !bHelpInitialized )
/*N*/ 	{
/*N*/ 		// Hilfetexte aus dem SlotPool (IDL-Slot-Ressourcen) laden
/*N*/ 		bHelpInitialized = TRUE;
/*N*/ 		SfxSlotPool &rSlotPool = SFX_SLOTPOOL();
/*N*/ 		for ( USHORT nPos = 0; nPos < GetItemCount(); ++nPos )
/*N*/ 		{
/*N*/ 			USHORT nId = GetItemId(nPos);
/*N*/ 			if ( nId )
/*N*/ 			{
/*N*/ #if 0
/*N*/ //! (pb) what about help?
/*N*/ 				if ( nHelpMode & HELPTEXTMODE_EXTERN )
/*N*/ 				{
/*N*/ 					ULONG nHelpId = GetHelpId( nId );
/*N*/ 					if( nHelpId )
/*N*/ 						SetHelpText( nId, String() );
/*N*/ 				}
/*N*/ 				else if ( nHelpMode & HELPTEXTMODE_NORESHELPTEXT )
/*N*/ 				{
/*N*/ 					SetHelpText( nId, String() );
/*N*/ 				}
/*N*/ 				else
/*N*/ #endif
/*N*/ 					SetHelpText( nId, rSlotPool.GetSlotHelpText_Impl( nId ) );
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	ToolBox::RequestHelp(rHEvt);
/*N*/ }

//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander (leitet an Mgr weiter)


//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Die Toolbox wird nicht
//  entfernt, sondern nur der Mode umgeschaltet.

/*?*/ BOOL SfxToolbox::Close()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Die Groesse des floating
//  windows wird gemerkt.
//	Behandelte events : floating window wurde umgegroessert.

/*N*/ void SfxToolbox::Resize()
/*N*/ {
/*N*/ 	ToolBox::Resize();
/*N*/ 	if (IsFloatingMode() && bConstructed)
/*N*/ 	{
/*N*/         if (!IsVisible())
/*N*/             return;
/*N*/ 
/*N*/         USHORT nActLines = GetFloatingLines();
/*N*/         if ( nActLines == nFloatLines )
/*N*/             return;
/*N*/ 
/*N*/         // if VCL does not return real line count for line count 0xFFFF
/*N*/         USHORT nLines = nFloatLines;
/*N*/         if ( nLines == 0xFFFF )
/*N*/         {
/*N*/             // every item takes on line
/*N*/             nLines = GetItemCount();
/*N*/             for ( USHORT nPos=0; nPos<GetItemCount(); ++nPos )
/*N*/             {
/*N*/                 USHORT nId = GetItemId(nPos);
/*N*/                 if ( !IsItemVisible( nId ) )
/*N*/                     nLines--;
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/         if ( nLines != nActLines )
/*N*/ 		{
/*N*/             nFloatLines = nActLines;
/*N*/ 			pMgr->GetBindings().GetToolBoxConfig()->Configure_Impl( pMgr );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*?*/ void SfxToolbox::FillInfo(SfxChildWinInfo&) const
/*?*/ {
/*?*/ }

/*N*/ void SfxToolbox::SetToolBoxAlignment_Impl( SfxChildAlignment eTbxAlign )
/*N*/ {
/*N*/ 	eAlignment = eTbxAlign;
/*N*/ 	if ( eTbxAlign != SFX_ALIGN_NOALIGNMENT )
/*N*/ 		SetAlign( ConvertAlign_Impl( eAlignment ) );
/*N*/ }


/*?*/ void SfxToolbox::SetChildAlignment_Impl( WindowAlign eTbxAlign )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*N*/ void SfxToolbox::ClearItemText_Impl()
/*N*/ {
/*N*/ 	aItems.Remove( 0, aItems.Count() );
/*N*/ }

/*N*/ void SfxToolbox::SetItemText_Impl( USHORT nId, BOOL bSet )
/*N*/ {
/*N*/ 	USHORT nCount = aItems.Count();
/*N*/ 	USHORT n;
/*N*/ 	for ( n=0; n<nCount; n++ )
/*N*/ 	{
/*N*/ 		if ( aItems[n] > nId )
/*N*/ 		{
/*N*/ 			break;
/*N*/ 		}
/*N*/ 		else if ( aItems[n] == nId )
/*N*/ 		{
/*N*/ 			aItems.Remove( n );
/*N*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( bSet )
/*N*/ 		aItems.Insert( nId, n );
/*N*/ }

/*?*/ BOOL SfxToolbox::HasItemText_Impl( USHORT nId )
/*?*/ {DBG_BF_ASSERT(0, "STRIP");return FALSE; //STRIP001 
/*?*/ }

/*N*/ void SfxToolbox::SetFloatingPosition( const Point& rPos )
/*N*/ {
/*N*/     aFloatPos = rPos;
/*N*/     SetFloatingPos( rPos );
/*N*/ }

/*N*/ Point SfxToolbox::GetFloatingPosition() const
{
/*
    if ( IsFloatingMode() )
    {
		SfxDispatcher *pDispat = pMgr->GetBindings().GetDispatcher_Impl();
		SfxViewFrame  *pFrame  = pDispat->GetFrame();

		// Alle nicht belegten Positionen rauswerfen
		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
        Rectangle aRect = ((SfxToolbox*)this)->GetWindowExtentsRelative( pWorkWin->GetWindow() );
        return aRect.TopLeft();
    }
    else
    {
        return GetFloatingPos();
    }
*/
/*N*/     return aFloatPos;
/*N*/ }

/*N*/ void SfxToolbox::Move()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*
		SfxDispatcher *pDispat = pMgr->GetBindings().GetDispatcher_Impl();
		SfxViewFrame  *pFrame  = pDispat->GetFrame();

        SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
        Window *pWindow = pWorkWin->GetWindow();
        while ( !pWindow->IsSystemWindow() )
            pWindow = pWindow->GetParent();

        Rectangle aRect = ((SfxToolbox*)this)->GetWindowExtentsRelative( pWindow );
        aFloatPos = aRect.TopLeft();
*/

//        pMgr->GetBindings().GetToolBoxConfig()->Configure_Impl( pMgr );
        //pWorkWin->ConfigChild_Impl( SFX_CHILDWIN_OBJECTBAR, SFX_ALIGNDOCKINGWINDOW, pMgr->GetType() );
///STRIP001 *N*/     }
/*N*/ }
}
