/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_mnuitem.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:42:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string> // HACK: prevent conflict between STLPORT and Workshop includes

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#pragma hdrstop

#include "sfx.hrc"
#include "msgpool.hxx"
#include "dispatch.hxx"
#include "sfxtypes.hxx"
#include "macrconf.hxx"
#include "virtmenu.hxx"
#include "tbxctrl.hxx"
#include "arrdecl.hxx"

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#include "viewfrm.hxx"
#include "../doc/doc.hrc"

namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::util;

//====================================================================


//=========================================================================


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//--------------------------------------------------------------------



//--------------------------------------------------------------------

// binds the instance to the specified id and assignes the title

/*N*/ void SfxMenuControl::Bind( SfxVirtualMenu* pOwn,
/*N*/ 						   USHORT nId, const String& rTitle,
/*N*/ 						   const String &rHelpText,
/*N*/ 						   SfxBindings &rBindings )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	aTitle = rTitle;
/*N*/ 	aHelpText = rHelpText;
/*N*/ 	pOwnMenu = pOwn;
/*N*/ 	pSubMenu = 0;
/*N*/ 	if ( pOwn )
/*N*/ 		SfxControllerItem::Bind(nId, &rBindings);
/*N*/ 	else
/*?*/ 		SetId( nId );
/*N*/ 
/*N*/ 	DBG( CheckConfigure_Impl(SFX_SLOT_MENUCONFIG) );
/*N*/ }


//--------------------------------------------------------------------

// binds the item to the specified menu and assignes the title

/*N*/ void SfxMenuControl::Bind( SfxVirtualMenu* pOwn,
/*N*/ 						   USHORT nId, SfxVirtualMenu& rMenu,
/*N*/ 						   const String& rTitle, const String &rHelpText,
/*N*/ 						   SfxBindings &rBindings )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	if ( nId == SID_NONE )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 nId = SFX_SLOTPOOL().GetIdPool().Get();
/*N*/ 	SetId( nId );
/*N*/ 	SetBindings(rBindings);
/*N*/ 	pOwnMenu = pOwn;
/*N*/ 	pSubMenu = &rMenu;
/*N*/ 	aTitle = rTitle;
/*N*/ 	aHelpText = rHelpText;
/*N*/ }

//--------------------------------------------------------------------

// ctor for explicit registration


//--------------------------------------------------------------------

// ctor for array

/*N*/ SfxMenuControl::SfxMenuControl():
/*N*/ 	pOwnMenu(0),
/*N*/ 	pSubMenu(0),
/*N*/ 	b_ShowStrings(FALSE)
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ }

//--------------------------------------------------------------------

/*?*/ SfxMenuControl::SfxMenuControl(USHORT nId, SfxBindings& rBindings):
/*?*/ 	SfxControllerItem(nId, rBindings),
/*?*/ 	pOwnMenu(0),
/*?*/ 	pSubMenu(0),
/*?*/ 	b_ShowStrings(FALSE)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }


//--------------------------------------------------------------------

// dtor

/*N*/ SfxMenuControl::~SfxMenuControl()
/*N*/ {
/*N*/ 	if ( SfxMacroConfig::IsMacroSlot( GetId() ) )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 SFX_APP()->GetMacroConfig()->ReleaseSlotId(GetId());
/*N*/ 	delete pSubMenu;
/*N*/ }


//--------------------------------------------------------------------

// changes the state in the virtual menu

/*N*/ void SfxMenuControl::StateChanged
/*N*/ (
/*N*/ 	USHORT 				nSID,
/*N*/ 	SfxItemState		eState,
/*N*/ 	const SfxPoolItem* 	pState
/*N*/ )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_ASSERT( nSID == GetId(), "strange SID" );
/*N*/ 	DBG_ASSERT( pOwnMenu != 0, "setting state to dangling SfxMenuControl" );
/*N*/ 
/*N*/ 	FASTBOOL bIsObjMenu =
/*N*/ 				GetId() >= SID_OBJECTMENU0 && GetId() < SID_OBJECTMENU_LAST;
/*N*/ 
/*N*/ 	// enabled/disabled-Flag pauschal korrigieren
/*N*/ 	pOwnMenu->EnableItem( GetId(), bIsObjMenu
/*N*/ 				? 0 != pOwnMenu->GetSVMenu()->GetPopupMenu( GetId() )
/*N*/ 				: eState != SFX_ITEM_DISABLED );
/*N*/ 
/*N*/ 	if ( eState != SFX_ITEM_AVAILABLE )
/*N*/ 	{
/*N*/ 		// checken nur bei nicht-Object-Menus
/*N*/ 		if ( !bIsObjMenu )
/*N*/ 			pOwnMenu->CheckItem( GetId(), FALSE );
/*N*/ 
/*N*/ 		// SetItemText flackert in MenuBar insbes. unter OS/2 (Bug #20658)
/*N*/ 		if ( // !bIsObjMenu && nicht wegen "Format/Datenbank"
/*N*/ 			 pOwnMenu->GetSVMenu()->GetItemText( GetId() ) != GetTitle() )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pOwnMenu->SetItemText( GetId(), GetTitle() );
/*N*/ 
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	// ggf. das alte Enum-Menu entfernen/loeschen
/*N*/ 	//! delete pOwnMenu->GetMenu().ChangePopupMenu( GetId(), 0 );
/*N*/ 
/*N*/ 	FASTBOOL bCheck = FALSE;
/*N*/ 	if ( pState->ISA(SfxBoolItem) )
/*N*/ 	{
/*N*/ 		// BoolItem fuer checken
/*N*/ 		DBG_ASSERT( GetId() < SID_OBJECTMENU0 || GetId() > SID_OBJECTMENU_LAST,
/*N*/ 					"SfxBoolItem not allowed for SID_OBJECTMENUx" );
/*N*/ 		bCheck = ((const SfxBoolItem*)pState)->GetValue();
/*N*/ 	}
/*N*/ 	else if ( pState->ISA(SfxEnumItemInterface) &&
/*N*/ 			  ((SfxEnumItemInterface *)pState)->HasBoolValue() )
/*N*/ 	{
/*N*/ 		// EnumItem wie Bool behandeln
/*?*/ 		DBG_ASSERT( GetId() < SID_OBJECTMENU0 || GetId() > SID_OBJECTMENU_LAST,
/*?*/ 					"SfxEnumItem not allowed for SID_OBJECTMENUx" );
/*?*/ 		bCheck = ((SfxEnumItemInterface *)pState)->GetBoolValue();
/*N*/ 	}
/*N*/ 	else if ( ( b_ShowStrings || bIsObjMenu ) && pState->ISA(SfxStringItem) )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP");//STRIP001 
/*N*/ 	}
/*N*/ 
/*N*/ #ifdef enum_item_menu_ok
/*?*/ 	else if ( aType == TYPE(SfxEnumItem) )
/*?*/ 	{
/*?*/ 		DBG_ASSERT( GetId() < SID_OBJECTMENU0 || GetId() > SID_OBJECTMENU_LAST,
/*?*/ 					"SfxEnumItem not allowed for SID_OBJECTMENUx" );
/*?*/         pOwnMenu->GetMenu().ChangePopupMenu( GetId(), &GetBindings(),
/*?*/ 			new SfxEnumMenu( GetId(), *(const SfxEnumItem*)pState ) );
/*?*/ 	}
/*N*/ #endif
/*N*/ 
/*N*/ 	pOwnMenu->CheckItem( GetId(), bCheck );
/*N*/ }

//--------------------------------------------------------------------

/*?*/ SfxMenuControl* SfxMenuControl::CreateImpl( USHORT nId, Menu &rMenu, SfxBindings &rBindings )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 
/*?*/ }

//--------------------------------------------------------------------

/*N*/ void SfxMenuControl::RegisterControl( USHORT nSlotId, SfxModule *pMod )
/*N*/ {
/*N*/ 	SFX_APP()->RegisterMenuControl( pMod, new SfxMenuCtrlFactory(
/*N*/ 				SfxMenuControl::CreateImpl, TYPE(SfxStringItem), nSlotId ) );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxMenuControl* SfxMenuControl::CreateControl( USHORT nId, Menu &rMenu, SfxBindings &rBindings )
/*N*/ {
/*N*/ 	TypeId aSlotType = SFX_SLOTPOOL().GetSlotType(nId);
/*N*/ 	if ( aSlotType )
/*N*/ 	{
/*N*/ 		SfxApplication *pApp = SFX_APP();
/*N*/ 		SfxDispatcher *pDisp = rBindings.GetDispatcher_Impl();
/*N*/ 		SfxModule *pMod = pDisp ? pApp->GetActiveModule( pDisp->GetFrame() ) :0;
/*N*/ 		if ( pMod )
/*N*/ 		{
/*N*/ 			SfxMenuCtrlFactArr_Impl *pFactories = pMod->GetMenuCtrlFactories_Impl();
/*N*/ 			if ( pFactories )
/*N*/ 			{
/*N*/ 				SfxMenuCtrlFactArr_Impl &rFactories = *pFactories;
/*N*/ 				for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 					if ( rFactories[nFactory]->nTypeId == aSlotType &&
/*N*/ 						 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
/*N*/ 						   ( rFactories[nFactory]->nSlotId == nId) ) )
/*?*/ 						return rFactories[nFactory]->pCtor( nId, rMenu, rBindings );
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		SfxMenuCtrlFactArr_Impl &rFactories = pApp->GetMenuCtrlFactories_Impl();
/*N*/ 
/*N*/ 		for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 			if ( rFactories[nFactory]->nTypeId == aSlotType &&
/*N*/ 				 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
/*N*/ 				   ( rFactories[nFactory]->nSlotId == nId) ) )
/*?*/ 				return rFactories[nFactory]->pCtor( nId, rMenu, rBindings );
/*N*/ 	}
/*N*/ 	return 0;
/*N*/ }



#if SUPD>633
#else
#endif

//--------------------------------------------------------------------

/*?*/ PopupMenu* SfxMenuControl::GetPopup () const
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 
/*?*/ }

long Select_Impl( void* pHdl, void* pVoid );

/*N*/ SFX_IMPL_MENU_CONTROL( SfxAppMenuControl_Impl, SfxStringItem );

/*?*/ SfxAppMenuControl_Impl::SfxAppMenuControl_Impl(
/*?*/ 	USHORT nPos, Menu& rMenu, SfxBindings& rBindings )
/*?*/ 	: SfxMenuControl( nPos, rBindings ), pMenu(0)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }






}
