/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_templdlg.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:24:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif
#pragma hdrstop

#define _SVSTDARR_STRINGSDTOR


#include "dispatch.hxx"
#include "templdgi.hxx"
#include "tplcitem.hxx"
#include "sfxtypes.hxx"
#include "styfitem.hxx"
#include "viewsh.hxx"
#include "tplpitem.hxx"
#include "sfxresid.hxx"

#include "templdlg.hrc"
#include "sfx.hrc"
#include "dialog.hrc"
#include "imgmgr.hxx"
#include "helpid.hrc"
#include "objshimp.hxx"
#include "viewfrm.hxx"


#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

namespace binfilter {

//=========================================================================

// Fenster wird ab jetzt dynamisch erstellt. Daher hier R"ander usw.

#define SFX_TEMPLDLG_HFRAME			3
#define SFX_TEMPLDLG_VTOPFRAME		3

#ifdef MAC
#define SFX_TEMPLDLG_VBOTFRAME		8
#else
#define SFX_TEMPLDLG_VBOTFRAME		3
#endif

#define SFX_TEMPLDLG_MIDHSPACE		3
#define SFX_TEMPLDLG_MIDVSPACE		3
#define SFX_TEMPLDLG_FILTERHEIGHT	100

static USHORT nLastItemId = USHRT_MAX;

//=========================================================================

/*N*/ TYPEINIT0(SfxCommonTemplateDialog_Impl);
/*N*/ TYPEINIT1(SfxTemplateDialog_Impl,SfxCommonTemplateDialog_Impl);

/*N*/ SFX_IMPL_DOCKINGWINDOW(SfxTemplateDialogWrapper, SID_STYLE_DESIGNER)

//-------------------------------------------------------------------------

// Redirektionsfunktionen

/*N*/ SfxTemplateDialog::SfxTemplateDialog
/*N*/ (
/*N*/ 	SfxBindings *pBindings,
/*N*/ 	SfxChildWindow *pCW,
/*N*/ 	Window *pParent
/*N*/ )

/*  [Beschreibung]
	Gestalterklasse.
*/
/*N*/ 	: SfxDockingWindow( pBindings, pCW, pParent, SfxResId(DLG_STYLE_DESIGNER) ),
/*N*/ 
/*N*/ 	pImpl( new SfxTemplateDialog_Impl( pParent, pBindings, this ) )
/*N*/ 
/*N*/ {
/*N*/ 	pImpl->updateNonFamilyImages();
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxTemplateDialog::~SfxTemplateDialog()
/*N*/ {
/*N*/ 	delete pImpl;
/*N*/ }

/*N*/ ISfxTemplateCommon* SfxTemplateDialog::GetISfxTemplateCommon()
/*N*/ {
/*N*/ 	return pImpl->GetISfxTemplateCommon();
/*N*/ }

// ------------------------------------------------------------------------

/*?*/ void SfxTemplateDialog::DataChanged( const DataChangedEvent& _rDCEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxTemplateDialog::Update()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog::Resize()
/*N*/ {
/*N*/ 	if(pImpl)
/*N*/ 		pImpl->Resize();
/*N*/ 	SfxDockingWindow::Resize();
/*N*/ }


//-------------------------------------------------------------------------

/*N*/ SfxChildAlignment SfxTemplateDialog::CheckAlignment(SfxChildAlignment eActAlign,SfxChildAlignment eAlign)
/*N*/ {
/*N*/ 	switch (eAlign)
/*N*/ 	{
/*N*/ 		case SFX_ALIGN_TOP:
/*N*/ 		case SFX_ALIGN_HIGHESTTOP:
/*N*/ 		case SFX_ALIGN_LOWESTTOP:
/*N*/ 		case SFX_ALIGN_BOTTOM:
/*N*/ 		case SFX_ALIGN_LOWESTBOTTOM:
/*N*/ 		case SFX_ALIGN_HIGHESTBOTTOM:
/*N*/ 			return eActAlign;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ALIGN_LEFT:
/*N*/ 		case SFX_ALIGN_RIGHT:
/*N*/ 		case SFX_ALIGN_FIRSTLEFT:
/*N*/ 		case SFX_ALIGN_LASTLEFT:
/*N*/ 		case SFX_ALIGN_FIRSTRIGHT:
/*N*/ 		case SFX_ALIGN_LASTRIGHT:
/*N*/ 			return eAlign;
/*N*/ 			break;
/*N*/ 
/*N*/ 		default:
/*N*/ 			return eAlign;
/*N*/ 			break;
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------

/*?*/ void DropListBox_Impl::MouseButtonDown( const MouseEvent& rMEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*?*/ sal_Int8 DropListBox_Impl::AcceptDrop( const AcceptDropEvent& rEvt )

/*  [Beschreibung ]

	Droppen eigentlich immer dann erlaubt, wenn von den selektieren
	Objekten ine Stylesheet erstellt werden kann und der Dragvorgang
	von der Selektion aus gestartet wurde.
	Hier vereinfachend: Es liegen Daten im Clipboardformat der
	Applikation vor. Cave mehrere Writer gleichzeitig!
*/

/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ sal_Int8 DropListBox_Impl::ExecuteDrop( const ExecuteDropEvent& rEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
/*?*/ }






/*?*/ long DropListBox_Impl::Notify( NotifyEvent& rNEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
/*?*/ }


//-------------------------------------------------------------------------


/*N*/ SfxActionListBox::SfxActionListBox
/*N*/ (
/*N*/ 	SfxCommonTemplateDialog_Impl* pParent,
/*N*/ 	WinBits nWinBits
/*N*/ )

/*  [Beschreibung]

	ListBox- Klasse, die im Command-Handler ein PopupMenu (Gestalter
	spezifisch) startet.

*/

/*N*/ :       DropListBox_Impl(pParent->GetWindow(), nWinBits, pParent)
/*N*/ 
/*N*/ {
/*N*/ 	EnableContextMenuHandling();
/*N*/ }

//-------------------------------------------------------------------------


//-------------------------------------------------------------------------

/*?*/ PopupMenu* SfxActionListBox::CreateContextMenu( void )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ SfxTemplateDialogWrapper::SfxTemplateDialogWrapper(Window *pParent,
/*N*/ 		USHORT nId,  SfxBindings *p, SfxChildWinInfo *pInfo) :
/*N*/ 	SfxChildWindow(pParent, nId)
/*N*/ {
/*N*/ 	SfxTemplateDialog *pWin = new SfxTemplateDialog(p, this, pParent);
/*N*/ 	pWindow = pWin;
/*N*/ 	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
/*N*/ 
/*N*/ 	pWin->Initialize( pInfo );
/*N*/ 	pWin->SetMinOutputSizePixel(pWin->pImpl->GetMinOutputSizePixel());
/*N*/ }

//=========================================================================

/*  [Beschreibung]

	TreeListBox- Klasse f"ur die Anzeige der hierarchischen View
	der Vorlagen

*/


//-------------------------------------------------------------------------





//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------
//-------------------------------------------------------------------------

class StyleTreeArr_Impl;


/*  [Beschreibung]

	Interne Struktur f"ur den Aufbau der hierarchischen View

*/





//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------






//-------------------------------------------------------------------------

// Konstruktor

/*N*/ SfxCommonTemplateDialog_Impl::SfxCommonTemplateDialog_Impl( SfxBindings* pB, SfxDockingWindow* pW ) :
/*N*/ 
/*N*/ 	aISfxTemplateCommon		( this ),
/*N*/ 	pBindings				( pB ),
/*N*/ 	pWindow					( pW ),
/*N*/ 	pModule					( NULL ),
/*N*/ 	pTimer					( NULL ),
/*N*/ 	pStyleSheetPool			( NULL ),
/*N*/ 	pTreeBox				( NULL ),
/*N*/ 	pCurObjShell			( NULL ),
/*N*/ 
/*N*/ 	aFmtLb					( this, WB_BORDER | WB_TABSTOP | WB_SORT ),
/*N*/ 	aFilterLb				( pW, WB_BORDER | WB_DROPDOWN | WB_TABSTOP ),
/*N*/ 
/*N*/ 	nActFamily				( 0xffff ),
/*N*/ 	nActFilter				( 0 ),
/*N*/ 	nAppFilter				( 0 ),
/*N*/ 
/*N*/ 	bDontUpdate				( FALSE ),
/*N*/ 	bIsWater				( FALSE ),
/*N*/ 	bEnabled				( TRUE ),
/*N*/ 	bUpdate					( FALSE ),
/*N*/ 	bUpdateFamily			( FALSE ),
/*N*/ 	bCanEdit				( FALSE ),
/*N*/ 	bCanDel					( FALSE ),
/*N*/ 	bCanNew					( TRUE ),
/*N*/ 	bWaterDisabled			( FALSE ),
/*N*/ 	bNewByExampleDisabled	( FALSE ),
/*N*/ 	bUpdateByExampleDisabled( FALSE ),
/*N*/ 	bTreeDrag				( TRUE ),
/*N*/ 	bHierarchical			( FALSE ),
/*N*/ 	bBindingUpdate			( TRUE ),
/*N*/ 	m_pStyleFamiliesId		( NULL )
/*N*/ {
/*N*/ 	aFmtLb.SetHelpId( HID_TEMPLATE_FMT );
/*N*/ 	aFilterLb.SetHelpId( HID_TEMPLATE_FILTER );
/*N*/ 	aFmtLb.SetWindowBits( WB_SORT | WB_HIDESELECTION );
/*N*/ 	Font aFont = aFmtLb.GetFont();
/*N*/ 	aFont.SetWeight( WEIGHT_NORMAL );
/*N*/ #ifdef MAC
/*N*/ 	aFont.SetName( String::CreateFromAscii( "Geneva" ) );
/*N*/ 	aFont.SetSize( Size( 0, 10 ) );
/*N*/ #endif
/*N*/ 	aFmtLb.SetFont( aFont );
/*N*/ }

//-------------------------------------------------------------------------


//-------------------------------------------------------------------------

/*N*/ USHORT SfxCommonTemplateDialog_Impl::StyleNrToInfoOffset(USHORT nId)
/*N*/ {
/*N*/ 	const SfxStyleFamilyItem *pItem=pStyleFamilies->GetObject(nId);
/*N*/ 	return SfxFamilyIdToNId(pItem->GetFamily())-1;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog_Impl::EnableEdit(BOOL bEnable)
/*N*/ {
/*N*/ 	SfxCommonTemplateDialog_Impl::EnableEdit( bEnable );
/*N*/ 	if( !bEnable || !bUpdateByExampleDisabled )
/*N*/ 		EnableItem( SID_STYLE_UPDATE_BY_EXAMPLE, bEnable);
/*N*/ }

//-------------------------------------------------------------------------




//-------------------------------------------------------------------------

/*N*/ void SfxCommonTemplateDialog_Impl::ReadResource()
/*N*/ {
/*N*/ 	// globale Benutzer-Resource auslesen
/*N*/ 	USHORT i;
/*N*/ 	for(i = 0; i < MAX_FAMILIES; ++i)
/*N*/ 		pFamilyState[i] = 0;
/*N*/ 
/*N*/ 	SfxViewFrame* pViewFrame = pBindings->GetDispatcher_Impl()->GetFrame();
/*N*/ 	pCurObjShell = pViewFrame->GetObjectShell();
/*N*/ 	ResMgr* pMgr = pCurObjShell ? pCurObjShell->GetResMgr() : NULL;
/*N*/ 	ResId aFamId( DLG_STYLE_DESIGNER, pMgr );
/*N*/ 	aFamId.SetRT(RSC_SFX_STYLE_FAMILIES);
/*N*/ 	m_pStyleFamiliesId = new ResId( aFamId );
/*N*/ 	if( !pMgr || !pMgr->IsAvailable( aFamId ) )
/*?*/ 		pStyleFamilies = new SfxStyleFamilies;
/*N*/ 	else
/*N*/ 		pStyleFamilies = new SfxStyleFamilies( aFamId );
/*N*/ 
/*N*/ 	nActFilter = pCurObjShell ? pCurObjShell->Get_Impl()->nStyleFilter : 0xFFFF;
/*N*/ 
/*N*/ 		// Einfuegen in die Toolbox
/*N*/ 		// umgekehrte Reihenfolge, da immer vorne eingefuegt wird.
/*N*/ 	USHORT nCount = pStyleFamilies->Count();
/*N*/ 
/*N*/ 	pBindings->ENTERREGISTRATIONS();
/*N*/ 
/*N*/ 	for(i = 0; i < nCount; ++i)
/*N*/ 	{
/*N*/ 		USHORT nSlot = 0;
/*N*/ 		switch((USHORT)pStyleFamilies->GetObject(i)->GetFamily())
/*N*/ 		{
/*N*/ 			case SFX_STYLE_FAMILY_CHAR: nSlot = SID_STYLE_FAMILY1; break;
/*N*/ 			case SFX_STYLE_FAMILY_PARA: nSlot = SID_STYLE_FAMILY2; break;
/*N*/ 			case SFX_STYLE_FAMILY_FRAME:nSlot = SID_STYLE_FAMILY3; break;
/*N*/ 			case SFX_STYLE_FAMILY_PAGE: nSlot = SID_STYLE_FAMILY4; break;
/*N*/ 			case SFX_STYLE_FAMILY_PSEUDO: nSlot = SID_STYLE_FAMILY5; break;
/*N*/ 			default: DBG_ERROR("unbekannte StyleFamily"); break;
/*N*/ 		}
/*N*/ 		pBoundItems[i] =
/*N*/ 			new SfxTemplateControllerItem(nSlot, *this, *pBindings);
/*N*/ 	}
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_WATERCAN, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_NEW_BY_EXAMPLE, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_UPDATE_BY_EXAMPLE, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_NEW, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_DRAGHIERARCHIE, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_EDIT, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_DELETE, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_FAMILY, *this, *pBindings);
/*N*/ 	pBindings->LEAVEREGISTRATIONS();
/*N*/ 
/*N*/ 	for(; i < COUNT_BOUND_FUNC; ++i)
/*N*/ 		pBoundItems[i] = 0;
/*N*/ 
/*N*/ 	StartListening(*pBindings);
/*N*/ 
/*N*/ //In umgekehrter Reihenfolge des Auftretens in den Stylefamilies einfuegen.
/*N*/ //Das ist fuer den Toolbar des Gestalters. Die Listbox des Kataloges achtet
/*N*/ //selbst auf korrekte Reihenfolge.
/*N*/ 
/*N*/ //Reihenfolgen: Reihenfolge in der Resource = Reihenfolge in Toolbar bzw.
/*N*/ //Listbox.
/*N*/ //Reihenfolge aufsteigender SIDs: Niedrige SIDs werden als erstes angezeigt,
/*N*/ //wenn Vorlagen mehrerer Familien aktiv sind.
/*N*/ 
/*N*/ 	for( ; nCount--; )
/*N*/ 	{
/*N*/ 		const SfxStyleFamilyItem *pItem = pStyleFamilies->GetObject( nCount );
/*N*/ 		USHORT nId = SfxFamilyIdToNId( (USHORT) pItem->GetFamily() );
/*N*/ 		InsertFamilyItem( nId, pItem );
/*N*/ 	}
/*N*/ 
/*N*/ 	LoadedFamilies();
/*N*/ 
/*N*/ 	USHORT nStart = SID_STYLE_FAMILY1;
/*N*/ 	USHORT nEnd = SID_STYLE_FAMILY4;
/*N*/ 
/*N*/ 	for ( i = nStart; i <= nEnd; i++ )
/*N*/ 		pBindings->Update(i);
/*N*/ 
/*N*/ 	pModule = pCurObjShell ? pCurObjShell->GetModule() : NULL;
/*N*/ }

//-------------------------------------------------------------------------


//-------------------------------------------------------------------------

/*N*/ void SfxCommonTemplateDialog_Impl::Initialize()
/*N*/ {
/*N*/ 	// globale Benutzer-Resource auslesen
/*N*/ 	ReadResource();
/*N*/ 	pBindings->Invalidate( SID_STYLE_FAMILY );
/*N*/ 	pBindings->Update( SID_STYLE_FAMILY );
/*N*/ 	Update_Impl();
/*N*/ 
/*N*/ 	aFilterLb.SetSelectHdl( LINK( this, SfxCommonTemplateDialog_Impl, FilterSelectHdl ) );
/*N*/ 	aFmtLb.SetDoubleClickHdl( LINK( this, SfxCommonTemplateDialog_Impl, ApplyHdl ) );
/*N*/ 	aFmtLb.SetSelectHdl( LINK( this, SfxCommonTemplateDialog_Impl, FmtSelectHdl ) );
/*N*/ 
/*N*/ 	aFilterLb.Show();
/*N*/ 	aFmtLb.Show();
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxCommonTemplateDialog_Impl::~SfxCommonTemplateDialog_Impl()
/*N*/ {
/*N*/ 	String aEmpty;
/*N*/ 	if ( bIsWater )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 Execute_Impl(SID_STYLE_WATERCAN, aEmpty, aEmpty, 0);
/*N*/ 	GetWindow()->Hide();
/*N*/ 	DELETEX(pStyleFamilies);
/*N*/ 	DELETEZ( m_pStyleFamiliesId );
/*N*/ 	USHORT i;
/*N*/ 	for ( i = 0; i < MAX_FAMILIES; ++i )
/*N*/ 		DELETEX(pFamilyState[i]);
/*N*/ 	for ( i = 0; i < COUNT_BOUND_FUNC; ++i )
/*N*/ 		delete pBoundItems[i];
/*N*/ 	if ( pStyleSheetPool )
/*N*/ 		EndListening(*pStyleSheetPool);
/*N*/ 	pStyleSheetPool = NULL;
/*N*/ 	delete pTreeBox;
/*N*/ 	delete pTimer;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ USHORT SfxCommonTemplateDialog_Impl::SfxFamilyIdToNId( USHORT nFamily )
/*N*/ {
/*N*/ 	switch ( nFamily )
/*N*/ 	{
/*N*/ 		case SFX_STYLE_FAMILY_CHAR:		return 1; break;
/*N*/ 		case SFX_STYLE_FAMILY_PARA:		return 2; break;
/*N*/ 		case SFX_STYLE_FAMILY_FRAME:	return 3; break;
/*N*/ 		case SFX_STYLE_FAMILY_PAGE:		return 4; break;
/*N*/ 		case SFX_STYLE_FAMILY_PSEUDO:	return 5; break;
/*N*/ 		default: 						return 0;
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

// Hilfsfunktion: Zugriff auf aktuelles Family-Item
/*N*/ const SfxStyleFamilyItem *SfxCommonTemplateDialog_Impl::GetFamilyItem_Impl() const
/*N*/ {
/*N*/ 	const USHORT nCount = pStyleFamilies->Count();
/*N*/ 	for(USHORT i = 0; i < nCount; ++i)
/*N*/ 	{
/*N*/ 		const SfxStyleFamilyItem *pItem = pStyleFamilies->GetObject(i);
/*N*/ //        if(!pItem)continue;
/*N*/ 		USHORT nId = SfxFamilyIdToNId((USHORT)pItem->GetFamily());
/*N*/ 		if(nId == nActFamily)
/*N*/ 			return pItem;
/*N*/ 	}
/*N*/ 	return 0;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxCommonTemplateDialog_Impl::SelectStyle(const String &rStr)
/*N*/ {
/*N*/ 	const SfxStyleFamilyItem* pItem = GetFamilyItem_Impl();
/*N*/ 	if ( !pItem )
/*N*/ 		return;
/*N*/ 	const SfxStyleFamily eFam = pItem->GetFamily();
/*N*/ 	SfxStyleSheetBase* pStyle = pStyleSheetPool->Find( rStr, eFam, SFXSTYLEBIT_ALL );
/*N*/ 	if( pStyle )
/*N*/ 		EnableEdit( !(pStyle->GetMask() & SFXSTYLEBIT_READONLY) );
/*N*/ 	else
/*N*/ 		EnableEdit(FALSE);
/*N*/ 
/*N*/ 	if ( pTreeBox )
/*N*/ 	{
/*?*/ 		if ( rStr.Len() )
/*?*/ 		{
/*?*/ 			SvLBoxEntry* pEntry = pTreeBox->First();
/*?*/ 			while ( pEntry )
/*?*/ 			{
/*?*/ 				if ( pTreeBox->GetEntryText( pEntry ) == rStr )
/*?*/ 				{
/*?*/ 					pTreeBox->MakeVisible( pEntry );
/*?*/ 					pTreeBox->Select( pEntry );
/*?*/ 					return;
/*?*/ 				}
/*?*/ 				pEntry = pTreeBox->Next( pEntry );
/*?*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 			pTreeBox->SelectAll( FALSE );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		BOOL bSelect = ( rStr.Len() > 0 );
/*N*/ 		if ( bSelect )
/*N*/ 		{
/*N*/ 			SvLBoxEntry* pEntry = (SvLBoxEntry*)aFmtLb.FirstVisible();
/*N*/ 			while ( pEntry && aFmtLb.GetEntryText( pEntry ) != rStr )
/*N*/ 				pEntry = (SvLBoxEntry*)aFmtLb.NextVisible( pEntry );
/*N*/ 			if ( !pEntry )
/*N*/ 				bSelect = FALSE;
/*N*/ 			else
/*N*/ 			{
/*N*/ 				aFmtLb.MakeVisible( pEntry );
/*N*/ 				aFmtLb.Select( pEntry );
/*N*/ 				bWaterDisabled = !HasSelectedStyle(); //added by BerryJia for fixing Bug76391 2003-1-22
/*N*/ 				FmtSelectHdl( NULL );
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( !bSelect )
/*N*/ 		{
/*N*/ 			aFmtLb.SelectAll( FALSE );
/*N*/ 			EnableEdit(FALSE);
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ String SfxCommonTemplateDialog_Impl::GetSelectedEntry() const
/*N*/ {
/*N*/ 	String aRet;
/*N*/ 	if ( pTreeBox )
/*N*/ 	{
/*?*/ 		SvLBoxEntry* pEntry = pTreeBox->FirstSelected();
/*?*/ 		if( !pEntry )
/*?*/ 			pEntry = aFmtLb.GetPreDropEntry();
/*?*/ 		if ( pEntry )
/*?*/ 			aRet = pTreeBox->GetEntryText( pEntry );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		SvLBoxEntry* pEntry = aFmtLb.FirstSelected();
/*N*/ 		if ( pEntry )
/*N*/ 			aRet = aFmtLb.GetEntryText( pEntry );
/*N*/ 	}
/*N*/ 	return aRet;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxCommonTemplateDialog_Impl::EnableTreeDrag( BOOL bEnable )
/*N*/ {
/*N*/ 	if ( pStyleSheetPool )
/*N*/ 	{
/*N*/ 		SfxStyleSheetBase* pStyle = pStyleSheetPool->First();
/*N*/ 		if ( pTreeBox )
/*N*/ 		{
/*N*/ 			if ( pStyle && pStyle->HasParentSupport() && bEnable )
/*N*/ 				pTreeBox->SetDragDropMode(SV_DRAGDROP_CTRL_MOVE);
/*N*/ 			else
/*N*/ 				pTreeBox->SetDragDropMode(SV_DRAGDROP_NONE);
/*N*/ 		}
/*N*/ 	}
/*N*/ 	bTreeDrag = bEnable;
/*N*/ }

//-------------------------------------------------------------------------


//-------------------------------------------------------------------------
/*?*/ BOOL SfxCommonTemplateDialog_Impl::HasSelectedStyle() const
/*?*/ {
/*?*/ 	return pTreeBox? pTreeBox->FirstSelected() != 0:
/*?*/ 			aFmtLb.GetSelectionCount() != 0;
/*?*/ }


//-------------------------------------------------------------------------

// intern: Aktualisierung der Anzeige
/*N*/ void SfxCommonTemplateDialog_Impl::UpdateStyles_Impl(USHORT nFlags)     // Flags, was aktualisiert werden soll (s.o.)
/*N*/ {
/*N*/ 	DBG_ASSERT(nFlags, "nichts zu tun");
/*N*/ 	const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
/*N*/ 	if (!pItem)
/*N*/ 	{
/*N*/ 		// Ist beim Vorlagenkatalog der Fall
/*N*/ 		SfxTemplateItem **ppItem = pFamilyState;
/*N*/ 		const USHORT nFamilyCount = pStyleFamilies->Count();
/*N*/ 		USHORT n;
/*N*/ 		for(n=0;n<nFamilyCount;n++)
/*N*/ 			if(ppItem[StyleNrToInfoOffset(n)])break;
/*N*/ 		if ( n == nFamilyCount )
/*N*/ 			// passiert gelegentlich bei Beichten, Formularen etc.; wei?der Teufel warum
/*N*/ 			return;
/*N*/ 		ppItem+=StyleNrToInfoOffset(n);
/*N*/ 		nAppFilter = (*ppItem)->GetValue();
/*N*/ 		FamilySelect(  StyleNrToInfoOffset(n)+1 );
/*N*/ 		pItem = GetFamilyItem_Impl();
/*N*/ 	}
/*N*/ 
/*N*/ 	const SfxStyleFamily eFam = pItem->GetFamily();
/*N*/ 
/*N*/ 	SfxFilterTupel *pT = pItem->GetFilterList().GetObject(nActFilter);
/*N*/ 	USHORT nFilter = pT ? pItem->GetFilterList().GetObject(nActFilter)->nFlags : 0;
/*N*/ 	if(!nFilter)    // automatisch
/*N*/ 		nFilter = nAppFilter;
/*N*/ 
/*N*/ 	DBG_ASSERT(pStyleSheetPool, "kein StyleSheetPool");
/*N*/ 	if(pStyleSheetPool)
/*N*/ 	{
/*N*/ 		pStyleSheetPool->SetSearchMask(eFam, nFilter);
/*N*/ 		const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
/*N*/ 		if((nFlags & UPDATE_FAMILY) == UPDATE_FAMILY)
/*N*/ 		{
/*N*/ 			if(ISA(SfxTemplateDialog_Impl))
/*N*/ 				((DockingWindow* )GetWindow())->SetText(
/*N*/ 					pItem->GetText()); // Titel setzen
/*N*/ 			CheckItem(nActFamily, TRUE);    // Button in Toolbox checken
/*N*/ 			aFilterLb.SetUpdateMode(FALSE);
/*N*/ 			aFilterLb.Clear();
/*N*/             //insert hierarchical at the beginning
/*N*/             aFilterLb.InsertEntry(String(SfxResId(STR_STYLE_FILTER_HIERARCHICAL)), 0);
/*N*/ 			const SfxStyleFilter& rFilter = pItem->GetFilterList();
/*N*/ 			for(USHORT i = 0; i < rFilter.Count(); ++i)
/*N*/ 				aFilterLb.InsertEntry(rFilter.GetObject(i)->aName);
/*N*/ 			if(nActFilter < aFilterLb.GetEntryCount() - 1)
/*N*/ 				aFilterLb.SelectEntryPos(nActFilter + 1);
/*N*/ 			else
/*N*/ 			{
/*?*/ 				nActFilter = 0;
/*?*/ 				aFilterLb.SelectEntryPos(1);
/*?*/ 				SfxFilterTupel *pT = rFilter.GetObject(nActFilter);
/*?*/ 				USHORT nFilter = pT ? rFilter.GetObject(nActFilter)->nFlags : 0;
/*?*/ 				pStyleSheetPool->SetSearchMask(eFam, nFilter);
/*N*/ 			}
/*N*/ 
/*N*/ 			if(pTreeBox)
/*?*/ 				aFilterLb.SelectEntry(String(SfxResId(STR_STYLE_FILTER_HIERARCHICAL)));
/*N*/ 			//Falls in Treedarstellung wieder Family Hierarchie selektieren
/*N*/ 
/*N*/ 			aFilterLb.SetUpdateMode(TRUE);
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			if( nActFilter < aFilterLb.GetEntryCount() - 1)
/*N*/ 				aFilterLb.SelectEntryPos(nActFilter + 1);
/*N*/ 			else
/*N*/ 			{
/*?*/ 				nActFilter = 0;
/*?*/ 				aFilterLb.SelectEntryPos(1);
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if(nFlags & UPDATE_FAMILY_LIST)
/*N*/ 		{
/*N*/ //			EnableEdit(FALSE);
/*N*/ 			EnableItem(SID_STYLE_WATERCAN,FALSE);
/*N*/ 
/*N*/ 			SfxStyleSheetBase *pStyle = pStyleSheetPool->First();
/*N*/ 			SvLBoxEntry* pEntry = aFmtLb.First();
/*N*/ 			SvStringsDtor aStrings;
/*N*/ 
/*N*/ 			while( pStyle )
/*N*/ 			{
/*N*/ 				//Bubblesort
/*N*/ 				for( USHORT nPos = aStrings.Count() + 1 ; nPos-- ;)
/*N*/ 				{
/*N*/ 					if( !nPos || *aStrings[nPos-1] < pStyle->GetName() )
/*N*/ 					{
/*N*/ 						// Die Namen stehen in den Styles, also nicht kopieren
/*N*/ 						// Reingefallen!: Writer hat insgesamt nur 1 Style
/*N*/ 						aStrings.Insert(
/*N*/ 							new String( pStyle->GetName() ), nPos );
/*N*/ 						break;
/*N*/ 					}
/*N*/ 				}
/*N*/ 				pStyle = pStyleSheetPool->Next();
/*N*/ 			}
/*N*/ 
/*N*/ 
/*N*/ 			USHORT nCount = aStrings.Count();
/*N*/ 			USHORT nPos = 0;
/*N*/ 			while( nPos < nCount && pEntry &&
/*N*/ 				   *aStrings[ nPos ] == aFmtLb.GetEntryText( pEntry ) )
/*N*/ 			{
/*N*/ 				nPos++;
/*N*/ 				pEntry = aFmtLb.Next( pEntry );
/*N*/ 			}
/*N*/ 
/*N*/ 			if( nPos < nCount || pEntry )
/*N*/ 			{
/*N*/ 				// Box mit den Vorlagen fuellen
/*N*/ 				aFmtLb.SetUpdateMode(FALSE);
/*N*/ 				aFmtLb.Clear();
/*N*/ 
/*N*/ 				nPos = 0;
/*N*/ 				while( nPos < nCount )
/*N*/ 					aFmtLb.InsertEntry( *aStrings.GetObject( nPos++ ));
/*N*/ 				aFmtLb.SetUpdateMode(TRUE);
/*N*/ 			}
/*N*/ 				// aktuelle Vorlage anzeigen
/*N*/ 			SfxTemplateItem *pState = pFamilyState[nActFamily-1];
/*N*/ 			String aStyle;
/*N*/ 			if(pState)  //Aktuellen Eintrag selektieren
/*N*/ 				aStyle = pState->GetStyleName();
/*N*/ 			SelectStyle(aStyle);
/*N*/ 			EnableDelete();
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

// Aktualisierung Anzeige: Gie\skanne an/aus
/*N*/ void SfxCommonTemplateDialog_Impl::SetWaterCanState(const SfxBoolItem *pItem)
/*N*/ {
/*N*/ //	EnableItem(SID_STYLE_WATERCAN, pItem != 0);
/*N*/ 	bWaterDisabled =  pItem == 0;
//added by BerryJia for fixing Bug76391 2003-1-7
/*N*/ 	if(!bWaterDisabled)
/*N*/ 		bWaterDisabled = !HasSelectedStyle();
/*N*/ 
/*N*/ 	if(pItem && !bWaterDisabled)
/*N*/ 	{
/*N*/ 		CheckItem(SID_STYLE_WATERCAN, pItem->GetValue());
/*N*/ 		EnableItem( SID_STYLE_WATERCAN, TRUE );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		if(!bWaterDisabled)
/*N*/ 			EnableItem(SID_STYLE_WATERCAN, TRUE);
/*N*/ 		else
/*N*/ 			EnableItem(SID_STYLE_WATERCAN, FALSE);
/*N*/ 
//Waehrend Giesskannenmodus Statusupdates ignorieren.
/*N*/ 
/*N*/ 	USHORT nCount=pStyleFamilies->Count();
/*N*/ 	pBindings->EnterRegistrations();
/*N*/ 	for(USHORT n=0; n<nCount; n++)
/*N*/ 	{
/*N*/ 		SfxControllerItem *pCItem=pBoundItems[n];
/*N*/ 		BOOL bChecked = pItem && pItem->GetValue();
/*N*/ 		if( pCItem->IsBound() == bChecked )
/*?*/ 			if( !bChecked )
/*?*/ 				pCItem->ReBind();
/*?*/ 			else
/*?*/ 				pCItem->UnBind();
/*N*/ 	}
/*N*/ 	pBindings->LeaveRegistrations();
/*N*/ }

//-------------------------------------------------------------------------

// Item mit dem Status einer Family wird kopiert und gemerkt
// (Aktualisierung erfolgt, wenn alle Stati aktualisiert worden sind.
// Siehe auch: <SfxBindings::AddDoneHdl(const Link &)>

/*N*/ void SfxCommonTemplateDialog_Impl::SetFamilyState( USHORT nSlotId, const SfxTemplateItem* pItem )
/*N*/ {
/*N*/ 	USHORT nIdx = nSlotId - SID_STYLE_FAMILY_START;
/*N*/ 	DELETEZ(pFamilyState[nIdx]);
/*N*/ 	if ( pItem )
/*N*/ 		pFamilyState[nIdx] = new SfxTemplateItem(*pItem);
/*N*/ 	bUpdate = TRUE;
/*N*/ 
/*N*/ 	// Wenn verwendete Vorlagen ( wie zum Teufel findet man das heraus ?? )
/*N*/ 	bUpdateFamily = TRUE;
/*N*/ }

//-------------------------------------------------------------------------

// Benachrichtigung durch SfxBindings, da"s die Aktualisierung
// beendet ist. St"o\st die Aktualisierung der Anzeige an.

/*N*/ void SfxCommonTemplateDialog_Impl::Update_Impl()
/*N*/ {
/*N*/ 	BOOL bDocChanged=FALSE;
/*N*/ 	SfxStyleSheetBasePool *pNewPool = 0;
/*N*/ 	SfxViewFrame *pViewFrame = pBindings->GetDispatcher_Impl()->GetFrame();
/*N*/ 	SfxObjectShell *pDocShell = pViewFrame->GetObjectShell();
/*N*/ 	if( pDocShell )
/*N*/ 		pNewPool = pDocShell->GetStyleSheetPool();
/*N*/ 
/*N*/ 	if ( pNewPool != pStyleSheetPool && pDocShell )
/*N*/ 	{
/*N*/ 		SfxModule* pNewModule = pDocShell->GetModule();
/*N*/ 		if( pNewModule && pNewModule != pModule )
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 		}
/*N*/ 		if ( pStyleSheetPool )
/*N*/ 		{
/*?*/ 			EndListening(*pStyleSheetPool);
/*?*/ 			pStyleSheetPool = 0;
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pNewPool )
/*N*/ 		{
/*N*/ 			StartListening(*pNewPool);
/*N*/ 			pStyleSheetPool = pNewPool;
/*N*/ 			bDocChanged=TRUE;
/*N*/ 		}
/*N*/ //		InvalidateBindings();
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bUpdateFamily)
/*N*/ 		UpdateFamily_Impl();
/*N*/ 
/*N*/ 	USHORT i;
/*N*/ 	for(i = 0; i < MAX_FAMILIES; ++i)
/*N*/ 		if(pFamilyState[i])
/*N*/ 			break;
/*N*/ 	if(i == MAX_FAMILIES || !pNewPool)
/*N*/ 		// nichts erlaubt
/*N*/ 		return;
/*N*/ 
/*N*/ 	 SfxTemplateItem *pItem = 0;
/*N*/ 	 // aktueller Bereich nicht innerhalb der erlaubten Bereiche
/*N*/ 	 // oder Default
/*N*/ 	 if(nActFamily == 0xffff || 0 == (pItem = pFamilyState[nActFamily-1] ) )
/*N*/ 	 {
/*?*/ 		 CheckItem(nActFamily, FALSE);
/*?*/ 		 SfxTemplateItem **ppItem = pFamilyState;
/*?*/ 		 const USHORT nFamilyCount = pStyleFamilies->Count();
/*?*/ 		 USHORT n;
/*?*/ 		 for(n=0;n<nFamilyCount;n++)
/*?*/ 			 if(ppItem[StyleNrToInfoOffset(n)])break;
/*?*/ 		 ppItem+=StyleNrToInfoOffset(n);
/*?*/ 
/*?*/ 		 nAppFilter = (*ppItem)->GetValue();
/*?*/ 		 FamilySelect(  StyleNrToInfoOffset(n)+1 );
/*?*/ 
/*?*/ 		 pItem = *ppItem;
/*N*/ 	 }
/*N*/ 	 else if( bDocChanged )
/*N*/ 	 {
/*N*/ 		 // andere DocShell -> alles neu
/*N*/ 		 CheckItem( nActFamily, TRUE );
/*N*/ 		 nActFilter = pDocShell->Get_Impl()->nStyleFilter;
/*N*/ 		 nAppFilter = pItem->GetValue();
/*N*/ 		 if(!pTreeBox)
/*N*/ 		 {
/*N*/ 			 UpdateStyles_Impl(UPDATE_FAMILY_LIST);
/*N*/ 		 }
/*N*/ 		 else
/*?*/ 			 {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 FillTreeBox();
/*N*/ 	 }
/*N*/ 	 else
/*N*/ 	 {
/*N*/ 		 // anderer Filter fuer automatisch
/*N*/ 		 CheckItem( nActFamily, TRUE );
/*N*/ 		 const SfxStyleFamilyItem *pStyleItem =  GetFamilyItem_Impl();
/*N*/ #if OSL_DEBUG_LEVEL > 1
/*N*/ 		 SfxFilterTupel *pT = pStyleItem->GetFilterList().GetObject(nActFilter);
/*N*/ #endif
/*N*/ 		 if(0 == pStyleItem->GetFilterList().GetObject(nActFilter)->nFlags
/*N*/ 			&& nAppFilter != pItem->GetValue())
/*N*/ 		 {
/*?*/ 			 nAppFilter = pItem->GetValue();
/*?*/ 			 if(!pTreeBox)
/*?*/ 				 UpdateStyles_Impl(UPDATE_FAMILY_LIST);
/*?*/ 			 else
/*?*/ 				 {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 FillTreeBox();
/*N*/ 		 }
/*N*/ 		 else
/*N*/ 			 nAppFilter = pItem->GetValue();
/*N*/ 	 }
/*N*/ 	 const String aStyle(pItem->GetStyleName());
/*N*/ 	 SelectStyle(aStyle);
/*N*/ 	 EnableDelete();
/*N*/ 	 EnableNew( bCanNew );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ IMPL_LINK( SfxCommonTemplateDialog_Impl, TimeOut, Timer *, pTim )
/*N*/ {
/*N*/ 	if(!bDontUpdate)
/*N*/ 	{
/*N*/ 		bDontUpdate=TRUE;
/*N*/ 		if(!pTreeBox)
/*N*/ 			UpdateStyles_Impl(UPDATE_FAMILY_LIST);
/*N*/ 		else
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 		}
/*N*/ 		bDontUpdate=FALSE;
/*N*/ 		DELETEZ(pTimer);
/*N*/ 	}
/*N*/ 	else
/*?*/ 		pTimer->Start();
/*N*/ 	return 0;
/*N*/ }


//-------------------------------------------------------------------------
/*N*/ void SfxCommonTemplateDialog_Impl::SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType,
/*N*/ 										  const SfxHint& rHint, const TypeId& rHintType)
/*N*/ {
/*N*/ 	// Aktualisierung anstossen
/*N*/ 	if(rHint.Type() == TYPE(SfxSimpleHint))
/*N*/ 	{
/*N*/ 		switch(((SfxSimpleHint&) rHint ).GetId())
/*N*/ 		{
/*N*/ 		  case SFX_HINT_UPDATEDONE:
/*N*/ 			{
/*N*/ 				SfxViewFrame *pViewFrame = pBindings->GetDispatcher_Impl()->GetFrame();
/*N*/ 				SfxObjectShell *pDocShell = pViewFrame->GetObjectShell();
/*N*/ 				if( bUpdate && (
/*N*/ 					!IsCheckedItem(SID_STYLE_WATERCAN) || pDocShell
/*N*/ 					&& pDocShell->GetStyleSheetPool() != pStyleSheetPool) )
/*N*/ 				{
/*N*/ 					bUpdate = FALSE;
/*N*/ 					Update_Impl();
/*N*/ 				}
/*N*/ 				else if ( bUpdateFamily )
/*N*/ 				{
/*?*/ 					UpdateFamily_Impl();
/*N*/ 				}
/*N*/ 
/*N*/ 				if( pStyleSheetPool )
/*N*/ 				{
/*N*/ 					String aStr = GetSelectedEntry();
/*N*/ 					if( aStr.Len() && pStyleSheetPool )
/*N*/ 					{
/*N*/ 						const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
/*N*/ 						if( !pItem ) break;
/*N*/ 						const SfxStyleFamily eFam = pItem->GetFamily();
/*N*/ 						SfxStyleSheetBase *pStyle =
/*N*/ 							pStyleSheetPool->Find(
/*N*/ 								aStr, eFam, SFXSTYLEBIT_ALL );
/*N*/ 						if( pStyle )
/*N*/ 							EnableEdit(
/*N*/ 								!(pStyle->GetMask() & SFXSTYLEBIT_READONLY) );
/*N*/ 						else
/*?*/ 							EnableEdit(FALSE);
/*N*/ 					}
/*N*/ 				}
/*N*/ 				break;
/*N*/ 			}
/*N*/ 		// noetig, wenn zwichen Dokumenten umgeschaltet wird,
/*N*/ 		// aber in beiden Dokumenten die gleiche Vorlage gilt.
/*N*/ 		// Nicht sofort Update_Impl rufen, fr den Fall da\s eines
/*N*/ 		// der Dokumente ein internes InPlaceObjekt ist!
/*N*/ 		  case SFX_HINT_DOCCHANGED:
/*N*/ 			bUpdate = TRUE;
/*N*/ 			break;
/*N*/ 		  case SFX_HINT_DYING:
/*N*/ 		  {
/*?*/ 			EndListening(*pStyleSheetPool);
/*?*/ 			pStyleSheetPool=0;
/*N*/ 			break;
/*N*/ 		  }
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// Timer nicht aufsetzen, wenn der StyleSheetPool in die Kiste geht, denn
/*N*/ 	// es kann sein, da\s sich ein neuer erst anmeldet, nachdem der Timer
/*N*/ 	// abgelaufen ist - macht sich schlecht in UpdateStyles_Impl() !
/*N*/ 
/*N*/ 	ULONG nId = ((SfxSimpleHint&) rHint).GetId();
/*N*/ 
/*N*/ 	if(!bDontUpdate && nId != SFX_HINT_DYING &&
/*N*/ 	   (rHint.Type() == TYPE(SfxStyleSheetPoolHint)||
/*N*/ 	   rHint.Type() == TYPE(SfxStyleSheetHint) ||
/*N*/ 	   rHint.Type() == TYPE( SfxStyleSheetHintExtended )))
/*N*/ 	{
/*N*/ 		if(!pTimer)
/*N*/ 		{
/*N*/ 			pTimer=new Timer;
/*N*/ 			pTimer->SetTimeout(500);
/*N*/ 			pTimer->SetTimeoutHdl(LINK(this,SfxCommonTemplateDialog_Impl,TimeOut));
/*N*/ 		}
/*N*/ 		pTimer->Start();
/*N*/ 
/*N*/ 	}
/*N*/ }


//-------------------------------------------------------------------------

// Anderer Filter; kann durch den Benutzer umgeschaltet werden
// oder als Folge von Neu oder Bearbeiten, wenn die aktuelle
// Vorlage einem anderen Filter zugewiesen wurde.

//-------------------------------------------------------------------------

// Intern: Ausf"uhren von Funktionen "uber den Dispatcher

//-------------------------------------------------------------------------

// Handler der Listbox der Filter
/*N*/ IMPL_LINK( SfxCommonTemplateDialog_Impl, FilterSelectHdl, ListBox *, pBox )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	return 0;
/*N*/ }

//-------------------------------------------------------------------------

// Select-Handler der Toolbox
/*N*/ void SfxCommonTemplateDialog_Impl::FamilySelect(USHORT nEntry)
/*N*/ {
/*N*/ 	USHORT nFamily = nActFamily;
/*N*/ 	if( nEntry != nActFamily )
/*N*/ 	{
/*N*/ 		CheckItem( nActFamily, FALSE );
/*N*/ 		nActFamily = nEntry;
/*N*/ 		SfxDispatcher* pDispat = pBindings->GetDispatcher_Impl();
/*N*/ 		SfxUInt16Item aItem( SID_STYLE_FAMILY, nEntry );
/*N*/ 		pDispat->Execute( SID_STYLE_FAMILY, SFX_CALLMODE_SYNCHRON, &aItem, 0L );
/*N*/ 		pBindings->Invalidate( SID_STYLE_FAMILY );
/*N*/ 		pBindings->Update( SID_STYLE_FAMILY );
/*N*/ 		UpdateFamily_Impl();
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------



//-------------------------------------------------------------------------


//-------------------------------------------------------------------------

// Handler des Neu-Buttons

//-------------------------------------------------------------------------

// Handler des Bearbeiten-Buttons

//-------------------------------------------------------------------------

// Handler des L"oschen-Buttons

//-------------------------------------------------------------------------

/*N*/ void    SfxCommonTemplateDialog_Impl::EnableDelete()
/*N*/ {
/*N*/ 	if(IsInitialized() && HasSelectedStyle())
/*N*/ 	{
/*N*/ 		DBG_ASSERT(pStyleSheetPool, "Kein StyleSheetPool");
/*N*/ 		const String aTemplName(GetSelectedEntry());
/*N*/ 		const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
/*N*/ 		const SfxStyleFamily eFam = pItem->GetFamily();
/*N*/         USHORT nFilter = 0;
/*N*/         if(pItem->GetFilterList().Count() > nActFilter)
/*N*/             nFilter = pItem->GetFilterList().GetObject(nActFilter)->nFlags;
/*N*/ 		if(!nFilter)    // automatisch
/*N*/ 			nFilter = nAppFilter;
/*N*/ 		const SfxStyleSheetBase *pStyle =
/*N*/ 			pStyleSheetPool->Find(aTemplName,eFam,
/*N*/ 								  pTreeBox? SFXSTYLEBIT_ALL: nFilter);
/*N*/ 		DBG_ASSERT(pStyle, "Style nicht gefunden");
/*N*/ 		if(pStyle && pStyle->IsUserDefined())
/*N*/ 		{
/*N*/ 			EnableDel(TRUE);
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			EnableDel(FALSE);
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		EnableDel(FALSE);
/*N*/ 	}
/*N*/ //	rBindings.Invalidate( SID_STYLE_DELETE );
/*N*/ //	rBindings.Update( SID_STYLE_DELETE );
/*N*/ }

//-------------------------------------------------------------------------

// nach Selektion eines Eintrags den Focus gfs. wieder auf das App-Fenster
// setzen

//-------------------------------------------------------------------------

// Doppelclick auf ein StyleSheet in der ListBox, wird angewendet.
/*?*/ IMPL_LINK( SfxCommonTemplateDialog_Impl, ApplyHdl, Control *, pControl )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

// Selektion einer Vorlage w"ahrend des Watercan-Status
/*N*/ IMPL_LINK( SfxCommonTemplateDialog_Impl, FmtSelectHdl, SvTreeListBox *, pListBox )
/*N*/ {
/*N*/ 	// HilfePI antriggern, wenn von Call als Handler und Bereich erlaubt ist
/*N*/ 	if( !pListBox || pListBox->IsSelected( pListBox->GetHdlEntry() ) )
/*N*/ 	{
/*N*/ #ifdef WIR_KOENNEN_WIEDER_HILFE_FUER_STYLESHEETS
/*N*/ 		SfxHelpPI* pHelpPI = SFX_APP()->GetHelpPI();
/*N*/ 		if ( pHelpPI && pListBox && IsInitialized() &&
/*N*/ 			 GetSelectedEntry().Len() )
/*N*/ 		{
/*N*/ 			const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
/*N*/ 			const SfxStyleFamily eFam = pItem->GetFamily();
/*N*/ 			DBG_ASSERT(pStyleSheetPool, "Kein Pool");
/*N*/ 			// SfxStyleSheetBase* pStyle = pStyleSheetPool
/*N*/ 			//		? pStyleSheetPool->Find( GetSelectedEntry(), eFam ) : 0;
/*N*/ 			SfxStyleSheetBase *pStyle;
/*N*/ 			if ( pStyleSheetPool )
/*N*/ 				pStyle = pStyleSheetPool->Find ( GetSelectedEntry(), eFam );
/*N*/ 			else
/*N*/ 				pStyle = 0;
/*N*/ 
/*N*/ 			if ( pStyle )
/*N*/ 			{
/*N*/ 				String aHelpFile;
/*N*/ 				ULONG nHelpId=pStyle->GetHelpId(aHelpFile);
/*N*/ 				if ( nHelpId )
/*N*/ 					pHelpPI->LoadTopic( nHelpId );
/*N*/ 			}
/*N*/ 		}
/*N*/ #endif
/*N*/ 
/*N*/ 		// nur, wenn Giesskanne an ist
/*N*/ 		if ( IsInitialized() &&
/*N*/ 			 IsCheckedItem(SID_STYLE_WATERCAN) &&
/*N*/ 			 // nur, wenn dieser Bereich erlaubt ist
/*N*/ 			 0 != pFamilyState[nActFamily-1] )
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 		}
/*N*/ //		EnableEdit(TRUE);
/*N*/ 		EnableItem(SID_STYLE_WATERCAN, !bWaterDisabled);
/*N*/ 		EnableDelete();
/*N*/ 	}
/*N*/ 	if( pListBox )
/*N*/ 		SelectStyle( pListBox->GetEntryText( pListBox->GetHdlEntry() ));
/*N*/ 
/*N*/ 	return 0;
/*N*/ }

//-------------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ SfxStyleFamily SfxCommonTemplateDialog_Impl::GetActualFamily() const
/*N*/ {
/*N*/ 	const SfxStyleFamilyItem *pFamilyItem = GetFamilyItem_Impl();
/*N*/ 	if( !pFamilyItem || nActFamily == 0xffff )
/*N*/ 		return SFX_STYLE_FAMILY_PARA;
/*N*/ 	else
/*N*/ 		return pFamilyItem->GetFamily();
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SfxCommonTemplateDialog_Impl::EnableExample_Impl(USHORT nId, BOOL bEnable)
/*N*/ {
/*N*/ 	if( nId == SID_STYLE_NEW_BY_EXAMPLE )
/*N*/ 		bNewByExampleDisabled = !bEnable;
/*N*/ 	else if( nId == SID_STYLE_UPDATE_BY_EXAMPLE )
/*N*/ 		bUpdateByExampleDisabled = !bEnable;
/*N*/ 	EnableItem(nId, bEnable);
/*N*/ }

/*?*/ void SfxCommonTemplateDialog_Impl::PrepareDeleteAction()
/*?*/ {
/*?*/ }

// -----------------------------------------------------------------------

/*?*/ PopupMenu* SfxCommonTemplateDialog_Impl::CreateContextMenu( void )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 
/*?*/ }

// ------------------------------------------------------------------------

/*N*/ SfxTemplateDialog_Impl::SfxTemplateDialog_Impl(
/*N*/ 	Window* pParent, SfxBindings* pB, SfxTemplateDialog* pWindow ) :
/*N*/ 
/*N*/ 	SfxCommonTemplateDialog_Impl( pB, pWindow ),
/*N*/ 
/*N*/ 	m_pFloat			( pWindow ),
/*N*/ 	m_bZoomIn			( FALSE ),
/*N*/ 	m_aActionTbL		( pWindow ),
/*N*/ 	m_aActionTbR		( pWindow, ResId( TB_ACTION ) )
/*N*/ 
/*N*/ {
/*N*/ 
/*N*/ 	pWindow->FreeResource();
/*N*/ 	Initialize();
/*N*/ 
/*N*/ 	m_aActionTbL.SetSelectHdl(LINK(this, SfxTemplateDialog_Impl, ToolBoxLSelect));
/*N*/ 	m_aActionTbR.SetSelectHdl(LINK(this, SfxTemplateDialog_Impl, ToolBoxRSelect));
/*N*/ 	m_aActionTbL.Show();
/*N*/ 	m_aActionTbR.Show();
/*N*/ 	Font aFont=aFilterLb.GetFont();
/*N*/ 	aFont.SetWeight( WEIGHT_NORMAL );
/*N*/ 	aFilterLb.SetFont( aFont );
/*N*/ 	m_aActionTbL.SetHelpId( HID_TEMPLDLG_TOOLBOX_LEFT );
/*N*/ 
/*N*/     SfxImageManager* pImgMgr = pBindings->GetImageManager();
/*N*/     if ( pImgMgr )
/*N*/     {
/*N*/         pImgMgr->RegisterToolBox( &m_aActionTbL, SFX_TOOLBOX_CHANGEOUTSTYLE );
/*N*/         pImgMgr->RegisterToolBox( &m_aActionTbR, SFX_TOOLBOX_CHANGEOUTSTYLE );
/*N*/     }
/*N*/ }

// ------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog_Impl::EnableFamilyItem( USHORT nId, BOOL bEnable )
/*N*/ {
/*N*/ 	m_aActionTbL.EnableItem( nId, bEnable );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog_Impl::InsertFamilyItem(USHORT nId,const SfxStyleFamilyItem *pItem)
/*N*/ {
/*N*/ 	USHORT nHelpId = 0;
/*N*/ 	switch( (USHORT) pItem->GetFamily() )
/*N*/ 	{
/*N*/ 		case SFX_STYLE_FAMILY_CHAR: nHelpId = SID_STYLE_FAMILY1; break;
/*N*/ 		case SFX_STYLE_FAMILY_PARA: nHelpId = SID_STYLE_FAMILY2; break;
/*N*/ 		case SFX_STYLE_FAMILY_FRAME:nHelpId = SID_STYLE_FAMILY3; break;
/*N*/ 		case SFX_STYLE_FAMILY_PAGE: nHelpId = SID_STYLE_FAMILY4; break;
/*N*/ 		case SFX_STYLE_FAMILY_PSEUDO: nHelpId = SID_STYLE_FAMILY5; break;
/*N*/ 		default: DBG_ERROR("unbekannte StyleFamily"); break;
/*N*/ 	}
/*N*/ 	m_aActionTbL.InsertItem( nId, pItem->GetImage(), pItem->GetText(), 0, 0);
/*N*/ 	m_aActionTbL.SetHelpId( nId, nHelpId );
/*N*/ }

// ------------------------------------------------------------------------
/*N*/ void SfxTemplateDialog_Impl::updateFamilyImages()
/*N*/ {
/*N*/ 	if ( !m_pStyleFamiliesId )
/*N*/ 		// we do not have a resource id to load the new images from
/*N*/ 		return;
/*N*/ 
/*N*/ 	// let the families collection update the images
/*N*/ 	sal_Bool bIsHighContrast = m_pFloat->GetDisplayBackground().GetColor().IsDark();
/*N*/ 	pStyleFamilies->updateImages( *m_pStyleFamiliesId, bIsHighContrast ? BMP_COLOR_HIGHCONTRAST : BMP_COLOR_NORMAL );
/*N*/ 
/*N*/ 	// and set the new images on our toolbox
/*N*/ 	USHORT nLoop = pStyleFamilies->Count();
/*N*/ 	for( ; nLoop--; )
/*N*/ 	{
/*N*/ 		const SfxStyleFamilyItem *pItem = pStyleFamilies->GetObject( nLoop );
/*N*/ 		USHORT nId = SfxFamilyIdToNId( (USHORT) pItem->GetFamily() );
/*N*/ 		m_aActionTbL.SetItemImage( nId, pItem->GetImage() );
/*N*/ 	}
/*N*/ }

// ------------------------------------------------------------------------
/*N*/ void SfxTemplateDialog_Impl::updateNonFamilyImages()
/*N*/ {
/*N*/ 	m_aActionTbR.SetImageList( ImageList( SfxResId(
/*N*/ 		m_pFloat->GetDisplayBackground().GetColor().IsDark() ? IMG_LST_STYLE_DESIGNER_HC
/*N*/ 															 : DLG_STYLE_DESIGNER ) ) );
/*N*/ }

// ------------------------------------------------------------------------

/*?*/ void SfxTemplateDialog_Impl::ClearFamilyList()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxCommonTemplateDialog_Impl::InvalidateBindings()
/*N*/ {
/*N*/ 	pBindings->Invalidate(SID_STYLE_NEW_BY_EXAMPLE, TRUE, FALSE);
/*N*/ 	pBindings->Update( SID_STYLE_NEW_BY_EXAMPLE );
/*N*/ 	pBindings->Invalidate(SID_STYLE_UPDATE_BY_EXAMPLE, TRUE, FALSE);
/*N*/ 	pBindings->Update( SID_STYLE_UPDATE_BY_EXAMPLE );
/*N*/ 	pBindings->Invalidate( SID_STYLE_WATERCAN, TRUE, FALSE);
/*N*/ 	pBindings->Update( SID_STYLE_WATERCAN );
/*N*/ 	pBindings->Invalidate( SID_STYLE_NEW, TRUE, FALSE );
/*N*/ 	pBindings->Update( SID_STYLE_NEW );
/*N*/ 	pBindings->Invalidate( SID_STYLE_DRAGHIERARCHIE, TRUE, FALSE );
/*N*/ 	pBindings->Update( SID_STYLE_DRAGHIERARCHIE );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxTemplateDialog_Impl::~SfxTemplateDialog_Impl()
/*N*/ {
/*N*/     SfxImageManager* pImgMgr = pBindings->GetImageManager();
/*N*/     if ( pImgMgr )
/*N*/     {
/*N*/         pImgMgr->ReleaseToolBox( &m_aActionTbL );
/*N*/         pImgMgr->ReleaseToolBox( &m_aActionTbR );
/*N*/     }
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog_Impl::LoadedFamilies()
/*N*/ {
/*N*/ 	updateFamilyImages();
/*N*/ 	Resize();
/*N*/ }

//-------------------------------------------------------------------------

// "Uberladener Resize-Handler ( StarView )
// Die Groesse der Listboxen wird angepasst
/*N*/ void SfxTemplateDialog_Impl::Resize()
/*N*/ {
/*N*/ 	FloatingWindow *pF = m_pFloat->GetFloatingWindow();
/*N*/ 	if ( pF )
/*N*/ 	{
/*N*/ // 		if(pF->IsZoomedIn() && m_bZoomIn==FALSE)
/*N*/ // 			pF->SetText(String(SfxResId( DLG_STYLE_DESIGNER )));
/*N*/ // 		if(!pF->IsZoomedIn() && m_bZoomIn==TRUE && GetFamilyItem_Impl())
/*N*/ // 			UpdateStyles_Impl(UPDATE_FAMILY); //Bereich wieder in Titel schreiben
/*N*/ 		m_bZoomIn = pF->IsRollUp();
/*N*/ 		if ( m_bZoomIn )
/*N*/ 			return;
/*N*/ 	}
/*N*/ 
/*N*/ 	Size aDlgSize=m_pFloat->PixelToLogic(m_pFloat->GetOutputSizePixel());
/*N*/ 	Size aSizeATL=m_pFloat->PixelToLogic(m_aActionTbL.CalcWindowSizePixel());
/*N*/ 	Size aSizeATR=m_pFloat->PixelToLogic(m_aActionTbR.CalcWindowSizePixel());
/*N*/ 	Size aMinSize = GetMinOutputSizePixel();
/*N*/ 
/*N*/ 	long nListHeight = m_pFloat->PixelToLogic( aFilterLb.GetSizePixel() ).Height();
/*N*/ 	long nWidth = aDlgSize.Width()- 2 * SFX_TEMPLDLG_HFRAME;
/*N*/ 
/*N*/ 	m_aActionTbL.SetPosSizePixel(m_pFloat->LogicToPixel(Point(SFX_TEMPLDLG_HFRAME,SFX_TEMPLDLG_VTOPFRAME)),
/*N*/ 								 m_pFloat->LogicToPixel(aSizeATL));
/*N*/ 
/*N*/ 	// Die Position der rechten Toolbox nur ver"andern, wenn das Fenster
/*N*/ 	// breit genug ist
/*N*/ 	Point aPosATR(aDlgSize.Width()-SFX_TEMPLDLG_HFRAME-aSizeATR.Width(),SFX_TEMPLDLG_VTOPFRAME);
/*N*/ 	if(aDlgSize.Width() >= aMinSize.Width())
/*N*/ 		m_aActionTbR.SetPosPixel(m_pFloat->LogicToPixel(aPosATR));
/*N*/ 	else
/*N*/ 		m_aActionTbR.SetPosPixel( m_pFloat->LogicToPixel(
/*N*/ 			Point( SFX_TEMPLDLG_HFRAME + aSizeATL.Width() + SFX_TEMPLDLG_MIDHSPACE,
/*N*/ 				   SFX_TEMPLDLG_VTOPFRAME ) ) );
/*N*/ 
/*N*/ 	m_aActionTbR.SetSizePixel(m_pFloat->LogicToPixel(aSizeATR));
/*N*/ 
/*N*/ 	Point aFilterPos(
/*N*/ 		m_pFloat->LogicToPixel(Point(SFX_TEMPLDLG_HFRAME,
/*N*/ 			aDlgSize.Height()-SFX_TEMPLDLG_VBOTFRAME-nListHeight)) );
/*N*/ 
/*N*/ 	Size aFilterSize(
/*N*/ 		m_pFloat->LogicToPixel(Size(nWidth,SFX_TEMPLDLG_FILTERHEIGHT)) );
/*N*/ 
/*N*/ 	Point aFmtPos(
/*N*/ 		m_pFloat->LogicToPixel(Point(SFX_TEMPLDLG_HFRAME, SFX_TEMPLDLG_VTOPFRAME +
/*N*/ 							SFX_TEMPLDLG_MIDVSPACE+aSizeATL.Height())) );
/*N*/ 	Size aFmtSize(
/*N*/ 		m_pFloat->LogicToPixel(Size(nWidth,
/*N*/ 					aDlgSize.Height() - SFX_TEMPLDLG_VBOTFRAME -
/*N*/ 					SFX_TEMPLDLG_VTOPFRAME - 2*SFX_TEMPLDLG_MIDVSPACE-
/*N*/ 					nListHeight-aSizeATL.Height())) );
/*N*/ 
/*N*/ 	// Die Position der Listboxen nur ver"andern, wenn das Fenster
/*N*/ 	// hoch genug ist
/*N*/ 	if(aDlgSize.Height() >= aMinSize.Height())
/*N*/ 	{
/*N*/ 		aFilterLb.SetPosPixel(aFilterPos);
/*N*/ 		aFmtLb.SetPosPixel(	aFmtPos );
/*N*/ 		if(pTreeBox)
/*?*/ 			pTreeBox->SetPosPixel(aFmtPos);
/*N*/ 	}
/*N*/ 	else
/*?*/ 		aFmtSize.Height() += aFilterSize.Height();
/*N*/ 
/*N*/ 	aFilterLb.SetSizePixel(aFilterSize);
/*N*/ 	aFmtLb.SetSizePixel( aFmtSize );
/*N*/ 	if(pTreeBox)
/*?*/ 		pTreeBox->SetSizePixel(aFmtSize);
/*N*/ }

// -----------------------------------------------------------------------


/*N*/ Size SfxTemplateDialog_Impl::GetMinOutputSizePixel()
/*N*/ {
/*N*/ 	Size aSizeATL=m_pFloat->PixelToLogic(m_aActionTbL.CalcWindowSizePixel());
/*N*/ 	Size aSizeATR=m_pFloat->PixelToLogic(m_aActionTbR.CalcWindowSizePixel());
/*N*/ 	Size aMinSize=Size(
/*N*/ 		aSizeATL.Width()+aSizeATR.Width()+
/*N*/ 		2*SFX_TEMPLDLG_HFRAME + SFX_TEMPLDLG_MIDHSPACE,
/*N*/ 		4*aSizeATL.Height()+2*SFX_TEMPLDLG_MIDVSPACE);
/*N*/ 	return aMinSize;
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxTemplateDialog_Impl::Command( const CommandEvent& rCEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog_Impl::EnableItem(USHORT nMesId, BOOL bCheck)
/*N*/ {
/*N*/ 	String aEmpty;
/*N*/ 	switch(nMesId)
/*N*/ 	{
/*N*/ 	  case SID_STYLE_WATERCAN :
/*N*/ 		  if(!bCheck && IsCheckedItem(SID_STYLE_WATERCAN))
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 Execute_Impl(SID_STYLE_WATERCAN, aEmpty, aEmpty, 0);
/*N*/ 	  case SID_STYLE_NEW_BY_EXAMPLE:
/*N*/ 	  case SID_STYLE_UPDATE_BY_EXAMPLE:
/*N*/ 		m_aActionTbR.EnableItem(nMesId,bCheck);
/*N*/ 		break;
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog_Impl::CheckItem(USHORT nMesId, BOOL bCheck)
/*N*/ {
/*N*/ 	switch(nMesId)
/*N*/ 	{
/*N*/ 		case SID_STYLE_WATERCAN :
/*N*/ 			bIsWater=bCheck;
/*N*/ 			m_aActionTbR.CheckItem(SID_STYLE_WATERCAN,bCheck);
/*N*/ 			break;
/*N*/ 		default:
/*N*/ 			m_aActionTbL.CheckItem(nMesId,bCheck); break;
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ BOOL SfxTemplateDialog_Impl::IsCheckedItem(USHORT nMesId)
/*N*/ {
/*N*/ 	switch(nMesId)
/*N*/ 	{
/*N*/ 		case SID_STYLE_WATERCAN :
/*N*/ 			return m_aActionTbR.GetItemState(SID_STYLE_WATERCAN)==STATE_CHECK;
/*N*/ 		default:
/*?*/ 			return m_aActionTbL.GetItemState(nMesId)==STATE_CHECK;
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ IMPL_LINK_INLINE_START( SfxTemplateDialog_Impl, ToolBoxLSelect, ToolBox *, pBox )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
/*?*/ }
/*?*/ IMPL_LINK_INLINE_END( SfxTemplateDialog_Impl, ToolBoxLSelect, ToolBox *, pBox )

//-------------------------------------------------------------------------

/*?*/ IMPL_LINK_INLINE_START( SfxTemplateDialog_Impl, ToolBoxRSelect, ToolBox *, pBox )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
/*?*/ }
/*?*/ IMPL_LINK_INLINE_END( SfxTemplateDialog_Impl, ToolBoxRSelect, ToolBox *, pBox )

//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------



//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------


//-------------------------------------------------------------------------

// Der Katalog muss nur das Disablen beherrschen, da waehrend seiner
// Lebenszeit keine Selektionsaenderungen vorgenommen werden koennen





/*N*/ void SfxCommonTemplateDialog_Impl::SetFamily( USHORT nId )
/*N*/ {
/*N*/ 	if ( nId != nActFamily )
/*N*/ 	{
/*?*/ 		if ( nActFamily != 0xFFFF )
/*?*/ 			CheckItem( nActFamily, FALSE );
/*?*/ 		nActFamily = nId;
/*?*/ 		if ( nId != 0xFFFF )
/*?*/ 			bUpdateFamily = TRUE;
/*N*/ 	}
/*N*/ }

/*N*/ void SfxCommonTemplateDialog_Impl::UpdateFamily_Impl()
/*N*/ {
/*N*/ 	bUpdateFamily = FALSE;
/*N*/ 
/*N*/ 	SfxDispatcher* pDispat = pBindings->GetDispatcher_Impl();
/*N*/ 	SfxViewFrame *pViewFrame = pDispat->GetFrame();
/*N*/ 	SfxObjectShell *pDocShell = pViewFrame->GetObjectShell();
/*N*/ 
/*N*/ 	SfxStyleSheetBasePool *pOldStyleSheetPool = pStyleSheetPool;
/*N*/ 	pStyleSheetPool = pDocShell? pDocShell->GetStyleSheetPool(): 0;
/*N*/ 	if ( pOldStyleSheetPool != pStyleSheetPool )
/*N*/ 	{
/*?*/ 		if ( pOldStyleSheetPool )
/*?*/ 			EndListening(*pOldStyleSheetPool);
/*?*/ 		if ( pStyleSheetPool )
/*?*/ 			StartListening(*pOldStyleSheetPool);
/*N*/ 	}
/*N*/ 
/*N*/ 	bWaterDisabled = FALSE;
/*N*/ 	bCanNew = TRUE;
/*N*/ 	bTreeDrag = TRUE;
/*N*/ 	bUpdateByExampleDisabled = FALSE;
/*N*/ 
/*N*/ 	if ( pStyleSheetPool )
/*N*/ 	{
/*N*/ 		if(!pTreeBox)
/*N*/ 			UpdateStyles_Impl(UPDATE_FAMILY | UPDATE_FAMILY_LIST);
/*N*/ 		else
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	InvalidateBindings();
/*N*/ 
/*N*/ 	if ( IsCheckedItem( SID_STYLE_WATERCAN ) &&
/*N*/ 		 // nur, wenn dieser Bereich erlaubt ist
/*N*/ 		 0 != pFamilyState[ nActFamily - 1 ] )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 Execute_Impl( SID_STYLE_APPLY, GetSelectedEntry(),
/*N*/ }

/*N*/ void SfxTemplateDialog::StateChanged( StateChangedType nStateChange )
/*N*/ {
/*N*/ 	if ( nStateChange == STATE_CHANGE_INITSHOW )
/*N*/ 	{
/*N*/ 		SfxViewFrame *pFrame = GetBindings().GetDispatcher_Impl()->GetFrame();
/*N*/ 		Window* pEditWin = pFrame->GetViewShell()->GetWindow();
/*N*/ 
/*N*/ 		Size aSize = pEditWin->GetSizePixel();
/*N*/ 		Point aPoint = pEditWin->OutputToScreenPixel( pEditWin->GetPosPixel() );
/*N*/ 		aPoint = GetParent()->ScreenToOutputPixel( aPoint );
/*N*/ 		Size aWinSize = GetSizePixel();
/*N*/ 		aPoint.X() += aSize.Width() - aWinSize.Width() - 20;
/*N*/ 		aPoint.Y() += aSize.Height() / 2 - aWinSize.Height() / 2;
/*N*/ 		SetFloatingPos( aPoint );
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxDockingWindow::StateChanged( nStateChange );
/*N*/ }


}
