/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_childwin.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:56:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif
#ifndef _RCID_H
#include <tools/rcid.h>
#endif
#ifndef INCLUDED_SVTOOLS_VIEWOPTIONS_HXX
#include <svtools/viewoptions.hxx>
#endif

#ifndef _COM_SUN_STAR_UTIL_XCLOSEABLE_HPP_
#include <com/sun/star/util/XCloseable.hpp>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#pragma hdrstop

#include "arrdecl.hxx"
#include "module.hxx"
#include "dispatch.hxx"
#include <workwin.hxx>
namespace binfilter {

static const sal_uInt16 nVersion = 2;

DBG_NAME(SfxChildWindow)

SV_IMPL_PTRARR( SfxChildWinContextArr_Impl, SfxChildWinContextFactory* );

struct SfxChildWindow_Impl
{
	::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > 			xFrame;
    ::com::sun::star::uno::Reference< ::com::sun::star::lang::XEventListener >      xListener;
	SfxChildWinFactory* pFact;
	sal_Bool				bHideNotDelete;
	sal_Bool				bVisible;
	sal_Bool				bHideAtToggle;
	sal_Bool				bWantsFocus;
	SfxModule*			pContextModule;
	SfxWorkWindow*		pWorkWin;
};

// -----------------------------------------------------------------------

class DisposeListener : public ::cppu::WeakImplHelper1< ::com::sun::star::lang::XEventListener >
{
    public:
        DisposeListener( SfxChildWindow*      pOwner ,
                         SfxChildWindow_Impl* pData  )
            :   m_pOwner( pOwner )
            ,   m_pData ( pData  )
        {}

/*?*/         virtual void SAL_CALL disposing( const ::com::sun::star::lang::EventObject& aSource ) throw (::com::sun::star::uno::RuntimeException)
/*?*/         {
/*?*/             ::com::sun::star::uno::Reference< ::com::sun::star::lang::XEventListener > xSelfHold( this );
/*?*/ 
/*?*/             ::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent > xComp( aSource.Source, ::com::sun::star::uno::UNO_QUERY );
/*?*/             if( xComp.is() )
/*?*/                 xComp->removeEventListener( this );
/*?*/ 
/*?*/             if( m_pOwner && m_pData )
/*?*/             {
/*?*/ 	            m_pData->xListener = ::com::sun::star::uno::Reference< ::com::sun::star::lang::XEventListener >();
/*?*/ 
/*?*/ 				if ( m_pData->pWorkWin )
/*?*/ 				{
/*?*/ 					// m_pOwner and m_pData will be killed
/*?*/ 		            m_pData->xFrame    = ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >();
/*?*/ 	                m_pData->pWorkWin->GetBindings().Execute( m_pOwner->GetType() );
/*?*/ 				}
/*?*/ 				else
/*?*/ 				{
/*?*/ 					delete m_pOwner;
/*?*/ 				}
/*?*/ 
/*?*/                 m_pOwner = NULL;
/*?*/                 m_pData  = NULL;
/*?*/             }
/*?*/         }

    private:
        SfxChildWindow*      m_pOwner;
        SfxChildWindow_Impl* m_pData ;
};

// -----------------------------------------------------------------------

/*N*/ sal_Bool GetPosSizeFromString( const String& rStr, Point& rPos, Size& rSize )
/*N*/ {
/*N*/ 	if ( rStr.GetTokenCount('/') != 4 )
/*N*/ 		return sal_False;
/*N*/ 
/*N*/ 	xub_StrLen nIdx = 0;
/*N*/ 	rPos.X() = rStr.GetToken(0, '/', nIdx).ToInt32();
/*N*/ 	rPos.Y() = rStr.GetToken(0, '/', nIdx).ToInt32();
/*N*/ 	rSize.Width() = rStr.GetToken(0, '/', nIdx).ToInt32();
/*N*/ 	rSize.Height() = rStr.GetToken(0, '/', nIdx).ToInt32();
/*N*/ 
/*N*/ 	// negative sizes are invalid
/*N*/ 	if ( rSize.Width() < 0 || rSize.Height() < 0 )
/*N*/ 		return sal_False;
/*N*/ 
/*N*/ 	return sal_True;
/*N*/ }

//=========================================================================
/*N*/ SfxChildWindow::SfxChildWindow(Window *pParentWindow, sal_uInt16 nId)
/*N*/ 	: pParent(pParentWindow)
/*N*/ 	, eChildAlignment(SFX_ALIGN_NOALIGNMENT)
/*N*/ 	, nType(nId)
/*N*/ 	, pWindow(0L)
/*N*/ {
/*N*/ 	pImp = new SfxChildWindow_Impl;
/*N*/ 	pImp->pFact = 0L;
/*N*/ 	pImp->bHideNotDelete = sal_False;
/*N*/ 	pImp->bHideAtToggle = sal_False;
/*N*/ 	pImp->bWantsFocus = sal_True;
/*N*/ 	pImp->bVisible = sal_True;
/*N*/ 	pImp->pContextModule = NULL;
/*N*/ 	pImp->pWorkWin = NULL;
/*N*/ 
/*N*/ 	pContext = 0L;
/*N*/ 	DBG_CTOR(SfxChildWindow,0);
/*N*/ }

/*N*/ void SfxChildWindow::Destroy()
/*N*/ {
/*N*/ 	if ( GetFrame().is() )
/*?*/ 	{
/*?*/ 		pImp->pWorkWin = NULL;
/*?*/ 		try
/*?*/ 		{
/*?*/ 			::com::sun::star::uno::Reference < ::com::sun::star::util::XCloseable > xClose( GetFrame(), ::com::sun::star::uno::UNO_QUERY );
/*?*/ 			if ( xClose.is() )
/*?*/ 				xClose->close( sal_True );
/*?*/ 			else
/*?*/ 				GetFrame()->dispose();
/*?*/ 		}
/*?*/ 		catch ( ::com::sun::star::uno::Exception& )
/*?*/ 		{
/*?*/ 		}
/*?*/ 	}
/*N*/ 	else
/*N*/ 		delete this;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ SfxChildWindow::~SfxChildWindow()
/*N*/ {
/*N*/ 	DBG_DTOR(SfxChildWindow,0);
/*N*/ 	if ( pContext )
/*N*/ 		delete pContext;
/*N*/ 	if ( pWindow )
/*N*/ 	    delete pWindow;
/*N*/ 	delete pImp;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ SfxChildWindow* SfxChildWindow::CreateChildWindow( sal_uInt16 nId,
/*N*/ 		Window *pParent, SfxBindings* pBindings, SfxChildWinInfo& rInfo)
/*N*/ {
/*N*/ 	SfxChildWindow *pChild=0;
/*N*/ 	SfxChildWinFactory* pFact=0;
/*N*/     sal_uInt16 nOldMode = Application::GetSystemWindowMode();
/*N*/ 
/*N*/ 	// Zuerst ChildWindow im SDT suchen; "Uberlagerungen m"ussen mit einem
/*N*/ 	// ChildWindowContext realisiert werden
/*N*/ 	SfxApplication *pApp = SFX_APP();
/*N*/ 	SfxChildWinFactArr_Impl &rFactories = pApp->GetChildWinFactories_Impl();
/*N*/ 	for ( sal_uInt16 nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 	{
/*N*/ 		pFact = rFactories[nFactory];
/*N*/ 		if ( pFact->nId == nId )
/*N*/ 		{
/*N*/ 			SfxChildWinInfo& rFactInfo = pFact->aInfo;
/*N*/ 			if ( rInfo.bVisible )
/*N*/ 			{
/*N*/ 				if ( pBindings )
/*N*/ 					pBindings->ENTERREGISTRATIONS();
/*N*/ 				rFactInfo.nFlags |= rInfo.nFlags & SFX_CHILDWIN_FORCEDOCK;
/*N*/ 				SfxChildWinInfo aInfo = rFactInfo;
/*N*/                 Application::SetSystemWindowMode( SYSTEMWINDOW_MODE_NOAUTOMODE );
/*N*/ 				pChild = pFact->pCtor( pParent, nId, pBindings, &aInfo );
/*N*/                 Application::SetSystemWindowMode( nOldMode );
/*N*/ 				rFactInfo.nFlags &= ~(rInfo.nFlags & SFX_CHILDWIN_FORCEDOCK );
/*N*/ 				if ( pBindings )
/*N*/ 					pBindings->LEAVEREGISTRATIONS();
/*N*/ 			}
/*N*/ 
/*N*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxDispatcher *pDisp = pBindings->GetDispatcher_Impl();
/*N*/ 	SfxModule *pMod = pDisp ? pApp->GetActiveModule( pDisp->GetFrame() ) :0;
/*N*/ 	if ( !pChild &&  pMod )
/*N*/ 	{
/*N*/ 		SfxChildWinFactArr_Impl *pFactories = pMod->GetChildWinFactories_Impl();
/*N*/ 		if ( pFactories )
/*N*/ 		{
/*N*/ 			SfxChildWinFactArr_Impl &rFactories = *pFactories;
/*N*/ 			for ( sal_uInt16 nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 			{
/*N*/ 				pFact = rFactories[nFactory];
/*N*/ 				if ( pFact->nId == nId )
/*N*/ 				{
/*N*/ 					SfxChildWinInfo& rFactInfo = pFact->aInfo;
/*N*/ 					if ( rInfo.bVisible )
/*N*/ 					{
/*N*/ 						if ( pBindings )
/*N*/ 							pBindings->ENTERREGISTRATIONS();
/*N*/ 						rFactInfo.nFlags |= rInfo.nFlags & SFX_CHILDWIN_FORCEDOCK;
/*N*/ 						SfxChildWinInfo aInfo = rFactInfo;
/*N*/                         Application::SetSystemWindowMode( SYSTEMWINDOW_MODE_NOAUTOMODE );
/*N*/ 						pChild = pFact->pCtor( pParent, nId, pBindings, &aInfo );
/*N*/                         Application::SetSystemWindowMode( nOldMode );
/*N*/ 						rFactInfo.nFlags &= ~(rInfo.nFlags & SFX_CHILDWIN_FORCEDOCK );
/*N*/ 						if ( pBindings )
/*N*/ 							pBindings->LEAVEREGISTRATIONS();
/*N*/ 					}
/*N*/ 
/*N*/ 					break;
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pChild )
/*N*/ 		pChild->SetFactory_Impl( pFact );
/*N*/ 
/*N*/ 	DBG_ASSERT(pFact && (pChild || !rInfo.bVisible), "ChildWindow-Typ nicht registriert!");
/*N*/ 
/*N*/ 	if ( pChild && !pChild->pWindow )
/*N*/ 	{
/*N*/ 		DELETEZ(pChild);
/*N*/ 		DBG_WARNING("ChildWindow hat kein Fenster!");
/*N*/ 	}
/*N*/ 
/*N*/ 	return pChild;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxChildWindow::SaveStatus(const SfxChildWinInfo& rInfo)
/*N*/ {
/*N*/     sal_uInt16 nID = GetType();
/*N*/ 
/*N*/     String aWinData( 'V' );
/*N*/     aWinData += String::CreateFromInt32( nVersion );
/*N*/     aWinData += ',';
/*N*/     aWinData += rInfo.bVisible ? 'V' : 'H';
/*N*/     aWinData += ',';
/*N*/     aWinData += String::CreateFromInt32( rInfo.nFlags );
/*N*/     if ( rInfo.aExtraString.Len() )
/*N*/     {
/*N*/         aWinData += ',';
/*N*/         aWinData += rInfo.aExtraString;
/*N*/     }
/*N*/ 
/*N*/     SvtViewOptions aWinOpt( E_WINDOW, String::CreateFromInt32( nID ) );
/*N*/     // aWinOpt.SetPosition( rInfo.aPos.X(), rInfo.aPos.Y() );
/*N*/     // aWinOpt.SetSize( rInfo.aSize.Width(), rInfo.aSize.Height() );
/*N*/     aWinOpt.SetWindowState( String( rInfo.aWinState, RTL_TEXTENCODING_UTF8 ) );
/*N*/ 
/*N*/     ::com::sun::star::uno::Sequence < ::com::sun::star::beans::NamedValue > aSeq(1);
/*N*/     aSeq[0].Name = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("Data") );
/*N*/     aSeq[0].Value <<= ::rtl::OUString( aWinData );
/*N*/     aWinOpt.SetUserData( aSeq );
/*N*/ 
/*N*/     // ... but save status at runtime!
/*N*/     pImp->pFact->aInfo = rInfo;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxChildWindow::SetAlignment(SfxChildAlignment eAlign)
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxChildWindow,0);
/*N*/ 
/*N*/ 	eChildAlignment = eAlign;
/*N*/ }

//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
/*N*/ SfxChildWinInfo SfxChildWindow::GetInfo() const
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxChildWindow,0);
/*N*/ 
/*N*/ 	SfxChildWinInfo aInfo;
/*N*/ 	aInfo.aPos	= pWindow->GetPosPixel();
/*N*/ 	aInfo.aSize = pWindow->GetSizePixel();
/*N*/     if ( pWindow->IsSystemWindow() )
/*N*/     {
/*N*/         ULONG nMask = WINDOWSTATE_MASK_POS | WINDOWSTATE_MASK_STATE;
/*N*/         if ( pWindow->GetStyle() & WB_SIZEABLE )
/*N*/             nMask |= ( WINDOWSTATE_MASK_WIDTH | WINDOWSTATE_MASK_HEIGHT );
/*N*/         aInfo.aWinState = ((SystemWindow*)pWindow)->GetWindowState( nMask );
/*N*/     }
/*N*/     else if ( pWindow->GetType() == RSC_DOCKINGWINDOW && ((DockingWindow*)pWindow)->GetFloatingWindow() )
/*N*/         aInfo.aWinState = ((DockingWindow*)pWindow)->GetFloatingWindow()->GetWindowState();
/*N*/ 
/*N*/ 	aInfo.bVisible = pImp->bVisible;
/*N*/ 	aInfo.nFlags = 0;
/*N*/ 	return aInfo;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ sal_uInt16 SfxChildWindow::GetPosition()
/*N*/ {
/*N*/ 	return pImp->pFact->nPos;
/*N*/ }

/*?*/ static void ImplWindowStateFromStr( Point rPos, Size rSize, const ByteString& rStr )
/*?*/ {
/*?*/     ULONG       nValidMask  = 0;
/*?*/     xub_StrLen  nIndex      = 0;
/*?*/     ByteString  aTokenStr;
/*?*/ 
/*?*/     aTokenStr = rStr.GetToken( 0, ',', nIndex );
/*?*/     if ( aTokenStr.Len() )
/*?*/     {
/*?*/         rPos.X() = aTokenStr.ToInt32();
/*?*/         nValidMask |= WINDOWSTATE_MASK_X;
/*?*/     }
/*?*/ 
/*?*/     aTokenStr = rStr.GetToken( 0, ',', nIndex );
/*?*/     if ( aTokenStr.Len() )
/*?*/     {
/*?*/         rPos.Y() = aTokenStr.ToInt32();
/*?*/         nValidMask |= WINDOWSTATE_MASK_Y;
/*?*/     }
/*?*/ 
/*?*/     aTokenStr = rStr.GetToken( 0, ',', nIndex );
/*?*/     if ( aTokenStr.Len() )
/*?*/     {
/*?*/         rSize.Width() = aTokenStr.ToInt32();
/*?*/         nValidMask |= WINDOWSTATE_MASK_WIDTH;
/*?*/     }
/*?*/ 
/*?*/     aTokenStr = rStr.GetToken( 0, ';', nIndex );
/*?*/     if ( aTokenStr.Len() )
/*?*/     {
/*?*/         rSize.Height() = aTokenStr.ToInt32();
/*?*/         nValidMask |= WINDOWSTATE_MASK_HEIGHT;
/*?*/     }
/*?*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxChildWindow::InitializeChildWinFactory_Impl( sal_uInt16 nId, SfxChildWinInfo& rInfo )
/*N*/ {
/*N*/ 	// load configuration
/*N*/ 	SvtViewOptions aWinOpt( E_WINDOW, String::CreateFromInt32( nId ) );
/*N*/     ::com::sun::star::uno::Sequence < ::com::sun::star::beans::NamedValue > aSeq = aWinOpt.GetUserData();
/*N*/     ::rtl::OUString aTmp;
/*N*/     if ( aSeq.getLength() )
/*N*/         aSeq[0].Value >>= aTmp;
/*N*/ 
/*N*/     String aWinData( aTmp );
/*N*/     rInfo.aWinState = ByteString( String(aWinOpt.GetWindowState()), RTL_TEXTENCODING_UTF8 );
/*N*/     //ImplWindowStateFromStr( rInfo.aPos, rInfo.aSize, ByteString( aWinState, RTL_TEXTENCODING_UTF8 ) );
/*N*/ 
/*N*/     if ( aWinData.Len() )
/*N*/ 	{
/*N*/ 		// Nach Versionskennung suchen
/*N*/ 		if ( aWinData.GetChar((sal_uInt16)0) != 0x0056 ) // 'V' = 56h
/*N*/ 			// Keine Versionskennung, daher nicht verwenden
/*N*/ 			return;
/*N*/ 
/*N*/ 		// 'V' l"oschen
/*N*/ 		aWinData.Erase(0,1);
/*N*/ 
/*N*/ 		// Version lesen
/*N*/ 		char cToken = ',';
/*N*/ 		sal_uInt16 nPos = aWinData.Search( cToken );
/*N*/         sal_uInt16 nActVersion = (sal_uInt16)aWinData.Copy( 0, nPos + 1 ).ToInt32();
/*N*/         if ( nActVersion != nVersion )
/*N*/             return;
/*N*/ 
/*N*/ 		aWinData.Erase(0,nPos+1);
/*N*/ 
/*N*/         //aWinOpt.GetPosition( rInfo.aPos.X(), rInfo.aPos.Y() );
/*N*/         //aWinOpt.GetSize( rInfo.aSize.Width(), rInfo.aSize.Height() );
/*N*/ 
/*N*/ 		// Sichtbarkeit laden: ist als ein char codiert
/*N*/         rInfo.bVisible = (aWinData.GetChar(0) == 0x0056); // 'V' = 56h
/*N*/         aWinData.Erase(0,1);
/*N*/         nPos = aWinData.Search( cToken );
/*N*/ 		if (nPos != STRING_NOTFOUND)
/*N*/ 		{
/*N*/             USHORT nNextPos = aWinData.Search( cToken, 2 );
/*N*/             if ( nNextPos != STRING_NOTFOUND )
/*N*/             {
/*N*/                 // es gibt noch Extra-Information
/*N*/                 rInfo.nFlags = (sal_uInt16)aWinData.Copy( nPos+1, nNextPos - nPos - 1 ).ToInt32();
/*N*/                 aWinData.Erase( nPos, nNextPos-nPos+1 );
/*N*/                 rInfo.aExtraString = aWinData;
/*N*/             }
/*N*/             else
/*N*/                 rInfo.nFlags = (sal_uInt16)aWinData.Copy( nPos+1 ).ToInt32();
/*N*/ 		}
/*N*/ 	}
/*N*/ }


/*N*/ SfxChildWindowContext::SfxChildWindowContext( sal_uInt16 nId )
/*N*/ 	: pWindow( NULL )
/*N*/ 	, nContextId( nId )
/*N*/ {
/*N*/ }

/*N*/ SfxChildWindowContext::~SfxChildWindowContext()
/*N*/ {
/*N*/ 	delete pWindow;
/*N*/ }



/*N*/ void SfxChildWindowContext::Resizing( Size& rSize )
/*N*/ {
/*N*/ }

/*N*/ sal_Bool SfxChildWindowContext::Close()
/*N*/ {
/*N*/ 	return sal_True;
/*N*/ }

/*N*/ void SfxChildWindow::SetFactory_Impl( SfxChildWinFactory *pF )
/*N*/ {
/*N*/ 	pImp->pFact = pF;
/*N*/ }










/*N*/ void SfxChildWindow::Hide()
/*N*/ {
/*N*/ 	switch ( pWindow->GetType() )
/*N*/ 	{
/*N*/ 		case RSC_DOCKINGWINDOW :
/*N*/ 			((DockingWindow*)pWindow)->Hide();
/*N*/ 			break;
/*N*/ 		case RSC_TOOLBOX :
/*N*/ 			((ToolBox*)pWindow)->Hide();
/*N*/ 			break;
/*N*/ 		default:
/*N*/ 			pWindow->Hide();
/*N*/ 			break;
/*N*/ 	}
/*N*/ }



/*N*/ void SfxChildWindow::Show( USHORT nFlags )
/*N*/ {
/*N*/ 	switch ( pWindow->GetType() )
/*N*/ 	{
/*N*/ 		case RSC_DOCKINGWINDOW :
/*N*/             ((DockingWindow*)pWindow)->Show( TRUE, nFlags );
/*N*/ 			break;
/*N*/ 		case RSC_TOOLBOX :
/*?*/             ((ToolBox*)pWindow)->Show( TRUE, nFlags );
/*N*/ 			break;
/*N*/ 		default:
/*N*/             pWindow->Show( TRUE, nFlags );
/*N*/ 			break;
/*N*/ 	}
/*N*/ }


/*N*/ void SfxChildWindow::SetWorkWindow_Impl( SfxWorkWindow* pWin )
/*N*/ {
/*N*/ 	pImp->pWorkWin = pWin;
/*N*/ 	if ( pWin && pWindow->HasChildPathFocus() )
/*?*/ 		pImp->pWorkWin->SetActiveChild_Impl( pWindow );
/*N*/ }

//SfxWorkWindow* SfxChildWindow::GetWorkWindow_Impl() const
//{
//	return pImp->pWorkWin;
//}


/*N*/ void SfxChildWindow::Deactivate_Impl()
/*N*/ {
/*N*/ //	pImp->pWorkWin->SetActiveChild_Impl( NULL );
/*N*/ }

/*N*/ sal_Bool SfxChildWindow::QueryClose()
/*N*/ {
/*N*/ 	if ( pImp->xFrame.is() )
/*N*/ 	{
/*?*/ 		::com::sun::star::uno::Reference< ::com::sun::star::frame::XController >  xCtrl = pImp->xFrame->getController();
/*?*/ 		if ( xCtrl.is() )
/*?*/ 			xCtrl->suspend( sal_True );
/*N*/ 	}
/*N*/ 
/*N*/ 	return sal_True;
/*N*/ }

/*N*/ ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >  SfxChildWindow::GetFrame()
/*N*/ {
/*N*/ 	return pImp->xFrame;
/*N*/ }


/*N*/ sal_Bool SfxChildWindow::CanGetFocus() const
/*N*/ {
/*N*/ 	return !(pImp->pFact->aInfo.nFlags & SFX_CHILDWIN_CANTGETFOCUS);
/*N*/ }

}
