/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_zoomlist.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2007/01/02 17:14:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif

#pragma hdrstop

#include "zoomlist.hxx"
namespace binfilter {

#define MAX_ENTRYS	10

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ ZoomList::ZoomList( SfxViewShell* pViewShell )
/*N*/ 	: List(),
/*N*/ 	pViewSh( pViewShell ),
/*N*/ 	nCurPos(0)
/*N*/ {
/*N*/ }


/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ ZoomList::~ZoomList()
/*N*/ {
/*N*/ #if ( defined GCC && defined C272 )
/*N*/ 	for (ULONG nCount=0; nCount<List::Count(); nCount++)
/*N*/ #else
/*N*/ 	for (ULONG nCount=0; nCount<Count(); nCount++)
/*N*/ #endif
/*N*/ 	{
/*N*/ 		// Ggf. ZoomRects loeschen
/*N*/ 		delete ((Rectangle*) GetObject(nCount));
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Gibt es ein naechstes ZoomRect?
|*
\************************************************************************/

/*N*/ BOOL ZoomList::IsNextPossible() const
/*N*/ {
/*N*/ 	BOOL bPossible = FALSE;
/*N*/ 	ULONG nCount = Count();
/*N*/ 
/*N*/ 	if (nCount > 0 && nCurPos < nCount - 1)
/*N*/ 	{
/*N*/ 		bPossible = TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	return (bPossible);
/*N*/ }

/*************************************************************************
|*
|* Gibt es ein vorheriges ZoomRect?
|*
\************************************************************************/

/*N*/ BOOL ZoomList::IsPreviousPossible() const
/*N*/ {
/*N*/ 	BOOL bPossible = FALSE;
/*N*/ 
/*N*/ 	if (nCurPos > 0)
/*N*/ 	{
/*N*/ 		bPossible = TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	return (bPossible);
/*N*/ }


}
