/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviewse.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:43:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONMODULES_HDL_
#include <com/sun/star/i18n/TransliterationModules.hdl>
#endif


#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif



#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif



#define ITEMID_FIELD	EE_FEATURE_FIELD

// #UndoRedo#

#pragma hdrstop


#include "app.hrc"
#include "glob.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "fusel.hxx"
#include "fuslshow.hxx"
#include "presvish.hxx"
#include "drawview.hxx"
#include "docshell.hxx"

// #97016#

// #98721#
#include "so3/staticbaseurl.hxx"
namespace binfilter {

using namespace ::rtl;
using namespace ::com::sun::star;

#ifdef WNT
#pragma optimize ( "", off )
#endif

/*************************************************************************
|*
|* Permanente Funktionen
|*
\************************************************************************/


/*N*/ void SdDrawViewShell::FuPermanent(SfxRequest& rReq)
/*N*/ {
/*N*/ 	// Waehrend einer Native-Diashow wird nichts ausgefuehrt!
/*?*/ 	if (pFuSlideShow && !pFuSlideShow->IsLivePresentation())
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 return;
/*N*/ 
/*N*/ 	USHORT nSId = rReq.GetSlot();
/*N*/ 
/*N*/ 	if( pFuActual && //STRIP001 pFuActual->ISA(FuText) &&
/*N*/ 		( nSId == SID_TEXTEDIT || nSId == SID_ATTR_CHAR || nSId == SID_TEXT_FITTOSIZE ||
/*N*/ 		  nSId == SID_ATTR_CHAR_VERTICAL || nSId == SID_TEXT_FITTOSIZE_VERTICAL ) )
/*N*/ 	{
/*N*/       DBG_ASSERT(0,"STRIP!");//STRIP001 ((FuText*) pFuActual)->SetPermanent(TRUE);
/*N*/ 	}
/*N*/ 
/*N*/ 	CheckLineTo (rReq);
/*N*/     USHORT nOldSId = 0;
/*N*/     BOOL bPermanent = FALSE;
/*N*/ 
/*N*/ 	if (pFuActual)
/*N*/ 	{
/*?*/ 		if (pFuOld == pFuActual)
/*?*/ 		{
/*?*/ 			pFuOld = NULL;
/*?*/ 		}
/*?*/ 
/*?*/ 		if ( nSId != SID_TEXTEDIT && nSId != SID_ATTR_CHAR && nSId != SID_TEXT_FITTOSIZE &&
/*?*/ 			 nSId != SID_ATTR_CHAR_VERTICAL && nSId != SID_TEXT_FITTOSIZE_VERTICAL &&
/*?*/ 			 pDrView->IsTextEdit() )
/*?*/ 		{
/*?*/ 			pDrView->EndTextEdit();
/*?*/ 		}
/*?*/ 
/*?*/         nOldSId = pFuActual->GetSlotID();
/*?*/ 
/*?*/         if (nOldSId == nSId ||
/*?*/             ((nOldSId == SID_TEXTEDIT || nOldSId == SID_ATTR_CHAR || nOldSId == SID_TEXT_FITTOSIZE ||
/*?*/ 			  nOldSId == SID_ATTR_CHAR_VERTICAL || nOldSId == SID_TEXT_FITTOSIZE_VERTICAL) &&
/*?*/              (nSId == SID_TEXTEDIT || nSId == SID_ATTR_CHAR || nSId == SID_TEXT_FITTOSIZE ||
/*?*/ 			  nSId == SID_ATTR_CHAR_VERTICAL || nSId == SID_TEXT_FITTOSIZE_VERTICAL )))
/*?*/         {
/*?*/             bPermanent = TRUE;
/*?*/         }
/*?*/ 
/*?*/ 		pFuActual->Deactivate();
/*?*/ 		delete pFuActual;
/*?*/ 		pFuActual = NULL;
/*?*/ 
/*?*/ 		SfxBindings& rBind = GetViewFrame()->GetBindings();
/*?*/         rBind.Invalidate(nOldSId);
/*?*/         rBind.Update(nOldSId);
/*N*/ 	}
/*N*/ 
/*N*/ 	// Slot wird gemapped (ToolboxImages/-Slots)
/*N*/ 	MapSlot( nSId );
/*N*/ 
/*N*/     switch ( nSId )
/*N*/ 	{
/*?*/  		case SID_TEXTEDIT:	// BASIC ???
/*?*/  		case SID_ATTR_CHAR:
/*?*/  		case SID_ATTR_CHAR_VERTICAL:
/*?*/  		case SID_TEXT_FITTOSIZE:
/*?*/  		case SID_TEXT_FITTOSIZE_VERTICAL:
/*?*/  		{
/*?*/  			DBG_ASSERT(0,"STRIP!");//STRIP001 pFuActual = new FuText(this, pWindow, pDrView, pDoc, rReq);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_FM_CREATE_CONTROL:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuConstUnoControl(this, pWindow, pDrView, pDoc, rReq);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		// #98721#
/*?*/ 		case SID_FM_CREATE_FIELDCONTROL:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SFX_REQUEST_ARG( rReq, pDescriptorItem, SfxUnoAnyItem, SID_FM_DATACCESS_DESCRIPTOR, sal_False );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_SELECT:
/*?*/ 		case SID_OBJECT_ROTATE:
/*?*/ 		case SID_OBJECT_MIRROR:
/*?*/ 		case SID_OBJECT_TRANSPARENCE:
/*?*/ 		case SID_OBJECT_GRADIENT:
/*?*/ 		case SID_OBJECT_SHEAR:
/*?*/ 		case SID_OBJECT_CROOK_ROTATE:
/*?*/ 		case SID_OBJECT_CROOK_SLANT:
/*?*/ 		case SID_OBJECT_CROOK_STRETCH:
/*N*/         case SID_CONVERT_TO_3D_LATHE:
/*N*/ 		{
/*N*/ 			short nSlotId = rReq.GetSlot();
/*N*/ 
/*N*/ 			if (nSlotId == SID_OBJECT_CROOK_ROTATE ||
/*N*/ 				nSlotId == SID_OBJECT_CROOK_SLANT ||
/*N*/ 				nSlotId == SID_OBJECT_CROOK_STRETCH)
/*N*/ 			{
/*?*/  				if ( pDrView->GetMarkList().GetMarkCount() > 0 &&
/*?*/  				    !pDrView->IsCrookAllowed( pDrView->IsCrookNoContortion() ) )
/*?*/  				{
/*?*/  					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsPresObjSelected() )
/*?*/  				}
/*N*/  			}
/*N*/  			else if (nSlotId == SID_OBJECT_SHEAR)
/*N*/  			{
/*?*/                  DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ULONG i = 0;
/*N*/  			}
/*N*/ 
/*N*/ 			pFuActual = new FuSelection(this, pWindow, pDrView,
/*N*/ 											  pDoc, rReq);
/*N*/ 
/*N*/ 			rReq.Done();
/*N*/ 			Invalidate( SID_OBJECT_SELECT );
/*N*/ 		}
/*N*/ 		break;
/*N*/ 
/*?*/ 		case SID_DRAW_LINE:
/*?*/ 		case SID_DRAW_XLINE:
/*?*/         case SID_DRAW_MEASURELINE:
/*?*/ 		case SID_LINE_ARROW_START:
/*?*/ 		case SID_LINE_ARROW_END:
/*?*/ 		case SID_LINE_ARROWS:
/*?*/ 		case SID_LINE_ARROW_CIRCLE:
/*?*/ 		case SID_LINE_CIRCLE_ARROW:
/*?*/ 		case SID_LINE_ARROW_SQUARE:
/*?*/ 		case SID_LINE_SQUARE_ARROW:
/*?*/ 
/*?*/ 		case SID_DRAW_RECT:
/*?*/ 		case SID_DRAW_RECT_NOFILL:
/*?*/ 		case SID_DRAW_RECT_ROUND:
/*?*/ 		case SID_DRAW_RECT_ROUND_NOFILL:
/*?*/ 		case SID_DRAW_SQUARE:
/*?*/ 		case SID_DRAW_SQUARE_NOFILL:
/*?*/ 		case SID_DRAW_SQUARE_ROUND:
/*?*/ 		case SID_DRAW_SQUARE_ROUND_NOFILL:
/*?*/ 		case SID_DRAW_ELLIPSE:
/*?*/ 		case SID_DRAW_ELLIPSE_NOFILL:
/*?*/ 		case SID_DRAW_CIRCLE:
/*?*/ 		case SID_DRAW_CIRCLE_NOFILL:
/*?*/ 		case SID_DRAW_CAPTION:
/*?*/ 		case SID_DRAW_CAPTION_VERTICAL:
/*?*/ 		case SID_TOOL_CONNECTOR:
/*?*/         case SID_CONNECTOR_ARROW_START:
/*?*/         case SID_CONNECTOR_ARROW_END:
/*?*/         case SID_CONNECTOR_ARROWS:
/*?*/         case SID_CONNECTOR_CIRCLE_START:
/*?*/         case SID_CONNECTOR_CIRCLE_END:
/*?*/         case SID_CONNECTOR_CIRCLES:
/*?*/         case SID_CONNECTOR_LINE:
/*?*/         case SID_CONNECTOR_LINE_ARROW_START:
/*?*/         case SID_CONNECTOR_LINE_ARROW_END:
/*?*/         case SID_CONNECTOR_LINE_ARROWS:
/*?*/         case SID_CONNECTOR_LINE_CIRCLE_START:
/*?*/         case SID_CONNECTOR_LINE_CIRCLE_END:
/*?*/         case SID_CONNECTOR_LINE_CIRCLES:
/*?*/         case SID_CONNECTOR_CURVE:
/*?*/         case SID_CONNECTOR_CURVE_ARROW_START:
/*?*/         case SID_CONNECTOR_CURVE_ARROW_END:
/*?*/         case SID_CONNECTOR_CURVE_ARROWS:
/*?*/         case SID_CONNECTOR_CURVE_CIRCLE_START:
/*?*/         case SID_CONNECTOR_CURVE_CIRCLE_END:
/*?*/         case SID_CONNECTOR_CURVE_CIRCLES:
/*?*/         case SID_CONNECTOR_LINES:
/*?*/         case SID_CONNECTOR_LINES_ARROW_START:
/*?*/         case SID_CONNECTOR_LINES_ARROW_END:
/*?*/         case SID_CONNECTOR_LINES_ARROWS:
/*?*/         case SID_CONNECTOR_LINES_CIRCLE_START:
/*?*/         case SID_CONNECTOR_LINES_CIRCLE_END:
/*?*/         case SID_CONNECTOR_LINES_CIRCLES:
/*?*/         {
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuConstRectangle(this, pWindow, pDrView,
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DRAW_POLYGON:
/*?*/ 		case SID_DRAW_POLYGON_NOFILL:
/*?*/ 		case SID_DRAW_XPOLYGON:
/*?*/ 		case SID_DRAW_XPOLYGON_NOFILL:
/*?*/         case SID_DRAW_FREELINE:
/*?*/         case SID_DRAW_FREELINE_NOFILL:
/*?*/         case SID_DRAW_BEZIER_FILL:          // BASIC
/*?*/         case SID_DRAW_BEZIER_NOFILL:        // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuConstBezPoly(this, pWindow, pDrView,
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_GLUE_EDITMODE:
/*?*/ 		{
/*?*/             if (nOldSId != SID_GLUE_EDITMODE)
/*?*/             {
/*?*/                 DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuEditGluePoints( this, pWindow, pDrView, pDoc, rReq );
/*?*/             }
/*?*/             else
/*?*/             {
/*?*/ 				GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);
/*?*/             }
/*?*/ 
/*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DRAW_ARC:
/*?*/ 		case SID_DRAW_CIRCLEARC:
/*?*/ 		case SID_DRAW_PIE:
/*?*/ 		case SID_DRAW_PIE_NOFILL:
/*?*/ 		case SID_DRAW_CIRCLEPIE:
/*?*/ 		case SID_DRAW_CIRCLEPIE_NOFILL:
/*?*/ 		case SID_DRAW_ELLIPSECUT:
/*?*/ 		case SID_DRAW_ELLIPSECUT_NOFILL:
/*?*/ 		case SID_DRAW_CIRCLECUT:
/*?*/ 		case SID_DRAW_CIRCLECUT_NOFILL:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuConstArc( this, pWindow, pDrView, pDoc, rReq);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_3D_CUBE:
/*?*/ 		case SID_3D_SHELL:
/*?*/ 		case SID_3D_SPHERE:
/*?*/ 		case SID_3D_TORUS:
/*?*/ 		case SID_3D_HALF_SPHERE:
/*?*/ 		case SID_3D_CYLINDER:
/*?*/ 		case SID_3D_CONE:
/*?*/ 		case SID_3D_PYRAMID:
/*?*/ 		{
/*?*/ 			DBG_ASSERT(0,"STRIP!"); //STRIP001 pFuActual = new FuConst3dObj(this, pWindow, pDrView, pDoc, rReq);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		default:
/*?*/ 		break;
/*?*/ 	}
/*N*/  
/*N*/  	if (pFuOld)
/*N*/  	{
/*?*/   		USHORT nSId = pFuOld->GetSlotID();
/*?*/   
/*?*/   		pFuOld->Deactivate();
/*?*/   		delete pFuOld;
/*?*/   		pFuOld = NULL;
/*?*/   
/*?*/   		SfxBindings& rBind = GetViewFrame()->GetBindings();
/*?*/   		rBind.Invalidate( nSId );
/*?*/   		rBind.Update( nSId );
/*?*/  	}
/*N*/  
/*N*/  	if (pFuActual)
/*N*/  	{
/*N*/  		pFuActual->Activate();
/*N*/  		pFuOld = pFuActual;
/*N*/  
/*N*/  		SetHelpId( pFuActual->GetSlotID() );
/*N*/  	}
/*N*/ 
/*N*/ 	// Shell wird invalidiert, schneller als einzeln (laut MI)
/*N*/ 	// Jetzt explizit der letzte Slot incl. Update()
/*N*/ 	Invalidate();
/*N*/ 
/*N*/ 	// #97016# III CTRL-SID_OBJECT_SELECT -> select first draw object if none is selected yet
/*N*/ 	if(SID_OBJECT_SELECT == nSId && pFuActual && (rReq.GetModifier() & KEY_MOD1))
/*N*/ 	{
/*N*/ 		if(!pView->HasMarkedObj())
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 // select first object
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// #97016# with qualifier construct directly
/*N*/ 	if(pFuActual && (rReq.GetModifier() & KEY_MOD1))
/*N*/ 	{
		// get SdOptions
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SdOptions* pOptions = SD_MOD()->GetSdOptions(pDoc->GetDocumentType());
/*?*/ 	}
/*N*/ }

//////////////////////////////////////////////////////////////////////////////
// service routine for Undo/Redo implementation

/*************************************************************************
|*
|* SfxRequests fuer Support-Funktionen
|*
\************************************************************************/


/*************************************************************************
|*
|* URL-Feld einfuegen
|*
\************************************************************************/


/*************************************************************************
|*
|* URL-Button einfuegen
|*
\************************************************************************/


/*************************************************************************
|*
|*
|*
\************************************************************************/


#ifdef WNT
#pragma optimize ( "", on )
#endif


}
